/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import jp.co.bizreach.jdynamo.action.DynamoCondExpression;
import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeWithValue;
import jp.co.bizreach.jdynamo.util.DynamoAttributeUtil;
import org.apache.commons.lang3.StringUtils;

class DynamoQueryValue
implements DynamoCondExpression {
    private DynamoAttributeDefinition attributeDefinition;
    private Object value;

    @Override
    public String getExpressionText(List<Integer> index) {
        if (this.value instanceof DynamoAttributeWithValue) {
            DynamoAttributeWithValue cond = (DynamoAttributeWithValue)this.value;
            return cond.getExpression(index);
        }
        return this.value.toString();
    }

    @Override
    public String getDynamoAttrName() {
        return this.attributeDefinition.getDynamoAttrName();
    }

    @Override
    public Object getTargetValue() {
        return this.value;
    }

    @Override
    public DynamoMappingAttributeType getMappingType() {
        return this.attributeDefinition.getMappingType();
    }

    @Override
    public void appendNames(List<Integer> indexes, Map<String, String> results) {
        String filterName = this.getDynamoAttrName();
        int idx = indexes.get(0);
        if (!results.containsValue(filterName)) {
            results.put("#fname" + idx, filterName);
        }
    }

    @Override
    public void appendValues(List<Integer> indexes, Map<String, AttributeValue> results) {
        Object filterValue = ((DynamoAttributeWithValue)this.getTargetValue()).getTargetValue();
        if (filterValue instanceof List) {
            int sidx = 0;
            for (Object lvalue : (List)filterValue) {
                DynamoAttributeUtil.appendValue(results, this.attributeDefinition.getMappingType(), ":fvalue" + StringUtils.join(indexes, (String)"_") + "L" + sidx, lvalue);
                ++sidx;
            }
        } else if (filterValue != null) {
            DynamoAttributeUtil.appendValue(results, this.attributeDefinition.getMappingType(), ":fvalue" + StringUtils.join(indexes, (String)"_"), filterValue);
        }
    }

    public DynamoAttributeDefinition getAttributeDefinition() {
        return this.attributeDefinition;
    }

    public Object getValue() {
        return this.value;
    }

    @ConstructorProperties(value={"attributeDefinition", "value"})
    public DynamoQueryValue(DynamoAttributeDefinition attributeDefinition, Object value) {
        this.attributeDefinition = attributeDefinition;
        this.value = value;
    }
}

