/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.action;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ReturnValue;
import com.amazonaws.services.dynamodbv2.model.UpdateItemRequest;
import com.amazonaws.services.dynamodbv2.model.UpdateItemResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.bizreach.jdynamo.DynamoClient;
import jp.co.bizreach.jdynamo.DynamoConditionalCheckFailedException;
import jp.co.bizreach.jdynamo.data.DynamoKey;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import jp.co.bizreach.jdynamo.data.DynamoUpdateValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeWithValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoUpdateChain<T> {
    private static final Logger log = LoggerFactory.getLogger(DynamoUpdateChain.class);
    private DynamoClient.DynamoClientPrivate client;
    private DynamoMetaTable<T> table;
    private DynamoKey key;
    private List<DynamoUpdateValue> values = new ArrayList<DynamoUpdateValue>();
    private DynamoAttributeWithValue condition;

    public DynamoUpdateChain(DynamoClient.DynamoClientPrivate client, DynamoMetaTable table, DynamoKey key) {
        this.client = client;
        this.table = table;
        this.key = key;
    }

    public DynamoUpdateChain set(DynamoUpdateValue value) {
        this.values.add(value);
        return this;
    }

    public void execute() {
        this.client.executeUpdate(this);
    }

    public T executeAndGet() {
        UpdateItemResult updateItemResult = this.client.executeUpdate(this, ReturnValue.ALL_NEW);
        Map attributes = updateItemResult.getAttributes();
        if (log.isDebugEnabled()) {
            log.debug(attributes.toString());
        }
        return this.client.toRecord(this.table, attributes);
    }

    public T executeConditionalAndGet() {
        try {
            UpdateItemResult updateItemResult = this.client.executeUpdate(this, ReturnValue.ALL_NEW);
            Map attributes = updateItemResult.getAttributes();
            if (log.isDebugEnabled()) {
                log.debug(attributes.toString());
            }
            return this.client.toRecord(this.table, attributes);
        }
        catch (DynamoConditionalCheckFailedException e) {
            log.warn(e.getMessage());
            return null;
        }
    }

    public T executeAndGetOld() {
        UpdateItemResult updateItemResult = this.client.executeUpdate(this, ReturnValue.ALL_OLD);
        Map attributes = updateItemResult.getAttributes();
        if (log.isDebugEnabled() && attributes != null) {
            log.debug(attributes.toString());
        }
        return this.client.toRecord(this.table, attributes);
    }

    public UpdateItemRequest makeUpdateItemRequest(UpdateItemRequest request) {
        String updateExpression = this.makeUpdateExpression();
        request.withUpdateExpression(updateExpression);
        this.setupConditionalExpression(request);
        Map<String, String> expressionAttributeNames = this.makeAttibuteNames();
        request.withExpressionAttributeNames(expressionAttributeNames);
        Map<String, AttributeValue> expressionAttributeValues = this.makeAttibuteValues();
        request.withExpressionAttributeValues(expressionAttributeValues);
        if (log.isDebugEnabled()) {
            String realTableName = this.client.getRealTableName(this.table);
            String conditionExpression = request.getConditionExpression();
            log.debug("new UpdateItemRequest().\nrealTableName = " + realTableName + "\nupdateExpression = " + updateExpression + "\nexpressionAttributeNames = " + expressionAttributeNames + "\nexpressionAttributeValues = " + expressionAttributeValues + "\nconditionExpression = " + conditionExpression + "\n");
        }
        return request;
    }

    private String makeUpdateExpression() {
        return this.table.createUpdateExpression(this.values);
    }

    private Map<String, String> makeAttibuteNames() {
        HashMap<String, String> map = new HashMap<String, String>();
        int idx = 1;
        for (DynamoUpdateValue value : this.values) {
            map.put("#uname" + idx, value.getName());
            ++idx;
        }
        if (this.condition != null) {
            this.condition.appendAttributeNames(map, 1);
        }
        return map;
    }

    private Map<String, AttributeValue> makeAttibuteValues() {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        int idx = 1;
        for (DynamoUpdateValue value : this.values) {
            if (value.hasAttributeValue()) {
                map.put(":uval" + idx, value.getAttributeValue().getValue());
            }
            value.appendAdditionalAttributeValues(map);
            ++idx;
        }
        if (this.condition != null) {
            this.condition.appendAttributeValues(map, 1);
        }
        return map;
    }

    private void setupConditionalExpression(UpdateItemRequest request) {
        if (this.condition != null) {
            List<Integer> indexes = Arrays.asList(1);
            String expression = this.condition.getExpression(indexes);
            request.withConditionExpression(expression);
        }
    }

    public DynamoUpdateChain condition(DynamoAttributeWithValue condition) {
        this.condition = condition;
        return this;
    }

    public DynamoMetaTable<T> getTable() {
        return this.table;
    }

    public DynamoKey getKey() {
        return this.key;
    }
}

