/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.admin;

import com.amazonaws.services.dynamodbv2.AmazonDynamoDBClient;
import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.CreateTableRequest;
import com.amazonaws.services.dynamodbv2.model.DeleteTableRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemRequest;
import com.amazonaws.services.dynamodbv2.model.GetItemResult;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.ListTablesResult;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import com.amazonaws.services.dynamodbv2.model.ResourceNotFoundException;
import java.util.List;
import jp.co.bizreach.jdynamo.DynamoClient;
import jp.co.bizreach.jdynamo.data.DynamoMetaTable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoAdminClient {
    private static final Logger log = LoggerFactory.getLogger(DynamoAdminClient.class);
    private AmazonDynamoDBClient amazonDynamoClient;
    private DynamoClient.DynamoClientPrivate clientPrivate;

    public DynamoAdminClient(AmazonDynamoDBClient amazonDynamoClient, DynamoClient.DynamoClientPrivate clientPrivate) {
        this.amazonDynamoClient = amazonDynamoClient;
        this.clientPrivate = clientPrivate;
    }

    public List<String> getTableNames() {
        ListTablesResult listTablesResult = this.clientPrivate.getRawDynamoClient().listTables();
        List tableNames = listTablesResult.getTableNames();
        if (log.isDebugEnabled()) {
            log.debug(StringUtils.join((Object[])new List[]{tableNames}));
        }
        return tableNames;
    }

    public List<String> getTableNamesAll() {
        ListTablesResult listTablesResult = this.clientPrivate.getRawDynamoClient().listTables();
        List tableNames = listTablesResult.getTableNames();
        while (listTablesResult.getLastEvaluatedTableName() != null) {
            listTablesResult = this.clientPrivate.getRawDynamoClient().listTables(listTablesResult.getLastEvaluatedTableName());
            tableNames.addAll(listTablesResult.getTableNames());
        }
        return tableNames;
    }

    public void createTableByLocal(DynamoMetaTable table) {
        this.amazonDynamoClient.createTable(this.makeCreateTableRequestByLocal(table));
    }

    public void deleteTableByLocal(DynamoMetaTable table) {
        try {
            this.amazonDynamoClient.deleteTable(this.makeDeleteTableRequestByLocal(table));
        }
        catch (ResourceNotFoundException e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    private DeleteTableRequest makeDeleteTableRequestByLocal(DynamoMetaTable table) {
        return new DeleteTableRequest().withTableName(this.clientPrivate.getRealTableName(table));
    }

    private CreateTableRequest makeCreateTableRequestByLocal(DynamoMetaTable table) {
        String realTableName = this.clientPrivate.getRealTableName(table);
        List<KeySchemaElement> keySchema = table.getKeySchema();
        List<AttributeDefinition> attributeDefinitions = table.getAttributeDefinitions();
        List<GlobalSecondaryIndex> globalSecondaryIndexes = table.createGlobalSecondaryIndexesByLocal();
        if (log.isDebugEnabled()) {
            log.debug("new CreateTableRequest().\nrealTableName = " + realTableName + "\nattributeDefinitions" + attributeDefinitions + "\nglobalSecondaryIndexes = " + globalSecondaryIndexes);
        }
        return new CreateTableRequest().withTableName(realTableName).withKeySchema(keySchema).withGlobalSecondaryIndexes(globalSecondaryIndexes).withAttributeDefinitions(attributeDefinitions).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(1L), Long.valueOf(1L)));
    }

    public GetItemResult getAsItemResult(DynamoMetaTable table, Object partitionKey, Object sortKey) {
        GetItemRequest request = new GetItemRequest().withTableName(this.clientPrivate.getRealTableName(table)).withKey(this.clientPrivate.createKey(table, partitionKey, sortKey));
        GetItemResult itemResult = this.amazonDynamoClient.getItem(request);
        return itemResult;
    }
}

