/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.core;

public class DynamoSnowFlakeIdGenerator {
    private static final int NODE_SHIFT = 10;
    private static final int SEQ_SHIFT = 12;
    private static final short MAX_NODE = 1024;
    private static final short MAX_SEQUENCE = 4096;
    private short sequence;
    private long referenceTime;
    private final int node;
    private final long epochTime;

    public DynamoSnowFlakeIdGenerator(int node, long epochTime) {
        if (node < 0 || node > 1024) {
            throw new IllegalArgumentException();
        }
        this.node = node;
        this.epochTime = epochTime;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long next() {
        long counter;
        long currentTime = this.timeGen();
        DynamoSnowFlakeIdGenerator dynamoSnowFlakeIdGenerator = this;
        synchronized (dynamoSnowFlakeIdGenerator) {
            if (currentTime < this.referenceTime) {
                throw new IllegalStateException(String.format("Last referenceTime %s is after reference time %s", this.referenceTime, currentTime));
            }
            if (currentTime > this.referenceTime) {
                this.sequence = 0;
            } else if (this.sequence < 4096) {
                this.sequence = (short)(this.sequence + 1);
            } else {
                throw new IllegalStateException("Sequence exhausted at " + this.sequence);
            }
            counter = this.sequence;
            this.referenceTime = currentTime;
        }
        return currentTime - this.epochTime << 10 << 12 | (long)(this.node << 12) | counter;
    }
}

