/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import jp.co.bizreach.jdynamo.DynamoRuntimeException;
import jp.co.bizreach.jdynamo.data.DynamoAttributeType;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.util.DynamoAttributeUtil;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoAttributeDefinition {
    private static final Logger log = LoggerFactory.getLogger(DynamoAttributeDefinition.class);
    private String fieldName;
    private String dynamoAttrName;
    private DynamoAttributeType type;
    private DynamoMappingAttributeType mappingType;
    private Class<?> fieldType;

    public DynamoAttributeDefinition(Field field) {
        this.fieldName = field.getName();
        this.dynamoAttrName = field.getName();
        this.type = DynamoAttributeType.typeOf(field.getType());
        this.mappingType = DynamoMappingAttributeType.fieldOf(field);
        this.fieldType = field.getType();
    }

    public AttributeValue createAttributeValue(Object record) {
        AttributeValue attrValue = null;
        try {
            Object value = PropertyUtils.getProperty((Object)record, (String)this.fieldName);
            if (value == null) {
                return null;
            }
            attrValue = DynamoAttributeUtil.createAttributeValue(this.mappingType, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return attrValue;
    }

    public Object getValue(Object record) {
        Object attrValue = null;
        try {
            Object value = PropertyUtils.getProperty((Object)record, (String)this.fieldName);
            return value;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new DynamoRuntimeException(e);
        }
    }

    public AttributeValueUpdate createAttributeValueUpdate(Object record) {
        AttributeValueUpdate attrValue = null;
        try {
            Object value = PropertyUtils.getProperty((Object)record, (String)this.fieldName);
            if (value == null) {
                return null;
            }
            attrValue = DynamoAttributeUtil.createAttributeValueUpdate(this.mappingType, value);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return attrValue;
    }

    public void storeFieldByAttributeValue(Object record, String fieldName, AttributeValue value) {
        try {
            if (value == null) {
                PropertyUtils.setProperty((Object)record, (String)fieldName, null);
                return;
            }
            this.mappingType.storeField(record, fieldName, value);
        }
        catch (ReflectiveOperationException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        return this.mappingType.createAttributeDefinition(dynamoName);
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getDynamoAttrName() {
        return this.dynamoAttrName;
    }

    public void setDynamoAttrName(String dynamoAttrName) {
        this.dynamoAttrName = dynamoAttrName;
    }

    public DynamoMappingAttributeType getMappingType() {
        return this.mappingType;
    }
}

