/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import com.amazonaws.services.dynamodbv2.model.GlobalSecondaryIndex;
import com.amazonaws.services.dynamodbv2.model.KeySchemaElement;
import com.amazonaws.services.dynamodbv2.model.KeyType;
import com.amazonaws.services.dynamodbv2.model.Projection;
import com.amazonaws.services.dynamodbv2.model.ProjectionType;
import com.amazonaws.services.dynamodbv2.model.ProvisionedThroughput;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jp.co.bizreach.jdynamo.DynamoClientSetting;
import jp.co.bizreach.jdynamo.annotation.PartitionKey;
import jp.co.bizreach.jdynamo.annotation.SortKey;
import jp.co.bizreach.jdynamo.annotation.Table;
import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;
import jp.co.bizreach.jdynamo.data.DynamoIndex;
import jp.co.bizreach.jdynamo.data.DynamoKey;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.data.DynamoUpdateValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeSupport;
import jp.co.bizreach.jdynamo.data.attr.DynamoBooleanAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoCompressStringAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoDateAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoDateTimeAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoDecimalAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoIntegerAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoIntegerSetAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoLongAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoLongListAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoLongSetAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoStringAttribute;
import jp.co.bizreach.jdynamo.data.attr.DynamoStringSetAttribute;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoMetaTable<T> {
    private static final Logger log = LoggerFactory.getLogger(DynamoMetaTable.class);
    private String baseTableName;
    private Class<?> recordClass;
    private List<KeySchemaElement> keySchema;
    private List<AttributeDefinition> attributeDefinitions;
    private String partitionKeyFieldName;
    private String sortKeyFieldName;
    private DynamoAttributeDefinition partitionKeyAttr;
    private DynamoAttributeDefinition sortKeyAttr;
    private List<DynamoAttributeDefinition> attributes;
    private Map<String, DynamoAttributeDefinition> attributeDynamoMap;
    private Map<String, DynamoAttributeDefinition> attributeFieldMap;
    private DynamoIndex mainIndex;
    private List<DynamoIndex> indexes;

    public DynamoMetaTable() {
        log.info("DynamoMetaTable::DynamoMetaTable");
        Type type = ((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
        this.initialize((Class)type);
    }

    public DynamoAttributeDefinition getAttributeDefinition(String fieldName) {
        return this.attributeFieldMap.get(fieldName);
    }

    private void initialize(Class<?> recordClass) {
        this.recordClass = recordClass;
        Table tableName = this.getClass().getAnnotation(Table.class);
        if (tableName != null) {
            this.baseTableName = tableName.baseName();
        }
        this.keySchema = new ArrayList<KeySchemaElement>();
        this.attributeDefinitions = new ArrayList<AttributeDefinition>();
        this.initByPartitionKey(recordClass);
        this.initBySortKey(recordClass);
        this.attributes = new ArrayList<DynamoAttributeDefinition>();
        this.attributeDynamoMap = new HashMap<String, DynamoAttributeDefinition>();
        this.attributeFieldMap = new HashMap<String, DynamoAttributeDefinition>();
        for (Field field : FieldUtils.getAllFields(recordClass)) {
            DynamoAttributeDefinition attr = new DynamoAttributeDefinition(field);
            if (attr.getMappingType() == DynamoMappingAttributeType.UNKNOWN) {
                log.info("Ignore field " + field + " because unknown mapping type.");
                continue;
            }
            this.attributes.add(attr);
            this.attributeFieldMap.put(field.getName(), attr);
            if (field.getName().equals(this.partitionKeyFieldName)) {
                this.partitionKeyAttr = attr;
            }
            if (!field.getName().equals(this.sortKeyFieldName)) continue;
            this.sortKeyAttr = attr;
        }
        this.indexes = new ArrayList<DynamoIndex>();
        this.mainIndex = new DynamoIndex(this, null, this.getPartitionKeyField(recordClass), this.getSortKeyField(recordClass));
    }

    private Field getPartitionKeyField(Class<?> recordClass) {
        List partitionKeys = FieldUtils.getFieldsListWithAnnotation(recordClass, PartitionKey.class);
        if (CollectionUtils.isNotEmpty((Collection)partitionKeys)) {
            return (Field)partitionKeys.get(0);
        }
        return null;
    }

    private Field getSortKeyField(Class<?> recordClass) {
        List sortKeys = FieldUtils.getFieldsListWithAnnotation(recordClass, SortKey.class);
        if (CollectionUtils.isNotEmpty((Collection)sortKeys)) {
            return (Field)sortKeys.get(0);
        }
        return null;
    }

    private void initByPartitionKey(Class<?> recordClass) {
        List partitionKeys = FieldUtils.getFieldsListWithAnnotation(recordClass, PartitionKey.class);
        if (CollectionUtils.isNotEmpty((Collection)partitionKeys)) {
            String name;
            Field field = (Field)partitionKeys.get(0);
            this.partitionKeyFieldName = name = field.getName();
            this.keySchema.add(new KeySchemaElement(name, KeyType.HASH));
            this.addAttributeDefinitions(field, name);
        }
    }

    private void initBySortKey(Class<?> recordClass) {
        List sortKeys = FieldUtils.getFieldsListWithAnnotation(recordClass, SortKey.class);
        if (CollectionUtils.isNotEmpty((Collection)sortKeys)) {
            String name;
            Field field = (Field)sortKeys.get(0);
            this.sortKeyFieldName = name = field.getName();
            this.keySchema.add(new KeySchemaElement(name, KeyType.RANGE));
            this.addAttributeDefinitions(field, name);
        }
    }

    private AttributeDefinition addAttributeDefinitions(Field field, String dynamoName) {
        for (AttributeDefinition def : this.attributeDefinitions) {
            if (!def.getAttributeName().equals(dynamoName)) continue;
            return null;
        }
        DynamoAttributeDefinition attr = new DynamoAttributeDefinition(field);
        AttributeDefinition attributeDefinition = attr.createAttributeDefinition(dynamoName);
        if (attributeDefinition != null) {
            this.attributeDefinitions.add(attributeDefinition);
        }
        return attributeDefinition;
    }

    public List<KeySchemaElement> getKeySchema() {
        return this.keySchema;
    }

    public List<AttributeDefinition> getAttributeDefinitions() {
        return this.attributeDefinitions;
    }

    public Map<String, AttributeValue> createItem(Object record) {
        HashMap<String, AttributeValue> map = new HashMap<String, AttributeValue>();
        for (DynamoAttributeDefinition attr : this.attributes) {
            AttributeValue attributeValue = attr.createAttributeValue(record);
            if (attributeValue == null) continue;
            map.put(attr.getDynamoAttrName(), attributeValue);
        }
        if (log.isDebugEnabled()) {
            log.debug(((Object)map).toString());
        }
        return map;
    }

    public Map<String, AttributeValueUpdate> createUpdateItem(Object record) {
        HashMap<String, AttributeValueUpdate> map = new HashMap<String, AttributeValueUpdate>();
        for (DynamoAttributeDefinition attr : this.attributes) {
            AttributeValueUpdate attributeValue = attr.createAttributeValueUpdate(record);
            if (attributeValue == null) continue;
            map.put(attr.getDynamoAttrName(), attributeValue);
        }
        if (log.isDebugEnabled()) {
            log.debug(((Object)map).toString());
        }
        return map;
    }

    public DynamoIndex getMainIndex() {
        return this.mainIndex;
    }

    public void storeFieldByItem(Object record, Map.Entry<String, AttributeValue> entry, DynamoClientSetting clientSetting) {
        String dynamoAttrName = entry.getKey();
        AttributeValue value = entry.getValue();
        try {
            DynamoAttributeDefinition attribute = this.attributeDynamoMap.get(dynamoAttrName);
            if (attribute != null) {
                String fieldName = attribute.getFieldName();
                if (value == null) {
                    PropertyUtils.setProperty((Object)record, (String)fieldName, null);
                } else {
                    attribute.storeFieldByAttributeValue(record, fieldName, value);
                }
            } else if (log.isWarnEnabled() && !clientSetting.isNoWarnUnknownDynamoAttr()) {
                log.warn(dynamoAttrName + " is not define.");
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void addIndex(DynamoIndex index) {
        this.indexes.add(index);
        String fieldName = index.getPartitionKeyFieldName();
        if (fieldName != null) {
            this.addAttributeDefinitions(FieldUtils.getDeclaredField(this.getRecordClass(), (String)fieldName, (boolean)true), fieldName);
        }
        if ((fieldName = index.getSortKeyFieldName()) != null) {
            this.addAttributeDefinitions(FieldUtils.getDeclaredField(this.getRecordClass(), (String)fieldName, (boolean)true), fieldName);
        }
    }

    public List<GlobalSecondaryIndex> createGlobalSecondaryIndexesByLocal() {
        ArrayList<GlobalSecondaryIndex> results = new ArrayList<GlobalSecondaryIndex>();
        for (DynamoIndex index : this.indexes) {
            if (index.getIndexName() == null) continue;
            GlobalSecondaryIndex tindex = new GlobalSecondaryIndex().withIndexName(index.getIndexName()).withKeySchema(index.getKeySchema()).withProjection(new Projection().withProjectionType(ProjectionType.ALL)).withProvisionedThroughput(new ProvisionedThroughput(Long.valueOf(1L), Long.valueOf(1L)));
            results.add(tindex);
        }
        return CollectionUtils.isEmpty(results) ? null : results;
    }

    public DynamoKey createKey(T rec) {
        if (this.sortKeyAttr != null) {
            return new DynamoKey(this.partitionKeyAttr.getValue(rec), this.sortKeyAttr.getValue(rec));
        }
        return new DynamoKey(this.partitionKeyAttr.getValue(rec));
    }

    protected DynamoAttributeSupport createStringAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoStringAttribute attr = new DynamoStringAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createStringAttribute(String fieldName, String dynamoAttrName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        attribute.setDynamoAttrName(dynamoAttrName);
        DynamoStringAttribute attr = new DynamoStringAttribute(attribute);
        this.attributeDynamoMap.put(dynamoAttrName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createCompressStringAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoCompressStringAttribute attr = new DynamoCompressStringAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createLongAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoLongAttribute attr = new DynamoLongAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createLongAttribute(String fieldName, String dynamoAttrName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        attribute.setDynamoAttrName(dynamoAttrName);
        DynamoLongAttribute attr = new DynamoLongAttribute(attribute);
        this.attributeDynamoMap.put(dynamoAttrName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createIntegerAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoIntegerAttribute attr = new DynamoIntegerAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createDecimalAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoDecimalAttribute attr = new DynamoDecimalAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createBooleanAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoBooleanAttribute attr = new DynamoBooleanAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createDateAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoDateAttribute attr = new DynamoDateAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createDateTimeAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoDateTimeAttribute attr = new DynamoDateTimeAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createStringSetAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoStringSetAttribute attr = new DynamoStringSetAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createLongSetAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoLongSetAttribute attr = new DynamoLongSetAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createIntegerSetAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoIntegerSetAttribute attr = new DynamoIntegerSetAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    protected DynamoAttributeSupport createLongListAttribute(String fieldName) {
        DynamoAttributeDefinition attribute = this.attributeFieldMap.get(fieldName);
        DynamoLongListAttribute attr = new DynamoLongListAttribute(attribute);
        this.attributeDynamoMap.put(fieldName, attribute);
        return attr;
    }

    public String createUpdateExpression(List<DynamoUpdateValue> values) {
        StringBuilder sb = new StringBuilder();
        for (DynamoUpdateValue.UpdateCategory category : DynamoUpdateValue.UpdateCategory.values()) {
            ArrayList<DynamoUpdateValue> categoryValues = new ArrayList<DynamoUpdateValue>();
            for (DynamoUpdateValue updateValue : values) {
                DynamoUpdateValue.UpdateCategory updateCategory = updateValue.getUpdateCategory();
                if (category != updateCategory) continue;
                categoryValues.add(updateValue);
            }
            if (categoryValues.isEmpty()) continue;
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(category.name()).append(" ");
            for (DynamoUpdateValue value : categoryValues) {
                int idx = values.indexOf(value) + 1;
                sb.append(value.createUpdateExpression(idx));
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
        return sb.toString();
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public Class<?> getRecordClass() {
        return this.recordClass;
    }

    public DynamoAttributeDefinition getPartitionKeyAttr() {
        return this.partitionKeyAttr;
    }

    public DynamoAttributeDefinition getSortKeyAttr() {
        return this.sortKeyAttr;
    }
}

