/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data.attr;

import java.util.Arrays;
import jp.co.bizreach.jdynamo.data.DynamoAttributeDefinition;
import jp.co.bizreach.jdynamo.data.DynamoUpdateValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeSupport;
import jp.co.bizreach.jdynamo.data.attr.DynamoAttributeWithValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoUpdateAddValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoUpdateAppendValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoUpdateDeleteValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoUpdateIfNotExistsValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoUpdateIncrValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoUpdatePutValue;
import jp.co.bizreach.jdynamo.data.attr.DynamoUpdateRemoveValue;

public abstract class AbstractDynamoAttributeSupport
implements DynamoAttributeSupport {
    private DynamoAttributeDefinition attr;

    public AbstractDynamoAttributeSupport(DynamoAttributeDefinition attr) {
        this.attr = attr;
    }

    @Override
    public String getDynamoAttrName() {
        return this.attr.getDynamoAttrName();
    }

    @Override
    public DynamoAttributeWithValue eq(Object targetValue) {
        return this.middle(targetValue, " = ");
    }

    @Override
    public DynamoAttributeWithValue ne(Object targetValue) {
        return this.middle(targetValue, " <> ");
    }

    @Override
    public DynamoAttributeWithValue contains(Object targetValue) {
        throw new IllegalArgumentException((Object)((Object)this.attr.getMappingType()) + " attribute is not support 'contains'.");
    }

    @Override
    public DynamoAttributeWithValue in(Object ... targetValues) {
        return this.middle(Arrays.asList(targetValues), " in ");
    }

    @Override
    public DynamoAttributeWithValue greaterThan(Object targetValue) {
        return this.middle(targetValue, " > ");
    }

    @Override
    public DynamoAttributeWithValue greaterThanEq(Object targetValue) {
        return this.middle(targetValue, " >= ");
    }

    @Override
    public DynamoAttributeWithValue lessThan(Object targetValue) {
        return this.middle(targetValue, " < ");
    }

    @Override
    public DynamoAttributeWithValue lessThanEq(Object targetValue) {
        return this.middle(targetValue, " <= ");
    }

    @Override
    public DynamoAttributeWithValue exists() {
        return this.leftMiddle("attribute_exists (", ")");
    }

    @Override
    public DynamoAttributeWithValue notExists() {
        return this.leftMiddle("attribute_not_exists (", ")");
    }

    @Override
    public DynamoUpdateValue set(Object value) {
        return new DynamoUpdatePutValue(this.attr.getMappingType(), this.attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue setIfNotExists(Object value) {
        return new DynamoUpdateIfNotExistsValue(this.attr.getMappingType(), this.attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue increment(Integer delta) {
        return new DynamoUpdateIncrValue(this.attr.getMappingType(), this.attr.getDynamoAttrName(), delta);
    }

    @Override
    public DynamoUpdateValue add(Integer delta) {
        return new DynamoUpdateAddValue(this.attr.getMappingType(), this.attr.getDynamoAttrName(), delta);
    }

    @Override
    public DynamoUpdateValue append(Long value) {
        return new DynamoUpdateAppendValue(this.attr.getMappingType(), this.attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue append(String value) {
        return new DynamoUpdateAppendValue(this.attr.getMappingType(), this.attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue delete(Long value) {
        return new DynamoUpdateDeleteValue(this.attr.getDynamoAttrName(), value);
    }

    @Override
    public DynamoUpdateValue clear() {
        return new DynamoUpdateRemoveValue(this.attr.getDynamoAttrName());
    }

    protected DynamoAttributeWithValue middle(Object targetValue, String m) {
        DynamoAttributeWithValue value = new DynamoAttributeWithValue(this.attr);
        value.setTargetValue(targetValue);
        value.setMiddleOperatorStr(m);
        value.setValueExist(true);
        return value;
    }

    protected DynamoAttributeWithValue leftMiddle(String left, String middle) {
        DynamoAttributeWithValue value = new DynamoAttributeWithValue(this.attr);
        value.setLeftOperatorStr(left);
        value.setMiddleOperatorStr(middle);
        return value;
    }

    protected DynamoAttributeWithValue leftMiddleRightValue(String left, String middle, String right, Object targetValue) {
        DynamoAttributeWithValue value = new DynamoAttributeWithValue(this.attr);
        value.setLeftOperatorStr(left);
        value.setMiddleOperatorStr(middle);
        value.setRightOperatorStr(right);
        value.setTargetValue(targetValue);
        value.setValueExist(true);
        return value;
    }
}

