/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data.attr;

import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import java.util.Map;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import jp.co.bizreach.jdynamo.data.DynamoUpdateValue;
import jp.co.bizreach.jdynamo.data.attr.AbstractDynamoUpdateValue;
import jp.co.bizreach.jdynamo.util.DynamoAttributeUtil;

public class DynamoUpdateAppendValue
extends AbstractDynamoUpdateValue {
    private Number nvalue;
    private String svalue;

    public DynamoUpdateAppendValue(DynamoMappingAttributeType mappingType, String dynamoAttrName, Number value) {
        super(mappingType, dynamoAttrName);
        this.nvalue = value;
    }

    public DynamoUpdateAppendValue(DynamoMappingAttributeType mappingType, String dynamoAttrName, String value) {
        super(mappingType, dynamoAttrName);
        this.svalue = value;
    }

    @Override
    public String createUpdateExpression(int idx) {
        if (this.mappingType.isList()) {
            return "#uname" + idx + " = list_append(if_not_exists(#uname" + idx + ", :_empty_list), :uval" + idx + ")";
        }
        return "#uname" + idx + " :uval" + idx;
    }

    @Override
    public void appendAdditionalAttributeValues(Map<String, AttributeValue> map) {
        super.appendAdditionalAttributeValues(map);
        if (this.mappingType.isList()) {
            map.put(":_empty_list", new AttributeValue().withL(new AttributeValue[0]));
        }
    }

    @Override
    public boolean hasAttributeValue() {
        return true;
    }

    @Override
    public DynamoUpdateValue.UpdateCategory getUpdateCategory() {
        if (this.mappingType.isList()) {
            return DynamoUpdateValue.UpdateCategory.SET;
        }
        return DynamoUpdateValue.UpdateCategory.ADD;
    }

    @Override
    public Object getValue() {
        return this.nvalue != null ? this.nvalue : this.svalue;
    }

    @Override
    public AttributeValueUpdate getAttributeValue() {
        if (this.nvalue != null) {
            return DynamoAttributeUtil.createAttributeValueUpdate(this.mappingType, this.nvalue);
        }
        return DynamoAttributeUtil.createAttributeValueUpdate(this.mappingType, this.svalue);
    }
}

