/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jp.co.bizreach.jdynamo.DynamoRuntimeException;
import jp.co.bizreach.jdynamo.annotation.Compress;
import jp.co.bizreach.jdynamo.data.mapper.IDynamoMapper;
import org.apache.commons.beanutils.PropertyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoCompressStringMapper
implements IDynamoMapper {
    private static final Logger log = LoggerFactory.getLogger(DynamoCompressStringMapper.class);
    public static final String COMPRESS_CHARSET = "UTF-8";

    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        throw new DynamoRuntimeException("not support COMPRESS_STRING key.");
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        ByteBuffer bb = value.getB();
        if (bb == null) {
            String svalue = value.getS();
            if (svalue != null) {
                PropertyUtils.setProperty((Object)record, (String)fieldName, (Object)svalue);
            }
            return;
        }
        try {
            PropertyUtils.setProperty((Object)record, (String)fieldName, (Object)this.createStringFromCompress(bb));
        }
        catch (IOException e) {
            throw new DynamoRuntimeException(e);
        }
    }

    @Override
    public boolean isMatch(Field field) {
        return String.class.equals(field.getType()) && field.getAnnotation(Compress.class) != null;
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        AttributeValue attributeValue = new AttributeValue();
        try {
            attributeValue.withB(DynamoCompressStringMapper.createCompressByteBuffer((String)value));
        }
        catch (IOException e) {
            throw new DynamoRuntimeException(e);
        }
        return attributeValue;
    }

    private String createStringFromCompress(ByteBuffer bb) throws IOException {
        int length;
        byte[] bytes = bb.array();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPInputStream is = new GZIPInputStream(bais);
        int chunkSize = 1024;
        byte[] buffer = new byte[chunkSize];
        while ((length = is.read(buffer, 0, chunkSize)) != -1) {
            baos.write(buffer, 0, length);
        }
        String result = new String(baos.toByteArray(), COMPRESS_CHARSET);
        is.close();
        baos.close();
        bais.close();
        return result;
    }

    private static ByteBuffer createCompressByteBuffer(String value) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream os = new GZIPOutputStream(baos);
        os.write(value.getBytes(COMPRESS_CHARSET));
        os.close();
        baos.close();
        byte[] compressedBytes = baos.toByteArray();
        if (log.isDebugEnabled()) {
            log.debug("compressed length " + value.getBytes(COMPRESS_CHARSET).length + " -> " + compressedBytes.length);
        }
        ByteBuffer buffer = ByteBuffer.allocate(compressedBytes.length);
        buffer.put(compressedBytes, 0, compressedBytes.length);
        buffer.position(0);
        return buffer;
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        throw new DynamoRuntimeException("Compress String is not support.");
    }

    @Override
    public boolean isList() {
        return false;
    }
}

