/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.ScalarAttributeType;
import java.lang.reflect.Field;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Map;
import jp.co.bizreach.jdynamo.data.mapper.IDynamoMapper;
import org.apache.commons.beanutils.PropertyUtils;

public class DynamoDateTimeMapper
implements IDynamoMapper {
    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        if (value instanceof LocalDateTime) {
            long second = ((LocalDateTime)value).toLocalDate().toEpochDay() * 60L * 60L * 24L + (long)((LocalDateTime)value).toLocalTime().toSecondOfDay();
            results.put(key, new AttributeValue().withN(Long.toString(second)));
        }
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        long esecond = Long.parseLong(value.getN());
        long time = esecond % 86400L;
        long day = esecond / 86400L;
        LocalDateTime dateTime = LocalDateTime.of(LocalDate.ofEpochDay(day), LocalTime.ofSecondOfDay(time));
        PropertyUtils.setProperty((Object)record, (String)fieldName, (Object)dateTime);
    }

    @Override
    public boolean isMatch(Field field) {
        return LocalDateTime.class.equals(field.getType());
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        AttributeValue attrValue = new AttributeValue();
        long second = ((LocalDateTime)value).toLocalDate().toEpochDay() * 60L * 60L * 24L + (long)((LocalDateTime)value).toLocalTime().toSecondOfDay();
        attrValue.withN(Long.toString(second));
        return attrValue;
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        return new AttributeDefinition(dynamoName, ScalarAttributeType.N);
    }

    @Override
    public boolean isList() {
        return false;
    }
}

