/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import jp.co.bizreach.jdynamo.DynamoRuntimeException;
import jp.co.bizreach.jdynamo.data.mapper.IDynamoMapper;
import org.apache.commons.beanutils.PropertyUtils;

public class DynamoLongSetMapper
implements IDynamoMapper {
    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        if (value instanceof Long) {
            results.put(key, new AttributeValue().withN(Long.toString((Long)value)));
        }
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        PropertyUtils.setProperty((Object)record, (String)fieldName, new HashSet(value.getNS().stream().map(Long::valueOf).collect(Collectors.toList())));
    }

    @Override
    public boolean isMatch(Field field) {
        Type type;
        Type genericType;
        Class<?> clazz = field.getType();
        return Set.class.equals(clazz) && (genericType = field.getGenericType()) instanceof ParameterizedType && Long.class.equals((Object)(type = ((ParameterizedType)genericType).getActualTypeArguments()[0]));
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        if (value instanceof Long) {
            return new AttributeValue().withNS(new String[]{String.valueOf((Long)value)});
        }
        return new AttributeValue().withNS((Collection)((Set)value).stream().map(i -> i.toString()).collect(Collectors.toList()));
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        throw new DynamoRuntimeException("Set<Long> is not support.");
    }

    @Override
    public boolean isList() {
        return false;
    }
}

