/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.data.mapper;

import com.amazonaws.services.dynamodbv2.model.AttributeDefinition;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jp.co.bizreach.jdynamo.DynamoRuntimeException;
import jp.co.bizreach.jdynamo.data.mapper.IDynamoMapper;
import org.apache.commons.beanutils.PropertyUtils;

public class DynamoStringSetMapper
implements IDynamoMapper {
    @Override
    public void appendValue(Map<String, AttributeValue> results, String key, Object value) {
        if (value instanceof String) {
            results.put(key, new AttributeValue().withS((String)value));
        }
    }

    @Override
    public void storeField(Object record, String fieldName, AttributeValue value) throws ReflectiveOperationException {
        PropertyUtils.setProperty((Object)record, (String)fieldName, new HashSet(value.getSS()));
    }

    @Override
    public boolean isMatch(Field field) {
        Type type;
        Type genericType;
        Class<?> clazz = field.getType();
        return Set.class.equals(clazz) && (genericType = field.getGenericType()) instanceof ParameterizedType && String.class.equals((Object)(type = ((ParameterizedType)genericType).getActualTypeArguments()[0]));
    }

    @Override
    public AttributeValue createAttributeValue(Object value) {
        if (value instanceof String) {
            return new AttributeValue().withSS(new String[]{value.toString()});
        }
        return new AttributeValue().withSS((Collection)((Set)value));
    }

    @Override
    public AttributeDefinition createAttributeDefinition(String dynamoName) {
        throw new DynamoRuntimeException("Set<String> is not support.");
    }

    @Override
    public boolean isList() {
        return false;
    }
}

