/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.jdynamo.util;

import com.amazonaws.services.dynamodbv2.model.AttributeAction;
import com.amazonaws.services.dynamodbv2.model.AttributeValue;
import com.amazonaws.services.dynamodbv2.model.AttributeValueUpdate;
import java.util.Map;
import jp.co.bizreach.jdynamo.data.DynamoMappingAttributeType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamoAttributeUtil {
    private static final Logger log = LoggerFactory.getLogger(DynamoAttributeUtil.class);

    private DynamoAttributeUtil() {
    }

    public static AttributeValue createAttributeValue(DynamoMappingAttributeType mappingType, Object value) {
        return mappingType.createAttributeValue(value);
    }

    public static void appendValue(Map<String, AttributeValue> results, DynamoMappingAttributeType attrType, String key, Object value) {
        attrType.appendValue(results, key, value);
    }

    public static AttributeValueUpdate createAttributeValueUpdate(DynamoMappingAttributeType mappingType, Object value) {
        AttributeValueUpdate attrValue = new AttributeValueUpdate();
        attrValue.withValue(DynamoAttributeUtil.createAttributeValue(mappingType, value));
        attrValue.withAction(AttributeAction.PUT);
        return attrValue;
    }
}

