/*
 * Decompiled with CFR 0.152.
 */
package com.typesafe.play.redis;

import java.io.Serializable;
import java.net.URI;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import play.api.ConfigLoader$;
import play.api.Configuration;
import play.api.Logger;
import play.api.Logger$;
import play.api.MarkerContext$;
import play.api.inject.ApplicationLifecycle;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.collection.Seq;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@Singleton
@ScalaSignature(bytes="\u0006\u0001Q3A!\u0001\u0002\u0001\u0017\t\t\"*\u001a3jgB{w\u000e\u001c)s_ZLG-\u001a:\u000b\u0005\r!\u0011!\u0002:fI&\u001c(BA\u0003\u0007\u0003\u0011\u0001H.Y=\u000b\u0005\u001dA\u0011\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003%\t1aY8n\u0007\u0001\u00192\u0001\u0001\u0007\u0015!\ti!#D\u0001\u000f\u0015\ty\u0001#\u0001\u0003mC:<'\"A\t\u0002\t)\fg/Y\u0005\u0003'9\u0011aa\u00142kK\u000e$\bcA\u000b\u001b95\taC\u0003\u0002\u00181\u00051\u0011N\u001c6fGRT\u0011!G\u0001\u0006U\u00064\u0018\r_\u0005\u00037Y\u0011\u0001\u0002\u0015:pm&$WM\u001d\t\u0003;\rj\u0011A\b\u0006\u0003?\u0001\nQA[3eSNT!!\t\u0012\u0002\u000f\rd\u0017.\u001a8ug*\t1!\u0003\u0002%=\tI!*\u001a3jgB{w\u000e\u001c\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u000511m\u001c8gS\u001e\u0004\"\u0001\u000b\u0017\u000e\u0003%R!AK\u0016\u0002\u0007\u0005\u0004\u0018NC\u0001\u0006\u0013\ti\u0013FA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005IA.\u001b4fGf\u001cG.\u001a\t\u0003cMj\u0011A\r\u0006\u0003/%J!\u0001\u000e\u001a\u0003)\u0005\u0003\b\u000f\\5dCRLwN\u001c'jM\u0016\u001c\u0017p\u00197f\u0011\u00151\u0004\u0001\"\u00018\u0003\u0019a\u0014N\\5u}Q\u0019\u0001HO\u001e\u0011\u0005e\u0002Q\"\u0001\u0002\t\u000b\u0019*\u0004\u0019A\u0014\t\u000b=*\u0004\u0019\u0001\u0019)\u0005Uj\u0004CA\u000b?\u0013\tydC\u0001\u0004J]*,7\r\u001e\u0005\t\u0003\u0002A)\u0019!C\u0001\u0005\u00061An\\4hKJ,\u0012a\u0011\t\u0003Q\u0011K!!R\u0015\u0003\r1{wmZ3s\u0011!9\u0005\u0001#b\u0001\n\u0003A\u0015aA4fiV\tA\u0004C\u0003K\u0001\u0011%1*\u0001\tde\u0016\fG/\u001a)p_2\u001cuN\u001c4jOR\u0011Aj\u0014\t\u0003;5K!A\u0014\u0010\u0003\u001f)+G-[:Q_>d7i\u001c8gS\u001eDQAJ%A\u0002\u001dB#\u0001A)\u0011\u0005U\u0011\u0016BA*\u0017\u0005%\u0019\u0016N\\4mKR|g\u000e")
public class JedisPoolProvider
implements Provider<JedisPool> {
    private Logger logger;
    private JedisPool get;
    private final Configuration config;
    private final ApplicationLifecycle lifecycle;
    private volatile byte bitmap$0;

    private Logger logger$lzycompute() {
        JedisPoolProvider jedisPoolProvider = this;
        synchronized (jedisPoolProvider) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.logger = Logger$.MODULE$.apply("redis.module");
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.logger$lzycompute() : this.logger;
    }

    /*
     * WARNING - void declaration
     */
    private JedisPool get$lzycompute() {
        JedisPoolProvider jedisPoolProvider = this;
        synchronized (jedisPoolProvider) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                void var2_9;
                Option redisUri = this.config.getOptional("redis.uri", ConfigLoader$.MODULE$.stringLoader()).map((Function1 & Serializable & scala.Serializable)x$1 -> new URI((String)x$1));
                String host = (String)this.config.getOptional("redis.host", ConfigLoader$.MODULE$.stringLoader()).orElse((Function0 & Serializable & scala.Serializable)() -> redisUri.map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getHost())).getOrElse((Function0 & Serializable & scala.Serializable)() -> "localhost");
                int port = BoxesRunTime.unboxToInt((Object)this.config.getOptional("redis.port", ConfigLoader$.MODULE$.intLoader()).orElse((Function0 & Serializable & scala.Serializable)() -> redisUri.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToInteger((int)x$3.getPort())).filter((Function1)(JFunction1.mcZI.sp & Serializable & scala.Serializable)x$4 -> x$4 != -1)).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 6379));
                String password = (String)this.config.getOptional("redis.password", ConfigLoader$.MODULE$.stringLoader()).orElse((Function0 & Serializable & scala.Serializable)() -> redisUri.map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getUserInfo()).filter((Function1 & Serializable & scala.Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)JedisPoolProvider.$anonfun$get$11(x$6))).filter((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)x$7.contains(":"))).map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.split(":", 2)[1])).orNull(Predef$.MODULE$.$conforms());
                int timeout = BoxesRunTime.unboxToInt((Object)this.config.getOptional("redis.timeout", ConfigLoader$.MODULE$.intLoader()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 2000));
                int database = BoxesRunTime.unboxToInt((Object)this.config.getOptional("redis.database", ConfigLoader$.MODULE$.intLoader()).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0));
                JedisPoolConfig poolConfig = this.createPoolConfig(this.config);
                Logger$.MODULE$.info((Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Redis Plugin enabled. Connecting to Redis on ", ":", " to ", " with timeout ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{host, BoxesRunTime.boxToInteger((int)port), BoxesRunTime.boxToInteger((int)database), BoxesRunTime.boxToInteger((int)timeout)})), MarkerContext$.MODULE$.NoMarker());
                Logger$.MODULE$.info((Function0 & Serializable & scala.Serializable)() -> "Redis Plugin pool configuration: " + new ReflectionToStringBuilder((Object)poolConfig).toString(), MarkerContext$.MODULE$.NoMarker());
                JedisPool jedisPool = new JedisPool((GenericObjectPoolConfig)poolConfig, host, port, timeout, password, database);
                this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Starting Jedis Pool Provider", MarkerContext$.MODULE$.NoMarker());
                this.lifecycle.addStopHook((Function0 & Serializable & scala.Serializable)() -> {
                    this.logger().info((Function0 & Serializable & scala.Serializable)() -> "Stopping Jedis Pool Provider", MarkerContext$.MODULE$.NoMarker());
                    jedisPool.destroy();
                    return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                });
                this.get = var2_9;
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        this.lifecycle = null;
        return this.get;
    }

    public JedisPool get() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.get$lzycompute() : this.get;
    }

    /*
     * WARNING - void declaration
     */
    private JedisPoolConfig createPoolConfig(Configuration config) {
        void var2_2;
        JedisPoolConfig poolConfig = new JedisPoolConfig();
        config.getOptional("redis.pool.maxIdle", ConfigLoader$.MODULE$.intLoader()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setMaxIdle(x$1));
        config.getOptional("redis.pool.minIdle", ConfigLoader$.MODULE$.intLoader()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setMinIdle(x$1));
        config.getOptional("redis.pool.maxTotal", ConfigLoader$.MODULE$.intLoader()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setMaxTotal(x$1));
        config.getOptional("redis.pool.maxWaitMillis", ConfigLoader$.MODULE$.longLoader()).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setMaxWaitMillis(x$1));
        config.getOptional("redis.pool.testOnBorrow", ConfigLoader$.MODULE$.booleanLoader()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            poolConfig.setTestOnBorrow(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        config.getOptional("redis.pool.testOnReturn", ConfigLoader$.MODULE$.booleanLoader()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            poolConfig.setTestOnReturn(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        config.getOptional("redis.pool.testWhileIdle", ConfigLoader$.MODULE$.booleanLoader()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            poolConfig.setTestWhileIdle(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        config.getOptional("redis.pool.timeBetweenEvictionRunsMillis", ConfigLoader$.MODULE$.longLoader()).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setTimeBetweenEvictionRunsMillis(x$1));
        config.getOptional("redis.pool.numTestsPerEvictionRun", ConfigLoader$.MODULE$.intLoader()).foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setNumTestsPerEvictionRun(x$1));
        config.getOptional("redis.pool.minEvictableIdleTimeMillis", ConfigLoader$.MODULE$.longLoader()).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setMinEvictableIdleTimeMillis(x$1));
        config.getOptional("redis.pool.softMinEvictableIdleTimeMillis", ConfigLoader$.MODULE$.longLoader()).foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)x$1 -> poolConfig.setSoftMinEvictableIdleTimeMillis(x$1));
        config.getOptional("redis.pool.lifo", ConfigLoader$.MODULE$.booleanLoader()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            poolConfig.setLifo(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        config.getOptional("redis.pool.blockWhenExhausted", ConfigLoader$.MODULE$.booleanLoader()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            poolConfig.setBlockWhenExhausted(BoxesRunTime.unboxToBoolean((Object)x$1));
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    public static final /* synthetic */ boolean $anonfun$get$11(String x$6) {
        return x$6 != null;
    }

    @Inject
    public JedisPoolProvider(Configuration config, ApplicationLifecycle lifecycle) {
        this.config = config;
        this.lifecycle = lifecycle;
    }
}

