/*
 * Decompiled with CFR 0.152.
 */
package jp.co.bizreach.suuji;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SuujiConverter {
    private static Pattern NUM_UNIT_PATTERN = Pattern.compile("(([1-9]+[0-9\\.]*)[\u5341\u767e\u5343\u4e07\u5104]*)?");
    private static Pattern DOUBLE_PATTERN = Pattern.compile("^([1-9][0-9]*)\\.([0-9]+)$");

    public static long convert(String str) {
        str = SuujiConverter.replaceFullWidthNumber(SuujiConverter.removeFullWidthSeparator(str));
        char last = str.charAt(str.length() - 1);
        switch (last) {
            case '\u5104': {
                return SuujiConverter.adjustUnit(str.substring(0, str.length() - 1)) * 100000000L;
            }
            case '\u4e07': {
                return SuujiConverter.adjustUnit(str.substring(0, str.length() - 1)) * 10000L;
            }
        }
        return SuujiConverter.adjustUnit(str);
    }

    private static String removeFullWidthSeparator(String str) {
        return str.replaceAll("[,\uff0c]", "");
    }

    private static String replaceFullWidthNumber(String str) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c == '\u4e00' || c == '\uff11') {
                sb.append(1);
                continue;
            }
            if (c == '\u4e8c' || c == '\uff12') {
                sb.append(2);
                continue;
            }
            if (c == '\u4e09' || c == '\uff13') {
                sb.append(3);
                continue;
            }
            if (c == '\u56db' || c == '\uff14') {
                sb.append(4);
                continue;
            }
            if (c == '\u4e94' || c == '\uff15') {
                sb.append(5);
                continue;
            }
            if (c == '\u516d' || c == '\uff16') {
                sb.append(6);
                continue;
            }
            if (c == '\u4e03' || c == '\uff17') {
                sb.append(7);
                continue;
            }
            if (c == '\u516b' || c == '\uff18') {
                sb.append(8);
                continue;
            }
            if (c == '\u4e5d' || c == '\uff19') {
                sb.append(9);
                continue;
            }
            if (c == '\uff10') {
                sb.append(0);
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static long adjustUnit(String str) {
        Matcher matcher = NUM_UNIT_PATTERN.matcher(str);
        long result = 0L;
        while (matcher.find()) {
            result += (long)(SuujiConverter.stringToDouble(matcher.group(2)) * SuujiConverter.convertUnit(matcher.group(1)));
        }
        return result;
    }

    private static double convertUnit(String str) {
        if (str == null) {
            return 1.0;
        }
        double result = 1.0;
        for (Double unit : SuujiConverter.getJapaneseUnitRate(str)) {
            result *= unit.doubleValue();
        }
        return result;
    }

    private static List<Double> getJapaneseUnitRate(String str) {
        ArrayList<Double> units = new ArrayList<Double>();
        if (str.contains("\u5104")) {
            units.add(1.0E8);
        } else if (str.contains("\u4e07")) {
            units.add(10000.0);
        } else if (str.contains("\u5343")) {
            units.add(1000.0);
        } else if (str.contains("\u767e")) {
            units.add(100.0);
        } else if (str.contains("\u5341")) {
            units.add(10.0);
        }
        return units;
    }

    private static double stringToDouble(String str) {
        if (str == null) {
            return 0.0;
        }
        Matcher matcher = DOUBLE_PATTERN.matcher(str);
        if (matcher.matches()) {
            return Double.parseDouble(matcher.group(1).replaceAll("\\.", "") + "." + matcher.group(2));
        }
        return Double.parseDouble(str.replaceAll("\\.", ""));
    }
}

