/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.aeromock.server.http;

import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import jp.co.cyberagent.aeromock.server.http.CustomResponse;
import jp.co.cyberagent.aeromock.server.http.HttpResponseWriter;
import jp.co.cyberagent.aeromock.util.ContentTypeUtil$;
import org.joda.time.DateTime;
import org.json4s.NoTypeHints$;
import org.json4s.TypeHints;
import org.json4s.native.Serialization$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public abstract class HttpResponseWriter$class {
    /*
     * WARNING - void declaration
     */
    public static HttpResponse redirect(HttpResponseWriter $this, String uri, ChannelHandlerContext context) {
        void var3_3;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.FOUND);
        $this.addDefaultHeader((HttpResponse)response);
        response.headers().set("Location", (Object)uri);
        context.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return var3_3;
    }

    public static HttpResponse renderYaml(HttpResponseWriter $this, String content, HttpResponseStatus status, ChannelHandlerContext context) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8));
        $this.addDefaultHeader((HttpResponse)response);
        response.headers().set("Content-Type", (Object)"text/yaml; charset=UTF-8");
        response.headers().set("Content-Length", (Object)BoxesRunTime.boxToInteger((int)response.content().readableBytes()));
        context.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return response;
    }

    public static HttpResponse renderHtml(HttpResponseWriter $this, String content, HttpResponseStatus status, Option customResponse, ChannelHandlerContext context) {
        HttpResponseStatus responseStatus = HttpResponseWriter$class.selectResponseStatus($this, status, customResponse);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8));
        $this.addDefaultHeader((HttpResponse)response);
        HttpResponseWriter$class.addCustomResponse($this, response, customResponse);
        response.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        response.headers().set("Content-Length", (Object)BoxesRunTime.boxToInteger((int)response.content().readableBytes()));
        context.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return response;
    }

    public static HttpResponse renderProtobuf(HttpResponseWriter $this, byte[] data, HttpResponseStatus status, Option customResponse, ChannelHandlerContext context) {
        HttpResponseStatus responseStatus = HttpResponseWriter$class.selectResponseStatus($this, status, customResponse);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.copiedBuffer((byte[])data));
        $this.addDefaultHeader((HttpResponse)response);
        HttpResponseWriter$class.addCustomResponse($this, response, customResponse);
        response.headers().set("Content-Type", (Object)"application/x-protobuf");
        response.headers().set("Content-Length", (Object)BoxesRunTime.boxToInteger((int)response.content().readableBytes()));
        context.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return response;
    }

    private static HttpResponseStatus selectResponseStatus(HttpResponseWriter $this, HttpResponseStatus status, Option customResponse) {
        return customResponse.isDefined() ? ((CustomResponse)customResponse.get()).getResponseStatus() : status;
    }

    private static void addCustomResponse(HttpResponseWriter $this, DefaultFullHttpResponse response, Option customResponse) {
        Option option;
        block4: {
            block3: {
                block2: {
                    option = customResponse;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    CustomResponse value = (CustomResponse)some.x();
                    value.headers().foreach((Function1)new Serializable($this, response){
                        private final DefaultFullHttpResponse response$1;

                        public final HttpHeaders apply(Tuple2<String, String> header) {
                            return this.response$1.headers().set((String)header._1(), header._2());
                        }
                        {
                            this.response$1 = response$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw new MatchError((Object)option);
    }

    private static Option addCustomResponse$default$2(HttpResponseWriter $this) {
        return None$.MODULE$;
    }

    public static HttpResponse renderJson(HttpResponseWriter $this, Object value, HttpResponseStatus status, Option customResponse, ChannelHandlerContext context) {
        HttpResponseStatus responseStatus = HttpResponseWriter$class.selectResponseStatus($this, status, customResponse);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, responseStatus, Unpooled.copiedBuffer((CharSequence)Serialization$.MODULE$.write(value, $this.formats()), (Charset)CharsetUtil.UTF_8));
        $this.addDefaultHeader((HttpResponse)response);
        HttpResponseWriter$class.addCustomResponse($this, response, customResponse);
        response.headers().set("Content-Type", (Object)"application/json; charset=UTF-8");
        response.headers().set("Access-Control-Allow-Origin", (Object)"*");
        response.headers().set("Content-Length", (Object)BoxesRunTime.boxToInteger((int)response.content().readableBytes()));
        context.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return response;
    }

    public static Option renderJson$default$3(HttpResponseWriter $this) {
        return None$.MODULE$;
    }

    public static HttpResponse renderResource(HttpResponseWriter $this, String content, HttpResponseStatus status, ChannelHandlerContext context) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)content, (Charset)CharsetUtil.UTF_8));
        $this.addDefaultHeader((HttpResponse)response);
        response.headers().set("Content-Type", (Object)"text/html; charset=UTF-8");
        response.headers().set("Content-Length", (Object)BoxesRunTime.boxToInteger((int)response.content().readableBytes()));
        context.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return response;
    }

    public static void setStaticResponseHeader(HttpResponseWriter $this, HttpResponse response, Option extension) {
        Option option;
        block4: {
            Option<String> option2;
            block7: {
                block6: {
                    block5: {
                        Option<String> contentType;
                        Option<String> option3;
                        block3: {
                            block2: {
                                $this.addDefaultHeader(response);
                                option = extension;
                                if (!None$.MODULE$.equals(option)) break block2;
                                option3 = None$.MODULE$;
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            String e = (String)some.x();
                            option3 = ContentTypeUtil$.MODULE$.getContentType(e);
                        }
                        option2 = contentType = option3;
                        if (!(option2 instanceof Some)) break block5;
                        Some some = (Some)option2;
                        String c = (String)some.x();
                        response.headers().set("Content-Type", (Object)c);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    if (!None$.MODULE$.equals(option2)) break block7;
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return;
            }
            throw new MatchError(option2);
        }
        throw new MatchError((Object)option);
    }

    public static void addDefaultHeader(HttpResponseWriter $this, HttpResponse response) {
        response.headers().set("Cache-Control", (Object)"no-cache");
        response.headers().set("Date", (Object)DateTime.now().toString("EEE, dd MMM yyy HH:mm:ss z"));
        response.headers().set("Server", (Object)"Aeromock");
    }

    public static void $init$(HttpResponseWriter $this) {
        $this.jp$co$cyberagent$aeromock$server$http$HttpResponseWriter$_setter_$formats_$eq(Serialization$.MODULE$.formats((TypeHints)NoTypeHints$.MODULE$));
    }
}

