/*
 * Decompiled with CFR 0.152.
 */
package jp.co.cyberagent.aeromock.server.http;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import jp.co.cyberagent.aeromock.AeromockBadImplementation;
import jp.co.cyberagent.aeromock.AeromockBadUsingException;
import jp.co.cyberagent.aeromock.AeromockConfigurationException;
import jp.co.cyberagent.aeromock.AeromockMethodNotAllowedException;
import jp.co.cyberagent.aeromock.AeromockNoneRelatedDataException;
import jp.co.cyberagent.aeromock.AeromockNotFoundException;
import jp.co.cyberagent.aeromock.server.AccessLog$;
import jp.co.cyberagent.aeromock.server.http.CustomResponse;
import jp.co.cyberagent.aeromock.server.http.HttpResponseWriter;
import jp.co.cyberagent.aeromock.server.http.HttpResponseWriter$class;
import jp.co.cyberagent.aeromock.server.http.error.BadImplementationErrorPage;
import jp.co.cyberagent.aeromock.server.http.error.BadUsingErrorPage;
import jp.co.cyberagent.aeromock.server.http.error.ConfigurationErrorPage;
import jp.co.cyberagent.aeromock.server.http.error.ErrorPageTemplate;
import jp.co.cyberagent.aeromock.server.http.error.MethodNotAllowedErrorPage;
import jp.co.cyberagent.aeromock.server.http.error.NoneRelatedDataErrorPage;
import jp.co.cyberagent.aeromock.server.http.error.NotFoundErrorPage;
import jp.co.cyberagent.aeromock.server.http.error.SystemErrorPage;
import org.json4s.Formats;
import scala.None$;
import scala.Option;

public final class ServerExceptionHandler$
implements HttpResponseWriter {
    public static final ServerExceptionHandler$ MODULE$;
    private final Formats formats;

    static {
        new ServerExceptionHandler$();
    }

    @Override
    public Formats formats() {
        return this.formats;
    }

    @Override
    public void jp$co$cyberagent$aeromock$server$http$HttpResponseWriter$_setter_$formats_$eq(Formats x$1) {
        this.formats = x$1;
    }

    @Override
    public HttpResponse redirect(String uri, ChannelHandlerContext context) {
        return HttpResponseWriter$class.redirect(this, uri, context);
    }

    @Override
    public HttpResponse renderYaml(String content, HttpResponseStatus status, ChannelHandlerContext context) {
        return HttpResponseWriter$class.renderYaml(this, content, status, context);
    }

    @Override
    public HttpResponse renderHtml(String content, HttpResponseStatus status, Option<CustomResponse> customResponse, ChannelHandlerContext context) {
        return HttpResponseWriter$class.renderHtml(this, content, status, customResponse, context);
    }

    @Override
    public HttpResponse renderProtobuf(byte[] data, HttpResponseStatus status, Option<CustomResponse> customResponse, ChannelHandlerContext context) {
        return HttpResponseWriter$class.renderProtobuf(this, data, status, customResponse, context);
    }

    @Override
    public <A> HttpResponse renderJson(A value, HttpResponseStatus status, Option<CustomResponse> customResponse, ChannelHandlerContext context) {
        return HttpResponseWriter$class.renderJson(this, value, status, customResponse, context);
    }

    @Override
    public HttpResponse renderResource(String content, HttpResponseStatus status, ChannelHandlerContext context) {
        return HttpResponseWriter$class.renderResource(this, content, status, context);
    }

    @Override
    public void setStaticResponseHeader(HttpResponse response, Option<String> extension) {
        HttpResponseWriter$class.setStaticResponseHeader(this, response, extension);
    }

    @Override
    public void addDefaultHeader(HttpResponse response) {
        HttpResponseWriter$class.addDefaultHeader(this, response);
    }

    @Override
    public <A> Option<CustomResponse> renderJson$default$3() {
        return HttpResponseWriter$class.renderJson$default$3(this);
    }

    public void handle(Throwable t, ChannelHandlerContext context) {
        if (context.channel().isActive()) {
            ErrorPageTemplate errorPageTemplate;
            Throwable throwable = t;
            if (throwable instanceof AeromockNotFoundException) {
                AeromockNotFoundException aeromockNotFoundException = (AeromockNotFoundException)throwable;
                errorPageTemplate = new NotFoundErrorPage(aeromockNotFoundException);
            } else if (throwable instanceof AeromockConfigurationException) {
                AeromockConfigurationException aeromockConfigurationException = (AeromockConfigurationException)throwable;
                errorPageTemplate = new ConfigurationErrorPage(aeromockConfigurationException);
            } else if (throwable instanceof AeromockNoneRelatedDataException) {
                AeromockNoneRelatedDataException aeromockNoneRelatedDataException = (AeromockNoneRelatedDataException)throwable;
                errorPageTemplate = new NoneRelatedDataErrorPage(aeromockNoneRelatedDataException);
            } else if (throwable instanceof AeromockBadImplementation) {
                AeromockBadImplementation aeromockBadImplementation = (AeromockBadImplementation)throwable;
                errorPageTemplate = new BadImplementationErrorPage(aeromockBadImplementation);
            } else if (throwable instanceof AeromockBadUsingException) {
                AeromockBadUsingException aeromockBadUsingException = (AeromockBadUsingException)throwable;
                errorPageTemplate = new BadUsingErrorPage(aeromockBadUsingException);
            } else if (throwable instanceof AeromockMethodNotAllowedException) {
                AeromockMethodNotAllowedException aeromockMethodNotAllowedException = (AeromockMethodNotAllowedException)throwable;
                errorPageTemplate = new MethodNotAllowedErrorPage(aeromockMethodNotAllowedException);
            } else {
                errorPageTemplate = new SystemErrorPage(t);
            }
            NotFoundErrorPage errorPage = errorPageTemplate;
            AccessLog$.MODULE$.writeAccessLog(((ErrorPageTemplate)errorPage).responseStatus().code());
            this.renderHtml(errorPage.render(), ((ErrorPageTemplate)errorPage).responseStatus(), (Option<CustomResponse>)None$.MODULE$, context);
        }
    }

    private ServerExceptionHandler$() {
        MODULE$ = this;
        HttpResponseWriter$class.$init$(this);
    }
}

