/*
 * freee API
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <pre><code>【重要】会計freee APIの新バージョンについて 2020年12月まで、2つのバージョンが利用できる状態です。古いものは2020年12月に利用不可となります。<br> 新しいAPIを利用するにはリクエストヘッダーに以下を指定します。 X-Api-Version: 2020-06-15<br> 指定がない場合は2020年12月に廃止予定のAPIを利用することとなります。<br> 【重要】APIのバージョン指定をせずに利用し続ける場合 2020年12月に新しいバージョンのAPIに自動的に切り替わります。 詳細は、<a href=\"https://developer.freee.co.jp/release-note/2948\" target=\"_blank\">リリースノート</a>をご覧ください。<br> 旧バージョンのAPIリファレンスを確認したい場合は、<a href=\"https://freee.github.io/freee-api-schema/\" target=\"_blank\">旧バージョンのAPIリファレンスページ</a>をご覧ください。 </code></pre>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2013-01-01&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsエンドポイント</h4>  <p>freeeは/reportsエンドポイントに対して1秒間に10以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>会計freeeプラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.co.freee.accounting.models.ApprovalRequestCreateParamsRequestItems;

/**
 * ApprovalRequestCreateParams
 */

public class ApprovalRequestCreateParams {
  public static final String SERIALIZED_NAME_APPLICATION_DATE = "application_date";
  @SerializedName(SERIALIZED_NAME_APPLICATION_DATE)
  private String applicationDate;

  public static final String SERIALIZED_NAME_APPROVAL_FLOW_ROUTE_ID = "approval_flow_route_id";
  @SerializedName(SERIALIZED_NAME_APPROVAL_FLOW_ROUTE_ID)
  private Integer approvalFlowRouteId;

  public static final String SERIALIZED_NAME_APPROVER_ID = "approver_id";
  @SerializedName(SERIALIZED_NAME_APPROVER_ID)
  private Integer approverId;

  public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
  @SerializedName(SERIALIZED_NAME_COMPANY_ID)
  private Integer companyId;

  public static final String SERIALIZED_NAME_DRAFT = "draft";
  @SerializedName(SERIALIZED_NAME_DRAFT)
  private Boolean draft;

  public static final String SERIALIZED_NAME_FORM_ID = "form_id";
  @SerializedName(SERIALIZED_NAME_FORM_ID)
  private Integer formId;

  public static final String SERIALIZED_NAME_PARENT_ID = "parent_id";
  @SerializedName(SERIALIZED_NAME_PARENT_ID)
  private Integer parentId;

  public static final String SERIALIZED_NAME_REQUEST_ITEMS = "request_items";
  @SerializedName(SERIALIZED_NAME_REQUEST_ITEMS)
  private List<ApprovalRequestCreateParamsRequestItems> requestItems = new ArrayList<>();


  public ApprovalRequestCreateParams applicationDate(String applicationDate) {
    
    this.applicationDate = applicationDate;
    return this;
  }

   /**
   * 申請日 (yyyy-mm-dd)
   * @return applicationDate
  **/
  @ApiModelProperty(example = "2020-01-01", required = true, value = "申請日 (yyyy-mm-dd)")

  public String getApplicationDate() {
    return applicationDate;
  }


  public void setApplicationDate(String applicationDate) {
    this.applicationDate = applicationDate;
  }


  public ApprovalRequestCreateParams approvalFlowRouteId(Integer approvalFlowRouteId) {
    
    this.approvalFlowRouteId = approvalFlowRouteId;
    return this;
  }

   /**
   * 申請経路ID
   * minimum: 1
   * maximum: 2147483647
   * @return approvalFlowRouteId
  **/
  @ApiModelProperty(example = "1", required = true, value = "申請経路ID")

  public Integer getApprovalFlowRouteId() {
    return approvalFlowRouteId;
  }


  public void setApprovalFlowRouteId(Integer approvalFlowRouteId) {
    this.approvalFlowRouteId = approvalFlowRouteId;
  }


  public ApprovalRequestCreateParams approverId(Integer approverId) {
    
    this.approverId = approverId;
    return this;
  }

   /**
   * 承認者のユーザーID
   * minimum: 1
   * maximum: 2147483647
   * @return approverId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "承認者のユーザーID")

  public Integer getApproverId() {
    return approverId;
  }


  public void setApproverId(Integer approverId) {
    this.approverId = approverId;
  }


  public ApprovalRequestCreateParams companyId(Integer companyId) {
    
    this.companyId = companyId;
    return this;
  }

   /**
   * 事業所ID
   * minimum: 1
   * maximum: 2147483647
   * @return companyId
  **/
  @ApiModelProperty(example = "1", required = true, value = "事業所ID")

  public Integer getCompanyId() {
    return companyId;
  }


  public void setCompanyId(Integer companyId) {
    this.companyId = companyId;
  }


  public ApprovalRequestCreateParams draft(Boolean draft) {
    
    this.draft = draft;
    return this;
  }

   /**
   * falseの時、in_progress:申請中で作成する。それ以外の時はdraft:下書きで作成する
   * @return draft
  **/
  @ApiModelProperty(example = "true", required = true, value = "falseの時、in_progress:申請中で作成する。それ以外の時はdraft:下書きで作成する")

  public Boolean getDraft() {
    return draft;
  }


  public void setDraft(Boolean draft) {
    this.draft = draft;
  }


  public ApprovalRequestCreateParams formId(Integer formId) {
    
    this.formId = formId;
    return this;
  }

   /**
   * 申請フォームID
   * minimum: 1
   * maximum: 2147483647
   * @return formId
  **/
  @ApiModelProperty(example = "1", required = true, value = "申請フォームID")

  public Integer getFormId() {
    return formId;
  }


  public void setFormId(Integer formId) {
    this.formId = formId;
  }


  public ApprovalRequestCreateParams parentId(Integer parentId) {
    
    this.parentId = parentId;
    return this;
  }

   /**
   * 親申請ID(既存各種申請IDのみ指定可能です。)
   * minimum: 1
   * maximum: 2147483647
   * @return parentId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2", value = "親申請ID(既存各種申請IDのみ指定可能です。)")

  public Integer getParentId() {
    return parentId;
  }


  public void setParentId(Integer parentId) {
    this.parentId = parentId;
  }


  public ApprovalRequestCreateParams requestItems(List<ApprovalRequestCreateParamsRequestItems> requestItems) {
    
    this.requestItems = requestItems;
    return this;
  }

  public ApprovalRequestCreateParams addRequestItemsItem(ApprovalRequestCreateParamsRequestItems requestItemsItem) {
    this.requestItems.add(requestItemsItem);
    return this;
  }

   /**
   * Get requestItems
   * @return requestItems
  **/
  @ApiModelProperty(required = true, value = "")

  public List<ApprovalRequestCreateParamsRequestItems> getRequestItems() {
    return requestItems;
  }


  public void setRequestItems(List<ApprovalRequestCreateParamsRequestItems> requestItems) {
    this.requestItems = requestItems;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApprovalRequestCreateParams approvalRequestCreateParams = (ApprovalRequestCreateParams) o;
    return Objects.equals(this.applicationDate, approvalRequestCreateParams.applicationDate) &&
        Objects.equals(this.approvalFlowRouteId, approvalRequestCreateParams.approvalFlowRouteId) &&
        Objects.equals(this.approverId, approvalRequestCreateParams.approverId) &&
        Objects.equals(this.companyId, approvalRequestCreateParams.companyId) &&
        Objects.equals(this.draft, approvalRequestCreateParams.draft) &&
        Objects.equals(this.formId, approvalRequestCreateParams.formId) &&
        Objects.equals(this.parentId, approvalRequestCreateParams.parentId) &&
        Objects.equals(this.requestItems, approvalRequestCreateParams.requestItems);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applicationDate, approvalFlowRouteId, approverId, companyId, draft, formId, parentId, requestItems);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApprovalRequestCreateParams {\n");
    sb.append("    applicationDate: ").append(toIndentedString(applicationDate)).append("\n");
    sb.append("    approvalFlowRouteId: ").append(toIndentedString(approvalFlowRouteId)).append("\n");
    sb.append("    approverId: ").append(toIndentedString(approverId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    draft: ").append(toIndentedString(draft)).append("\n");
    sb.append("    formId: ").append(toIndentedString(formId)).append("\n");
    sb.append("    parentId: ").append(toIndentedString(parentId)).append("\n");
    sb.append("    requestItems: ").append(toIndentedString(requestItems)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

