/*
 * freee API
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <pre><code>【重要】会計freee APIの新バージョンについて 2020年12月まで、2つのバージョンが利用できる状態です。古いものは2020年12月に利用不可となります。<br> 新しいAPIを利用するにはリクエストヘッダーに以下を指定します。 X-Api-Version: 2020-06-15<br> 指定がない場合は2020年12月に廃止予定のAPIを利用することとなります。<br> 【重要】APIのバージョン指定をせずに利用し続ける場合 2020年12月に新しいバージョンのAPIに自動的に切り替わります。 詳細は、<a href=\"https://developer.freee.co.jp/release-note/2948\" target=\"_blank\">リリースノート</a>をご覧ください。<br> 旧バージョンのAPIリファレンスを確認したい場合は、<a href=\"https://freee.github.io/freee-api-schema/\" target=\"_blank\">旧バージョンのAPIリファレンスページ</a>をご覧ください。 </code></pre>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2013-01-01&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsエンドポイント</h4>  <p>freeeは/reportsエンドポイントに対して1秒間に10以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>会計freeeプラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.co.freee.accounting.models.ApprovalRequestResponseApprovalRequestApprovalFlowLogs;
import jp.co.freee.accounting.models.ApprovalRequestResponseApprovalRequestApprovalRequestForm;
import jp.co.freee.accounting.models.ApprovalRequestResponseApprovalRequestApprovers;
import jp.co.freee.accounting.models.ApprovalRequestResponseApprovalRequestComments;
import jp.co.freee.accounting.models.ApprovalRequestResponseApprovalRequestRequestItems;

/**
 * ApprovalRequestResponseApprovalRequest
 */

public class ApprovalRequestResponseApprovalRequest {
  public static final String SERIALIZED_NAME_APPLICANT_ID = "applicant_id";
  @SerializedName(SERIALIZED_NAME_APPLICANT_ID)
  private Integer applicantId;

  public static final String SERIALIZED_NAME_APPLICATION_DATE = "application_date";
  @SerializedName(SERIALIZED_NAME_APPLICATION_DATE)
  private String applicationDate;

  public static final String SERIALIZED_NAME_APPLICATION_NUMBER = "application_number";
  @SerializedName(SERIALIZED_NAME_APPLICATION_NUMBER)
  private String applicationNumber;

  public static final String SERIALIZED_NAME_APPROVAL_FLOW_LOGS = "approval_flow_logs";
  @SerializedName(SERIALIZED_NAME_APPROVAL_FLOW_LOGS)
  private List<ApprovalRequestResponseApprovalRequestApprovalFlowLogs> approvalFlowLogs = new ArrayList<>();

  public static final String SERIALIZED_NAME_APPROVAL_FLOW_ROUTE_ID = "approval_flow_route_id";
  @SerializedName(SERIALIZED_NAME_APPROVAL_FLOW_ROUTE_ID)
  private Integer approvalFlowRouteId;

  public static final String SERIALIZED_NAME_APPROVAL_REQUEST_FORM = "approval_request_form";
  @SerializedName(SERIALIZED_NAME_APPROVAL_REQUEST_FORM)
  private ApprovalRequestResponseApprovalRequestApprovalRequestForm approvalRequestForm;

  public static final String SERIALIZED_NAME_APPROVERS = "approvers";
  @SerializedName(SERIALIZED_NAME_APPROVERS)
  private List<ApprovalRequestResponseApprovalRequestApprovers> approvers = new ArrayList<>();

  public static final String SERIALIZED_NAME_COMMENTS = "comments";
  @SerializedName(SERIALIZED_NAME_COMMENTS)
  private List<ApprovalRequestResponseApprovalRequestComments> comments = new ArrayList<>();

  public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
  @SerializedName(SERIALIZED_NAME_COMPANY_ID)
  private Integer companyId;

  public static final String SERIALIZED_NAME_CURRENT_ROUND = "current_round";
  @SerializedName(SERIALIZED_NAME_CURRENT_ROUND)
  private Integer currentRound;

  public static final String SERIALIZED_NAME_CURRENT_STEP_ID = "current_step_id";
  @SerializedName(SERIALIZED_NAME_CURRENT_STEP_ID)
  private Integer currentStepId;

  public static final String SERIALIZED_NAME_FORM_ID = "form_id";
  @SerializedName(SERIALIZED_NAME_FORM_ID)
  private Integer formId;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Integer id;

  public static final String SERIALIZED_NAME_REQUEST_ITEMS = "request_items";
  @SerializedName(SERIALIZED_NAME_REQUEST_ITEMS)
  private List<ApprovalRequestResponseApprovalRequestRequestItems> requestItems = new ArrayList<>();

  /**
   * 申請ステータス(draft:下書き, in_progress:申請中, approved:承認済, rejected:却下, feedback:差戻し)
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    DRAFT("draft"),
    
    IN_PROGRESS("in_progress"),
    
    APPROVED("approved"),
    
    REJECTED("rejected"),
    
    FEEDBACK("feedback");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_TITLE = "title";
  @SerializedName(SERIALIZED_NAME_TITLE)
  private String title;


  public ApprovalRequestResponseApprovalRequest applicantId(Integer applicantId) {
    
    this.applicantId = applicantId;
    return this;
  }

   /**
   * 申請者のユーザーID
   * minimum: 1
   * maximum: 2147483647
   * @return applicantId
  **/
  @ApiModelProperty(example = "1", required = true, value = "申請者のユーザーID")

  public Integer getApplicantId() {
    return applicantId;
  }


  public void setApplicantId(Integer applicantId) {
    this.applicantId = applicantId;
  }


  public ApprovalRequestResponseApprovalRequest applicationDate(String applicationDate) {
    
    this.applicationDate = applicationDate;
    return this;
  }

   /**
   * 申請日 (yyyy-mm-dd)
   * @return applicationDate
  **/
  @ApiModelProperty(example = "2018-07-19", required = true, value = "申請日 (yyyy-mm-dd)")

  public String getApplicationDate() {
    return applicationDate;
  }


  public void setApplicationDate(String applicationDate) {
    this.applicationDate = applicationDate;
  }


  public ApprovalRequestResponseApprovalRequest applicationNumber(String applicationNumber) {
    
    this.applicationNumber = applicationNumber;
    return this;
  }

   /**
   * 申請No.
   * @return applicationNumber
  **/
  @ApiModelProperty(example = "2", required = true, value = "申請No.")

  public String getApplicationNumber() {
    return applicationNumber;
  }


  public void setApplicationNumber(String applicationNumber) {
    this.applicationNumber = applicationNumber;
  }


  public ApprovalRequestResponseApprovalRequest approvalFlowLogs(List<ApprovalRequestResponseApprovalRequestApprovalFlowLogs> approvalFlowLogs) {
    
    this.approvalFlowLogs = approvalFlowLogs;
    return this;
  }

  public ApprovalRequestResponseApprovalRequest addApprovalFlowLogsItem(ApprovalRequestResponseApprovalRequestApprovalFlowLogs approvalFlowLogsItem) {
    this.approvalFlowLogs.add(approvalFlowLogsItem);
    return this;
  }

   /**
   * 各種申請の承認履歴（配列）
   * @return approvalFlowLogs
  **/
  @ApiModelProperty(required = true, value = "各種申請の承認履歴（配列）")

  public List<ApprovalRequestResponseApprovalRequestApprovalFlowLogs> getApprovalFlowLogs() {
    return approvalFlowLogs;
  }


  public void setApprovalFlowLogs(List<ApprovalRequestResponseApprovalRequestApprovalFlowLogs> approvalFlowLogs) {
    this.approvalFlowLogs = approvalFlowLogs;
  }


  public ApprovalRequestResponseApprovalRequest approvalFlowRouteId(Integer approvalFlowRouteId) {
    
    this.approvalFlowRouteId = approvalFlowRouteId;
    return this;
  }

   /**
   * 申請経路ID
   * minimum: 1
   * maximum: 2147483647
   * @return approvalFlowRouteId
  **/
  @ApiModelProperty(example = "1", required = true, value = "申請経路ID")

  public Integer getApprovalFlowRouteId() {
    return approvalFlowRouteId;
  }


  public void setApprovalFlowRouteId(Integer approvalFlowRouteId) {
    this.approvalFlowRouteId = approvalFlowRouteId;
  }


  public ApprovalRequestResponseApprovalRequest approvalRequestForm(ApprovalRequestResponseApprovalRequestApprovalRequestForm approvalRequestForm) {
    
    this.approvalRequestForm = approvalRequestForm;
    return this;
  }

   /**
   * Get approvalRequestForm
   * @return approvalRequestForm
  **/
  @ApiModelProperty(required = true, value = "")

  public ApprovalRequestResponseApprovalRequestApprovalRequestForm getApprovalRequestForm() {
    return approvalRequestForm;
  }


  public void setApprovalRequestForm(ApprovalRequestResponseApprovalRequestApprovalRequestForm approvalRequestForm) {
    this.approvalRequestForm = approvalRequestForm;
  }


  public ApprovalRequestResponseApprovalRequest approvers(List<ApprovalRequestResponseApprovalRequestApprovers> approvers) {
    
    this.approvers = approvers;
    return this;
  }

  public ApprovalRequestResponseApprovalRequest addApproversItem(ApprovalRequestResponseApprovalRequestApprovers approversItem) {
    this.approvers.add(approversItem);
    return this;
  }

   /**
   * 承認者（配列）   承認ステップのresource_typeがunspecified (指定なし)の場合はapproversはレスポンスに含まれません。   しかし、resource_typeがunspecifiedの承認ステップにおいて誰かが承認・却下・差し戻しのいずれかのアクションを取った後は、    approversはレスポンスに含まれるようになります。    その場合approversにはアクションを行ったステップのIDとアクションを行ったユーザーのIDが含まれます。
   * @return approvers
  **/
  @ApiModelProperty(required = true, value = "承認者（配列）   承認ステップのresource_typeがunspecified (指定なし)の場合はapproversはレスポンスに含まれません。   しかし、resource_typeがunspecifiedの承認ステップにおいて誰かが承認・却下・差し戻しのいずれかのアクションを取った後は、    approversはレスポンスに含まれるようになります。    その場合approversにはアクションを行ったステップのIDとアクションを行ったユーザーのIDが含まれます。")

  public List<ApprovalRequestResponseApprovalRequestApprovers> getApprovers() {
    return approvers;
  }


  public void setApprovers(List<ApprovalRequestResponseApprovalRequestApprovers> approvers) {
    this.approvers = approvers;
  }


  public ApprovalRequestResponseApprovalRequest comments(List<ApprovalRequestResponseApprovalRequestComments> comments) {
    
    this.comments = comments;
    return this;
  }

  public ApprovalRequestResponseApprovalRequest addCommentsItem(ApprovalRequestResponseApprovalRequestComments commentsItem) {
    this.comments.add(commentsItem);
    return this;
  }

   /**
   * 各種申請のコメント一覧（配列）
   * @return comments
  **/
  @ApiModelProperty(required = true, value = "各種申請のコメント一覧（配列）")

  public List<ApprovalRequestResponseApprovalRequestComments> getComments() {
    return comments;
  }


  public void setComments(List<ApprovalRequestResponseApprovalRequestComments> comments) {
    this.comments = comments;
  }


  public ApprovalRequestResponseApprovalRequest companyId(Integer companyId) {
    
    this.companyId = companyId;
    return this;
  }

   /**
   * 事業所ID
   * minimum: 1
   * maximum: 2147483647
   * @return companyId
  **/
  @ApiModelProperty(example = "1", required = true, value = "事業所ID")

  public Integer getCompanyId() {
    return companyId;
  }


  public void setCompanyId(Integer companyId) {
    this.companyId = companyId;
  }


  public ApprovalRequestResponseApprovalRequest currentRound(Integer currentRound) {
    
    this.currentRound = currentRound;
    return this;
  }

   /**
   * 現在のround。差し戻し等により申請がstepの最初からやり直しになるとroundの値が増えます。
   * minimum: 0
   * maximum: 2147483647
   * @return currentRound
  **/
  @ApiModelProperty(example = "1", required = true, value = "現在のround。差し戻し等により申請がstepの最初からやり直しになるとroundの値が増えます。")

  public Integer getCurrentRound() {
    return currentRound;
  }


  public void setCurrentRound(Integer currentRound) {
    this.currentRound = currentRound;
  }


  public ApprovalRequestResponseApprovalRequest currentStepId(Integer currentStepId) {
    
    this.currentStepId = currentStepId;
    return this;
  }

   /**
   * 現在承認ステップID
   * minimum: 1
   * maximum: 2147483647
   * @return currentStepId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", required = true, value = "現在承認ステップID")

  public Integer getCurrentStepId() {
    return currentStepId;
  }


  public void setCurrentStepId(Integer currentStepId) {
    this.currentStepId = currentStepId;
  }


  public ApprovalRequestResponseApprovalRequest formId(Integer formId) {
    
    this.formId = formId;
    return this;
  }

   /**
   * 申請フォームID
   * minimum: 1
   * maximum: 2147483647
   * @return formId
  **/
  @ApiModelProperty(example = "1", required = true, value = "申請フォームID")

  public Integer getFormId() {
    return formId;
  }


  public void setFormId(Integer formId) {
    this.formId = formId;
  }


  public ApprovalRequestResponseApprovalRequest id(Integer id) {
    
    this.id = id;
    return this;
  }

   /**
   * 各種申請ID
   * minimum: 1
   * maximum: 2147483647
   * @return id
  **/
  @ApiModelProperty(example = "1", required = true, value = "各種申請ID")

  public Integer getId() {
    return id;
  }


  public void setId(Integer id) {
    this.id = id;
  }


  public ApprovalRequestResponseApprovalRequest requestItems(List<ApprovalRequestResponseApprovalRequestRequestItems> requestItems) {
    
    this.requestItems = requestItems;
    return this;
  }

  public ApprovalRequestResponseApprovalRequest addRequestItemsItem(ApprovalRequestResponseApprovalRequestRequestItems requestItemsItem) {
    this.requestItems.add(requestItemsItem);
    return this;
  }

   /**
   * 各種申請の項目一覧（配列）
   * @return requestItems
  **/
  @ApiModelProperty(required = true, value = "各種申請の項目一覧（配列）")

  public List<ApprovalRequestResponseApprovalRequestRequestItems> getRequestItems() {
    return requestItems;
  }


  public void setRequestItems(List<ApprovalRequestResponseApprovalRequestRequestItems> requestItems) {
    this.requestItems = requestItems;
  }


  public ApprovalRequestResponseApprovalRequest status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * 申請ステータス(draft:下書き, in_progress:申請中, approved:承認済, rejected:却下, feedback:差戻し)
   * @return status
  **/
  @ApiModelProperty(example = "draft", required = true, value = "申請ステータス(draft:下書き, in_progress:申請中, approved:承認済, rejected:却下, feedback:差戻し)")

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public ApprovalRequestResponseApprovalRequest title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * 申請タイトル
   * @return title
  **/
  @ApiModelProperty(example = "大阪出張", required = true, value = "申請タイトル")

  public String getTitle() {
    return title;
  }


  public void setTitle(String title) {
    this.title = title;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    ApprovalRequestResponseApprovalRequest approvalRequestResponseApprovalRequest = (ApprovalRequestResponseApprovalRequest) o;
    return Objects.equals(this.applicantId, approvalRequestResponseApprovalRequest.applicantId) &&
        Objects.equals(this.applicationDate, approvalRequestResponseApprovalRequest.applicationDate) &&
        Objects.equals(this.applicationNumber, approvalRequestResponseApprovalRequest.applicationNumber) &&
        Objects.equals(this.approvalFlowLogs, approvalRequestResponseApprovalRequest.approvalFlowLogs) &&
        Objects.equals(this.approvalFlowRouteId, approvalRequestResponseApprovalRequest.approvalFlowRouteId) &&
        Objects.equals(this.approvalRequestForm, approvalRequestResponseApprovalRequest.approvalRequestForm) &&
        Objects.equals(this.approvers, approvalRequestResponseApprovalRequest.approvers) &&
        Objects.equals(this.comments, approvalRequestResponseApprovalRequest.comments) &&
        Objects.equals(this.companyId, approvalRequestResponseApprovalRequest.companyId) &&
        Objects.equals(this.currentRound, approvalRequestResponseApprovalRequest.currentRound) &&
        Objects.equals(this.currentStepId, approvalRequestResponseApprovalRequest.currentStepId) &&
        Objects.equals(this.formId, approvalRequestResponseApprovalRequest.formId) &&
        Objects.equals(this.id, approvalRequestResponseApprovalRequest.id) &&
        Objects.equals(this.requestItems, approvalRequestResponseApprovalRequest.requestItems) &&
        Objects.equals(this.status, approvalRequestResponseApprovalRequest.status) &&
        Objects.equals(this.title, approvalRequestResponseApprovalRequest.title);
  }

  @Override
  public int hashCode() {
    return Objects.hash(applicantId, applicationDate, applicationNumber, approvalFlowLogs, approvalFlowRouteId, approvalRequestForm, approvers, comments, companyId, currentRound, currentStepId, formId, id, requestItems, status, title);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class ApprovalRequestResponseApprovalRequest {\n");
    sb.append("    applicantId: ").append(toIndentedString(applicantId)).append("\n");
    sb.append("    applicationDate: ").append(toIndentedString(applicationDate)).append("\n");
    sb.append("    applicationNumber: ").append(toIndentedString(applicationNumber)).append("\n");
    sb.append("    approvalFlowLogs: ").append(toIndentedString(approvalFlowLogs)).append("\n");
    sb.append("    approvalFlowRouteId: ").append(toIndentedString(approvalFlowRouteId)).append("\n");
    sb.append("    approvalRequestForm: ").append(toIndentedString(approvalRequestForm)).append("\n");
    sb.append("    approvers: ").append(toIndentedString(approvers)).append("\n");
    sb.append("    comments: ").append(toIndentedString(comments)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    currentRound: ").append(toIndentedString(currentRound)).append("\n");
    sb.append("    currentStepId: ").append(toIndentedString(currentStepId)).append("\n");
    sb.append("    formId: ").append(toIndentedString(formId)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    requestItems: ").append(toIndentedString(requestItems)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

