/*
 * freee API
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <pre><code>【重要】会計freee APIの新バージョンについて 2020年12月まで、2つのバージョンが利用できる状態です。古いものは2020年12月に利用不可となります。<br> 新しいAPIを利用するにはリクエストヘッダーに以下を指定します。 X-Api-Version: 2020-06-15<br> 指定がない場合は2020年12月に廃止予定のAPIを利用することとなります。<br> 【重要】APIのバージョン指定をせずに利用し続ける場合 2020年12月に新しいバージョンのAPIに自動的に切り替わります。 詳細は、<a href=\"https://developer.freee.co.jp/release-note/2948\" target=\"_blank\">リリースノート</a>をご覧ください。<br> 旧バージョンのAPIリファレンスを確認したい場合は、<a href=\"https://freee.github.io/freee-api-schema/\" target=\"_blank\">旧バージョンのAPIリファレンスページ</a>をご覧ください。 </code></pre>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2013-01-01&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsエンドポイント</h4>  <p>freeeは/reportsエンドポイントに対して1秒間に10以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>会計freeeプラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * CompanyParamsFiscalYears
 */

public class CompanyParamsFiscalYears {
  public static final String SERIALIZED_NAME_ACCOUNTING_PERIOD = "accounting_period";
  @SerializedName(SERIALIZED_NAME_ACCOUNTING_PERIOD)
  private Integer accountingPeriod;

  public static final String SERIALIZED_NAME_DEPRECIATION_FRACTION = "depreciation_fraction";
  @SerializedName(SERIALIZED_NAME_DEPRECIATION_FRACTION)
  private Integer depreciationFraction;

  public static final String SERIALIZED_NAME_END_DATE = "end_date";
  @SerializedName(SERIALIZED_NAME_END_DATE)
  private String endDate;

  public static final String SERIALIZED_NAME_INDIRECT_WRITE_OFF_METHOD = "indirect_write_off_method";
  @SerializedName(SERIALIZED_NAME_INDIRECT_WRITE_OFF_METHOD)
  private Boolean indirectWriteOffMethod;

  public static final String SERIALIZED_NAME_INDIRECT_WRITE_OFF_METHOD_TYPE = "indirect_write_off_method_type";
  @SerializedName(SERIALIZED_NAME_INDIRECT_WRITE_OFF_METHOD_TYPE)
  private Boolean indirectWriteOffMethodType;

  public static final String SERIALIZED_NAME_RETURN_CODE = "return_code";
  @SerializedName(SERIALIZED_NAME_RETURN_CODE)
  private Integer returnCode;

  public static final String SERIALIZED_NAME_START_DATE = "start_date";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private String startDate;

  public static final String SERIALIZED_NAME_TAX_FRACTION = "tax_fraction";
  @SerializedName(SERIALIZED_NAME_TAX_FRACTION)
  private Integer taxFraction;

  public static final String SERIALIZED_NAME_USE_INDUSTRY_TEMPLATE = "use_industry_template";
  @SerializedName(SERIALIZED_NAME_USE_INDUSTRY_TEMPLATE)
  private Boolean useIndustryTemplate;


  public CompanyParamsFiscalYears accountingPeriod(Integer accountingPeriod) {
    
    this.accountingPeriod = accountingPeriod;
    return this;
  }

   /**
   * 期
   * @return accountingPeriod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "期")

  public Integer getAccountingPeriod() {
    return accountingPeriod;
  }


  public void setAccountingPeriod(Integer accountingPeriod) {
    this.accountingPeriod = accountingPeriod;
  }


  public CompanyParamsFiscalYears depreciationFraction(Integer depreciationFraction) {
    
    this.depreciationFraction = depreciationFraction;
    return this;
  }

   /**
   * 減価償却端数処理法(法人のみ)(0: 切り捨て、1: 切り上げ)
   * minimum: 0
   * maximum: 1
   * @return depreciationFraction
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "減価償却端数処理法(法人のみ)(0: 切り捨て、1: 切り上げ)")

  public Integer getDepreciationFraction() {
    return depreciationFraction;
  }


  public void setDepreciationFraction(Integer depreciationFraction) {
    this.depreciationFraction = depreciationFraction;
  }


  public CompanyParamsFiscalYears endDate(String endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * 期末日（決算日）
   * @return endDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2018-12-31", value = "期末日（決算日）")

  public String getEndDate() {
    return endDate;
  }


  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }


  public CompanyParamsFiscalYears indirectWriteOffMethod(Boolean indirectWriteOffMethod) {
    
    this.indirectWriteOffMethod = indirectWriteOffMethod;
    return this;
  }

   /**
   * 固定資産の控除法（true: 間接控除法、false: 直接控除法）
   * @return indirectWriteOffMethod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "固定資産の控除法（true: 間接控除法、false: 直接控除法）")

  public Boolean getIndirectWriteOffMethod() {
    return indirectWriteOffMethod;
  }


  public void setIndirectWriteOffMethod(Boolean indirectWriteOffMethod) {
    this.indirectWriteOffMethod = indirectWriteOffMethod;
  }


  public CompanyParamsFiscalYears indirectWriteOffMethodType(Boolean indirectWriteOffMethodType) {
    
    this.indirectWriteOffMethodType = indirectWriteOffMethodType;
    return this;
  }

   /**
   * 間接控除時の累計額（true: 資産分類別、false: 共通）
   * @return indirectWriteOffMethodType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "間接控除時の累計額（true: 資産分類別、false: 共通）")

  public Boolean getIndirectWriteOffMethodType() {
    return indirectWriteOffMethodType;
  }


  public void setIndirectWriteOffMethodType(Boolean indirectWriteOffMethodType) {
    this.indirectWriteOffMethodType = indirectWriteOffMethodType;
  }


  public CompanyParamsFiscalYears returnCode(Integer returnCode) {
    
    this.returnCode = returnCode;
    return this;
  }

   /**
   * 不動産所得使用区分（0: 一般、3: 一般/不動産） ※個人事業主のみ設定可能
   * minimum: 0
   * maximum: 3
   * @return returnCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0", value = "不動産所得使用区分（0: 一般、3: 一般/不動産） ※個人事業主のみ設定可能")

  public Integer getReturnCode() {
    return returnCode;
  }


  public void setReturnCode(Integer returnCode) {
    this.returnCode = returnCode;
  }


  public CompanyParamsFiscalYears startDate(String startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * 期首日
   * @return startDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2018-01-01", value = "期首日")

  public String getStartDate() {
    return startDate;
  }


  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }


  public CompanyParamsFiscalYears taxFraction(Integer taxFraction) {
    
    this.taxFraction = taxFraction;
    return this;
  }

   /**
   * 消費税端数処理方法（0: 切り上げ、1: 切り捨て, 2: 四捨五入）
   * minimum: 0
   * maximum: 2
   * @return taxFraction
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "0", value = "消費税端数処理方法（0: 切り上げ、1: 切り捨て, 2: 四捨五入）")

  public Integer getTaxFraction() {
    return taxFraction;
  }


  public void setTaxFraction(Integer taxFraction) {
    this.taxFraction = taxFraction;
  }


  public CompanyParamsFiscalYears useIndustryTemplate(Boolean useIndustryTemplate) {
    
    this.useIndustryTemplate = useIndustryTemplate;
    return this;
  }

   /**
   * 製造業向け機能（true: 使用する、false: 使用しない）
   * @return useIndustryTemplate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "false", value = "製造業向け機能（true: 使用する、false: 使用しない）")

  public Boolean getUseIndustryTemplate() {
    return useIndustryTemplate;
  }


  public void setUseIndustryTemplate(Boolean useIndustryTemplate) {
    this.useIndustryTemplate = useIndustryTemplate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    CompanyParamsFiscalYears companyParamsFiscalYears = (CompanyParamsFiscalYears) o;
    return Objects.equals(this.accountingPeriod, companyParamsFiscalYears.accountingPeriod) &&
        Objects.equals(this.depreciationFraction, companyParamsFiscalYears.depreciationFraction) &&
        Objects.equals(this.endDate, companyParamsFiscalYears.endDate) &&
        Objects.equals(this.indirectWriteOffMethod, companyParamsFiscalYears.indirectWriteOffMethod) &&
        Objects.equals(this.indirectWriteOffMethodType, companyParamsFiscalYears.indirectWriteOffMethodType) &&
        Objects.equals(this.returnCode, companyParamsFiscalYears.returnCode) &&
        Objects.equals(this.startDate, companyParamsFiscalYears.startDate) &&
        Objects.equals(this.taxFraction, companyParamsFiscalYears.taxFraction) &&
        Objects.equals(this.useIndustryTemplate, companyParamsFiscalYears.useIndustryTemplate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountingPeriod, depreciationFraction, endDate, indirectWriteOffMethod, indirectWriteOffMethodType, returnCode, startDate, taxFraction, useIndustryTemplate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class CompanyParamsFiscalYears {\n");
    sb.append("    accountingPeriod: ").append(toIndentedString(accountingPeriod)).append("\n");
    sb.append("    depreciationFraction: ").append(toIndentedString(depreciationFraction)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    indirectWriteOffMethod: ").append(toIndentedString(indirectWriteOffMethod)).append("\n");
    sb.append("    indirectWriteOffMethodType: ").append(toIndentedString(indirectWriteOffMethodType)).append("\n");
    sb.append("    returnCode: ").append(toIndentedString(returnCode)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    taxFraction: ").append(toIndentedString(taxFraction)).append("\n");
    sb.append("    useIndustryTemplate: ").append(toIndentedString(useIndustryTemplate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

