/*
 * freee API
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <pre><code>【重要】会計freee APIの新バージョンについて 2020年12月まで、2つのバージョンが利用できる状態です。古いものは2020年12月に利用不可となります。<br> 新しいAPIを利用するにはリクエストヘッダーに以下を指定します。 X-Api-Version: 2020-06-15<br> 指定がない場合は2020年12月に廃止予定のAPIを利用することとなります。<br> 【重要】APIのバージョン指定をせずに利用し続ける場合 2020年12月に新しいバージョンのAPIに自動的に切り替わります。 詳細は、<a href=\"https://developer.freee.co.jp/release-note/2948\" target=\"_blank\">リリースノート</a>をご覧ください。<br> 旧バージョンのAPIリファレンスを確認したい場合は、<a href=\"https://freee.github.io/freee-api-schema/\" target=\"_blank\">旧バージョンのAPIリファレンスページ</a>をご覧ください。 </code></pre>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2013-01-01&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsエンドポイント</h4>  <p>freeeは/reportsエンドポイントに対して1秒間に10以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>会計freeeプラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * FiscalYears
 */

public class FiscalYears {
  public static final String SERIALIZED_NAME_DEPRECIATION_RECORD_METHOD = "depreciation_record_method";
  @SerializedName(SERIALIZED_NAME_DEPRECIATION_RECORD_METHOD)
  private Integer depreciationRecordMethod;

  public static final String SERIALIZED_NAME_END_DATE = "end_date";
  @SerializedName(SERIALIZED_NAME_END_DATE)
  private String endDate;

  public static final String SERIALIZED_NAME_INDIRECT_WRITE_OFF_METHOD = "indirect_write_off_method";
  @SerializedName(SERIALIZED_NAME_INDIRECT_WRITE_OFF_METHOD)
  private Boolean indirectWriteOffMethod;

  public static final String SERIALIZED_NAME_RETURN_CODE = "return_code";
  @SerializedName(SERIALIZED_NAME_RETURN_CODE)
  private Integer returnCode;

  public static final String SERIALIZED_NAME_SALES_TAX_BUSINESS_CODE = "sales_tax_business_code";
  @SerializedName(SERIALIZED_NAME_SALES_TAX_BUSINESS_CODE)
  private Integer salesTaxBusinessCode;

  public static final String SERIALIZED_NAME_START_DATE = "start_date";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private String startDate;

  public static final String SERIALIZED_NAME_TAX_ACCOUNT_METHOD = "tax_account_method";
  @SerializedName(SERIALIZED_NAME_TAX_ACCOUNT_METHOD)
  private Integer taxAccountMethod;

  public static final String SERIALIZED_NAME_TAX_FRACTION = "tax_fraction";
  @SerializedName(SERIALIZED_NAME_TAX_FRACTION)
  private Integer taxFraction;

  public static final String SERIALIZED_NAME_TAX_METHOD = "tax_method";
  @SerializedName(SERIALIZED_NAME_TAX_METHOD)
  private Integer taxMethod;

  public static final String SERIALIZED_NAME_USE_INDUSTRY_TEMPLATE = "use_industry_template";
  @SerializedName(SERIALIZED_NAME_USE_INDUSTRY_TEMPLATE)
  private Boolean useIndustryTemplate;


  public FiscalYears depreciationRecordMethod(Integer depreciationRecordMethod) {
    
    this.depreciationRecordMethod = depreciationRecordMethod;
    return this;
  }

   /**
   * 月次償却（0: しない、1: する）
   * minimum: 0
   * maximum: 1
   * @return depreciationRecordMethod
  **/
  @ApiModelProperty(example = "0", required = true, value = "月次償却（0: しない、1: する）")

  public Integer getDepreciationRecordMethod() {
    return depreciationRecordMethod;
  }


  public void setDepreciationRecordMethod(Integer depreciationRecordMethod) {
    this.depreciationRecordMethod = depreciationRecordMethod;
  }


  public FiscalYears endDate(String endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * 期末日
   * @return endDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2018-12-31", value = "期末日")

  public String getEndDate() {
    return endDate;
  }


  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }


  public FiscalYears indirectWriteOffMethod(Boolean indirectWriteOffMethod) {
    
    this.indirectWriteOffMethod = indirectWriteOffMethod;
    return this;
  }

   /**
   * 固定資産の控除法（true: 間接控除法、false: 直接控除法）
   * @return indirectWriteOffMethod
  **/
  @ApiModelProperty(example = "true", required = true, value = "固定資産の控除法（true: 間接控除法、false: 直接控除法）")

  public Boolean getIndirectWriteOffMethod() {
    return indirectWriteOffMethod;
  }


  public void setIndirectWriteOffMethod(Boolean indirectWriteOffMethod) {
    this.indirectWriteOffMethod = indirectWriteOffMethod;
  }


  public FiscalYears returnCode(Integer returnCode) {
    
    this.returnCode = returnCode;
    return this;
  }

   /**
   * 不動産所得使用区分（0: 一般、3: 一般/不動産） ※個人事業主のみ設定可能
   * minimum: 0
   * maximum: 3
   * @return returnCode
  **/
  @ApiModelProperty(example = "0", required = true, value = "不動産所得使用区分（0: 一般、3: 一般/不動産） ※個人事業主のみ設定可能")

  public Integer getReturnCode() {
    return returnCode;
  }


  public void setReturnCode(Integer returnCode) {
    this.returnCode = returnCode;
  }


  public FiscalYears salesTaxBusinessCode(Integer salesTaxBusinessCode) {
    
    this.salesTaxBusinessCode = salesTaxBusinessCode;
    return this;
  }

   /**
   * 簡易課税用事業区分（0: 第一種：卸売業、1: 第二種：小売業、2: 第三種：農林水産業、工業、建設業、製造業など、3: 第四種：飲食店業など、4: 第五種：金融・保険業、運輸通信業、サービス業など、5: 第六種：不動産業など
   * minimum: 0
   * maximum: 5
   * @return salesTaxBusinessCode
  **/
  @ApiModelProperty(example = "0", required = true, value = "簡易課税用事業区分（0: 第一種：卸売業、1: 第二種：小売業、2: 第三種：農林水産業、工業、建設業、製造業など、3: 第四種：飲食店業など、4: 第五種：金融・保険業、運輸通信業、サービス業など、5: 第六種：不動産業など")

  public Integer getSalesTaxBusinessCode() {
    return salesTaxBusinessCode;
  }


  public void setSalesTaxBusinessCode(Integer salesTaxBusinessCode) {
    this.salesTaxBusinessCode = salesTaxBusinessCode;
  }


  public FiscalYears startDate(String startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * 期首日
   * @return startDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2018-01-01", value = "期首日")

  public String getStartDate() {
    return startDate;
  }


  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }


  public FiscalYears taxAccountMethod(Integer taxAccountMethod) {
    
    this.taxAccountMethod = taxAccountMethod;
    return this;
  }

   /**
   * 消費税経理処理方法（0: 税込経理、1: 旧税抜経理、2: 税抜経理）
   * minimum: 0
   * maximum: 2
   * @return taxAccountMethod
  **/
  @ApiModelProperty(example = "0", required = true, value = "消費税経理処理方法（0: 税込経理、1: 旧税抜経理、2: 税抜経理）")

  public Integer getTaxAccountMethod() {
    return taxAccountMethod;
  }


  public void setTaxAccountMethod(Integer taxAccountMethod) {
    this.taxAccountMethod = taxAccountMethod;
  }


  public FiscalYears taxFraction(Integer taxFraction) {
    
    this.taxFraction = taxFraction;
    return this;
  }

   /**
   * 消費税端数処理方法（0: 切り捨て、1: 切り上げ、2: 四捨五入）
   * minimum: 0
   * maximum: 2
   * @return taxFraction
  **/
  @ApiModelProperty(example = "0", required = true, value = "消費税端数処理方法（0: 切り捨て、1: 切り上げ、2: 四捨五入）")

  public Integer getTaxFraction() {
    return taxFraction;
  }


  public void setTaxFraction(Integer taxFraction) {
    this.taxFraction = taxFraction;
  }


  public FiscalYears taxMethod(Integer taxMethod) {
    
    this.taxMethod = taxMethod;
    return this;
  }

   /**
   * 課税区分（0: 免税、1: 簡易課税、2: 本則課税（個別対応方式）、3: 本則課税（一括比例配分方式）、4: 本則課税（全額控除））
   * minimum: 0
   * maximum: 4
   * @return taxMethod
  **/
  @ApiModelProperty(example = "0", required = true, value = "課税区分（0: 免税、1: 簡易課税、2: 本則課税（個別対応方式）、3: 本則課税（一括比例配分方式）、4: 本則課税（全額控除））")

  public Integer getTaxMethod() {
    return taxMethod;
  }


  public void setTaxMethod(Integer taxMethod) {
    this.taxMethod = taxMethod;
  }


  public FiscalYears useIndustryTemplate(Boolean useIndustryTemplate) {
    
    this.useIndustryTemplate = useIndustryTemplate;
    return this;
  }

   /**
   * 製造業向け機能（true: 使用する、false: 使用しない）
   * @return useIndustryTemplate
  **/
  @ApiModelProperty(example = "false", required = true, value = "製造業向け機能（true: 使用する、false: 使用しない）")

  public Boolean getUseIndustryTemplate() {
    return useIndustryTemplate;
  }


  public void setUseIndustryTemplate(Boolean useIndustryTemplate) {
    this.useIndustryTemplate = useIndustryTemplate;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    FiscalYears fiscalYears = (FiscalYears) o;
    return Objects.equals(this.depreciationRecordMethod, fiscalYears.depreciationRecordMethod) &&
        Objects.equals(this.endDate, fiscalYears.endDate) &&
        Objects.equals(this.indirectWriteOffMethod, fiscalYears.indirectWriteOffMethod) &&
        Objects.equals(this.returnCode, fiscalYears.returnCode) &&
        Objects.equals(this.salesTaxBusinessCode, fiscalYears.salesTaxBusinessCode) &&
        Objects.equals(this.startDate, fiscalYears.startDate) &&
        Objects.equals(this.taxAccountMethod, fiscalYears.taxAccountMethod) &&
        Objects.equals(this.taxFraction, fiscalYears.taxFraction) &&
        Objects.equals(this.taxMethod, fiscalYears.taxMethod) &&
        Objects.equals(this.useIndustryTemplate, fiscalYears.useIndustryTemplate);
  }

  @Override
  public int hashCode() {
    return Objects.hash(depreciationRecordMethod, endDate, indirectWriteOffMethod, returnCode, salesTaxBusinessCode, startDate, taxAccountMethod, taxFraction, taxMethod, useIndustryTemplate);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class FiscalYears {\n");
    sb.append("    depreciationRecordMethod: ").append(toIndentedString(depreciationRecordMethod)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    indirectWriteOffMethod: ").append(toIndentedString(indirectWriteOffMethod)).append("\n");
    sb.append("    returnCode: ").append(toIndentedString(returnCode)).append("\n");
    sb.append("    salesTaxBusinessCode: ").append(toIndentedString(salesTaxBusinessCode)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    taxAccountMethod: ").append(toIndentedString(taxAccountMethod)).append("\n");
    sb.append("    taxFraction: ").append(toIndentedString(taxFraction)).append("\n");
    sb.append("    taxMethod: ").append(toIndentedString(taxMethod)).append("\n");
    sb.append("    useIndustryTemplate: ").append(toIndentedString(useIndustryTemplate)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

