/*
 * freee API
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <pre><code>【重要】会計freee APIの新バージョンについて 2020年12月まで、2つのバージョンが利用できる状態です。古いものは2020年12月に利用不可となります。<br> 新しいAPIを利用するにはリクエストヘッダーに以下を指定します。 X-Api-Version: 2020-06-15<br> 指定がない場合は2020年12月に廃止予定のAPIを利用することとなります。<br> 【重要】APIのバージョン指定をせずに利用し続ける場合 2020年12月に新しいバージョンのAPIに自動的に切り替わります。 詳細は、<a href=\"https://developer.freee.co.jp/release-note/2948\" target=\"_blank\">リリースノート</a>をご覧ください。<br> 旧バージョンのAPIリファレンスを確認したい場合は、<a href=\"https://freee.github.io/freee-api-schema/\" target=\"_blank\">旧バージョンのAPIリファレンスページ</a>をご覧ください。 </code></pre>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2013-01-01&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsエンドポイント</h4>  <p>freeeは/reportsエンドポイントに対して1秒間に10以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>会計freeeプラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import jp.co.freee.accounting.models.UserCapability;

/**
 * InlineResponse20016
 */

public class InlineResponse20016 {
  public static final String SERIALIZED_NAME_TAGS = "tags";
  @SerializedName(SERIALIZED_NAME_TAGS)
  private UserCapability tags;

  public static final String SERIALIZED_NAME_ACCOUNT_ITEM_STATEMENTS = "account_item_statements";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ITEM_STATEMENTS)
  private UserCapability accountItemStatements;

  public static final String SERIALIZED_NAME_ACCOUNT_ITEMS = "account_items";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ITEMS)
  private UserCapability accountItems;

  public static final String SERIALIZED_NAME_ANNUAL_REPORTS = "annual_reports";
  @SerializedName(SERIALIZED_NAME_ANNUAL_REPORTS)
  private UserCapability annualReports;

  public static final String SERIALIZED_NAME_APPROVAL_FLOW_ROUTES = "approval_flow_routes";
  @SerializedName(SERIALIZED_NAME_APPROVAL_FLOW_ROUTES)
  private UserCapability approvalFlowRoutes;

  public static final String SERIALIZED_NAME_APPROVAL_REQUESTS = "approval_requests";
  @SerializedName(SERIALIZED_NAME_APPROVAL_REQUESTS)
  private UserCapability approvalRequests;

  public static final String SERIALIZED_NAME_BACKUPS = "backups";
  @SerializedName(SERIALIZED_NAME_BACKUPS)
  private UserCapability backups;

  public static final String SERIALIZED_NAME_BANK_ACCOUNTANT_STAFF_USERS = "bank_accountant_staff_users";
  @SerializedName(SERIALIZED_NAME_BANK_ACCOUNTANT_STAFF_USERS)
  private UserCapability bankAccountantStaffUsers;

  public static final String SERIALIZED_NAME_BIZ_ALLOCATIONS = "biz_allocations";
  @SerializedName(SERIALIZED_NAME_BIZ_ALLOCATIONS)
  private UserCapability bizAllocations;

  public static final String SERIALIZED_NAME_COMPANIES = "companies";
  @SerializedName(SERIALIZED_NAME_COMPANIES)
  private UserCapability companies;

  public static final String SERIALIZED_NAME_CONSUMPTION_ENTRIES = "consumption_entries";
  @SerializedName(SERIALIZED_NAME_CONSUMPTION_ENTRIES)
  private UserCapability consumptionEntries;

  public static final String SERIALIZED_NAME_COST_ALLOCATIONS = "cost_allocations";
  @SerializedName(SERIALIZED_NAME_COST_ALLOCATIONS)
  private UserCapability costAllocations;

  public static final String SERIALIZED_NAME_DEAL_TEMPLATES = "deal_templates";
  @SerializedName(SERIALIZED_NAME_DEAL_TEMPLATES)
  private UserCapability dealTemplates;

  public static final String SERIALIZED_NAME_DEALS = "deals";
  @SerializedName(SERIALIZED_NAME_DEALS)
  private UserCapability deals;

  public static final String SERIALIZED_NAME_DOC_POSTINGS = "doc_postings";
  @SerializedName(SERIALIZED_NAME_DOC_POSTINGS)
  private UserCapability docPostings;

  public static final String SERIALIZED_NAME_DOCS = "docs";
  @SerializedName(SERIALIZED_NAME_DOCS)
  private UserCapability docs;

  public static final String SERIALIZED_NAME_EXPENSE_APPLICATION_TEMPLATES = "expense_application_templates";
  @SerializedName(SERIALIZED_NAME_EXPENSE_APPLICATION_TEMPLATES)
  private UserCapability expenseApplicationTemplates;

  public static final String SERIALIZED_NAME_EXPENSE_APPLICATIONS = "expense_applications";
  @SerializedName(SERIALIZED_NAME_EXPENSE_APPLICATIONS)
  private UserCapability expenseApplications;

  public static final String SERIALIZED_NAME_FIXED_ASSETS = "fixed_assets";
  @SerializedName(SERIALIZED_NAME_FIXED_ASSETS)
  private UserCapability fixedAssets;

  public static final String SERIALIZED_NAME_INVENTORY_REFRESHES = "inventory_refreshes";
  @SerializedName(SERIALIZED_NAME_INVENTORY_REFRESHES)
  private UserCapability inventoryRefreshes;

  public static final String SERIALIZED_NAME_INVITATIONS = "invitations";
  @SerializedName(SERIALIZED_NAME_INVITATIONS)
  private UserCapability invitations;

  public static final String SERIALIZED_NAME_ITEMS = "items";
  @SerializedName(SERIALIZED_NAME_ITEMS)
  private UserCapability items;

  public static final String SERIALIZED_NAME_MANUAL_JOURNAL_TEMPLATES = "manual_journal_templates";
  @SerializedName(SERIALIZED_NAME_MANUAL_JOURNAL_TEMPLATES)
  private UserCapability manualJournalTemplates;

  public static final String SERIALIZED_NAME_MANUAL_JOURNALS = "manual_journals";
  @SerializedName(SERIALIZED_NAME_MANUAL_JOURNALS)
  private UserCapability manualJournals;

  public static final String SERIALIZED_NAME_MONTH_END = "month_end";
  @SerializedName(SERIALIZED_NAME_MONTH_END)
  private UserCapability monthEnd;

  public static final String SERIALIZED_NAME_OAUTH_APPLICATIONS = "oauth_applications";
  @SerializedName(SERIALIZED_NAME_OAUTH_APPLICATIONS)
  private UserCapability oauthApplications;

  public static final String SERIALIZED_NAME_OAUTH_AUTHORIZATIONS = "oauth_authorizations";
  @SerializedName(SERIALIZED_NAME_OAUTH_AUTHORIZATIONS)
  private UserCapability oauthAuthorizations;

  public static final String SERIALIZED_NAME_OPENING_BALANCES = "opening_balances";
  @SerializedName(SERIALIZED_NAME_OPENING_BALANCES)
  private UserCapability openingBalances;

  public static final String SERIALIZED_NAME_PARTNERS = "partners";
  @SerializedName(SERIALIZED_NAME_PARTNERS)
  private UserCapability partners;

  public static final String SERIALIZED_NAME_PAYMENT_RECORDS = "payment_records";
  @SerializedName(SERIALIZED_NAME_PAYMENT_RECORDS)
  private UserCapability paymentRecords;

  public static final String SERIALIZED_NAME_PAYMENT_REQUESTS = "payment_requests";
  @SerializedName(SERIALIZED_NAME_PAYMENT_REQUESTS)
  private UserCapability paymentRequests;

  public static final String SERIALIZED_NAME_RECEIPT_STREAM_EDITOR = "receipt_stream_editor";
  @SerializedName(SERIALIZED_NAME_RECEIPT_STREAM_EDITOR)
  private UserCapability receiptStreamEditor;

  public static final String SERIALIZED_NAME_RECEIPTS = "receipts";
  @SerializedName(SERIALIZED_NAME_RECEIPTS)
  private UserCapability receipts;

  public static final String SERIALIZED_NAME_REPORTS = "reports";
  @SerializedName(SERIALIZED_NAME_REPORTS)
  private UserCapability reports;

  public static final String SERIALIZED_NAME_REPORTS_BS = "reports_bs";
  @SerializedName(SERIALIZED_NAME_REPORTS_BS)
  private UserCapability reportsBs;

  public static final String SERIALIZED_NAME_REPORTS_CASH_BALANCE = "reports_cash_balance";
  @SerializedName(SERIALIZED_NAME_REPORTS_CASH_BALANCE)
  private UserCapability reportsCashBalance;

  public static final String SERIALIZED_NAME_REPORTS_CROSSTABS = "reports_crosstabs";
  @SerializedName(SERIALIZED_NAME_REPORTS_CROSSTABS)
  private UserCapability reportsCrosstabs;

  public static final String SERIALIZED_NAME_REPORTS_GENERAL_LEDGERS = "reports_general_ledgers";
  @SerializedName(SERIALIZED_NAME_REPORTS_GENERAL_LEDGERS)
  private UserCapability reportsGeneralLedgers;

  public static final String SERIALIZED_NAME_REPORTS_INCOME_EXPENSE = "reports_income_expense";
  @SerializedName(SERIALIZED_NAME_REPORTS_INCOME_EXPENSE)
  private UserCapability reportsIncomeExpense;

  public static final String SERIALIZED_NAME_REPORTS_JOURNALS = "reports_journals";
  @SerializedName(SERIALIZED_NAME_REPORTS_JOURNALS)
  private UserCapability reportsJournals;

  public static final String SERIALIZED_NAME_REPORTS_MANAGEMENTS_NAVIGATION = "reports_managements_navigation";
  @SerializedName(SERIALIZED_NAME_REPORTS_MANAGEMENTS_NAVIGATION)
  private UserCapability reportsManagementsNavigation;

  public static final String SERIALIZED_NAME_REPORTS_MANAGEMENTS_PLANNING = "reports_managements_planning";
  @SerializedName(SERIALIZED_NAME_REPORTS_MANAGEMENTS_PLANNING)
  private UserCapability reportsManagementsPlanning;

  public static final String SERIALIZED_NAME_REPORTS_PAYABLES = "reports_payables";
  @SerializedName(SERIALIZED_NAME_REPORTS_PAYABLES)
  private UserCapability reportsPayables;

  public static final String SERIALIZED_NAME_REPORTS_PL = "reports_pl";
  @SerializedName(SERIALIZED_NAME_REPORTS_PL)
  private UserCapability reportsPl;

  public static final String SERIALIZED_NAME_REPORTS_RECEIVABLES = "reports_receivables";
  @SerializedName(SERIALIZED_NAME_REPORTS_RECEIVABLES)
  private UserCapability reportsReceivables;

  public static final String SERIALIZED_NAME_REQUEST_FORMS = "request_forms";
  @SerializedName(SERIALIZED_NAME_REQUEST_FORMS)
  private UserCapability requestForms;

  public static final String SERIALIZED_NAME_RESETS = "resets";
  @SerializedName(SERIALIZED_NAME_RESETS)
  private UserCapability resets;

  public static final String SERIALIZED_NAME_SECTIONS = "sections";
  @SerializedName(SERIALIZED_NAME_SECTIONS)
  private UserCapability sections;

  public static final String SERIALIZED_NAME_SIGN_IN_LOGS = "sign_in_logs";
  @SerializedName(SERIALIZED_NAME_SIGN_IN_LOGS)
  private UserCapability signInLogs;

  public static final String SERIALIZED_NAME_SPREADSHEETS = "spreadsheets";
  @SerializedName(SERIALIZED_NAME_SPREADSHEETS)
  private UserCapability spreadsheets;

  public static final String SERIALIZED_NAME_SYSTEM_CONVERSION = "system_conversion";
  @SerializedName(SERIALIZED_NAME_SYSTEM_CONVERSION)
  private UserCapability systemConversion;

  public static final String SERIALIZED_NAME_TAX_REPORTS = "tax_reports";
  @SerializedName(SERIALIZED_NAME_TAX_REPORTS)
  private UserCapability taxReports;

  public static final String SERIALIZED_NAME_TAX_RETURN = "tax_return";
  @SerializedName(SERIALIZED_NAME_TAX_RETURN)
  private UserCapability taxReturn;

  public static final String SERIALIZED_NAME_TAXES = "taxes";
  @SerializedName(SERIALIZED_NAME_TAXES)
  private UserCapability taxes;

  public static final String SERIALIZED_NAME_TRANSFERS = "transfers";
  @SerializedName(SERIALIZED_NAME_TRANSFERS)
  private UserCapability transfers;

  public static final String SERIALIZED_NAME_USER_MATCHERS = "user_matchers";
  @SerializedName(SERIALIZED_NAME_USER_MATCHERS)
  private UserCapability userMatchers;

  public static final String SERIALIZED_NAME_WALLET_TXNS = "wallet_txns";
  @SerializedName(SERIALIZED_NAME_WALLET_TXNS)
  private UserCapability walletTxns;

  public static final String SERIALIZED_NAME_WALLETABLES = "walletables";
  @SerializedName(SERIALIZED_NAME_WALLETABLES)
  private UserCapability walletables;

  public static final String SERIALIZED_NAME_WORKFLOWS = "workflows";
  @SerializedName(SERIALIZED_NAME_WORKFLOWS)
  private UserCapability workflows;

  public static final String SERIALIZED_NAME_YEAR_END = "year_end";
  @SerializedName(SERIALIZED_NAME_YEAR_END)
  private UserCapability yearEnd;


  public InlineResponse20016 tags(UserCapability tags) {
    
    this.tags = tags;
    return this;
  }

   /**
   * Get tags
   * @return tags
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getTags() {
    return tags;
  }


  public void setTags(UserCapability tags) {
    this.tags = tags;
  }


  public InlineResponse20016 accountItemStatements(UserCapability accountItemStatements) {
    
    this.accountItemStatements = accountItemStatements;
    return this;
  }

   /**
   * Get accountItemStatements
   * @return accountItemStatements
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getAccountItemStatements() {
    return accountItemStatements;
  }


  public void setAccountItemStatements(UserCapability accountItemStatements) {
    this.accountItemStatements = accountItemStatements;
  }


  public InlineResponse20016 accountItems(UserCapability accountItems) {
    
    this.accountItems = accountItems;
    return this;
  }

   /**
   * Get accountItems
   * @return accountItems
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getAccountItems() {
    return accountItems;
  }


  public void setAccountItems(UserCapability accountItems) {
    this.accountItems = accountItems;
  }


  public InlineResponse20016 annualReports(UserCapability annualReports) {
    
    this.annualReports = annualReports;
    return this;
  }

   /**
   * Get annualReports
   * @return annualReports
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getAnnualReports() {
    return annualReports;
  }


  public void setAnnualReports(UserCapability annualReports) {
    this.annualReports = annualReports;
  }


  public InlineResponse20016 approvalFlowRoutes(UserCapability approvalFlowRoutes) {
    
    this.approvalFlowRoutes = approvalFlowRoutes;
    return this;
  }

   /**
   * Get approvalFlowRoutes
   * @return approvalFlowRoutes
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getApprovalFlowRoutes() {
    return approvalFlowRoutes;
  }


  public void setApprovalFlowRoutes(UserCapability approvalFlowRoutes) {
    this.approvalFlowRoutes = approvalFlowRoutes;
  }


  public InlineResponse20016 approvalRequests(UserCapability approvalRequests) {
    
    this.approvalRequests = approvalRequests;
    return this;
  }

   /**
   * Get approvalRequests
   * @return approvalRequests
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getApprovalRequests() {
    return approvalRequests;
  }


  public void setApprovalRequests(UserCapability approvalRequests) {
    this.approvalRequests = approvalRequests;
  }


  public InlineResponse20016 backups(UserCapability backups) {
    
    this.backups = backups;
    return this;
  }

   /**
   * Get backups
   * @return backups
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getBackups() {
    return backups;
  }


  public void setBackups(UserCapability backups) {
    this.backups = backups;
  }


  public InlineResponse20016 bankAccountantStaffUsers(UserCapability bankAccountantStaffUsers) {
    
    this.bankAccountantStaffUsers = bankAccountantStaffUsers;
    return this;
  }

   /**
   * Get bankAccountantStaffUsers
   * @return bankAccountantStaffUsers
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getBankAccountantStaffUsers() {
    return bankAccountantStaffUsers;
  }


  public void setBankAccountantStaffUsers(UserCapability bankAccountantStaffUsers) {
    this.bankAccountantStaffUsers = bankAccountantStaffUsers;
  }


  public InlineResponse20016 bizAllocations(UserCapability bizAllocations) {
    
    this.bizAllocations = bizAllocations;
    return this;
  }

   /**
   * Get bizAllocations
   * @return bizAllocations
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getBizAllocations() {
    return bizAllocations;
  }


  public void setBizAllocations(UserCapability bizAllocations) {
    this.bizAllocations = bizAllocations;
  }


  public InlineResponse20016 companies(UserCapability companies) {
    
    this.companies = companies;
    return this;
  }

   /**
   * Get companies
   * @return companies
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getCompanies() {
    return companies;
  }


  public void setCompanies(UserCapability companies) {
    this.companies = companies;
  }


  public InlineResponse20016 consumptionEntries(UserCapability consumptionEntries) {
    
    this.consumptionEntries = consumptionEntries;
    return this;
  }

   /**
   * Get consumptionEntries
   * @return consumptionEntries
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getConsumptionEntries() {
    return consumptionEntries;
  }


  public void setConsumptionEntries(UserCapability consumptionEntries) {
    this.consumptionEntries = consumptionEntries;
  }


  public InlineResponse20016 costAllocations(UserCapability costAllocations) {
    
    this.costAllocations = costAllocations;
    return this;
  }

   /**
   * Get costAllocations
   * @return costAllocations
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getCostAllocations() {
    return costAllocations;
  }


  public void setCostAllocations(UserCapability costAllocations) {
    this.costAllocations = costAllocations;
  }


  public InlineResponse20016 dealTemplates(UserCapability dealTemplates) {
    
    this.dealTemplates = dealTemplates;
    return this;
  }

   /**
   * Get dealTemplates
   * @return dealTemplates
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getDealTemplates() {
    return dealTemplates;
  }


  public void setDealTemplates(UserCapability dealTemplates) {
    this.dealTemplates = dealTemplates;
  }


  public InlineResponse20016 deals(UserCapability deals) {
    
    this.deals = deals;
    return this;
  }

   /**
   * Get deals
   * @return deals
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getDeals() {
    return deals;
  }


  public void setDeals(UserCapability deals) {
    this.deals = deals;
  }


  public InlineResponse20016 docPostings(UserCapability docPostings) {
    
    this.docPostings = docPostings;
    return this;
  }

   /**
   * Get docPostings
   * @return docPostings
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getDocPostings() {
    return docPostings;
  }


  public void setDocPostings(UserCapability docPostings) {
    this.docPostings = docPostings;
  }


  public InlineResponse20016 docs(UserCapability docs) {
    
    this.docs = docs;
    return this;
  }

   /**
   * Get docs
   * @return docs
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getDocs() {
    return docs;
  }


  public void setDocs(UserCapability docs) {
    this.docs = docs;
  }


  public InlineResponse20016 expenseApplicationTemplates(UserCapability expenseApplicationTemplates) {
    
    this.expenseApplicationTemplates = expenseApplicationTemplates;
    return this;
  }

   /**
   * Get expenseApplicationTemplates
   * @return expenseApplicationTemplates
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getExpenseApplicationTemplates() {
    return expenseApplicationTemplates;
  }


  public void setExpenseApplicationTemplates(UserCapability expenseApplicationTemplates) {
    this.expenseApplicationTemplates = expenseApplicationTemplates;
  }


  public InlineResponse20016 expenseApplications(UserCapability expenseApplications) {
    
    this.expenseApplications = expenseApplications;
    return this;
  }

   /**
   * Get expenseApplications
   * @return expenseApplications
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getExpenseApplications() {
    return expenseApplications;
  }


  public void setExpenseApplications(UserCapability expenseApplications) {
    this.expenseApplications = expenseApplications;
  }


  public InlineResponse20016 fixedAssets(UserCapability fixedAssets) {
    
    this.fixedAssets = fixedAssets;
    return this;
  }

   /**
   * Get fixedAssets
   * @return fixedAssets
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getFixedAssets() {
    return fixedAssets;
  }


  public void setFixedAssets(UserCapability fixedAssets) {
    this.fixedAssets = fixedAssets;
  }


  public InlineResponse20016 inventoryRefreshes(UserCapability inventoryRefreshes) {
    
    this.inventoryRefreshes = inventoryRefreshes;
    return this;
  }

   /**
   * Get inventoryRefreshes
   * @return inventoryRefreshes
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getInventoryRefreshes() {
    return inventoryRefreshes;
  }


  public void setInventoryRefreshes(UserCapability inventoryRefreshes) {
    this.inventoryRefreshes = inventoryRefreshes;
  }


  public InlineResponse20016 invitations(UserCapability invitations) {
    
    this.invitations = invitations;
    return this;
  }

   /**
   * Get invitations
   * @return invitations
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getInvitations() {
    return invitations;
  }


  public void setInvitations(UserCapability invitations) {
    this.invitations = invitations;
  }


  public InlineResponse20016 items(UserCapability items) {
    
    this.items = items;
    return this;
  }

   /**
   * Get items
   * @return items
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getItems() {
    return items;
  }


  public void setItems(UserCapability items) {
    this.items = items;
  }


  public InlineResponse20016 manualJournalTemplates(UserCapability manualJournalTemplates) {
    
    this.manualJournalTemplates = manualJournalTemplates;
    return this;
  }

   /**
   * Get manualJournalTemplates
   * @return manualJournalTemplates
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getManualJournalTemplates() {
    return manualJournalTemplates;
  }


  public void setManualJournalTemplates(UserCapability manualJournalTemplates) {
    this.manualJournalTemplates = manualJournalTemplates;
  }


  public InlineResponse20016 manualJournals(UserCapability manualJournals) {
    
    this.manualJournals = manualJournals;
    return this;
  }

   /**
   * Get manualJournals
   * @return manualJournals
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getManualJournals() {
    return manualJournals;
  }


  public void setManualJournals(UserCapability manualJournals) {
    this.manualJournals = manualJournals;
  }


  public InlineResponse20016 monthEnd(UserCapability monthEnd) {
    
    this.monthEnd = monthEnd;
    return this;
  }

   /**
   * Get monthEnd
   * @return monthEnd
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getMonthEnd() {
    return monthEnd;
  }


  public void setMonthEnd(UserCapability monthEnd) {
    this.monthEnd = monthEnd;
  }


  public InlineResponse20016 oauthApplications(UserCapability oauthApplications) {
    
    this.oauthApplications = oauthApplications;
    return this;
  }

   /**
   * Get oauthApplications
   * @return oauthApplications
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getOauthApplications() {
    return oauthApplications;
  }


  public void setOauthApplications(UserCapability oauthApplications) {
    this.oauthApplications = oauthApplications;
  }


  public InlineResponse20016 oauthAuthorizations(UserCapability oauthAuthorizations) {
    
    this.oauthAuthorizations = oauthAuthorizations;
    return this;
  }

   /**
   * Get oauthAuthorizations
   * @return oauthAuthorizations
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getOauthAuthorizations() {
    return oauthAuthorizations;
  }


  public void setOauthAuthorizations(UserCapability oauthAuthorizations) {
    this.oauthAuthorizations = oauthAuthorizations;
  }


  public InlineResponse20016 openingBalances(UserCapability openingBalances) {
    
    this.openingBalances = openingBalances;
    return this;
  }

   /**
   * Get openingBalances
   * @return openingBalances
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getOpeningBalances() {
    return openingBalances;
  }


  public void setOpeningBalances(UserCapability openingBalances) {
    this.openingBalances = openingBalances;
  }


  public InlineResponse20016 partners(UserCapability partners) {
    
    this.partners = partners;
    return this;
  }

   /**
   * Get partners
   * @return partners
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getPartners() {
    return partners;
  }


  public void setPartners(UserCapability partners) {
    this.partners = partners;
  }


  public InlineResponse20016 paymentRecords(UserCapability paymentRecords) {
    
    this.paymentRecords = paymentRecords;
    return this;
  }

   /**
   * Get paymentRecords
   * @return paymentRecords
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getPaymentRecords() {
    return paymentRecords;
  }


  public void setPaymentRecords(UserCapability paymentRecords) {
    this.paymentRecords = paymentRecords;
  }


  public InlineResponse20016 paymentRequests(UserCapability paymentRequests) {
    
    this.paymentRequests = paymentRequests;
    return this;
  }

   /**
   * Get paymentRequests
   * @return paymentRequests
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getPaymentRequests() {
    return paymentRequests;
  }


  public void setPaymentRequests(UserCapability paymentRequests) {
    this.paymentRequests = paymentRequests;
  }


  public InlineResponse20016 receiptStreamEditor(UserCapability receiptStreamEditor) {
    
    this.receiptStreamEditor = receiptStreamEditor;
    return this;
  }

   /**
   * Get receiptStreamEditor
   * @return receiptStreamEditor
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReceiptStreamEditor() {
    return receiptStreamEditor;
  }


  public void setReceiptStreamEditor(UserCapability receiptStreamEditor) {
    this.receiptStreamEditor = receiptStreamEditor;
  }


  public InlineResponse20016 receipts(UserCapability receipts) {
    
    this.receipts = receipts;
    return this;
  }

   /**
   * Get receipts
   * @return receipts
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReceipts() {
    return receipts;
  }


  public void setReceipts(UserCapability receipts) {
    this.receipts = receipts;
  }


  public InlineResponse20016 reports(UserCapability reports) {
    
    this.reports = reports;
    return this;
  }

   /**
   * Get reports
   * @return reports
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReports() {
    return reports;
  }


  public void setReports(UserCapability reports) {
    this.reports = reports;
  }


  public InlineResponse20016 reportsBs(UserCapability reportsBs) {
    
    this.reportsBs = reportsBs;
    return this;
  }

   /**
   * Get reportsBs
   * @return reportsBs
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsBs() {
    return reportsBs;
  }


  public void setReportsBs(UserCapability reportsBs) {
    this.reportsBs = reportsBs;
  }


  public InlineResponse20016 reportsCashBalance(UserCapability reportsCashBalance) {
    
    this.reportsCashBalance = reportsCashBalance;
    return this;
  }

   /**
   * Get reportsCashBalance
   * @return reportsCashBalance
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsCashBalance() {
    return reportsCashBalance;
  }


  public void setReportsCashBalance(UserCapability reportsCashBalance) {
    this.reportsCashBalance = reportsCashBalance;
  }


  public InlineResponse20016 reportsCrosstabs(UserCapability reportsCrosstabs) {
    
    this.reportsCrosstabs = reportsCrosstabs;
    return this;
  }

   /**
   * Get reportsCrosstabs
   * @return reportsCrosstabs
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsCrosstabs() {
    return reportsCrosstabs;
  }


  public void setReportsCrosstabs(UserCapability reportsCrosstabs) {
    this.reportsCrosstabs = reportsCrosstabs;
  }


  public InlineResponse20016 reportsGeneralLedgers(UserCapability reportsGeneralLedgers) {
    
    this.reportsGeneralLedgers = reportsGeneralLedgers;
    return this;
  }

   /**
   * Get reportsGeneralLedgers
   * @return reportsGeneralLedgers
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsGeneralLedgers() {
    return reportsGeneralLedgers;
  }


  public void setReportsGeneralLedgers(UserCapability reportsGeneralLedgers) {
    this.reportsGeneralLedgers = reportsGeneralLedgers;
  }


  public InlineResponse20016 reportsIncomeExpense(UserCapability reportsIncomeExpense) {
    
    this.reportsIncomeExpense = reportsIncomeExpense;
    return this;
  }

   /**
   * Get reportsIncomeExpense
   * @return reportsIncomeExpense
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsIncomeExpense() {
    return reportsIncomeExpense;
  }


  public void setReportsIncomeExpense(UserCapability reportsIncomeExpense) {
    this.reportsIncomeExpense = reportsIncomeExpense;
  }


  public InlineResponse20016 reportsJournals(UserCapability reportsJournals) {
    
    this.reportsJournals = reportsJournals;
    return this;
  }

   /**
   * Get reportsJournals
   * @return reportsJournals
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsJournals() {
    return reportsJournals;
  }


  public void setReportsJournals(UserCapability reportsJournals) {
    this.reportsJournals = reportsJournals;
  }


  public InlineResponse20016 reportsManagementsNavigation(UserCapability reportsManagementsNavigation) {
    
    this.reportsManagementsNavigation = reportsManagementsNavigation;
    return this;
  }

   /**
   * Get reportsManagementsNavigation
   * @return reportsManagementsNavigation
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsManagementsNavigation() {
    return reportsManagementsNavigation;
  }


  public void setReportsManagementsNavigation(UserCapability reportsManagementsNavigation) {
    this.reportsManagementsNavigation = reportsManagementsNavigation;
  }


  public InlineResponse20016 reportsManagementsPlanning(UserCapability reportsManagementsPlanning) {
    
    this.reportsManagementsPlanning = reportsManagementsPlanning;
    return this;
  }

   /**
   * Get reportsManagementsPlanning
   * @return reportsManagementsPlanning
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsManagementsPlanning() {
    return reportsManagementsPlanning;
  }


  public void setReportsManagementsPlanning(UserCapability reportsManagementsPlanning) {
    this.reportsManagementsPlanning = reportsManagementsPlanning;
  }


  public InlineResponse20016 reportsPayables(UserCapability reportsPayables) {
    
    this.reportsPayables = reportsPayables;
    return this;
  }

   /**
   * Get reportsPayables
   * @return reportsPayables
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsPayables() {
    return reportsPayables;
  }


  public void setReportsPayables(UserCapability reportsPayables) {
    this.reportsPayables = reportsPayables;
  }


  public InlineResponse20016 reportsPl(UserCapability reportsPl) {
    
    this.reportsPl = reportsPl;
    return this;
  }

   /**
   * Get reportsPl
   * @return reportsPl
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsPl() {
    return reportsPl;
  }


  public void setReportsPl(UserCapability reportsPl) {
    this.reportsPl = reportsPl;
  }


  public InlineResponse20016 reportsReceivables(UserCapability reportsReceivables) {
    
    this.reportsReceivables = reportsReceivables;
    return this;
  }

   /**
   * Get reportsReceivables
   * @return reportsReceivables
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getReportsReceivables() {
    return reportsReceivables;
  }


  public void setReportsReceivables(UserCapability reportsReceivables) {
    this.reportsReceivables = reportsReceivables;
  }


  public InlineResponse20016 requestForms(UserCapability requestForms) {
    
    this.requestForms = requestForms;
    return this;
  }

   /**
   * Get requestForms
   * @return requestForms
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getRequestForms() {
    return requestForms;
  }


  public void setRequestForms(UserCapability requestForms) {
    this.requestForms = requestForms;
  }


  public InlineResponse20016 resets(UserCapability resets) {
    
    this.resets = resets;
    return this;
  }

   /**
   * Get resets
   * @return resets
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getResets() {
    return resets;
  }


  public void setResets(UserCapability resets) {
    this.resets = resets;
  }


  public InlineResponse20016 sections(UserCapability sections) {
    
    this.sections = sections;
    return this;
  }

   /**
   * Get sections
   * @return sections
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getSections() {
    return sections;
  }


  public void setSections(UserCapability sections) {
    this.sections = sections;
  }


  public InlineResponse20016 signInLogs(UserCapability signInLogs) {
    
    this.signInLogs = signInLogs;
    return this;
  }

   /**
   * Get signInLogs
   * @return signInLogs
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getSignInLogs() {
    return signInLogs;
  }


  public void setSignInLogs(UserCapability signInLogs) {
    this.signInLogs = signInLogs;
  }


  public InlineResponse20016 spreadsheets(UserCapability spreadsheets) {
    
    this.spreadsheets = spreadsheets;
    return this;
  }

   /**
   * Get spreadsheets
   * @return spreadsheets
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getSpreadsheets() {
    return spreadsheets;
  }


  public void setSpreadsheets(UserCapability spreadsheets) {
    this.spreadsheets = spreadsheets;
  }


  public InlineResponse20016 systemConversion(UserCapability systemConversion) {
    
    this.systemConversion = systemConversion;
    return this;
  }

   /**
   * Get systemConversion
   * @return systemConversion
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getSystemConversion() {
    return systemConversion;
  }


  public void setSystemConversion(UserCapability systemConversion) {
    this.systemConversion = systemConversion;
  }


  public InlineResponse20016 taxReports(UserCapability taxReports) {
    
    this.taxReports = taxReports;
    return this;
  }

   /**
   * Get taxReports
   * @return taxReports
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getTaxReports() {
    return taxReports;
  }


  public void setTaxReports(UserCapability taxReports) {
    this.taxReports = taxReports;
  }


  public InlineResponse20016 taxReturn(UserCapability taxReturn) {
    
    this.taxReturn = taxReturn;
    return this;
  }

   /**
   * Get taxReturn
   * @return taxReturn
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getTaxReturn() {
    return taxReturn;
  }


  public void setTaxReturn(UserCapability taxReturn) {
    this.taxReturn = taxReturn;
  }


  public InlineResponse20016 taxes(UserCapability taxes) {
    
    this.taxes = taxes;
    return this;
  }

   /**
   * Get taxes
   * @return taxes
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getTaxes() {
    return taxes;
  }


  public void setTaxes(UserCapability taxes) {
    this.taxes = taxes;
  }


  public InlineResponse20016 transfers(UserCapability transfers) {
    
    this.transfers = transfers;
    return this;
  }

   /**
   * Get transfers
   * @return transfers
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getTransfers() {
    return transfers;
  }


  public void setTransfers(UserCapability transfers) {
    this.transfers = transfers;
  }


  public InlineResponse20016 userMatchers(UserCapability userMatchers) {
    
    this.userMatchers = userMatchers;
    return this;
  }

   /**
   * Get userMatchers
   * @return userMatchers
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getUserMatchers() {
    return userMatchers;
  }


  public void setUserMatchers(UserCapability userMatchers) {
    this.userMatchers = userMatchers;
  }


  public InlineResponse20016 walletTxns(UserCapability walletTxns) {
    
    this.walletTxns = walletTxns;
    return this;
  }

   /**
   * Get walletTxns
   * @return walletTxns
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getWalletTxns() {
    return walletTxns;
  }


  public void setWalletTxns(UserCapability walletTxns) {
    this.walletTxns = walletTxns;
  }


  public InlineResponse20016 walletables(UserCapability walletables) {
    
    this.walletables = walletables;
    return this;
  }

   /**
   * Get walletables
   * @return walletables
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getWalletables() {
    return walletables;
  }


  public void setWalletables(UserCapability walletables) {
    this.walletables = walletables;
  }


  public InlineResponse20016 workflows(UserCapability workflows) {
    
    this.workflows = workflows;
    return this;
  }

   /**
   * Get workflows
   * @return workflows
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getWorkflows() {
    return workflows;
  }


  public void setWorkflows(UserCapability workflows) {
    this.workflows = workflows;
  }


  public InlineResponse20016 yearEnd(UserCapability yearEnd) {
    
    this.yearEnd = yearEnd;
    return this;
  }

   /**
   * Get yearEnd
   * @return yearEnd
  **/
  @ApiModelProperty(required = true, value = "")

  public UserCapability getYearEnd() {
    return yearEnd;
  }


  public void setYearEnd(UserCapability yearEnd) {
    this.yearEnd = yearEnd;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    InlineResponse20016 inlineResponse20016 = (InlineResponse20016) o;
    return Objects.equals(this.tags, inlineResponse20016.tags) &&
        Objects.equals(this.accountItemStatements, inlineResponse20016.accountItemStatements) &&
        Objects.equals(this.accountItems, inlineResponse20016.accountItems) &&
        Objects.equals(this.annualReports, inlineResponse20016.annualReports) &&
        Objects.equals(this.approvalFlowRoutes, inlineResponse20016.approvalFlowRoutes) &&
        Objects.equals(this.approvalRequests, inlineResponse20016.approvalRequests) &&
        Objects.equals(this.backups, inlineResponse20016.backups) &&
        Objects.equals(this.bankAccountantStaffUsers, inlineResponse20016.bankAccountantStaffUsers) &&
        Objects.equals(this.bizAllocations, inlineResponse20016.bizAllocations) &&
        Objects.equals(this.companies, inlineResponse20016.companies) &&
        Objects.equals(this.consumptionEntries, inlineResponse20016.consumptionEntries) &&
        Objects.equals(this.costAllocations, inlineResponse20016.costAllocations) &&
        Objects.equals(this.dealTemplates, inlineResponse20016.dealTemplates) &&
        Objects.equals(this.deals, inlineResponse20016.deals) &&
        Objects.equals(this.docPostings, inlineResponse20016.docPostings) &&
        Objects.equals(this.docs, inlineResponse20016.docs) &&
        Objects.equals(this.expenseApplicationTemplates, inlineResponse20016.expenseApplicationTemplates) &&
        Objects.equals(this.expenseApplications, inlineResponse20016.expenseApplications) &&
        Objects.equals(this.fixedAssets, inlineResponse20016.fixedAssets) &&
        Objects.equals(this.inventoryRefreshes, inlineResponse20016.inventoryRefreshes) &&
        Objects.equals(this.invitations, inlineResponse20016.invitations) &&
        Objects.equals(this.items, inlineResponse20016.items) &&
        Objects.equals(this.manualJournalTemplates, inlineResponse20016.manualJournalTemplates) &&
        Objects.equals(this.manualJournals, inlineResponse20016.manualJournals) &&
        Objects.equals(this.monthEnd, inlineResponse20016.monthEnd) &&
        Objects.equals(this.oauthApplications, inlineResponse20016.oauthApplications) &&
        Objects.equals(this.oauthAuthorizations, inlineResponse20016.oauthAuthorizations) &&
        Objects.equals(this.openingBalances, inlineResponse20016.openingBalances) &&
        Objects.equals(this.partners, inlineResponse20016.partners) &&
        Objects.equals(this.paymentRecords, inlineResponse20016.paymentRecords) &&
        Objects.equals(this.paymentRequests, inlineResponse20016.paymentRequests) &&
        Objects.equals(this.receiptStreamEditor, inlineResponse20016.receiptStreamEditor) &&
        Objects.equals(this.receipts, inlineResponse20016.receipts) &&
        Objects.equals(this.reports, inlineResponse20016.reports) &&
        Objects.equals(this.reportsBs, inlineResponse20016.reportsBs) &&
        Objects.equals(this.reportsCashBalance, inlineResponse20016.reportsCashBalance) &&
        Objects.equals(this.reportsCrosstabs, inlineResponse20016.reportsCrosstabs) &&
        Objects.equals(this.reportsGeneralLedgers, inlineResponse20016.reportsGeneralLedgers) &&
        Objects.equals(this.reportsIncomeExpense, inlineResponse20016.reportsIncomeExpense) &&
        Objects.equals(this.reportsJournals, inlineResponse20016.reportsJournals) &&
        Objects.equals(this.reportsManagementsNavigation, inlineResponse20016.reportsManagementsNavigation) &&
        Objects.equals(this.reportsManagementsPlanning, inlineResponse20016.reportsManagementsPlanning) &&
        Objects.equals(this.reportsPayables, inlineResponse20016.reportsPayables) &&
        Objects.equals(this.reportsPl, inlineResponse20016.reportsPl) &&
        Objects.equals(this.reportsReceivables, inlineResponse20016.reportsReceivables) &&
        Objects.equals(this.requestForms, inlineResponse20016.requestForms) &&
        Objects.equals(this.resets, inlineResponse20016.resets) &&
        Objects.equals(this.sections, inlineResponse20016.sections) &&
        Objects.equals(this.signInLogs, inlineResponse20016.signInLogs) &&
        Objects.equals(this.spreadsheets, inlineResponse20016.spreadsheets) &&
        Objects.equals(this.systemConversion, inlineResponse20016.systemConversion) &&
        Objects.equals(this.taxReports, inlineResponse20016.taxReports) &&
        Objects.equals(this.taxReturn, inlineResponse20016.taxReturn) &&
        Objects.equals(this.taxes, inlineResponse20016.taxes) &&
        Objects.equals(this.transfers, inlineResponse20016.transfers) &&
        Objects.equals(this.userMatchers, inlineResponse20016.userMatchers) &&
        Objects.equals(this.walletTxns, inlineResponse20016.walletTxns) &&
        Objects.equals(this.walletables, inlineResponse20016.walletables) &&
        Objects.equals(this.workflows, inlineResponse20016.workflows) &&
        Objects.equals(this.yearEnd, inlineResponse20016.yearEnd);
  }

  @Override
  public int hashCode() {
    return Objects.hash(tags, accountItemStatements, accountItems, annualReports, approvalFlowRoutes, approvalRequests, backups, bankAccountantStaffUsers, bizAllocations, companies, consumptionEntries, costAllocations, dealTemplates, deals, docPostings, docs, expenseApplicationTemplates, expenseApplications, fixedAssets, inventoryRefreshes, invitations, items, manualJournalTemplates, manualJournals, monthEnd, oauthApplications, oauthAuthorizations, openingBalances, partners, paymentRecords, paymentRequests, receiptStreamEditor, receipts, reports, reportsBs, reportsCashBalance, reportsCrosstabs, reportsGeneralLedgers, reportsIncomeExpense, reportsJournals, reportsManagementsNavigation, reportsManagementsPlanning, reportsPayables, reportsPl, reportsReceivables, requestForms, resets, sections, signInLogs, spreadsheets, systemConversion, taxReports, taxReturn, taxes, transfers, userMatchers, walletTxns, walletables, workflows, yearEnd);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class InlineResponse20016 {\n");
    sb.append("    tags: ").append(toIndentedString(tags)).append("\n");
    sb.append("    accountItemStatements: ").append(toIndentedString(accountItemStatements)).append("\n");
    sb.append("    accountItems: ").append(toIndentedString(accountItems)).append("\n");
    sb.append("    annualReports: ").append(toIndentedString(annualReports)).append("\n");
    sb.append("    approvalFlowRoutes: ").append(toIndentedString(approvalFlowRoutes)).append("\n");
    sb.append("    approvalRequests: ").append(toIndentedString(approvalRequests)).append("\n");
    sb.append("    backups: ").append(toIndentedString(backups)).append("\n");
    sb.append("    bankAccountantStaffUsers: ").append(toIndentedString(bankAccountantStaffUsers)).append("\n");
    sb.append("    bizAllocations: ").append(toIndentedString(bizAllocations)).append("\n");
    sb.append("    companies: ").append(toIndentedString(companies)).append("\n");
    sb.append("    consumptionEntries: ").append(toIndentedString(consumptionEntries)).append("\n");
    sb.append("    costAllocations: ").append(toIndentedString(costAllocations)).append("\n");
    sb.append("    dealTemplates: ").append(toIndentedString(dealTemplates)).append("\n");
    sb.append("    deals: ").append(toIndentedString(deals)).append("\n");
    sb.append("    docPostings: ").append(toIndentedString(docPostings)).append("\n");
    sb.append("    docs: ").append(toIndentedString(docs)).append("\n");
    sb.append("    expenseApplicationTemplates: ").append(toIndentedString(expenseApplicationTemplates)).append("\n");
    sb.append("    expenseApplications: ").append(toIndentedString(expenseApplications)).append("\n");
    sb.append("    fixedAssets: ").append(toIndentedString(fixedAssets)).append("\n");
    sb.append("    inventoryRefreshes: ").append(toIndentedString(inventoryRefreshes)).append("\n");
    sb.append("    invitations: ").append(toIndentedString(invitations)).append("\n");
    sb.append("    items: ").append(toIndentedString(items)).append("\n");
    sb.append("    manualJournalTemplates: ").append(toIndentedString(manualJournalTemplates)).append("\n");
    sb.append("    manualJournals: ").append(toIndentedString(manualJournals)).append("\n");
    sb.append("    monthEnd: ").append(toIndentedString(monthEnd)).append("\n");
    sb.append("    oauthApplications: ").append(toIndentedString(oauthApplications)).append("\n");
    sb.append("    oauthAuthorizations: ").append(toIndentedString(oauthAuthorizations)).append("\n");
    sb.append("    openingBalances: ").append(toIndentedString(openingBalances)).append("\n");
    sb.append("    partners: ").append(toIndentedString(partners)).append("\n");
    sb.append("    paymentRecords: ").append(toIndentedString(paymentRecords)).append("\n");
    sb.append("    paymentRequests: ").append(toIndentedString(paymentRequests)).append("\n");
    sb.append("    receiptStreamEditor: ").append(toIndentedString(receiptStreamEditor)).append("\n");
    sb.append("    receipts: ").append(toIndentedString(receipts)).append("\n");
    sb.append("    reports: ").append(toIndentedString(reports)).append("\n");
    sb.append("    reportsBs: ").append(toIndentedString(reportsBs)).append("\n");
    sb.append("    reportsCashBalance: ").append(toIndentedString(reportsCashBalance)).append("\n");
    sb.append("    reportsCrosstabs: ").append(toIndentedString(reportsCrosstabs)).append("\n");
    sb.append("    reportsGeneralLedgers: ").append(toIndentedString(reportsGeneralLedgers)).append("\n");
    sb.append("    reportsIncomeExpense: ").append(toIndentedString(reportsIncomeExpense)).append("\n");
    sb.append("    reportsJournals: ").append(toIndentedString(reportsJournals)).append("\n");
    sb.append("    reportsManagementsNavigation: ").append(toIndentedString(reportsManagementsNavigation)).append("\n");
    sb.append("    reportsManagementsPlanning: ").append(toIndentedString(reportsManagementsPlanning)).append("\n");
    sb.append("    reportsPayables: ").append(toIndentedString(reportsPayables)).append("\n");
    sb.append("    reportsPl: ").append(toIndentedString(reportsPl)).append("\n");
    sb.append("    reportsReceivables: ").append(toIndentedString(reportsReceivables)).append("\n");
    sb.append("    requestForms: ").append(toIndentedString(requestForms)).append("\n");
    sb.append("    resets: ").append(toIndentedString(resets)).append("\n");
    sb.append("    sections: ").append(toIndentedString(sections)).append("\n");
    sb.append("    signInLogs: ").append(toIndentedString(signInLogs)).append("\n");
    sb.append("    spreadsheets: ").append(toIndentedString(spreadsheets)).append("\n");
    sb.append("    systemConversion: ").append(toIndentedString(systemConversion)).append("\n");
    sb.append("    taxReports: ").append(toIndentedString(taxReports)).append("\n");
    sb.append("    taxReturn: ").append(toIndentedString(taxReturn)).append("\n");
    sb.append("    taxes: ").append(toIndentedString(taxes)).append("\n");
    sb.append("    transfers: ").append(toIndentedString(transfers)).append("\n");
    sb.append("    userMatchers: ").append(toIndentedString(userMatchers)).append("\n");
    sb.append("    walletTxns: ").append(toIndentedString(walletTxns)).append("\n");
    sb.append("    walletables: ").append(toIndentedString(walletables)).append("\n");
    sb.append("    workflows: ").append(toIndentedString(workflows)).append("\n");
    sb.append("    yearEnd: ").append(toIndentedString(yearEnd)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

