/*
 * freee API
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <pre><code>【重要】会計freee APIの新バージョンについて 2020年12月まで、2つのバージョンが利用できる状態です。古いものは2020年12月に利用不可となります。<br> 新しいAPIを利用するにはリクエストヘッダーに以下を指定します。 X-Api-Version: 2020-06-15<br> 指定がない場合は2020年12月に廃止予定のAPIを利用することとなります。<br> 【重要】APIのバージョン指定をせずに利用し続ける場合 2020年12月に新しいバージョンのAPIに自動的に切り替わります。 詳細は、<a href=\"https://developer.freee.co.jp/release-note/2948\" target=\"_blank\">リリースノート</a>をご覧ください。<br> 旧バージョンのAPIリファレンスを確認したい場合は、<a href=\"https://freee.github.io/freee-api-schema/\" target=\"_blank\">旧バージョンのAPIリファレンスページ</a>をご覧ください。 </code></pre>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2013-01-01&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsエンドポイント</h4>  <p>freeeは/reportsエンドポイントに対して1秒間に10以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>会計freeeプラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * JournalsResponseJournals
 */

public class JournalsResponseJournals {
  public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
  @SerializedName(SERIALIZED_NAME_COMPANY_ID)
  private Integer companyId;

  /**
   * ダウンロード形式
   */
  @JsonAdapter(DownloadTypeEnum.Adapter.class)
  public enum DownloadTypeEnum {
    CSV("csv"),
    
    GENERIC("generic"),
    
    PDF("pdf");

    private String value;

    DownloadTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DownloadTypeEnum fromValue(String value) {
      for (DownloadTypeEnum b : DownloadTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<DownloadTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DownloadTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DownloadTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DownloadTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DOWNLOAD_TYPE = "download_type";
  @SerializedName(SERIALIZED_NAME_DOWNLOAD_TYPE)
  private DownloadTypeEnum downloadType;

  public static final String SERIALIZED_NAME_END_DATE = "end_date";
  @SerializedName(SERIALIZED_NAME_END_DATE)
  private String endDate;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Integer id;

  public static final String SERIALIZED_NAME_MESSAGES = "messages";
  @SerializedName(SERIALIZED_NAME_MESSAGES)
  private List<String> messages = null;

  public static final String SERIALIZED_NAME_START_DATE = "start_date";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private String startDate;

  public static final String SERIALIZED_NAME_STATUS_URL = "status_url";
  @SerializedName(SERIALIZED_NAME_STATUS_URL)
  private String statusUrl;

  /**
   * 補助科目やコメントとして出力する項目
   */
  @JsonAdapter(VisibleTagsEnum.Adapter.class)
  public enum VisibleTagsEnum {
    PARTNER("partner"),
    
    ITEM("item"),
    
    TAG("tag"),
    
    SECTION("section"),
    
    DESCRIPTION("description"),
    
    WALLET_TXN_DESCRIPTION("wallet_txn_description"),
    
    ALL("all"),
    
    SEGMENT_1_TAG("segment_1_tag"),
    
    SEGMENT_2_TAG("segment_2_tag"),
    
    SEGMENT_3_TAG("segment_3_tag");

    private String value;

    VisibleTagsEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static VisibleTagsEnum fromValue(String value) {
      for (VisibleTagsEnum b : VisibleTagsEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<VisibleTagsEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final VisibleTagsEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public VisibleTagsEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return VisibleTagsEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_VISIBLE_TAGS = "visible_tags";
  @SerializedName(SERIALIZED_NAME_VISIBLE_TAGS)
  private List<VisibleTagsEnum> visibleTags = null;


  public JournalsResponseJournals companyId(Integer companyId) {
    
    this.companyId = companyId;
    return this;
  }

   /**
   * 事業所ID
   * minimum: 1
   * maximum: 2147483647
   * @return companyId
  **/
  @ApiModelProperty(example = "1", required = true, value = "事業所ID")

  public Integer getCompanyId() {
    return companyId;
  }


  public void setCompanyId(Integer companyId) {
    this.companyId = companyId;
  }


  public JournalsResponseJournals downloadType(DownloadTypeEnum downloadType) {
    
    this.downloadType = downloadType;
    return this;
  }

   /**
   * ダウンロード形式
   * @return downloadType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "csv", value = "ダウンロード形式")

  public DownloadTypeEnum getDownloadType() {
    return downloadType;
  }


  public void setDownloadType(DownloadTypeEnum downloadType) {
    this.downloadType = downloadType;
  }


  public JournalsResponseJournals endDate(String endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * 取得終了日 (yyyy-mm-dd)
   * @return endDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2017-05-31", value = "取得終了日 (yyyy-mm-dd)")

  public String getEndDate() {
    return endDate;
  }


  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }


  public JournalsResponseJournals id(Integer id) {
    
    this.id = id;
    return this;
  }

   /**
   * 受け付けID
   * minimum: 1
   * maximum: 2147483647
   * @return id
  **/
  @ApiModelProperty(example = "1", required = true, value = "受け付けID")

  public Integer getId() {
    return id;
  }


  public void setId(Integer id) {
    this.id = id;
  }


  public JournalsResponseJournals messages(List<String> messages) {
    
    this.messages = messages;
    return this;
  }

  public JournalsResponseJournals addMessagesItem(String messagesItem) {
    if (this.messages == null) {
      this.messages = new ArrayList<>();
    }
    this.messages.add(messagesItem);
    return this;
  }

   /**
   * Get messages
   * @return messages
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<String> getMessages() {
    return messages;
  }


  public void setMessages(List<String> messages) {
    this.messages = messages;
  }


  public JournalsResponseJournals startDate(String startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * 取得開始日 (yyyy-mm-dd)
   * @return startDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2017-05-01", value = "取得開始日 (yyyy-mm-dd)")

  public String getStartDate() {
    return startDate;
  }


  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }


  public JournalsResponseJournals statusUrl(String statusUrl) {
    
    this.statusUrl = statusUrl;
    return this;
  }

   /**
   * ステータス確認用URL
   * @return statusUrl
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "https://api.freee.co.jp/api/1/journals/reports/4/status", value = "ステータス確認用URL")

  public String getStatusUrl() {
    return statusUrl;
  }


  public void setStatusUrl(String statusUrl) {
    this.statusUrl = statusUrl;
  }


  public JournalsResponseJournals visibleTags(List<VisibleTagsEnum> visibleTags) {
    
    this.visibleTags = visibleTags;
    return this;
  }

  public JournalsResponseJournals addVisibleTagsItem(VisibleTagsEnum visibleTagsItem) {
    if (this.visibleTags == null) {
      this.visibleTags = new ArrayList<>();
    }
    this.visibleTags.add(visibleTagsItem);
    return this;
  }

   /**
   * Get visibleTags
   * @return visibleTags
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public List<VisibleTagsEnum> getVisibleTags() {
    return visibleTags;
  }


  public void setVisibleTags(List<VisibleTagsEnum> visibleTags) {
    this.visibleTags = visibleTags;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    JournalsResponseJournals journalsResponseJournals = (JournalsResponseJournals) o;
    return Objects.equals(this.companyId, journalsResponseJournals.companyId) &&
        Objects.equals(this.downloadType, journalsResponseJournals.downloadType) &&
        Objects.equals(this.endDate, journalsResponseJournals.endDate) &&
        Objects.equals(this.id, journalsResponseJournals.id) &&
        Objects.equals(this.messages, journalsResponseJournals.messages) &&
        Objects.equals(this.startDate, journalsResponseJournals.startDate) &&
        Objects.equals(this.statusUrl, journalsResponseJournals.statusUrl) &&
        Objects.equals(this.visibleTags, journalsResponseJournals.visibleTags);
  }

  @Override
  public int hashCode() {
    return Objects.hash(companyId, downloadType, endDate, id, messages, startDate, statusUrl, visibleTags);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class JournalsResponseJournals {\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    downloadType: ").append(toIndentedString(downloadType)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    messages: ").append(toIndentedString(messages)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    statusUrl: ").append(toIndentedString(statusUrl)).append("\n");
    sb.append("    visibleTags: ").append(toIndentedString(visibleTags)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

