/*
 * freee API
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <pre><code>【重要】会計freee APIの新バージョンについて 2020年12月まで、2つのバージョンが利用できる状態です。古いものは2020年12月に利用不可となります。<br> 新しいAPIを利用するにはリクエストヘッダーに以下を指定します。 X-Api-Version: 2020-06-15<br> 指定がない場合は2020年12月に廃止予定のAPIを利用することとなります。<br> 【重要】APIのバージョン指定をせずに利用し続ける場合 2020年12月に新しいバージョンのAPIに自動的に切り替わります。 詳細は、<a href=\"https://developer.freee.co.jp/release-note/2948\" target=\"_blank\">リリースノート</a>をご覧ください。<br> 旧バージョンのAPIリファレンスを確認したい場合は、<a href=\"https://freee.github.io/freee-api-schema/\" target=\"_blank\">旧バージョンのAPIリファレンスページ</a>をご覧ください。 </code></pre>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2013-01-01&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsエンドポイント</h4>  <p>freeeは/reportsエンドポイントに対して1秒間に10以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>会計freeeプラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * PartnerCreateParamsPartnerBankAccountAttributes
 */

public class PartnerCreateParamsPartnerBankAccountAttributes {
  public static final String SERIALIZED_NAME_ACCOUNT_NAME = "account_name";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NAME)
  private String accountName;

  public static final String SERIALIZED_NAME_ACCOUNT_NUMBER = "account_number";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_NUMBER)
  private String accountNumber;

  public static final String SERIALIZED_NAME_ACCOUNT_TYPE = "account_type";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_TYPE)
  private String accountType;

  public static final String SERIALIZED_NAME_BANK_CODE = "bank_code";
  @SerializedName(SERIALIZED_NAME_BANK_CODE)
  private String bankCode;

  public static final String SERIALIZED_NAME_BANK_NAME = "bank_name";
  @SerializedName(SERIALIZED_NAME_BANK_NAME)
  private String bankName;

  public static final String SERIALIZED_NAME_BANK_NAME_KANA = "bank_name_kana";
  @SerializedName(SERIALIZED_NAME_BANK_NAME_KANA)
  private String bankNameKana;

  public static final String SERIALIZED_NAME_BRANCH_CODE = "branch_code";
  @SerializedName(SERIALIZED_NAME_BRANCH_CODE)
  private String branchCode;

  public static final String SERIALIZED_NAME_BRANCH_KANA = "branch_kana";
  @SerializedName(SERIALIZED_NAME_BRANCH_KANA)
  private String branchKana;

  public static final String SERIALIZED_NAME_BRANCH_NAME = "branch_name";
  @SerializedName(SERIALIZED_NAME_BRANCH_NAME)
  private String branchName;

  public static final String SERIALIZED_NAME_LONG_ACCOUNT_NAME = "long_account_name";
  @SerializedName(SERIALIZED_NAME_LONG_ACCOUNT_NAME)
  private String longAccountName;


  public PartnerCreateParamsPartnerBankAccountAttributes accountName(String accountName) {
    
    this.accountName = accountName;
    return this;
  }

   /**
   * 受取人名（カナ）
   * @return accountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "フリータロウ", value = "受取人名（カナ）")

  public String getAccountName() {
    return accountName;
  }


  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }


  public PartnerCreateParamsPartnerBankAccountAttributes accountNumber(String accountNumber) {
    
    this.accountNumber = accountNumber;
    return this;
  }

   /**
   * 口座番号
   * @return accountNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1010101", value = "口座番号")

  public String getAccountNumber() {
    return accountNumber;
  }


  public void setAccountNumber(String accountNumber) {
    this.accountNumber = accountNumber;
  }


  public PartnerCreateParamsPartnerBankAccountAttributes accountType(String accountType) {
    
    this.accountType = accountType;
    return this;
  }

   /**
   * 口座種別(ordinary:普通、checking：当座、earmarked：納税準備預金、savings：貯蓄、other:その他)
   * @return accountType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ordinary", value = "口座種別(ordinary:普通、checking：当座、earmarked：納税準備預金、savings：貯蓄、other:その他)")

  public String getAccountType() {
    return accountType;
  }


  public void setAccountType(String accountType) {
    this.accountType = accountType;
  }


  public PartnerCreateParamsPartnerBankAccountAttributes bankCode(String bankCode) {
    
    this.bankCode = bankCode;
    return this;
  }

   /**
   * 銀行番号
   * @return bankCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "001", value = "銀行番号")

  public String getBankCode() {
    return bankCode;
  }


  public void setBankCode(String bankCode) {
    this.bankCode = bankCode;
  }


  public PartnerCreateParamsPartnerBankAccountAttributes bankName(String bankName) {
    
    this.bankName = bankName;
    return this;
  }

   /**
   * 銀行名
   * @return bankName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ＸＸ銀行", value = "銀行名")

  public String getBankName() {
    return bankName;
  }


  public void setBankName(String bankName) {
    this.bankName = bankName;
  }


  public PartnerCreateParamsPartnerBankAccountAttributes bankNameKana(String bankNameKana) {
    
    this.bankNameKana = bankNameKana;
    return this;
  }

   /**
   * 銀行名（カナ）
   * @return bankNameKana
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ＸＸ", value = "銀行名（カナ）")

  public String getBankNameKana() {
    return bankNameKana;
  }


  public void setBankNameKana(String bankNameKana) {
    this.bankNameKana = bankNameKana;
  }


  public PartnerCreateParamsPartnerBankAccountAttributes branchCode(String branchCode) {
    
    this.branchCode = branchCode;
    return this;
  }

   /**
   * 支店番号
   * @return branchCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "101", value = "支店番号")

  public String getBranchCode() {
    return branchCode;
  }


  public void setBranchCode(String branchCode) {
    this.branchCode = branchCode;
  }


  public PartnerCreateParamsPartnerBankAccountAttributes branchKana(String branchKana) {
    
    this.branchKana = branchKana;
    return this;
  }

   /**
   * 支店名（カナ）
   * @return branchKana
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ギンザ", value = "支店名（カナ）")

  public String getBranchKana() {
    return branchKana;
  }


  public void setBranchKana(String branchKana) {
    this.branchKana = branchKana;
  }


  public PartnerCreateParamsPartnerBankAccountAttributes branchName(String branchName) {
    
    this.branchName = branchName;
    return this;
  }

   /**
   * 支店名
   * @return branchName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "銀座支店", value = "支店名")

  public String getBranchName() {
    return branchName;
  }


  public void setBranchName(String branchName) {
    this.branchName = branchName;
  }


  public PartnerCreateParamsPartnerBankAccountAttributes longAccountName(String longAccountName) {
    
    this.longAccountName = longAccountName;
    return this;
  }

   /**
   * 受取人名
   * @return longAccountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "freee太郎", value = "受取人名")

  public String getLongAccountName() {
    return longAccountName;
  }


  public void setLongAccountName(String longAccountName) {
    this.longAccountName = longAccountName;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PartnerCreateParamsPartnerBankAccountAttributes partnerCreateParamsPartnerBankAccountAttributes = (PartnerCreateParamsPartnerBankAccountAttributes) o;
    return Objects.equals(this.accountName, partnerCreateParamsPartnerBankAccountAttributes.accountName) &&
        Objects.equals(this.accountNumber, partnerCreateParamsPartnerBankAccountAttributes.accountNumber) &&
        Objects.equals(this.accountType, partnerCreateParamsPartnerBankAccountAttributes.accountType) &&
        Objects.equals(this.bankCode, partnerCreateParamsPartnerBankAccountAttributes.bankCode) &&
        Objects.equals(this.bankName, partnerCreateParamsPartnerBankAccountAttributes.bankName) &&
        Objects.equals(this.bankNameKana, partnerCreateParamsPartnerBankAccountAttributes.bankNameKana) &&
        Objects.equals(this.branchCode, partnerCreateParamsPartnerBankAccountAttributes.branchCode) &&
        Objects.equals(this.branchKana, partnerCreateParamsPartnerBankAccountAttributes.branchKana) &&
        Objects.equals(this.branchName, partnerCreateParamsPartnerBankAccountAttributes.branchName) &&
        Objects.equals(this.longAccountName, partnerCreateParamsPartnerBankAccountAttributes.longAccountName);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountName, accountNumber, accountType, bankCode, bankName, bankNameKana, branchCode, branchKana, branchName, longAccountName);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PartnerCreateParamsPartnerBankAccountAttributes {\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    accountNumber: ").append(toIndentedString(accountNumber)).append("\n");
    sb.append("    accountType: ").append(toIndentedString(accountType)).append("\n");
    sb.append("    bankCode: ").append(toIndentedString(bankCode)).append("\n");
    sb.append("    bankName: ").append(toIndentedString(bankName)).append("\n");
    sb.append("    bankNameKana: ").append(toIndentedString(bankNameKana)).append("\n");
    sb.append("    branchCode: ").append(toIndentedString(branchCode)).append("\n");
    sb.append("    branchKana: ").append(toIndentedString(branchKana)).append("\n");
    sb.append("    branchName: ").append(toIndentedString(branchName)).append("\n");
    sb.append("    longAccountName: ").append(toIndentedString(longAccountName)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

