/*
 * freee API
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <pre><code>【重要】会計freee APIの新バージョンについて 2020年12月まで、2つのバージョンが利用できる状態です。古いものは2020年12月に利用不可となります。<br> 新しいAPIを利用するにはリクエストヘッダーに以下を指定します。 X-Api-Version: 2020-06-15<br> 指定がない場合は2020年12月に廃止予定のAPIを利用することとなります。<br> 【重要】APIのバージョン指定をせずに利用し続ける場合 2020年12月に新しいバージョンのAPIに自動的に切り替わります。 詳細は、<a href=\"https://developer.freee.co.jp/release-note/2948\" target=\"_blank\">リリースノート</a>をご覧ください。<br> 旧バージョンのAPIリファレンスを確認したい場合は、<a href=\"https://freee.github.io/freee-api-schema/\" target=\"_blank\">旧バージョンのAPIリファレンスページ</a>をご覧ください。 </code></pre>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2013-01-01&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsエンドポイント</h4>  <p>freeeは/reportsエンドポイントに対して1秒間に10以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>会計freeeプラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import jp.co.freee.accounting.models.PartnerResponsePartnerAddressAttributes;

/**
 * PartnerResponsePartner
 */

public class PartnerResponsePartner {
  public static final String SERIALIZED_NAME_ADDRESS_ATTRIBUTES = "address_attributes";
  @SerializedName(SERIALIZED_NAME_ADDRESS_ATTRIBUTES)
  private PartnerResponsePartnerAddressAttributes addressAttributes;

  public static final String SERIALIZED_NAME_CODE = "code";
  @SerializedName(SERIALIZED_NAME_CODE)
  private String code;

  public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
  @SerializedName(SERIALIZED_NAME_COMPANY_ID)
  private Integer companyId;

  public static final String SERIALIZED_NAME_CONTACT_NAME = "contact_name";
  @SerializedName(SERIALIZED_NAME_CONTACT_NAME)
  private String contactName;

  public static final String SERIALIZED_NAME_COUNTRY_CODE = "country_code";
  @SerializedName(SERIALIZED_NAME_COUNTRY_CODE)
  private String countryCode;

  public static final String SERIALIZED_NAME_DEFAULT_TITLE = "default_title";
  @SerializedName(SERIALIZED_NAME_DEFAULT_TITLE)
  private String defaultTitle;

  public static final String SERIALIZED_NAME_EMAIL = "email";
  @SerializedName(SERIALIZED_NAME_EMAIL)
  private String email;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Integer id;

  public static final String SERIALIZED_NAME_INVOICE_PAYMENT_TERM_ATTRIBUTES_ADDITIONAL_MONTHS = "invoice_payment_term_attributes[additional_months]";
  @SerializedName(SERIALIZED_NAME_INVOICE_PAYMENT_TERM_ATTRIBUTES_ADDITIONAL_MONTHS)
  private Integer invoicePaymentTermAttributesAdditionalMonths;

  public static final String SERIALIZED_NAME_INVOICE_PAYMENT_TERM_ATTRIBUTES_CUTOFF_DAY = "invoice_payment_term_attributes[cutoff_day]";
  @SerializedName(SERIALIZED_NAME_INVOICE_PAYMENT_TERM_ATTRIBUTES_CUTOFF_DAY)
  private Integer invoicePaymentTermAttributesCutoffDay;

  public static final String SERIALIZED_NAME_INVOICE_PAYMENT_TERM_ATTRIBUTES_FIXED_DAY = "invoice_payment_term_attributes[fixed_day]";
  @SerializedName(SERIALIZED_NAME_INVOICE_PAYMENT_TERM_ATTRIBUTES_FIXED_DAY)
  private Integer invoicePaymentTermAttributesFixedDay;

  public static final String SERIALIZED_NAME_LONG_NAME = "long_name";
  @SerializedName(SERIALIZED_NAME_LONG_NAME)
  private String longName;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  public static final String SERIALIZED_NAME_NAME_KANA = "name_kana";
  @SerializedName(SERIALIZED_NAME_NAME_KANA)
  private String nameKana;

  public static final String SERIALIZED_NAME_ORG_CODE = "org_code";
  @SerializedName(SERIALIZED_NAME_ORG_CODE)
  private Integer orgCode;

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_ACCOUNT_NAME = "partner_bank_account_attributes[account_name]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_ACCOUNT_NAME)
  private String partnerBankAccountAttributesAccountName;

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_ACCOUNT_NUMBER = "partner_bank_account_attributes[account_number]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_ACCOUNT_NUMBER)
  private String partnerBankAccountAttributesAccountNumber;

  /**
   * 口座種別(ordinary:普通、checking:当座、earmarked:納税準備預金、savings:貯蓄、other:その他)
   */
  @JsonAdapter(PartnerBankAccountAttributesAccountTypeEnum.Adapter.class)
  public enum PartnerBankAccountAttributesAccountTypeEnum {
    ORDINARY("ordinary"),
    
    CHECKING("checking"),
    
    EARMARKED("earmarked"),
    
    SAVINGS("savings"),
    
    OTHER("other");

    private String value;

    PartnerBankAccountAttributesAccountTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static PartnerBankAccountAttributesAccountTypeEnum fromValue(String value) {
      for (PartnerBankAccountAttributesAccountTypeEnum b : PartnerBankAccountAttributesAccountTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<PartnerBankAccountAttributesAccountTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final PartnerBankAccountAttributesAccountTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public PartnerBankAccountAttributesAccountTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return PartnerBankAccountAttributesAccountTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_ACCOUNT_TYPE = "partner_bank_account_attributes[account_type]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_ACCOUNT_TYPE)
  private PartnerBankAccountAttributesAccountTypeEnum partnerBankAccountAttributesAccountType;

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BANK_CODE = "partner_bank_account_attributes[bank_code]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BANK_CODE)
  private String partnerBankAccountAttributesBankCode;

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BANK_NAME = "partner_bank_account_attributes[bank_name]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BANK_NAME)
  private String partnerBankAccountAttributesBankName;

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BANK_NAME_KANA = "partner_bank_account_attributes[bank_name_kana]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BANK_NAME_KANA)
  private String partnerBankAccountAttributesBankNameKana;

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BRANCH_CODE = "partner_bank_account_attributes[branch_code]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BRANCH_CODE)
  private String partnerBankAccountAttributesBranchCode;

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BRANCH_KANA = "partner_bank_account_attributes[branch_kana]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BRANCH_KANA)
  private String partnerBankAccountAttributesBranchKana;

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BRANCH_NAME = "partner_bank_account_attributes[branch_name]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_BRANCH_NAME)
  private String partnerBankAccountAttributesBranchName;

  public static final String SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_LONG_ACCOUNT_NAME = "partner_bank_account_attributes[long_account_name]";
  @SerializedName(SERIALIZED_NAME_PARTNER_BANK_ACCOUNT_ATTRIBUTES_LONG_ACCOUNT_NAME)
  private String partnerBankAccountAttributesLongAccountName;

  /**
   * 請求書送付方法(email:メール、posting:郵送、email_and_posting:メールと郵送)
   */
  @JsonAdapter(PartnerDocSettingAttributesSendingMethodEnum.Adapter.class)
  public enum PartnerDocSettingAttributesSendingMethodEnum {
    EMAIL("email"),
    
    POSTING("posting"),
    
    EMAIL_AND_POSTING("email_and_posting");

    private String value;

    PartnerDocSettingAttributesSendingMethodEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static PartnerDocSettingAttributesSendingMethodEnum fromValue(String value) {
      for (PartnerDocSettingAttributesSendingMethodEnum b : PartnerDocSettingAttributesSendingMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<PartnerDocSettingAttributesSendingMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final PartnerDocSettingAttributesSendingMethodEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public PartnerDocSettingAttributesSendingMethodEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return PartnerDocSettingAttributesSendingMethodEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PARTNER_DOC_SETTING_ATTRIBUTES_SENDING_METHOD = "partner_doc_setting_attributes[sending_method]";
  @SerializedName(SERIALIZED_NAME_PARTNER_DOC_SETTING_ATTRIBUTES_SENDING_METHOD)
  private PartnerDocSettingAttributesSendingMethodEnum partnerDocSettingAttributesSendingMethod;

  public static final String SERIALIZED_NAME_PAYER_WALLETABLE_ID = "payer_walletable_id";
  @SerializedName(SERIALIZED_NAME_PAYER_WALLETABLE_ID)
  private Integer payerWalletableId;

  public static final String SERIALIZED_NAME_PAYMENT_TERM_ATTRIBUTES_ADDITIONAL_MONTHS = "payment_term_attributes[additional_months]";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TERM_ATTRIBUTES_ADDITIONAL_MONTHS)
  private Integer paymentTermAttributesAdditionalMonths;

  public static final String SERIALIZED_NAME_PAYMENT_TERM_ATTRIBUTES_CUTOFF_DAY = "payment_term_attributes[cutoff_day]";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TERM_ATTRIBUTES_CUTOFF_DAY)
  private Integer paymentTermAttributesCutoffDay;

  public static final String SERIALIZED_NAME_PAYMENT_TERM_ATTRIBUTES_FIXED_DAY = "payment_term_attributes[fixed_day]";
  @SerializedName(SERIALIZED_NAME_PAYMENT_TERM_ATTRIBUTES_FIXED_DAY)
  private Integer paymentTermAttributesFixedDay;

  public static final String SERIALIZED_NAME_PHONE = "phone";
  @SerializedName(SERIALIZED_NAME_PHONE)
  private String phone;

  public static final String SERIALIZED_NAME_SHORTCUT1 = "shortcut1";
  @SerializedName(SERIALIZED_NAME_SHORTCUT1)
  private String shortcut1;

  public static final String SERIALIZED_NAME_SHORTCUT2 = "shortcut2";
  @SerializedName(SERIALIZED_NAME_SHORTCUT2)
  private String shortcut2;

  /**
   * 振込手数料負担（一括振込ファイル用）: (振込元(当方): payer, 振込先(先方): payee)
   */
  @JsonAdapter(TransferFeeHandlingSideEnum.Adapter.class)
  public enum TransferFeeHandlingSideEnum {
    PAYER("payer"),
    
    PAYEE("payee");

    private String value;

    TransferFeeHandlingSideEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TransferFeeHandlingSideEnum fromValue(String value) {
      for (TransferFeeHandlingSideEnum b : TransferFeeHandlingSideEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TransferFeeHandlingSideEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TransferFeeHandlingSideEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TransferFeeHandlingSideEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TransferFeeHandlingSideEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TRANSFER_FEE_HANDLING_SIDE = "transfer_fee_handling_side";
  @SerializedName(SERIALIZED_NAME_TRANSFER_FEE_HANDLING_SIDE)
  private TransferFeeHandlingSideEnum transferFeeHandlingSide;


  public PartnerResponsePartner addressAttributes(PartnerResponsePartnerAddressAttributes addressAttributes) {
    
    this.addressAttributes = addressAttributes;
    return this;
  }

   /**
   * Get addressAttributes
   * @return addressAttributes
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "")

  public PartnerResponsePartnerAddressAttributes getAddressAttributes() {
    return addressAttributes;
  }


  public void setAddressAttributes(PartnerResponsePartnerAddressAttributes addressAttributes) {
    this.addressAttributes = addressAttributes;
  }


  public PartnerResponsePartner code(String code) {
    
    this.code = code;
    return this;
  }

   /**
   * 取引先コード
   * @return code
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "code001", required = true, value = "取引先コード")

  public String getCode() {
    return code;
  }


  public void setCode(String code) {
    this.code = code;
  }


  public PartnerResponsePartner companyId(Integer companyId) {
    
    this.companyId = companyId;
    return this;
  }

   /**
   * 事業所ID
   * minimum: 1
   * maximum: 2147483647
   * @return companyId
  **/
  @ApiModelProperty(example = "1", required = true, value = "事業所ID")

  public Integer getCompanyId() {
    return companyId;
  }


  public void setCompanyId(Integer companyId) {
    this.companyId = companyId;
  }


  public PartnerResponsePartner contactName(String contactName) {
    
    this.contactName = contactName;
    return this;
  }

   /**
   * 担当者 氏名
   * @return contactName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "営業担当", value = "担当者 氏名")

  public String getContactName() {
    return contactName;
  }


  public void setContactName(String contactName) {
    this.contactName = contactName;
  }


  public PartnerResponsePartner countryCode(String countryCode) {
    
    this.countryCode = countryCode;
    return this;
  }

   /**
   * 地域（JP: 国内、ZZ:国外）
   * @return countryCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "JP", value = "地域（JP: 国内、ZZ:国外）")

  public String getCountryCode() {
    return countryCode;
  }


  public void setCountryCode(String countryCode) {
    this.countryCode = countryCode;
  }


  public PartnerResponsePartner defaultTitle(String defaultTitle) {
    
    this.defaultTitle = defaultTitle;
    return this;
  }

   /**
   * 敬称（御中、様、(空白)の3つから選択）
   * @return defaultTitle
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "御中", value = "敬称（御中、様、(空白)の3つから選択）")

  public String getDefaultTitle() {
    return defaultTitle;
  }


  public void setDefaultTitle(String defaultTitle) {
    this.defaultTitle = defaultTitle;
  }


  public PartnerResponsePartner email(String email) {
    
    this.email = email;
    return this;
  }

   /**
   * 担当者 メールアドレス
   * @return email
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "contact@example.com", value = "担当者 メールアドレス")

  public String getEmail() {
    return email;
  }


  public void setEmail(String email) {
    this.email = email;
  }


  public PartnerResponsePartner id(Integer id) {
    
    this.id = id;
    return this;
  }

   /**
   * 取引先ID
   * minimum: 1
   * maximum: 2147483647
   * @return id
  **/
  @ApiModelProperty(example = "1", required = true, value = "取引先ID")

  public Integer getId() {
    return id;
  }


  public void setId(Integer id) {
    this.id = id;
  }


  public PartnerResponsePartner invoicePaymentTermAttributesAdditionalMonths(Integer invoicePaymentTermAttributesAdditionalMonths) {
    
    this.invoicePaymentTermAttributesAdditionalMonths = invoicePaymentTermAttributesAdditionalMonths;
    return this;
  }

   /**
   * 支払月
   * minimum: 1
   * maximum: 6
   * @return invoicePaymentTermAttributesAdditionalMonths
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "支払月")

  public Integer getInvoicePaymentTermAttributesAdditionalMonths() {
    return invoicePaymentTermAttributesAdditionalMonths;
  }


  public void setInvoicePaymentTermAttributesAdditionalMonths(Integer invoicePaymentTermAttributesAdditionalMonths) {
    this.invoicePaymentTermAttributesAdditionalMonths = invoicePaymentTermAttributesAdditionalMonths;
  }


  public PartnerResponsePartner invoicePaymentTermAttributesCutoffDay(Integer invoicePaymentTermAttributesCutoffDay) {
    
    this.invoicePaymentTermAttributesCutoffDay = invoicePaymentTermAttributesCutoffDay;
    return this;
  }

   /**
   * 締め日（29, 30, 31日の末日を指定する場合は、32。）
   * minimum: 1
   * maximum: 32
   * @return invoicePaymentTermAttributesCutoffDay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15", value = "締め日（29, 30, 31日の末日を指定する場合は、32。）")

  public Integer getInvoicePaymentTermAttributesCutoffDay() {
    return invoicePaymentTermAttributesCutoffDay;
  }


  public void setInvoicePaymentTermAttributesCutoffDay(Integer invoicePaymentTermAttributesCutoffDay) {
    this.invoicePaymentTermAttributesCutoffDay = invoicePaymentTermAttributesCutoffDay;
  }


  public PartnerResponsePartner invoicePaymentTermAttributesFixedDay(Integer invoicePaymentTermAttributesFixedDay) {
    
    this.invoicePaymentTermAttributesFixedDay = invoicePaymentTermAttributesFixedDay;
    return this;
  }

   /**
   * 支払日（29, 30, 31日の末日を指定する場合は、32。）
   * minimum: 1
   * maximum: 32
   * @return invoicePaymentTermAttributesFixedDay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "32", value = "支払日（29, 30, 31日の末日を指定する場合は、32。）")

  public Integer getInvoicePaymentTermAttributesFixedDay() {
    return invoicePaymentTermAttributesFixedDay;
  }


  public void setInvoicePaymentTermAttributesFixedDay(Integer invoicePaymentTermAttributesFixedDay) {
    this.invoicePaymentTermAttributesFixedDay = invoicePaymentTermAttributesFixedDay;
  }


  public PartnerResponsePartner longName(String longName) {
    
    this.longName = longName;
    return this;
  }

   /**
   * 正式名称（255文字以内）
   * @return longName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "新しい取引先正式名称", value = "正式名称（255文字以内）")

  public String getLongName() {
    return longName;
  }


  public void setLongName(String longName) {
    this.longName = longName;
  }


  public PartnerResponsePartner name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * 取引先名
   * @return name
  **/
  @ApiModelProperty(example = "ABC商店", required = true, value = "取引先名")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public PartnerResponsePartner nameKana(String nameKana) {
    
    this.nameKana = nameKana;
    return this;
  }

   /**
   * カナ名称（255文字以内）
   * @return nameKana
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "アタラシイトリヒキサキメイショウ", value = "カナ名称（255文字以内）")

  public String getNameKana() {
    return nameKana;
  }


  public void setNameKana(String nameKana) {
    this.nameKana = nameKana;
  }


  public PartnerResponsePartner orgCode(Integer orgCode) {
    
    this.orgCode = orgCode;
    return this;
  }

   /**
   * 事業所種別（null: 未設定、1: 法人、2: 個人）
   * minimum: 1
   * maximum: 2
   * @return orgCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "事業所種別（null: 未設定、1: 法人、2: 個人）")

  public Integer getOrgCode() {
    return orgCode;
  }


  public void setOrgCode(Integer orgCode) {
    this.orgCode = orgCode;
  }


  public PartnerResponsePartner partnerBankAccountAttributesAccountName(String partnerBankAccountAttributesAccountName) {
    
    this.partnerBankAccountAttributesAccountName = partnerBankAccountAttributesAccountName;
    return this;
  }

   /**
   * 受取人名（カナ）
   * @return partnerBankAccountAttributesAccountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "フリータロウ", value = "受取人名（カナ）")

  public String getPartnerBankAccountAttributesAccountName() {
    return partnerBankAccountAttributesAccountName;
  }


  public void setPartnerBankAccountAttributesAccountName(String partnerBankAccountAttributesAccountName) {
    this.partnerBankAccountAttributesAccountName = partnerBankAccountAttributesAccountName;
  }


  public PartnerResponsePartner partnerBankAccountAttributesAccountNumber(String partnerBankAccountAttributesAccountNumber) {
    
    this.partnerBankAccountAttributesAccountNumber = partnerBankAccountAttributesAccountNumber;
    return this;
  }

   /**
   * 口座番号
   * @return partnerBankAccountAttributesAccountNumber
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1010101", value = "口座番号")

  public String getPartnerBankAccountAttributesAccountNumber() {
    return partnerBankAccountAttributesAccountNumber;
  }


  public void setPartnerBankAccountAttributesAccountNumber(String partnerBankAccountAttributesAccountNumber) {
    this.partnerBankAccountAttributesAccountNumber = partnerBankAccountAttributesAccountNumber;
  }


  public PartnerResponsePartner partnerBankAccountAttributesAccountType(PartnerBankAccountAttributesAccountTypeEnum partnerBankAccountAttributesAccountType) {
    
    this.partnerBankAccountAttributesAccountType = partnerBankAccountAttributesAccountType;
    return this;
  }

   /**
   * 口座種別(ordinary:普通、checking:当座、earmarked:納税準備預金、savings:貯蓄、other:その他)
   * @return partnerBankAccountAttributesAccountType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ordinary", value = "口座種別(ordinary:普通、checking:当座、earmarked:納税準備預金、savings:貯蓄、other:その他)")

  public PartnerBankAccountAttributesAccountTypeEnum getPartnerBankAccountAttributesAccountType() {
    return partnerBankAccountAttributesAccountType;
  }


  public void setPartnerBankAccountAttributesAccountType(PartnerBankAccountAttributesAccountTypeEnum partnerBankAccountAttributesAccountType) {
    this.partnerBankAccountAttributesAccountType = partnerBankAccountAttributesAccountType;
  }


  public PartnerResponsePartner partnerBankAccountAttributesBankCode(String partnerBankAccountAttributesBankCode) {
    
    this.partnerBankAccountAttributesBankCode = partnerBankAccountAttributesBankCode;
    return this;
  }

   /**
   * 銀行番号
   * @return partnerBankAccountAttributesBankCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "001", value = "銀行番号")

  public String getPartnerBankAccountAttributesBankCode() {
    return partnerBankAccountAttributesBankCode;
  }


  public void setPartnerBankAccountAttributesBankCode(String partnerBankAccountAttributesBankCode) {
    this.partnerBankAccountAttributesBankCode = partnerBankAccountAttributesBankCode;
  }


  public PartnerResponsePartner partnerBankAccountAttributesBankName(String partnerBankAccountAttributesBankName) {
    
    this.partnerBankAccountAttributesBankName = partnerBankAccountAttributesBankName;
    return this;
  }

   /**
   * 銀行名
   * @return partnerBankAccountAttributesBankName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ＸＸ銀行", value = "銀行名")

  public String getPartnerBankAccountAttributesBankName() {
    return partnerBankAccountAttributesBankName;
  }


  public void setPartnerBankAccountAttributesBankName(String partnerBankAccountAttributesBankName) {
    this.partnerBankAccountAttributesBankName = partnerBankAccountAttributesBankName;
  }


  public PartnerResponsePartner partnerBankAccountAttributesBankNameKana(String partnerBankAccountAttributesBankNameKana) {
    
    this.partnerBankAccountAttributesBankNameKana = partnerBankAccountAttributesBankNameKana;
    return this;
  }

   /**
   * 銀行名（カナ）
   * @return partnerBankAccountAttributesBankNameKana
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ＸＸ", value = "銀行名（カナ）")

  public String getPartnerBankAccountAttributesBankNameKana() {
    return partnerBankAccountAttributesBankNameKana;
  }


  public void setPartnerBankAccountAttributesBankNameKana(String partnerBankAccountAttributesBankNameKana) {
    this.partnerBankAccountAttributesBankNameKana = partnerBankAccountAttributesBankNameKana;
  }


  public PartnerResponsePartner partnerBankAccountAttributesBranchCode(String partnerBankAccountAttributesBranchCode) {
    
    this.partnerBankAccountAttributesBranchCode = partnerBankAccountAttributesBranchCode;
    return this;
  }

   /**
   * 支店番号
   * @return partnerBankAccountAttributesBranchCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "999", value = "支店番号")

  public String getPartnerBankAccountAttributesBranchCode() {
    return partnerBankAccountAttributesBranchCode;
  }


  public void setPartnerBankAccountAttributesBranchCode(String partnerBankAccountAttributesBranchCode) {
    this.partnerBankAccountAttributesBranchCode = partnerBankAccountAttributesBranchCode;
  }


  public PartnerResponsePartner partnerBankAccountAttributesBranchKana(String partnerBankAccountAttributesBranchKana) {
    
    this.partnerBankAccountAttributesBranchKana = partnerBankAccountAttributesBranchKana;
    return this;
  }

   /**
   * 支店名（カナ）
   * @return partnerBankAccountAttributesBranchKana
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ギンザ", value = "支店名（カナ）")

  public String getPartnerBankAccountAttributesBranchKana() {
    return partnerBankAccountAttributesBranchKana;
  }


  public void setPartnerBankAccountAttributesBranchKana(String partnerBankAccountAttributesBranchKana) {
    this.partnerBankAccountAttributesBranchKana = partnerBankAccountAttributesBranchKana;
  }


  public PartnerResponsePartner partnerBankAccountAttributesBranchName(String partnerBankAccountAttributesBranchName) {
    
    this.partnerBankAccountAttributesBranchName = partnerBankAccountAttributesBranchName;
    return this;
  }

   /**
   * 支店名
   * @return partnerBankAccountAttributesBranchName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "銀座支店", value = "支店名")

  public String getPartnerBankAccountAttributesBranchName() {
    return partnerBankAccountAttributesBranchName;
  }


  public void setPartnerBankAccountAttributesBranchName(String partnerBankAccountAttributesBranchName) {
    this.partnerBankAccountAttributesBranchName = partnerBankAccountAttributesBranchName;
  }


  public PartnerResponsePartner partnerBankAccountAttributesLongAccountName(String partnerBankAccountAttributesLongAccountName) {
    
    this.partnerBankAccountAttributesLongAccountName = partnerBankAccountAttributesLongAccountName;
    return this;
  }

   /**
   * 受取人名
   * @return partnerBankAccountAttributesLongAccountName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "freee太郎", value = "受取人名")

  public String getPartnerBankAccountAttributesLongAccountName() {
    return partnerBankAccountAttributesLongAccountName;
  }


  public void setPartnerBankAccountAttributesLongAccountName(String partnerBankAccountAttributesLongAccountName) {
    this.partnerBankAccountAttributesLongAccountName = partnerBankAccountAttributesLongAccountName;
  }


  public PartnerResponsePartner partnerDocSettingAttributesSendingMethod(PartnerDocSettingAttributesSendingMethodEnum partnerDocSettingAttributesSendingMethod) {
    
    this.partnerDocSettingAttributesSendingMethod = partnerDocSettingAttributesSendingMethod;
    return this;
  }

   /**
   * 請求書送付方法(email:メール、posting:郵送、email_and_posting:メールと郵送)
   * @return partnerDocSettingAttributesSendingMethod
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "posting", value = "請求書送付方法(email:メール、posting:郵送、email_and_posting:メールと郵送)")

  public PartnerDocSettingAttributesSendingMethodEnum getPartnerDocSettingAttributesSendingMethod() {
    return partnerDocSettingAttributesSendingMethod;
  }


  public void setPartnerDocSettingAttributesSendingMethod(PartnerDocSettingAttributesSendingMethodEnum partnerDocSettingAttributesSendingMethod) {
    this.partnerDocSettingAttributesSendingMethod = partnerDocSettingAttributesSendingMethod;
  }


  public PartnerResponsePartner payerWalletableId(Integer payerWalletableId) {
    
    this.payerWalletableId = payerWalletableId;
    return this;
  }

   /**
   * 振込元口座ID（一括振込ファイル用）:（未設定の場合は、nullです。）
   * minimum: 1
   * maximum: 2147483647
   * @return payerWalletableId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "振込元口座ID（一括振込ファイル用）:（未設定の場合は、nullです。）")

  public Integer getPayerWalletableId() {
    return payerWalletableId;
  }


  public void setPayerWalletableId(Integer payerWalletableId) {
    this.payerWalletableId = payerWalletableId;
  }


  public PartnerResponsePartner paymentTermAttributesAdditionalMonths(Integer paymentTermAttributesAdditionalMonths) {
    
    this.paymentTermAttributesAdditionalMonths = paymentTermAttributesAdditionalMonths;
    return this;
  }

   /**
   * 支払月
   * minimum: 1
   * maximum: 6
   * @return paymentTermAttributesAdditionalMonths
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "支払月")

  public Integer getPaymentTermAttributesAdditionalMonths() {
    return paymentTermAttributesAdditionalMonths;
  }


  public void setPaymentTermAttributesAdditionalMonths(Integer paymentTermAttributesAdditionalMonths) {
    this.paymentTermAttributesAdditionalMonths = paymentTermAttributesAdditionalMonths;
  }


  public PartnerResponsePartner paymentTermAttributesCutoffDay(Integer paymentTermAttributesCutoffDay) {
    
    this.paymentTermAttributesCutoffDay = paymentTermAttributesCutoffDay;
    return this;
  }

   /**
   * 締め日（29, 30, 31日の末日を指定する場合は、32。）
   * minimum: 1
   * maximum: 32
   * @return paymentTermAttributesCutoffDay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "15", value = "締め日（29, 30, 31日の末日を指定する場合は、32。）")

  public Integer getPaymentTermAttributesCutoffDay() {
    return paymentTermAttributesCutoffDay;
  }


  public void setPaymentTermAttributesCutoffDay(Integer paymentTermAttributesCutoffDay) {
    this.paymentTermAttributesCutoffDay = paymentTermAttributesCutoffDay;
  }


  public PartnerResponsePartner paymentTermAttributesFixedDay(Integer paymentTermAttributesFixedDay) {
    
    this.paymentTermAttributesFixedDay = paymentTermAttributesFixedDay;
    return this;
  }

   /**
   * 支払日（29, 30, 31日の末日を指定する場合は、32。）
   * minimum: 1
   * maximum: 32
   * @return paymentTermAttributesFixedDay
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "32", value = "支払日（29, 30, 31日の末日を指定する場合は、32。）")

  public Integer getPaymentTermAttributesFixedDay() {
    return paymentTermAttributesFixedDay;
  }


  public void setPaymentTermAttributesFixedDay(Integer paymentTermAttributesFixedDay) {
    this.paymentTermAttributesFixedDay = paymentTermAttributesFixedDay;
  }


  public PartnerResponsePartner phone(String phone) {
    
    this.phone = phone;
    return this;
  }

   /**
   * 電話番号
   * @return phone
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "03-1234-xxxx", value = "電話番号")

  public String getPhone() {
    return phone;
  }


  public void setPhone(String phone) {
    this.phone = phone;
  }


  public PartnerResponsePartner shortcut1(String shortcut1) {
    
    this.shortcut1 = shortcut1;
    return this;
  }

   /**
   * ショートカット1 (20文字以内)
   * @return shortcut1
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "ABC", value = "ショートカット1 (20文字以内)")

  public String getShortcut1() {
    return shortcut1;
  }


  public void setShortcut1(String shortcut1) {
    this.shortcut1 = shortcut1;
  }


  public PartnerResponsePartner shortcut2(String shortcut2) {
    
    this.shortcut2 = shortcut2;
    return this;
  }

   /**
   * ショートカット2 (20文字以内)
   * @return shortcut2
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "501", value = "ショートカット2 (20文字以内)")

  public String getShortcut2() {
    return shortcut2;
  }


  public void setShortcut2(String shortcut2) {
    this.shortcut2 = shortcut2;
  }


  public PartnerResponsePartner transferFeeHandlingSide(TransferFeeHandlingSideEnum transferFeeHandlingSide) {
    
    this.transferFeeHandlingSide = transferFeeHandlingSide;
    return this;
  }

   /**
   * 振込手数料負担（一括振込ファイル用）: (振込元(当方): payer, 振込先(先方): payee)
   * @return transferFeeHandlingSide
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "payer", value = "振込手数料負担（一括振込ファイル用）: (振込元(当方): payer, 振込先(先方): payee)")

  public TransferFeeHandlingSideEnum getTransferFeeHandlingSide() {
    return transferFeeHandlingSide;
  }


  public void setTransferFeeHandlingSide(TransferFeeHandlingSideEnum transferFeeHandlingSide) {
    this.transferFeeHandlingSide = transferFeeHandlingSide;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PartnerResponsePartner partnerResponsePartner = (PartnerResponsePartner) o;
    return Objects.equals(this.addressAttributes, partnerResponsePartner.addressAttributes) &&
        Objects.equals(this.code, partnerResponsePartner.code) &&
        Objects.equals(this.companyId, partnerResponsePartner.companyId) &&
        Objects.equals(this.contactName, partnerResponsePartner.contactName) &&
        Objects.equals(this.countryCode, partnerResponsePartner.countryCode) &&
        Objects.equals(this.defaultTitle, partnerResponsePartner.defaultTitle) &&
        Objects.equals(this.email, partnerResponsePartner.email) &&
        Objects.equals(this.id, partnerResponsePartner.id) &&
        Objects.equals(this.invoicePaymentTermAttributesAdditionalMonths, partnerResponsePartner.invoicePaymentTermAttributesAdditionalMonths) &&
        Objects.equals(this.invoicePaymentTermAttributesCutoffDay, partnerResponsePartner.invoicePaymentTermAttributesCutoffDay) &&
        Objects.equals(this.invoicePaymentTermAttributesFixedDay, partnerResponsePartner.invoicePaymentTermAttributesFixedDay) &&
        Objects.equals(this.longName, partnerResponsePartner.longName) &&
        Objects.equals(this.name, partnerResponsePartner.name) &&
        Objects.equals(this.nameKana, partnerResponsePartner.nameKana) &&
        Objects.equals(this.orgCode, partnerResponsePartner.orgCode) &&
        Objects.equals(this.partnerBankAccountAttributesAccountName, partnerResponsePartner.partnerBankAccountAttributesAccountName) &&
        Objects.equals(this.partnerBankAccountAttributesAccountNumber, partnerResponsePartner.partnerBankAccountAttributesAccountNumber) &&
        Objects.equals(this.partnerBankAccountAttributesAccountType, partnerResponsePartner.partnerBankAccountAttributesAccountType) &&
        Objects.equals(this.partnerBankAccountAttributesBankCode, partnerResponsePartner.partnerBankAccountAttributesBankCode) &&
        Objects.equals(this.partnerBankAccountAttributesBankName, partnerResponsePartner.partnerBankAccountAttributesBankName) &&
        Objects.equals(this.partnerBankAccountAttributesBankNameKana, partnerResponsePartner.partnerBankAccountAttributesBankNameKana) &&
        Objects.equals(this.partnerBankAccountAttributesBranchCode, partnerResponsePartner.partnerBankAccountAttributesBranchCode) &&
        Objects.equals(this.partnerBankAccountAttributesBranchKana, partnerResponsePartner.partnerBankAccountAttributesBranchKana) &&
        Objects.equals(this.partnerBankAccountAttributesBranchName, partnerResponsePartner.partnerBankAccountAttributesBranchName) &&
        Objects.equals(this.partnerBankAccountAttributesLongAccountName, partnerResponsePartner.partnerBankAccountAttributesLongAccountName) &&
        Objects.equals(this.partnerDocSettingAttributesSendingMethod, partnerResponsePartner.partnerDocSettingAttributesSendingMethod) &&
        Objects.equals(this.payerWalletableId, partnerResponsePartner.payerWalletableId) &&
        Objects.equals(this.paymentTermAttributesAdditionalMonths, partnerResponsePartner.paymentTermAttributesAdditionalMonths) &&
        Objects.equals(this.paymentTermAttributesCutoffDay, partnerResponsePartner.paymentTermAttributesCutoffDay) &&
        Objects.equals(this.paymentTermAttributesFixedDay, partnerResponsePartner.paymentTermAttributesFixedDay) &&
        Objects.equals(this.phone, partnerResponsePartner.phone) &&
        Objects.equals(this.shortcut1, partnerResponsePartner.shortcut1) &&
        Objects.equals(this.shortcut2, partnerResponsePartner.shortcut2) &&
        Objects.equals(this.transferFeeHandlingSide, partnerResponsePartner.transferFeeHandlingSide);
  }

  @Override
  public int hashCode() {
    return Objects.hash(addressAttributes, code, companyId, contactName, countryCode, defaultTitle, email, id, invoicePaymentTermAttributesAdditionalMonths, invoicePaymentTermAttributesCutoffDay, invoicePaymentTermAttributesFixedDay, longName, name, nameKana, orgCode, partnerBankAccountAttributesAccountName, partnerBankAccountAttributesAccountNumber, partnerBankAccountAttributesAccountType, partnerBankAccountAttributesBankCode, partnerBankAccountAttributesBankName, partnerBankAccountAttributesBankNameKana, partnerBankAccountAttributesBranchCode, partnerBankAccountAttributesBranchKana, partnerBankAccountAttributesBranchName, partnerBankAccountAttributesLongAccountName, partnerDocSettingAttributesSendingMethod, payerWalletableId, paymentTermAttributesAdditionalMonths, paymentTermAttributesCutoffDay, paymentTermAttributesFixedDay, phone, shortcut1, shortcut2, transferFeeHandlingSide);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PartnerResponsePartner {\n");
    sb.append("    addressAttributes: ").append(toIndentedString(addressAttributes)).append("\n");
    sb.append("    code: ").append(toIndentedString(code)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    contactName: ").append(toIndentedString(contactName)).append("\n");
    sb.append("    countryCode: ").append(toIndentedString(countryCode)).append("\n");
    sb.append("    defaultTitle: ").append(toIndentedString(defaultTitle)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    invoicePaymentTermAttributesAdditionalMonths: ").append(toIndentedString(invoicePaymentTermAttributesAdditionalMonths)).append("\n");
    sb.append("    invoicePaymentTermAttributesCutoffDay: ").append(toIndentedString(invoicePaymentTermAttributesCutoffDay)).append("\n");
    sb.append("    invoicePaymentTermAttributesFixedDay: ").append(toIndentedString(invoicePaymentTermAttributesFixedDay)).append("\n");
    sb.append("    longName: ").append(toIndentedString(longName)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    nameKana: ").append(toIndentedString(nameKana)).append("\n");
    sb.append("    orgCode: ").append(toIndentedString(orgCode)).append("\n");
    sb.append("    partnerBankAccountAttributesAccountName: ").append(toIndentedString(partnerBankAccountAttributesAccountName)).append("\n");
    sb.append("    partnerBankAccountAttributesAccountNumber: ").append(toIndentedString(partnerBankAccountAttributesAccountNumber)).append("\n");
    sb.append("    partnerBankAccountAttributesAccountType: ").append(toIndentedString(partnerBankAccountAttributesAccountType)).append("\n");
    sb.append("    partnerBankAccountAttributesBankCode: ").append(toIndentedString(partnerBankAccountAttributesBankCode)).append("\n");
    sb.append("    partnerBankAccountAttributesBankName: ").append(toIndentedString(partnerBankAccountAttributesBankName)).append("\n");
    sb.append("    partnerBankAccountAttributesBankNameKana: ").append(toIndentedString(partnerBankAccountAttributesBankNameKana)).append("\n");
    sb.append("    partnerBankAccountAttributesBranchCode: ").append(toIndentedString(partnerBankAccountAttributesBranchCode)).append("\n");
    sb.append("    partnerBankAccountAttributesBranchKana: ").append(toIndentedString(partnerBankAccountAttributesBranchKana)).append("\n");
    sb.append("    partnerBankAccountAttributesBranchName: ").append(toIndentedString(partnerBankAccountAttributesBranchName)).append("\n");
    sb.append("    partnerBankAccountAttributesLongAccountName: ").append(toIndentedString(partnerBankAccountAttributesLongAccountName)).append("\n");
    sb.append("    partnerDocSettingAttributesSendingMethod: ").append(toIndentedString(partnerDocSettingAttributesSendingMethod)).append("\n");
    sb.append("    payerWalletableId: ").append(toIndentedString(payerWalletableId)).append("\n");
    sb.append("    paymentTermAttributesAdditionalMonths: ").append(toIndentedString(paymentTermAttributesAdditionalMonths)).append("\n");
    sb.append("    paymentTermAttributesCutoffDay: ").append(toIndentedString(paymentTermAttributesCutoffDay)).append("\n");
    sb.append("    paymentTermAttributesFixedDay: ").append(toIndentedString(paymentTermAttributesFixedDay)).append("\n");
    sb.append("    phone: ").append(toIndentedString(phone)).append("\n");
    sb.append("    shortcut1: ").append(toIndentedString(shortcut1)).append("\n");
    sb.append("    shortcut2: ").append(toIndentedString(shortcut2)).append("\n");
    sb.append("    transferFeeHandlingSide: ").append(toIndentedString(transferFeeHandlingSide)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

