/*
 * freee API
 *  <h1 id=\"freee_api\">freee API</h1> <hr /> <h2 id=\"start_guide\">スタートガイド</h2>  <p>freee API開発がはじめての方は<a href=\"https://developer.freee.co.jp/getting-started\">freee API スタートガイド</a>を参照してください。</p>  <hr /> <h2 id=\"specification\">仕様</h2>  <pre><code>【重要】会計freee APIの新バージョンについて 2020年12月まで、2つのバージョンが利用できる状態です。古いものは2020年12月に利用不可となります。<br> 新しいAPIを利用するにはリクエストヘッダーに以下を指定します。 X-Api-Version: 2020-06-15<br> 指定がない場合は2020年12月に廃止予定のAPIを利用することとなります。<br> 【重要】APIのバージョン指定をせずに利用し続ける場合 2020年12月に新しいバージョンのAPIに自動的に切り替わります。 詳細は、<a href=\"https://developer.freee.co.jp/release-note/2948\" target=\"_blank\">リリースノート</a>をご覧ください。<br> 旧バージョンのAPIリファレンスを確認したい場合は、<a href=\"https://freee.github.io/freee-api-schema/\" target=\"_blank\">旧バージョンのAPIリファレンスページ</a>をご覧ください。 </code></pre>  <h3 id=\"api_endpoint\">APIエンドポイント</h3>  <p>https://api.freee.co.jp/ (httpsのみ)</p>  <h3 id=\"about_authorize\">認証について</h3> <p>OAuth2.0を利用します。詳細は<a href=\"https://developer.freee.co.jp/docs\" target=\"_blank\">ドキュメントの認証</a>パートを参照してください。</p>  <h3 id=\"data_format\">データフォーマット</h3>  <p>リクエスト、レスポンスともにJSON形式をサポートしていますが、詳細は、API毎の説明欄（application/jsonなど）を確認してください。</p>  <h3 id=\"compatibility\">後方互換性ありの変更</h3>  <p>freeeでは、APIを改善していくために以下のような変更は後方互換性ありとして通知なく変更を入れることがあります。アプリケーション実装者は以下を踏まえて開発を行ってください。</p>  <ul> <li>新しいAPIリソース・エンドポイントの追加</li> <li>既存のAPIに対して必須ではない新しいリクエストパラメータの追加</li> <li>既存のAPIレスポンスに対する新しいプロパティの追加</li> <li>既存のAPIレスポンスに対するプロパティの順番の入れ変え</li> <li>keyとなっているidやcodeの長さの変更（長くする）</li> </ul>  <h3 id=\"common_response_header\">共通レスポンスヘッダー</h3>  <p>すべてのAPIのレスポンスには以下のHTTPヘッダーが含まれます。</p>  <ul> <li> <p>X-Freee-Request-ID</p> <ul> <li>各リクエスト毎に発行されるID</li> </ul> </li> </ul>  <h3 id=\"common_error_response\">共通エラーレスポンス</h3>  <ul> <li> <p>ステータスコードはレスポンス内のJSONに含まれる他、HTTPヘッダにも含まれる</p> </li> <li> <p>一部のエラーレスポンスにはエラーコードが含まれます。<br>詳細は、<a href=\"https://developer.freee.co.jp/tips/faq/40x-checkpoint\">HTTPステータスコード400台エラー時のチェックポイント</a>を参照してください</p> </li> <p>type</p>  <ul> <li>status : HTTPステータスコードの説明</li>  <li>validation : エラーの詳細の説明（開発者向け）</li> </ul> </li> </ul>  <p>レスポンスの例</p>  <pre><code>  {     &quot;status_code&quot; : 400,     &quot;errors&quot; : [       {         &quot;type&quot; : &quot;status&quot;,         &quot;messages&quot; : [&quot;不正なリクエストです。&quot;]       },       {         &quot;type&quot; : &quot;validation&quot;,         &quot;messages&quot; : [&quot;Date は不正な日付フォーマットです。入力例：2013-01-01&quot;]       }     ]   }</code></pre>  </br>  <h3 id=\"api_rate_limit\">API使用制限</h3>    <p>freeeは一定期間に過度のアクセスを検知した場合、APIアクセスをコントロールする場合があります。</p>   <p>その際のhttp status codeは403となります。制限がかかってから10分程度が過ぎると再度使用することができるようになります。</p>  <h4 id=\"reports_api_endpoint\">/reportsエンドポイント</h4>  <p>freeeは/reportsエンドポイントに対して1秒間に10以上のアクセスを検知した場合、APIアクセスをコントロールする場合があります。その際のhttp status codeは429（too many requests）となります。</p>  <p>レスポンスボディのmetaプロパティに以下を含めます。</p>  <ul>   <li>設定されている上限値</li>   <li>上限に達するまでの使用可能回数</li>   <li>（上限値に達した場合）使用回数がリセットされる時刻</li> </ul>  <h3 id=\"plan_api_rate_limit\">プラン別のAPI Rate Limit</h3>   <table border=\"1\">     <tbody>       <tr>         <th style=\"padding: 10px\"><strong>会計freeeプラン名</strong></th>         <th style=\"padding: 10px\"><strong>事業所とアプリケーション毎に1日でのAPIコール数</strong></th>       </tr>       <tr>         <td style=\"padding: 10px\">エンタープライズ</td>         <td style=\"padding: 10px\">10,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">プロフェッショナル</td>         <td style=\"padding: 10px\">5,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ベーシック</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">ミニマム</td>         <td style=\"padding: 10px\">3,000</td>       </tr>       <tr>         <td style=\"padding: 10px\">上記以外</td>         <td style=\"padding: 10px\">3,000</td>       </tr>     </tbody>   </table>  <h3 id=\"webhook\">Webhookについて</h3>  <p>詳細は<a href=\"https://developer.freee.co.jp/docs/accounting/webhook\" target=\"_blank\">会計Webhook概要</a>を参照してください。</p>  <hr /> <h2 id=\"contact\">連絡先</h2>  <p>ご不明点、ご要望等は <a href=\"https://support.freee.co.jp/hc/ja/requests/new\">freee サポートデスクへのお問い合わせフォーム</a> からご連絡ください。</p> <hr />&copy; Since 2013 freee K.K.
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.co.freee.accounting.models.TrialPlResponseTrialPlBalances;

/**
 * TrialPlResponseTrialPl
 */

public class TrialPlResponseTrialPl {
  /**
   * 勘定科目の表示（勘定科目: account_item, 決算書表示:group）(条件に指定した時のみ含まれる）
   */
  @JsonAdapter(AccountItemDisplayTypeEnum.Adapter.class)
  public enum AccountItemDisplayTypeEnum {
    ACCOUNT_ITEM("account_item"),
    
    GROUP("group");

    private String value;

    AccountItemDisplayTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AccountItemDisplayTypeEnum fromValue(String value) {
      for (AccountItemDisplayTypeEnum b : AccountItemDisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AccountItemDisplayTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AccountItemDisplayTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AccountItemDisplayTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AccountItemDisplayTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ACCOUNT_ITEM_DISPLAY_TYPE = "account_item_display_type";
  @SerializedName(SERIALIZED_NAME_ACCOUNT_ITEM_DISPLAY_TYPE)
  private AccountItemDisplayTypeEnum accountItemDisplayType;

  /**
   * 決算整理仕訳のみ: only, 決算整理仕訳以外: without(条件に指定した時のみ含まれる）
   */
  @JsonAdapter(AdjustmentEnum.Adapter.class)
  public enum AdjustmentEnum {
    ONLY("only"),
    
    WITHOUT("without");

    private String value;

    AdjustmentEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static AdjustmentEnum fromValue(String value) {
      for (AdjustmentEnum b : AdjustmentEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<AdjustmentEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final AdjustmentEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public AdjustmentEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return AdjustmentEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_ADJUSTMENT = "adjustment";
  @SerializedName(SERIALIZED_NAME_ADJUSTMENT)
  private AdjustmentEnum adjustment;

  public static final String SERIALIZED_NAME_BALANCES = "balances";
  @SerializedName(SERIALIZED_NAME_BALANCES)
  private List<TrialPlResponseTrialPlBalances> balances = new ArrayList<>();

  /**
   * 内訳の表示（取引先: partner, 品目: item, 部門: section, 勘定科目: account_item）(条件に指定した時のみ含まれる）
   */
  @JsonAdapter(BreakdownDisplayTypeEnum.Adapter.class)
  public enum BreakdownDisplayTypeEnum {
    PARTNER("partner"),
    
    ITEM("item"),
    
    SECTION("section"),
    
    ACCOUNT_ITEM("account_item");

    private String value;

    BreakdownDisplayTypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static BreakdownDisplayTypeEnum fromValue(String value) {
      for (BreakdownDisplayTypeEnum b : BreakdownDisplayTypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<BreakdownDisplayTypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final BreakdownDisplayTypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public BreakdownDisplayTypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return BreakdownDisplayTypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_BREAKDOWN_DISPLAY_TYPE = "breakdown_display_type";
  @SerializedName(SERIALIZED_NAME_BREAKDOWN_DISPLAY_TYPE)
  private BreakdownDisplayTypeEnum breakdownDisplayType;

  public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
  @SerializedName(SERIALIZED_NAME_COMPANY_ID)
  private Integer companyId;

  /**
   * 配賦仕訳のみ：only,配賦仕訳以外：without(条件に指定した時のみ含まれる）
   */
  @JsonAdapter(CostAllocationEnum.Adapter.class)
  public enum CostAllocationEnum {
    ONLY("only"),
    
    WITHOUT("without");

    private String value;

    CostAllocationEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static CostAllocationEnum fromValue(String value) {
      for (CostAllocationEnum b : CostAllocationEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<CostAllocationEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final CostAllocationEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public CostAllocationEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return CostAllocationEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_COST_ALLOCATION = "cost_allocation";
  @SerializedName(SERIALIZED_NAME_COST_ALLOCATION)
  private CostAllocationEnum costAllocation;

  public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
  @SerializedName(SERIALIZED_NAME_CREATED_AT)
  private String createdAt;

  public static final String SERIALIZED_NAME_END_DATE = "end_date";
  @SerializedName(SERIALIZED_NAME_END_DATE)
  private String endDate;

  public static final String SERIALIZED_NAME_END_MONTH = "end_month";
  @SerializedName(SERIALIZED_NAME_END_MONTH)
  private Integer endMonth;

  public static final String SERIALIZED_NAME_FISCAL_YEAR = "fiscal_year";
  @SerializedName(SERIALIZED_NAME_FISCAL_YEAR)
  private Integer fiscalYear;

  public static final String SERIALIZED_NAME_ITEM_ID = "item_id";
  @SerializedName(SERIALIZED_NAME_ITEM_ID)
  private Integer itemId;

  public static final String SERIALIZED_NAME_PARTNER_CODE = "partner_code";
  @SerializedName(SERIALIZED_NAME_PARTNER_CODE)
  private String partnerCode;

  public static final String SERIALIZED_NAME_PARTNER_ID = "partner_id";
  @SerializedName(SERIALIZED_NAME_PARTNER_ID)
  private Integer partnerId;

  public static final String SERIALIZED_NAME_SECTION_ID = "section_id";
  @SerializedName(SERIALIZED_NAME_SECTION_ID)
  private Integer sectionId;

  public static final String SERIALIZED_NAME_START_DATE = "start_date";
  @SerializedName(SERIALIZED_NAME_START_DATE)
  private String startDate;

  public static final String SERIALIZED_NAME_START_MONTH = "start_month";
  @SerializedName(SERIALIZED_NAME_START_MONTH)
  private Integer startMonth;


  public TrialPlResponseTrialPl accountItemDisplayType(AccountItemDisplayTypeEnum accountItemDisplayType) {
    
    this.accountItemDisplayType = accountItemDisplayType;
    return this;
  }

   /**
   * 勘定科目の表示（勘定科目: account_item, 決算書表示:group）(条件に指定した時のみ含まれる）
   * @return accountItemDisplayType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "勘定科目の表示（勘定科目: account_item, 決算書表示:group）(条件に指定した時のみ含まれる）")

  public AccountItemDisplayTypeEnum getAccountItemDisplayType() {
    return accountItemDisplayType;
  }


  public void setAccountItemDisplayType(AccountItemDisplayTypeEnum accountItemDisplayType) {
    this.accountItemDisplayType = accountItemDisplayType;
  }


  public TrialPlResponseTrialPl adjustment(AdjustmentEnum adjustment) {
    
    this.adjustment = adjustment;
    return this;
  }

   /**
   * 決算整理仕訳のみ: only, 決算整理仕訳以外: without(条件に指定した時のみ含まれる）
   * @return adjustment
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "only", value = "決算整理仕訳のみ: only, 決算整理仕訳以外: without(条件に指定した時のみ含まれる）")

  public AdjustmentEnum getAdjustment() {
    return adjustment;
  }


  public void setAdjustment(AdjustmentEnum adjustment) {
    this.adjustment = adjustment;
  }


  public TrialPlResponseTrialPl balances(List<TrialPlResponseTrialPlBalances> balances) {
    
    this.balances = balances;
    return this;
  }

  public TrialPlResponseTrialPl addBalancesItem(TrialPlResponseTrialPlBalances balancesItem) {
    this.balances.add(balancesItem);
    return this;
  }

   /**
   * Get balances
   * @return balances
  **/
  @ApiModelProperty(required = true, value = "")

  public List<TrialPlResponseTrialPlBalances> getBalances() {
    return balances;
  }


  public void setBalances(List<TrialPlResponseTrialPlBalances> balances) {
    this.balances = balances;
  }


  public TrialPlResponseTrialPl breakdownDisplayType(BreakdownDisplayTypeEnum breakdownDisplayType) {
    
    this.breakdownDisplayType = breakdownDisplayType;
    return this;
  }

   /**
   * 内訳の表示（取引先: partner, 品目: item, 部門: section, 勘定科目: account_item）(条件に指定した時のみ含まれる）
   * @return breakdownDisplayType
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(value = "内訳の表示（取引先: partner, 品目: item, 部門: section, 勘定科目: account_item）(条件に指定した時のみ含まれる）")

  public BreakdownDisplayTypeEnum getBreakdownDisplayType() {
    return breakdownDisplayType;
  }


  public void setBreakdownDisplayType(BreakdownDisplayTypeEnum breakdownDisplayType) {
    this.breakdownDisplayType = breakdownDisplayType;
  }


  public TrialPlResponseTrialPl companyId(Integer companyId) {
    
    this.companyId = companyId;
    return this;
  }

   /**
   * 事業所ID
   * minimum: 1
   * maximum: 2147483647
   * @return companyId
  **/
  @ApiModelProperty(example = "1", required = true, value = "事業所ID")

  public Integer getCompanyId() {
    return companyId;
  }


  public void setCompanyId(Integer companyId) {
    this.companyId = companyId;
  }


  public TrialPlResponseTrialPl costAllocation(CostAllocationEnum costAllocation) {
    
    this.costAllocation = costAllocation;
    return this;
  }

   /**
   * 配賦仕訳のみ：only,配賦仕訳以外：without(条件に指定した時のみ含まれる）
   * @return costAllocation
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "only", value = "配賦仕訳のみ：only,配賦仕訳以外：without(条件に指定した時のみ含まれる）")

  public CostAllocationEnum getCostAllocation() {
    return costAllocation;
  }


  public void setCostAllocation(CostAllocationEnum costAllocation) {
    this.costAllocation = costAllocation;
  }


  public TrialPlResponseTrialPl createdAt(String createdAt) {
    
    this.createdAt = createdAt;
    return this;
  }

   /**
   * 作成日時
   * @return createdAt
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2018-09-10T13:47:24.000+09:00", value = "作成日時")

  public String getCreatedAt() {
    return createdAt;
  }


  public void setCreatedAt(String createdAt) {
    this.createdAt = createdAt;
  }


  public TrialPlResponseTrialPl endDate(String endDate) {
    
    this.endDate = endDate;
    return this;
  }

   /**
   * 発生日で絞込：終了日(yyyy-mm-dd)(条件に指定した時のみ含まれる）
   * @return endDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2019-12-31", value = "発生日で絞込：終了日(yyyy-mm-dd)(条件に指定した時のみ含まれる）")

  public String getEndDate() {
    return endDate;
  }


  public void setEndDate(String endDate) {
    this.endDate = endDate;
  }


  public TrialPlResponseTrialPl endMonth(Integer endMonth) {
    
    this.endMonth = endMonth;
    return this;
  }

   /**
   * 発生月で絞込：終了会計月(1-12)(条件に指定した時のみ含まれる）
   * minimum: 1
   * maximum: 12
   * @return endMonth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "12", value = "発生月で絞込：終了会計月(1-12)(条件に指定した時のみ含まれる）")

  public Integer getEndMonth() {
    return endMonth;
  }


  public void setEndMonth(Integer endMonth) {
    this.endMonth = endMonth;
  }


  public TrialPlResponseTrialPl fiscalYear(Integer fiscalYear) {
    
    this.fiscalYear = fiscalYear;
    return this;
  }

   /**
   * 会計年度(条件に指定した時、または条件に月、日条件がない時のみ含まれる）
   * @return fiscalYear
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2019", value = "会計年度(条件に指定した時、または条件に月、日条件がない時のみ含まれる）")

  public Integer getFiscalYear() {
    return fiscalYear;
  }


  public void setFiscalYear(Integer fiscalYear) {
    this.fiscalYear = fiscalYear;
  }


  public TrialPlResponseTrialPl itemId(Integer itemId) {
    
    this.itemId = itemId;
    return this;
  }

   /**
   * 品目ID(条件に指定した時のみ含まれる）
   * minimum: 1
   * maximum: 2147483647
   * @return itemId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "品目ID(条件に指定した時のみ含まれる）")

  public Integer getItemId() {
    return itemId;
  }


  public void setItemId(Integer itemId) {
    this.itemId = itemId;
  }


  public TrialPlResponseTrialPl partnerCode(String partnerCode) {
    
    this.partnerCode = partnerCode;
    return this;
  }

   /**
   * 取引先コード(条件に指定した時のみ含まれる）
   * @return partnerCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "code001", value = "取引先コード(条件に指定した時のみ含まれる）")

  public String getPartnerCode() {
    return partnerCode;
  }


  public void setPartnerCode(String partnerCode) {
    this.partnerCode = partnerCode;
  }


  public TrialPlResponseTrialPl partnerId(Integer partnerId) {
    
    this.partnerId = partnerId;
    return this;
  }

   /**
   * 取引先ID(条件に指定した時のみ含まれる）
   * minimum: 1
   * maximum: 2147483647
   * @return partnerId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "取引先ID(条件に指定した時のみ含まれる）")

  public Integer getPartnerId() {
    return partnerId;
  }


  public void setPartnerId(Integer partnerId) {
    this.partnerId = partnerId;
  }


  public TrialPlResponseTrialPl sectionId(Integer sectionId) {
    
    this.sectionId = sectionId;
    return this;
  }

   /**
   * 部門ID(条件に指定した時のみ含まれる）
   * minimum: 1
   * maximum: 2147483647
   * @return sectionId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "部門ID(条件に指定した時のみ含まれる）")

  public Integer getSectionId() {
    return sectionId;
  }


  public void setSectionId(Integer sectionId) {
    this.sectionId = sectionId;
  }


  public TrialPlResponseTrialPl startDate(String startDate) {
    
    this.startDate = startDate;
    return this;
  }

   /**
   * 発生日で絞込：開始日(yyyy-mm-dd)(条件に指定した時のみ含まれる）
   * @return startDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2019-01-01", value = "発生日で絞込：開始日(yyyy-mm-dd)(条件に指定した時のみ含まれる）")

  public String getStartDate() {
    return startDate;
  }


  public void setStartDate(String startDate) {
    this.startDate = startDate;
  }


  public TrialPlResponseTrialPl startMonth(Integer startMonth) {
    
    this.startMonth = startMonth;
    return this;
  }

   /**
   * 発生月で絞込：開始会計月(1-12)(条件に指定した時のみ含まれる）
   * minimum: 1
   * maximum: 12
   * @return startMonth
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "発生月で絞込：開始会計月(1-12)(条件に指定した時のみ含まれる）")

  public Integer getStartMonth() {
    return startMonth;
  }


  public void setStartMonth(Integer startMonth) {
    this.startMonth = startMonth;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    TrialPlResponseTrialPl trialPlResponseTrialPl = (TrialPlResponseTrialPl) o;
    return Objects.equals(this.accountItemDisplayType, trialPlResponseTrialPl.accountItemDisplayType) &&
        Objects.equals(this.adjustment, trialPlResponseTrialPl.adjustment) &&
        Objects.equals(this.balances, trialPlResponseTrialPl.balances) &&
        Objects.equals(this.breakdownDisplayType, trialPlResponseTrialPl.breakdownDisplayType) &&
        Objects.equals(this.companyId, trialPlResponseTrialPl.companyId) &&
        Objects.equals(this.costAllocation, trialPlResponseTrialPl.costAllocation) &&
        Objects.equals(this.createdAt, trialPlResponseTrialPl.createdAt) &&
        Objects.equals(this.endDate, trialPlResponseTrialPl.endDate) &&
        Objects.equals(this.endMonth, trialPlResponseTrialPl.endMonth) &&
        Objects.equals(this.fiscalYear, trialPlResponseTrialPl.fiscalYear) &&
        Objects.equals(this.itemId, trialPlResponseTrialPl.itemId) &&
        Objects.equals(this.partnerCode, trialPlResponseTrialPl.partnerCode) &&
        Objects.equals(this.partnerId, trialPlResponseTrialPl.partnerId) &&
        Objects.equals(this.sectionId, trialPlResponseTrialPl.sectionId) &&
        Objects.equals(this.startDate, trialPlResponseTrialPl.startDate) &&
        Objects.equals(this.startMonth, trialPlResponseTrialPl.startMonth);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountItemDisplayType, adjustment, balances, breakdownDisplayType, companyId, costAllocation, createdAt, endDate, endMonth, fiscalYear, itemId, partnerCode, partnerId, sectionId, startDate, startMonth);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class TrialPlResponseTrialPl {\n");
    sb.append("    accountItemDisplayType: ").append(toIndentedString(accountItemDisplayType)).append("\n");
    sb.append("    adjustment: ").append(toIndentedString(adjustment)).append("\n");
    sb.append("    balances: ").append(toIndentedString(balances)).append("\n");
    sb.append("    breakdownDisplayType: ").append(toIndentedString(breakdownDisplayType)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    costAllocation: ").append(toIndentedString(costAllocation)).append("\n");
    sb.append("    createdAt: ").append(toIndentedString(createdAt)).append("\n");
    sb.append("    endDate: ").append(toIndentedString(endDate)).append("\n");
    sb.append("    endMonth: ").append(toIndentedString(endMonth)).append("\n");
    sb.append("    fiscalYear: ").append(toIndentedString(fiscalYear)).append("\n");
    sb.append("    itemId: ").append(toIndentedString(itemId)).append("\n");
    sb.append("    partnerCode: ").append(toIndentedString(partnerCode)).append("\n");
    sb.append("    partnerId: ").append(toIndentedString(partnerId)).append("\n");
    sb.append("    sectionId: ").append(toIndentedString(sectionId)).append("\n");
    sb.append("    startDate: ").append(toIndentedString(startDate)).append("\n");
    sb.append("    startMonth: ").append(toIndentedString(startMonth)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

