/*
 * Decompiled with CFR 0.152.
 */
package jp.co.freee.accounting.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Objects;
import javax.annotation.Nullable;
import jp.co.freee.accounting.models.CompanyParamsFiscalYears;

public class CompanyParams {
    public static final String SERIALIZED_NAME_AMOUNT_FRACTION = "amount_fraction";
    @SerializedName(value="amount_fraction")
    private Integer amountFraction;
    public static final String SERIALIZED_NAME_CONTACT_NAME = "contact_name";
    @SerializedName(value="contact_name")
    private String contactName;
    public static final String SERIALIZED_NAME_CORPORATE_NUMBER = "corporate_number";
    @SerializedName(value="corporate_number")
    private String corporateNumber;
    public static final String SERIALIZED_NAME_DEFAULT_WALLET_ACCOUNT_ID = "default_wallet_account_id";
    @SerializedName(value="default_wallet_account_id")
    private Integer defaultWalletAccountId;
    public static final String SERIALIZED_NAME_FAX = "fax";
    @SerializedName(value="fax")
    private String fax;
    public static final String SERIALIZED_NAME_FISCAL_YEARS = "fiscal_years";
    @SerializedName(value="fiscal_years")
    private CompanyParamsFiscalYears fiscalYears;
    public static final String SERIALIZED_NAME_HEAD_COUNT = "head_count";
    @SerializedName(value="head_count")
    private HeadCountEnum headCount;
    public static final String SERIALIZED_NAME_INDUSTRY_CLASS = "industry_class";
    @SerializedName(value="industry_class")
    private IndustryClassEnum industryClass;
    public static final String SERIALIZED_NAME_INDUSTRY_CODE = "industry_code";
    @SerializedName(value="industry_code")
    private IndustryCodeEnum industryCode;
    public static final String SERIALIZED_NAME_INVOICE_LAYOUT = "invoice_layout";
    @SerializedName(value="invoice_layout")
    private InvoiceLayoutEnum invoiceLayout;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NAME_KANA = "name_kana";
    @SerializedName(value="name_kana")
    private String nameKana;
    public static final String SERIALIZED_NAME_PHONE1 = "phone1";
    @SerializedName(value="phone1")
    private String phone1;
    public static final String SERIALIZED_NAME_PHONE2 = "phone2";
    @SerializedName(value="phone2")
    private String phone2;
    public static final String SERIALIZED_NAME_PREFECTURE_CODE = "prefecture_code";
    @SerializedName(value="prefecture_code")
    private Integer prefectureCode;
    public static final String SERIALIZED_NAME_PRIVATE_SETTLEMENT = "private_settlement";
    @SerializedName(value="private_settlement")
    private Boolean privateSettlement;
    public static final String SERIALIZED_NAME_STREET_NAME1 = "street_name1";
    @SerializedName(value="street_name1")
    private String streetName1;
    public static final String SERIALIZED_NAME_STREET_NAME2 = "street_name2";
    @SerializedName(value="street_name2")
    private String streetName2;
    public static final String SERIALIZED_NAME_TXN_NUMBER_FORMAT = "txn_number_format";
    @SerializedName(value="txn_number_format")
    private TxnNumberFormatEnum txnNumberFormat;
    public static final String SERIALIZED_NAME_ZIPCODE = "zipcode";
    @SerializedName(value="zipcode")
    private String zipcode;

    public CompanyParams amountFraction(Integer amountFraction) {
        this.amountFraction = amountFraction;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="0", value="\u91d1\u984d\u7aef\u6570\u51e6\u7406\u65b9\u6cd5\uff080: \u5207\u308a\u6368\u3066\u30011: \u5207\u308a\u4e0a\u3052, 2: \u56db\u6368\u4e94\u5165\uff09")
    public Integer getAmountFraction() {
        return this.amountFraction;
    }

    public void setAmountFraction(Integer amountFraction) {
        this.amountFraction = amountFraction;
    }

    public CompanyParams contactName(String contactName) {
        this.contactName = contactName;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u62c5\u5f53\u8005", value="\u62c5\u5f53\u8005\u540d (50\u6587\u5b57\u4ee5\u5185)")
    public String getContactName() {
        return this.contactName;
    }

    public void setContactName(String contactName) {
        this.contactName = contactName;
    }

    public CompanyParams corporateNumber(String corporateNumber) {
        this.corporateNumber = corporateNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1234567890123", value="\u6cd5\u4eba\u756a\u53f7 (\u534a\u89d2\u6570\u5b5713\u6841\u3001\u6cd5\u4eba\u306e\u307f)")
    public String getCorporateNumber() {
        return this.corporateNumber;
    }

    public void setCorporateNumber(String corporateNumber) {
        this.corporateNumber = corporateNumber;
    }

    public CompanyParams defaultWalletAccountId(Integer defaultWalletAccountId) {
        this.defaultWalletAccountId = defaultWalletAccountId;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="\u6c7a\u6e08\u53e3\u5ea7\u306e\u30c7\u30d5\u30a9\u30eb\u30c8")
    public Integer getDefaultWalletAccountId() {
        return this.defaultWalletAccountId;
    }

    public void setDefaultWalletAccountId(Integer defaultWalletAccountId) {
        this.defaultWalletAccountId = defaultWalletAccountId;
    }

    public CompanyParams fax(String fax) {
        this.fax = fax;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="03-1234-xxxx", value="FAX")
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public CompanyParams fiscalYears(CompanyParamsFiscalYears fiscalYears) {
        this.fiscalYears = fiscalYears;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public CompanyParamsFiscalYears getFiscalYears() {
        return this.fiscalYears;
    }

    public void setFiscalYears(CompanyParamsFiscalYears fiscalYears) {
        this.fiscalYears = fiscalYears;
    }

    public CompanyParams headCount(HeadCountEnum headCount) {
        this.headCount = headCount;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="1", value="\u5f93\u696d\u54e1\u6570\uff080: \u7d4c\u55b6\u8005\u306e\u307f\u30011: 2~5\u4eba\u30012: 6~10\u4eba\u30013: 11~20\u4eba\u300113: 21~50\u4eba\u300114: 51~100\u4eba\u300115: 101~300\u4eba\u300118: 301~500\u4eba\u300116: 501~1,000\u4eba\u300117: 1,001\u4eba\u4ee5\u4e0a")
    public HeadCountEnum getHeadCount() {
        return this.headCount;
    }

    public void setHeadCount(HeadCountEnum headCount) {
        this.headCount = headCount;
    }

    public CompanyParams industryClass(IndustryClassEnum industryClass) {
        this.industryClass = industryClass;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="agriculture_forestry_fisheries_ore", value="\u7a2e\u5225\uff08agriculture_forestry_fisheries_ore: \u8fb2\u6797\u6c34\u7523\u696d/\u9271\u696d\u3001construction: \u5efa\u8a2d\u3001manufacturing_processing: \u88fd\u9020/\u52a0\u5de5\u3001it: IT\u3001transportation_logistics: \u904b\u8f38/\u7269\u6d41\u3001retail_wholesale: \u5c0f\u58f2/\u5378\u58f2\u3001finance_insurance: \u91d1\u878d/\u4fdd\u967a\u3001real_estate_rental: \u4e0d\u52d5\u7523/\u30ec\u30f3\u30bf\u30eb\u3001profession: \u58eb\u696d/\u5b66\u8853/\u5c02\u9580\u6280\u8853\u30b5\u30fc\u30d3\u30b9\u3001design_production: \u30c7\u30b6\u30a4\u30f3/\u5236\u4f5c\u3001food: \u98f2\u98df\u3001leisure_entertainment: \u30ec\u30b8\u30e3\u30fc/\u5a2f\u697d\u3001lifestyle: \u751f\u6d3b\u95a2\u9023\u30b5\u30fc\u30d3\u30b9\u3001education: \u6559\u80b2/\u5b66\u7fd2\u652f\u63f4\u3001medical_welfare: \u533b\u7642/\u798f\u7949\u3001other_services: \u305d\u306e\u4ed6\u30b5\u30fc\u30d3\u30b9\u3001other: \u305d\u306e\u4ed6\uff09")
    public IndustryClassEnum getIndustryClass() {
        return this.industryClass;
    }

    public void setIndustryClass(IndustryClassEnum industryClass) {
        this.industryClass = industryClass;
    }

    public CompanyParams industryCode(IndustryCodeEnum industryCode) {
        this.industryCode = industryCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="\u696d\u7a2e\uff08agriculture: \u8fb2\u696d, forestry: \u6797\u696d, fishing_industry: \u6f01\u696d\u3001\u6c34\u7523\u990a\u6b96\u696d, mining: \u9271\u696d\u3001\u63a1\u77f3\u696d\u3001\u7802\u5229\u63a1\u53d6\u696d, civil_contractors: \u571f\u6728\u5de5\u4e8b\u696d, pavement: \u8217\u88c5\u5de5\u4e8b\u696d, carpenter: \u3068\u3073\u3001\u5927\u5de5\u3001\u5de6\u5b98\u7b49\u306e\u5efa\u8a2d\u5de5\u4e8b\u696d, renovation: \u30ea\u30d5\u30a9\u30fc\u30e0\u5de5\u4e8b\u696d, electrical_plumbing: \u96fb\u6c17\u3001\u7ba1\u5de5\u4e8b\u7b49\u306e\u8a2d\u5099\u5de5\u4e8b\u696d, grocery: \u98df\u6599\u54c1\u306e\u88fd\u9020\u52a0\u5de5\u696d, machinery_manufacturing: \u6a5f\u68b0\u5668\u5177\u306e\u88fd\u9020\u52a0\u5de5\u696d, printing: \u5370\u5237\u696d, other_manufacturing: \u305d\u306e\u4ed6\u306e\u88fd\u9020\u52a0\u5de5\u696d, software_development: \u53d7\u8a17\uff1a\u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u3001\u30a2\u30d7\u30ea\u958b\u767a\u696d, system_development: \u53d7\u8a17\uff1a\u30b7\u30b9\u30c6\u30e0\u958b\u767a\u696d, survey_analysis: \u53d7\u8a17\uff1a\u8abf\u67fb\u3001\u5206\u6790\u7b49\u306e\u60c5\u5831\u51e6\u7406\u696d, server_management: \u53d7\u8a17\uff1a\u30b5\u30fc\u30d0\u30fc\u904b\u55b6\u7ba1\u7406, website_production: \u53d7\u8a17\uff1a\u30a6\u30a7\u30d6\u30b5\u30a4\u30c8\u5236\u4f5c, online_service_management: \u30aa\u30f3\u30e9\u30a4\u30f3\u30b5\u30fc\u30d3\u30b9\u904b\u55b6\u696d, online_advertising_agency: \u30aa\u30f3\u30e9\u30a4\u30f3\u5e83\u544a\u4ee3\u7406\u5e97\u696d, online_advertising_planning_production: \u30aa\u30f3\u30e9\u30a4\u30f3\u5e83\u544a\u4f01\u753b\u30fb\u5236\u4f5c\u696d, online_media_management: \u30aa\u30f3\u30e9\u30a4\u30f3\u30e1\u30c7\u30a3\u30a2\u904b\u55b6\u696d, portal_site_management: \u30dd\u30fc\u30bf\u30eb\u30b5\u30a4\u30c8\u904b\u55b6\u696d, other_it_services: \u305d\u306e\u4ed6\u3001IT \u30b5\u30fc\u30d3\u30b9\u696d, transport_delivery: \u8f38\u9001\u696d\u3001\u914d\u9001\u696d, delivery: \u30d0\u30a4\u30af\u4fbf\u7b49\u306e\u914d\u9054\u696d, other_transportation_logistics: \u305d\u306e\u4ed6\u306e\u904b\u8f38\u696d\u3001\u7269\u6d41\u696d, other_wholesale: \u5378\u58f2\u696d\uff1a\u305d\u306e\u4ed6, clothing_wholesale_fiber: \u5378\u58f2\u696d\uff1a\u8863\u985e\u5378\u58f2\uff0f\u7e4a\u7dad, food_wholesale: \u5378\u58f2\u696d\uff1a\u98f2\u98df\u6599\u54c1, entrusted_development_wholesale: \u5378\u58f2\u696d\uff1a\u6a5f\u68b0\u5668\u5177, online_shop: \u5c0f\u58f2\u696d\uff1a\u7121\u5e97\u8217\u3000\u30aa\u30f3\u30e9\u30a4\u30f3\u30b7\u30e7\u30c3\u30d7, fashion_grocery_store: \u5c0f\u58f2\u696d\uff1a\u5e97\u8217\u3042\u308a\u3000\u30d5\u30a1\u30c3\u30b7\u30e7\u30f3\u3001\u96d1\u8ca8, food_store: \u5c0f\u58f2\u696d\uff1a\u5e97\u8217\u3042\u308a\u3000\u751f\u9bae\u98df\u54c1\u3001\u98f2\u98df\u6599\u54c1, entrusted_store: \u5c0f\u58f2\u696d\uff1a\u5e97\u8217\u3042\u308a\u3000\u6a5f\u68b0\u3001\u5668\u5177, other_store: \u5c0f\u58f2\u696d\uff1a\u5e97\u8217\u3042\u308a\u3000\u305d\u306e\u4ed6, financial_instruments_exchange: \u91d1\u878d\u696d\uff1a\u91d1\u878d\u5546\u54c1\u53d6\u5f15, commodity_futures_investment_advisor: \u91d1\u878d\u696d\uff1a\u5546\u54c1\u5148\u7269\u53d6\u5f15\u3001\u5546\u54c1\u6295\u8cc7\u9867\u554f, other_financial: \u91d1\u878d\u696d\uff1a\u305d\u306e\u4ed6, brokerage_insurance: \u4fdd\u967a\u696d\uff1a\u4ef2\u4ecb\u3001\u4ee3\u7406, other_insurance: \u4fdd\u967a\u696d\uff1a\u305d\u306e\u4ed6, real_estate_developer: \u4e0d\u52d5\u7523\u696d\uff1a\u30c7\u30a3\u30d9\u30ed\u30c3\u30d1\u30fc, real_estate_brokerage: \u4e0d\u52d5\u7523\u696d\uff1a\u58f2\u8cb7\u3001\u4ef2\u4ecb, rent_coin_parking_management: \u4e0d\u52d5\u7523\u696d\uff1a\u8cc3\u8cb8\u3001\u30b3\u30a4\u30f3\u30d1\u30fc\u30ad\u30f3\u30b0\u3001\u7ba1\u7406, rental_office_co_working_space: \u4e0d\u52d5\u7523\u696d\uff1a\u30ec\u30f3\u30bf\u30eb\u30aa\u30d5\u30a3\u30b9\u3001\u30b3\u30ef\u30fc\u30ad\u30f3\u30b0\u30b9\u30da\u30fc\u30b9, rental_lease: \u30ec\u30f3\u30bf\u30eb\u696d\u3001\u30ea\u30fc\u30b9\u696d, cpa_tax_accountant: \u58eb\u696d\uff1a\u516c\u8a8d\u4f1a\u8a08\u58eb\u4e8b\u52d9\u6240\u3001\u7a0e\u7406\u58eb\u4e8b\u52d9\u6240, law_office: \u58eb\u696d\uff1a\u6cd5\u5f8b\u4e8b\u52d9\u6240, judicial_and_administrative_scrivener: \u58eb\u696d\uff1a\u53f8\u6cd5\u66f8\u58eb\u4e8b\u52d9\u6240\uff0f\u884c\u653f\u66f8\u58eb\u4e8b\u52d9\u6240, labor_consultant: \u58eb\u696d\uff1a\u793e\u4f1a\u4fdd\u967a\u52b4\u52d9\u58eb\u4e8b\u52d9\u6240, other_profession: \u58eb\u696d\uff1a\u305d\u306e\u4ed6, business_consultant: \u7d4c\u55b6\u30b3\u30f3\u30b5\u30eb\u30bf\u30f3\u30c8, academic_research_development: \u5b66\u8853\u30fb\u958b\u767a\u7814\u7a76\u6a5f\u95a2, advertising_agency: \u5e83\u544a\u4ee3\u7406\u5e97, advertising_planning_production: \u5e83\u544a\u4f01\u753b\uff0f\u5236\u4f5c, design_development: \u30bd\u30d5\u30c8\u30a6\u30a7\u30a2\u3001\u30a2\u30d7\u30ea\u958b\u767a\u696d\uff08\u53d7\u8a17\uff09, apparel_industry_design: \u670d\u98fe\u30c7\u30b6\u30a4\u30f3\u696d\u3001\u5de5\u696d\u30c7\u30b6\u30a4\u30f3\u696d, website_design: \u30a6\u30a7\u30d6\u30b5\u30a4\u30c8\u5236\u4f5c\uff08\u53d7\u8a17\uff09, advertising_planning_design: \u5e83\u544a\u4f01\u753b\uff0f\u5236\u4f5c\u696d, other_design: \u305d\u306e\u4ed6\u3001\u30c7\u30b6\u30a4\u30f3\uff0f\u5236\u4f5c, restaurants_coffee_shops: \u30ec\u30b9\u30c8\u30e9\u30f3\u3001\u55ab\u8336\u5e97\u7b49\u306e\u98f2\u98df\u5e97\u696d, sale_of_lunch: \u5f01\u5f53\u306e\u8ca9\u58f2\u696d, bread_confectionery_manufacture_sale: \u30d1\u30f3\u3001\u83d3\u5b50\u7b49\u306e\u88fd\u9020\u8ca9\u58f2\u696d, delivery_catering_mobile_catering: \u30c7\u30ea\u30d0\u30ea\u30fc\u696d\u3001\u30b1\u30fc\u30bf\u30ea\u30f3\u30b0\u696d\u3001\u79fb\u52d5\u8ca9\u58f2\u696d, hotel_inn: \u5bbf\u6cca\u696d\uff1a\u30db\u30c6\u30eb\u3001\u65c5\u9928, homestay: \u5bbf\u6cca\u696d\uff1a\u6c11\u6cca, travel_agency: \u65c5\u884c\u4ee3\u7406\u5e97\u696d, leisure_sports_facility_management: \u30ec\u30b8\u30e3\u30fc\u3001\u30b9\u30dd\u30fc\u30c4\u7b49\u306e\u65bd\u8a2d\u904b\u55b6\u696d, show_event_management: \u30b7\u30e7\u30fc\u3001\u30a4\u30d9\u30f3\u30c8\u7b49\u306e\u8208\u884c\u3001\u30a4\u30d9\u30f3\u30c8\u904b\u55b6\u696d, barber: \u30d3\u30e5\u30fc\u30c6\u30a3\u3001\u30d8\u30eb\u30b9\u30b1\u30a2\u696d\uff1a\u5e8a\u5c4b\u3001\u7406\u5bb9\u5ba4, beauty_salon: \u30d3\u30e5\u30fc\u30c6\u30a3\u3001\u30d8\u30eb\u30b9\u30b1\u30a2\u696d\uff1a\u7f8e\u5bb9\u5ba4, spa_sand_bath_sauna: \u30d3\u30e5\u30fc\u30c6\u30a3\u3001\u30d8\u30eb\u30b9\u30b1\u30a2\u696d\uff1a\u30b9\u30d1\u3001\u7802\u98a8\u5442\u3001\u30b5\u30a6\u30ca\u7b49, este_ail_salon: \u30d3\u30e5\u30fc\u30c6\u30a3\u3001\u30d8\u30eb\u30b9\u30b1\u30a2\u696d\uff1a\u305d\u306e\u4ed6\u3001\u30a8\u30b9\u30c6\u30b5\u30ed\u30f3\u3001\u30cd\u30a4\u30eb\u30b5\u30ed\u30f3\u7b49, bridal_planning_introduce_wedding: \u51a0\u5a5a\u846c\u796d\u696d\uff1a\u30d6\u30e9\u30a4\u30c0\u30eb\u30d7\u30e9\u30f3\u30cb\u30f3\u30b0\u3001\u7d50\u5a5a\u5f0f\u5834\u7d39\u4ecb\u7b49, memorial_ceremony_funeral: \u51a0\u5a5a\u846c\u796d\u696d\uff1a\u30e1\u30e2\u30ea\u30a2\u30eb\u30bb\u30ec\u30e2\u30cb\u30fc\u3001\u846c\u5100\u7b49, moving: \u5f15\u3063\u8d8a\u3057\u696d, courier_industry: \u5b85\u914d\u696d, house_maid_cleaning_agency: \u5bb6\u4e8b\u4ee3\u884c\u30b5\u30fc\u30d3\u30b9\u696d\uff1a\u7121\u5e97\u8217\u3000\u30cf\u30a6\u30b9\u30e1\u30a4\u30c9\u3001\u6383\u9664\u4ee3\u884c\u7b49, re_tailoring_clothes: \u5bb6\u4e8b\u4ee3\u884c\u30b5\u30fc\u30d3\u30b9\u696d\uff1a\u5e97\u8217\u3042\u308a\u3000\u8863\u985e\u4fee\u7406\u3001\u8863\u985e\u4ed5\u7acb\u3066\u76f4\u3057\u7b49, training_institute_management: \u7814\u4fee\u6240\u7b49\u306e\u65bd\u8a2d\u904b\u55b6\u696d, tutoring_school: \u5b66\u7fd2\u587e\u3001\u9032\u5b66\u587e\u7b49\u306e\u6559\u80b2\u30fb\u5b66\u7fd2\u652f\u63f4\u696d, music_calligraphy_abacus_classroom: \u97f3\u697d\u6559\u5ba4\u3001\u66f8\u9053\u6559\u5ba4\u3001\u305d\u308d\u3070\u3093\u6559\u5ba4\u7b49\u306e\u306e\u6559\u80b2\u30fb\u5b66\u7fd2\u652f\u63f4\u696d, english_school: \u82f1\u4f1a\u8a71\u30b9\u30af\u30fc\u30eb\u7b49\u306e\u8a9e\u5b66\u5b66\u7fd2\u652f\u63f4\u696d, tennis_yoga_judo_school: \u30c6\u30cb\u30b9\u30b9\u30af\u30fc\u30eb\u3001\u30e8\u30ac\u6559\u5ba4\u3001\u67d4\u9053\u5834\u7b49\u306e\u30b9\u30dd\u30fc\u30c4\u6307\u5c0e\u3001\u652f\u63f4\u696d, culture_school: \u305d\u306e\u4ed6\u3001\u30ab\u30eb\u30c1\u30e3\u30fc\u30b9\u30af\u30fc\u30eb\u7b49\u306e\u6559\u80b2\u30fb\u5b66\u7fd2\u652f\u63f4\u696d, seminar_planning_management: \u30bb\u30df\u30ca\u30fc\u7b49\u306e\u4f01\u753b\u3001\u904b\u55b6\u696d, hospital_clinic: \u533b\u7642\u696d\uff1a\u75c5\u9662\u3001\u4e00\u822c\u8a3a\u7642\u6240\u3001\u30af\u30ea\u30cb\u30c3\u30af\u7b49, dental_clinic: \u533b\u7642\u696d\uff1a\u6b6f\u79d1\u8a3a\u7642\u6240, other_medical_services: \u533b\u7642\u696d\uff1a\u305d\u306e\u4ed6\u3001\u533b\u7642\u30b5\u30fc\u30d3\u30b9\u7b49, nursery: \u798f\u7949\u696d\uff1a\u4fdd\u80b2\u6240\u7b49\u3001\u5150\u7ae5\u5411\u3051\u65bd\u8a2d\u578b\u30b5\u30fc\u30d3\u30b9, nursing_home: \u798f\u7949\u696d\uff1a\u8001\u4eba\u30db\u30fc\u30e0\u7b49\u3001\u8001\u4eba\u5411\u3051\u65bd\u8a2d\u578b\u30b5\u30fc\u30d3\u30b9, rehabilitation_support_services: \u798f\u7949\u696d\uff1a\u7642\u80b2\u652f\u63f4\u30b5\u30fc\u30d3\u30b9\u7b49\u3001\u969c\u5bb3\u8005\u7b49\u5411\u3051\u65bd\u8a2d\u578b\u30b5\u30fc\u30d3\u30b9, other_welfare: \u798f\u7949\u696d\uff1a\u305d\u306e\u4ed6\u3001\u65bd\u8a2d\u578b\u798f\u7949\u30b5\u30fc\u30d3\u30b9, visit_welfare_service: \u798f\u7949\u696d\uff1a\u8a2a\u554f\u578b\u798f\u7949\u30b5\u30fc\u30d3\u30b9, recruitment_temporary_staffing: \u4eba\u6750\u7d39\u4ecb\u696d\u3001\u4eba\u6750\u6d3e\u9063\u696d, life_related_recruitment_temporary_staffing: \u751f\u6d3b\u95a2\u9023\u30b5\u30fc\u30d3\u30b9\u306e\u4eba\u6750\u7d39\u4ecb\u696d\u3001\u4eba\u6750\u6d3e\u9063\u696d, car_maintenance_car_repair: \u81ea\u52d5\u8eca\u6574\u5099\u696d\u3001\u81ea\u52d5\u8eca\u4fee\u7406\u696d, machinery_equipment_maintenance_repair: \u6a5f\u68b0\u6a5f\u5668\u985e\u306e\u6574\u5099\u696d\u3001\u4fee\u7406\u696d, cleaning_maintenance_building_management: \u6e05\u6383\u696d\u3001\u30e1\u30f3\u30c6\u30ca\u30f3\u30b9\u696d\u3001\u5efa\u7269\u7ba1\u7406\u696d, security: \u8b66\u5099\u696d, other_services: \u305d\u306e\u4ed6\u306e\u30b5\u30fc\u30d3\u30b9\u696d, npo: NPO, general_incorporated_association: \u4e00\u822c\u793e\u56e3\u6cd5\u4eba, general_incorporated_foundation: \u4e00\u822c\u8ca1\u56e3\u6cd5\u4eba, other_association: \u305d\u306e\u4ed6\u7d44\u7e54)")
    public IndustryCodeEnum getIndustryCode() {
        return this.industryCode;
    }

    public void setIndustryCode(IndustryCodeEnum industryCode) {
        this.industryCode = industryCode;
    }

    public CompanyParams invoiceLayout(InvoiceLayoutEnum invoiceLayout) {
        this.invoiceLayout = invoiceLayout;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="default_classic", value="\u8acb\u6c42\u66f8\u30ec\u30a4\u30a2\u30a6\u30c8 * `default_classic` - \u30ec\u30a4\u30a2\u30a6\u30c8\uff11/\u30af\u30e9\u30b7\u30c3\u30af (\u30c7\u30d5\u30a9\u30eb\u30c8)  * `standard_classic` - \u30ec\u30a4\u30a2\u30a6\u30c8\uff12/\u30af\u30e9\u30b7\u30c3\u30af  * `envelope_classic` - \u5c01\u7b52\uff11/\u30af\u30e9\u30b7\u30c3\u30af  * `carried_forward_standard_classic` - \u30ec\u30a4\u30a2\u30a6\u30c8\uff13\uff08\u7e70\u8d8a\u91d1\u984d\u6b04\u3042\u308a\uff09/\u30af\u30e9\u30b7\u30c3\u30af  * `carried_forward_envelope_classic` - \u5c01\u7b52\uff12\uff08\u7e70\u8d8a\u91d1\u984d\u6b04\u3042\u308a\uff09/\u30af\u30e9\u30b7\u30c3\u30af  * `default_modern` - \u30ec\u30a4\u30a2\u30a6\u30c8\uff11/\u30e2\u30c0\u30f3  * `standard_modern` - \u30ec\u30a4\u30a2\u30a6\u30c8\uff12/\u30e2\u30c0\u30f3  * `envelope_modern` - \u5c01\u7b52/\u30e2\u30c0\u30f3")
    public InvoiceLayoutEnum getInvoiceLayout() {
        return this.invoiceLayout;
    }

    public void setInvoiceLayout(InvoiceLayoutEnum invoiceLayout) {
        this.invoiceLayout = invoiceLayout;
    }

    public CompanyParams name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="freee\u4e8b\u52d9\u6240", value="\u4e8b\u696d\u6240\u306e\u6b63\u5f0f\u540d\u79f0 (100\u6587\u5b57\u4ee5\u5185)")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public CompanyParams nameKana(String nameKana) {
        this.nameKana = nameKana;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u30d5\u30ea\u30fc\u30b8\u30e0\u30b7\u30e7", value="\u6b63\u5f0f\u540d\u79f0\u30d5\u30ea\u30ac\u30ca (100\u6587\u5b57\u4ee5\u5185)")
    public String getNameKana() {
        return this.nameKana;
    }

    public void setNameKana(String nameKana) {
        this.nameKana = nameKana;
    }

    public CompanyParams phone1(String phone1) {
        this.phone1 = phone1;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="03-1234-xxxx", value="\u96fb\u8a71\u756a\u53f7\uff11")
    public String getPhone1() {
        return this.phone1;
    }

    public void setPhone1(String phone1) {
        this.phone1 = phone1;
    }

    public CompanyParams phone2(String phone2) {
        this.phone2 = phone2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="090-1234-xxxx", value="\u96fb\u8a71\u756a\u53f7\uff12")
    public String getPhone2() {
        return this.phone2;
    }

    public void setPhone2(String phone2) {
        this.phone2 = phone2;
    }

    public CompanyParams prefectureCode(Integer prefectureCode) {
        this.prefectureCode = prefectureCode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="4", value="\u90fd\u9053\u5e9c\u770c\u30b3\u30fc\u30c9\uff080: \u5317\u6d77\u9053\u30011:\u9752\u68ee\u30012:\u5ca9\u624b\u30013:\u5bae\u57ce\u30014:\u79cb\u7530\u30015:\u5c71\u5f62\u30016:\u798f\u5cf6\u30017:\u8328\u57ce\u30018:\u6803\u6728\u30019:\u7fa4\u99ac\u300110:\u57fc\u7389\u300111:\u5343\u8449\u300112:\u6771\u4eac\u300113:\u795e\u5948\u5ddd\u300114:\u65b0\u6f5f\u300115:\u5bcc\u5c71\u300116:\u77f3\u5ddd\u300117:\u798f\u4e95\u300118:\u5c71\u68a8\u300119:\u9577\u91ce\u300120:\u5c90\u961c\u300121:\u9759\u5ca1\u300122:\u611b\u77e5\u300123:\u4e09\u91cd\u300124:\u6ecb\u8cc0\u300125:\u4eac\u90fd\u300126:\u5927\u962a\u300127:\u5175\u5eab\u300128:\u5948\u826f\u300129:\u548c\u6b4c\u5c71\u300130:\u9ce5\u53d6\u300131:\u5cf6\u6839\u300132:\u5ca1\u5c71\u300133:\u5e83\u5cf6\u300134:\u5c71\u53e3\u300135:\u5fb3\u5cf6\u300136:\u9999\u5ddd\u300137:\u611b\u5a9b\u300138:\u9ad8\u77e5\u300139:\u798f\u5ca1\u300140:\u4f50\u8cc0\u300141:\u9577\u5d0e\u300142:\u718a\u672c\u300143:\u5927\u5206\u300144:\u5bae\u5d0e\u300145:\u9e7f\u5150\u5cf6\u300146:\u6c96\u7e04")
    public Integer getPrefectureCode() {
        return this.prefectureCode;
    }

    public void setPrefectureCode(Integer prefectureCode) {
        this.prefectureCode = prefectureCode;
    }

    public CompanyParams privateSettlement(Boolean privateSettlement) {
        this.privateSettlement = privateSettlement;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="true", value="\u30d7\u30e9\u30a4\u30d9\u30fc\u30c8\u8cc7\u91d1/\u5f79\u54e1\u8cc7\u91d1\uff08false: \u4f7f\u7528\u3057\u306a\u3044\u3001true: \u4f7f\u7528\u3059\u308b\uff09")
    public Boolean getPrivateSettlement() {
        return this.privateSettlement;
    }

    public void setPrivateSettlement(Boolean privateSettlement) {
        this.privateSettlement = privateSettlement;
    }

    public CompanyParams streetName1(String streetName1) {
        this.streetName1 = streetName1;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\uff38\uff38\u533a\uff39\uff39\uff11\u2212\uff11\u30fc\uff11", value="\u5e02\u533a\u753a\u6751\u30fb\u756a\u5730")
    public String getStreetName1() {
        return this.streetName1;
    }

    public void setStreetName1(String streetName1) {
        this.streetName1 = streetName1;
    }

    public CompanyParams streetName2(String streetName2) {
        this.streetName2 = streetName2;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u30d3\u30eb\uff11\uff26", value="\u5efa\u7269\u540d\u30fb\u90e8\u5c4b\u756a\u53f7\u306a\u3069")
    public String getStreetName2() {
        return this.streetName2;
    }

    public void setStreetName2(String streetName2) {
        this.streetName2 = streetName2;
    }

    public CompanyParams txnNumberFormat(TxnNumberFormatEnum txnNumberFormat) {
        this.txnNumberFormat = txnNumberFormat;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="not_used", value="\u4ed5\u8a33\u756a\u53f7\u5f62\u5f0f\uff08not_used: \u4f7f\u7528\u3057\u306a\u3044\u3001digits: \u6570\u5b57\uff08\u4f8b\uff1a5091824\uff09\u3001alnum: \u82f1\u6570\u5b57\uff08\u4f8b\uff1a59J0P\uff09\uff09")
    public TxnNumberFormatEnum getTxnNumberFormat() {
        return this.txnNumberFormat;
    }

    public void setTxnNumberFormat(TxnNumberFormatEnum txnNumberFormat) {
        this.txnNumberFormat = txnNumberFormat;
    }

    public CompanyParams zipcode(String zipcode) {
        this.zipcode = zipcode;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="000-0000", value="\u90f5\u4fbf\u756a\u53f7")
    public String getZipcode() {
        return this.zipcode;
    }

    public void setZipcode(String zipcode) {
        this.zipcode = zipcode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompanyParams companyParams = (CompanyParams)o;
        return Objects.equals(this.amountFraction, companyParams.amountFraction) && Objects.equals(this.contactName, companyParams.contactName) && Objects.equals(this.corporateNumber, companyParams.corporateNumber) && Objects.equals(this.defaultWalletAccountId, companyParams.defaultWalletAccountId) && Objects.equals(this.fax, companyParams.fax) && Objects.equals(this.fiscalYears, companyParams.fiscalYears) && Objects.equals((Object)this.headCount, (Object)companyParams.headCount) && Objects.equals((Object)this.industryClass, (Object)companyParams.industryClass) && Objects.equals((Object)this.industryCode, (Object)companyParams.industryCode) && Objects.equals((Object)this.invoiceLayout, (Object)companyParams.invoiceLayout) && Objects.equals(this.name, companyParams.name) && Objects.equals(this.nameKana, companyParams.nameKana) && Objects.equals(this.phone1, companyParams.phone1) && Objects.equals(this.phone2, companyParams.phone2) && Objects.equals(this.prefectureCode, companyParams.prefectureCode) && Objects.equals(this.privateSettlement, companyParams.privateSettlement) && Objects.equals(this.streetName1, companyParams.streetName1) && Objects.equals(this.streetName2, companyParams.streetName2) && Objects.equals((Object)this.txnNumberFormat, (Object)companyParams.txnNumberFormat) && Objects.equals(this.zipcode, companyParams.zipcode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amountFraction, this.contactName, this.corporateNumber, this.defaultWalletAccountId, this.fax, this.fiscalYears, this.headCount, this.industryClass, this.industryCode, this.invoiceLayout, this.name, this.nameKana, this.phone1, this.phone2, this.prefectureCode, this.privateSettlement, this.streetName1, this.streetName2, this.txnNumberFormat, this.zipcode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompanyParams {\n");
        sb.append("    amountFraction: ").append(this.toIndentedString(this.amountFraction)).append("\n");
        sb.append("    contactName: ").append(this.toIndentedString(this.contactName)).append("\n");
        sb.append("    corporateNumber: ").append(this.toIndentedString(this.corporateNumber)).append("\n");
        sb.append("    defaultWalletAccountId: ").append(this.toIndentedString(this.defaultWalletAccountId)).append("\n");
        sb.append("    fax: ").append(this.toIndentedString(this.fax)).append("\n");
        sb.append("    fiscalYears: ").append(this.toIndentedString(this.fiscalYears)).append("\n");
        sb.append("    headCount: ").append(this.toIndentedString((Object)this.headCount)).append("\n");
        sb.append("    industryClass: ").append(this.toIndentedString((Object)this.industryClass)).append("\n");
        sb.append("    industryCode: ").append(this.toIndentedString((Object)this.industryCode)).append("\n");
        sb.append("    invoiceLayout: ").append(this.toIndentedString((Object)this.invoiceLayout)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameKana: ").append(this.toIndentedString(this.nameKana)).append("\n");
        sb.append("    phone1: ").append(this.toIndentedString(this.phone1)).append("\n");
        sb.append("    phone2: ").append(this.toIndentedString(this.phone2)).append("\n");
        sb.append("    prefectureCode: ").append(this.toIndentedString(this.prefectureCode)).append("\n");
        sb.append("    privateSettlement: ").append(this.toIndentedString(this.privateSettlement)).append("\n");
        sb.append("    streetName1: ").append(this.toIndentedString(this.streetName1)).append("\n");
        sb.append("    streetName2: ").append(this.toIndentedString(this.streetName2)).append("\n");
        sb.append("    txnNumberFormat: ").append(this.toIndentedString((Object)this.txnNumberFormat)).append("\n");
        sb.append("    zipcode: ").append(this.toIndentedString(this.zipcode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TxnNumberFormatEnum {
        NOT_USED("not_used"),
        DIGITS("digits"),
        ALNUM("alnum");

        private String value;

        private TxnNumberFormatEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TxnNumberFormatEnum fromValue(String value) {
            for (TxnNumberFormatEnum b : TxnNumberFormatEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TxnNumberFormatEnum> {
            public void write(JsonWriter jsonWriter, TxnNumberFormatEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TxnNumberFormatEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TxnNumberFormatEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum InvoiceLayoutEnum {
        DEFAULT_CLASSIC("default_classic"),
        STANDARD_CLASSIC("standard_classic"),
        ENVELOPE_CLASSIC("envelope_classic"),
        CARRIED_FORWARD_STANDARD_CLASSIC("carried_forward_standard_classic"),
        CARRIED_FORWARD_ENVELOPE_CLASSIC("carried_forward_envelope_classic"),
        DEFAULT_MODERN("default_modern"),
        STANDARD_MODERN("standard_modern"),
        ENVELOPE_MODERN("envelope_modern");

        private String value;

        private InvoiceLayoutEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static InvoiceLayoutEnum fromValue(String value) {
            for (InvoiceLayoutEnum b : InvoiceLayoutEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<InvoiceLayoutEnum> {
            public void write(JsonWriter jsonWriter, InvoiceLayoutEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public InvoiceLayoutEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return InvoiceLayoutEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IndustryCodeEnum {
        AGRICULTURE("agriculture"),
        FORESTRY("forestry"),
        FISHING_INDUSTRY("fishing_industry"),
        MINING("mining"),
        CIVIL_CONTRACTORS("civil_contractors"),
        PAVEMENT("pavement"),
        CARPENTER("carpenter"),
        RENOVATION("renovation"),
        ELECTRICAL_PLUMBING("electrical_plumbing"),
        GROCERY("grocery"),
        MACHINERY_MANUFACTURING("machinery_manufacturing"),
        PRINTING("printing"),
        OTHER_MANUFACTURING("other_manufacturing"),
        SOFTWARE_DEVELOPMENT("software_development"),
        SYSTEM_DEVELOPMENT("system_development"),
        SURVEY_ANALYSIS("survey_analysis"),
        SERVER_MANAGEMENT("server_management"),
        WEBSITE_PRODUCTION("website_production"),
        ONLINE_SERVICE_MANAGEMENT("online_service_management"),
        ONLINE_ADVERTISING_AGENCY("online_advertising_agency"),
        ONLINE_ADVERTISING_PLANNING_PRODUCTION("online_advertising_planning_production"),
        ONLINE_MEDIA_MANAGEMENT("online_media_management"),
        PORTAL_SITE_MANAGEMENT("portal_site_management"),
        OTHER_IT_SERVICES("other_it_services"),
        TRANSPORT_DELIVERY("transport_delivery"),
        DELIVERY("delivery"),
        OTHER_TRANSPORTATION_LOGISTICS("other_transportation_logistics"),
        OTHER_WHOLESALE("other_wholesale"),
        CLOTHING_WHOLESALE_FIBER("clothing_wholesale_fiber"),
        FOOD_WHOLESALE("food_wholesale"),
        ENTRUSTED_DEVELOPMENT_WHOLESALE("entrusted_development_wholesale"),
        ONLINE_SHOP("online_shop"),
        FASHION_GROCERY_STORE("fashion_grocery_store"),
        FOOD_STORE("food_store"),
        ENTRUSTED_STORE("entrusted_store"),
        OTHER_STORE("other_store"),
        FINANCIAL_INSTRUMENTS_EXCHANGE("financial_instruments_exchange"),
        COMMODITY_FUTURES_INVESTMENT_ADVISOR("commodity_futures_investment_advisor"),
        OTHER_FINANCIAL("other_financial"),
        BROKERAGE_INSURANCE("brokerage_insurance"),
        OTHER_INSURANCE("other_insurance"),
        REAL_ESTATE_DEVELOPER("real_estate_developer"),
        REAL_ESTATE_BROKERAGE("real_estate_brokerage"),
        RENT_COIN_PARKING_MANAGEMENT("rent_coin_parking_management"),
        RENTAL_OFFICE_CO_WORKING_SPACE("rental_office_co_working_space"),
        RENTAL_LEASE("rental_lease"),
        CPA_TAX_ACCOUNTANT("cpa_tax_accountant"),
        LAW_OFFICE("law_office"),
        JUDICIAL_AND_ADMINISTRATIVE_SCRIVENER("judicial_and_administrative_scrivener"),
        LABOR_CONSULTANT("labor_consultant"),
        OTHER_PROFESSION("other_profession"),
        BUSINESS_CONSULTANT("business_consultant"),
        ACADEMIC_RESEARCH_DEVELOPMENT("academic_research_development"),
        ADVERTISING_AGENCY("advertising_agency"),
        ADVERTISING_PLANNING_PRODUCTION("advertising_planning_production"),
        DESIGN_DEVELOPMENT("design_development"),
        APPAREL_INDUSTRY_DESIGN("apparel_industry_design"),
        WEBSITE_DESIGN("website_design"),
        ADVERTISING_PLANNING_DESIGN("advertising_planning_design"),
        OTHER_DESIGN("other_design"),
        RESTAURANTS_COFFEE_SHOPS("restaurants_coffee_shops"),
        SALE_OF_LUNCH("sale_of_lunch"),
        BREAD_CONFECTIONERY_MANUFACTURE_SALE("bread_confectionery_manufacture_sale"),
        DELIVERY_CATERING_MOBILE_CATERING("delivery_catering_mobile_catering"),
        HOTEL_INN("hotel_inn"),
        HOMESTAY("homestay"),
        TRAVEL_AGENCY("travel_agency"),
        LEISURE_SPORTS_FACILITY_MANAGEMENT("leisure_sports_facility_management"),
        SHOW_EVENT_MANAGEMENT("show_event_management"),
        BARBER("barber"),
        BEAUTY_SALON("beauty_salon"),
        SPA_SAND_BATH_SAUNA("spa_sand_bath_sauna"),
        ESTE_AIL_SALON("este_ail_salon"),
        BRIDAL_PLANNING_INTRODUCE_WEDDING("bridal_planning_introduce_wedding"),
        MEMORIAL_CEREMONY_FUNERAL("memorial_ceremony_funeral"),
        MOVING("moving"),
        COURIER_INDUSTRY("courier_industry"),
        HOUSE_MAID_CLEANING_AGENCY("house_maid_cleaning_agency"),
        RE_TAILORING_CLOTHES("re_tailoring_clothes"),
        TRAINING_INSTITUTE_MANAGEMENT("training_institute_management"),
        TUTORING_SCHOOL("tutoring_school"),
        MUSIC_CALLIGRAPHY_ABACUS_CLASSROOM("music_calligraphy_abacus_classroom"),
        ENGLISH_SCHOOL("english_school"),
        TENNIS_YOGA_JUDO_SCHOOL("tennis_yoga_judo_school"),
        CULTURE_SCHOOL("culture_school"),
        SEMINAR_PLANNING_MANAGEMENT("seminar_planning_management"),
        HOSPITAL_CLINIC("hospital_clinic"),
        DENTAL_CLINIC("dental_clinic"),
        OTHER_MEDICAL_SERVICES("other_medical_services"),
        NURSERY("nursery"),
        NURSING_HOME("nursing_home"),
        REHABILITATION_SUPPORT_SERVICES("rehabilitation_support_services"),
        OTHER_WELFARE("other_welfare"),
        VISIT_WELFARE_SERVICE("visit_welfare_service"),
        RECRUITMENT_TEMPORARY_STAFFING("recruitment_temporary_staffing"),
        LIFE_RELATED_RECRUITMENT_TEMPORARY_STAFFING("life_related_recruitment_temporary_staffing"),
        CAR_MAINTENANCE_CAR_REPAIR("car_maintenance_car_repair"),
        MACHINERY_EQUIPMENT_MAINTENANCE_REPAIR("machinery_equipment_maintenance_repair"),
        CLEANING_MAINTENANCE_BUILDING_MANAGEMENT("cleaning_maintenance_building_management"),
        SECURITY("security"),
        OTHER_SERVICES("other_services"),
        NPO("npo"),
        GENERAL_INCORPORATED_ASSOCIATION("general_incorporated_association"),
        GENERAL_INCORPORATED_FOUNDATION("general_incorporated_foundation"),
        OTHER_ASSOCIATION("other_association");

        private String value;

        private IndustryCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IndustryCodeEnum fromValue(String value) {
            for (IndustryCodeEnum b : IndustryCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<IndustryCodeEnum> {
            public void write(JsonWriter jsonWriter, IndustryCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IndustryCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IndustryCodeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum IndustryClassEnum {
        AGRICULTURE_FORESTRY_FISHERIES_ORE("agriculture_forestry_fisheries_ore"),
        CONSTRUCTION("construction"),
        MANUFACTURING_PROCESSING("manufacturing_processing"),
        IT("it"),
        TRANSPORTATION_LOGISTICS("transportation_logistics"),
        RETAIL_WHOLESALE("retail_wholesale"),
        FINANCE_INSURANCE("finance_insurance"),
        REAL_ESTATE_RENTAL("real_estate_rental"),
        PROFESSION("profession"),
        DESIGN_PRODUCTION("design_production"),
        FOOD("food"),
        LEISURE_ENTERTAINMENT("leisure_entertainment"),
        LIFESTYLE("lifestyle"),
        EDUCATION("education"),
        MEDICAL_WELFARE("medical_welfare"),
        OTHER_SERVICES("other_services"),
        OTHER("other");

        private String value;

        private IndustryClassEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static IndustryClassEnum fromValue(String value) {
            for (IndustryClassEnum b : IndustryClassEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<IndustryClassEnum> {
            public void write(JsonWriter jsonWriter, IndustryClassEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public IndustryClassEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return IndustryClassEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum HeadCountEnum {
        NUMBER_0(new BigDecimal("0")),
        NUMBER_1(new BigDecimal("1")),
        NUMBER_2(new BigDecimal("2")),
        NUMBER_3(new BigDecimal("3")),
        NUMBER_13(new BigDecimal("13")),
        NUMBER_14(new BigDecimal("14")),
        NUMBER_15(new BigDecimal("15")),
        NUMBER_18(new BigDecimal("18")),
        NUMBER_16(new BigDecimal("16")),
        NUMBER_17(new BigDecimal("17"));

        private BigDecimal value;

        private HeadCountEnum(BigDecimal value) {
            this.value = value;
        }

        public BigDecimal getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static HeadCountEnum fromValue(BigDecimal value) {
            for (HeadCountEnum b : HeadCountEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<HeadCountEnum> {
            public void write(JsonWriter jsonWriter, HeadCountEnum enumeration) throws IOException {
                jsonWriter.value((Number)enumeration.getValue());
            }

            public HeadCountEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return HeadCountEnum.fromValue(new BigDecimal(value));
            }
        }
    }
}

