/*
 * Decompiled with CFR 0.152.
 */
package jp.co.freee.accounting.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;

public class PaymentParams {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Integer amount;
    public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
    @SerializedName(value="company_id")
    private Integer companyId;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private String date;
    public static final String SERIALIZED_NAME_FROM_WALLETABLE_ID = "from_walletable_id";
    @SerializedName(value="from_walletable_id")
    private Integer fromWalletableId;
    public static final String SERIALIZED_NAME_FROM_WALLETABLE_TYPE = "from_walletable_type";
    @SerializedName(value="from_walletable_type")
    private FromWalletableTypeEnum fromWalletableType;

    public PaymentParams amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="10000", required=true, value="\u91d1\u984d")
    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public PaymentParams companyId(Integer companyId) {
        this.companyId = companyId;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="\u4e8b\u696d\u6240ID")
    public Integer getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(Integer companyId) {
        this.companyId = companyId;
    }

    public PaymentParams date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="2018-01-01", required=true, value="\u652f\u6255\u65e5")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public PaymentParams fromWalletableId(Integer fromWalletableId) {
        this.fromWalletableId = fromWalletableId;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="\u53e3\u5ea7ID\uff08from_walletable_type\u304cprivate_account_item\u306e\u5834\u5408\u306f\u52d8\u5b9a\u79d1\u76eeID\uff09\uff1apayments\u6307\u5b9a\u6642\u306f\u5fc5\u9808")
    public Integer getFromWalletableId() {
        return this.fromWalletableId;
    }

    public void setFromWalletableId(Integer fromWalletableId) {
        this.fromWalletableId = fromWalletableId;
    }

    public PaymentParams fromWalletableType(FromWalletableTypeEnum fromWalletableType) {
        this.fromWalletableType = fromWalletableType;
        return this;
    }

    @ApiModelProperty(example="2018-01-01", required=true, value="\u53e3\u5ea7\u533a\u5206 (\u9280\u884c\u53e3\u5ea7: bank_account, \u30af\u30ec\u30b8\u30c3\u30c8\u30ab\u30fc\u30c9: credit_card, \u73fe\u91d1: wallet, \u30d7\u30e9\u30a4\u30d9\u30fc\u30c8\u8cc7\u91d1\uff08\u6cd5\u4eba\u306e\u5834\u5408\u306f\u5f79\u54e1\u501f\u5165\u91d1\u3082\u3057\u304f\u306f\u5f79\u54e1\u501f\u5165\u91d1\u3001\u500b\u4eba\u306e\u5834\u5408\u306f\u4e8b\u696d\u4e3b\u8cb8\u3082\u3057\u304f\u306f\u4e8b\u696d\u4e3b\u501f\uff09: private_account_item)\uff1apayments\u6307\u5b9a\u6642\u306f\u5fc5\u9808")
    public FromWalletableTypeEnum getFromWalletableType() {
        return this.fromWalletableType;
    }

    public void setFromWalletableType(FromWalletableTypeEnum fromWalletableType) {
        this.fromWalletableType = fromWalletableType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentParams paymentParams = (PaymentParams)o;
        return Objects.equals(this.amount, paymentParams.amount) && Objects.equals(this.companyId, paymentParams.companyId) && Objects.equals(this.date, paymentParams.date) && Objects.equals(this.fromWalletableId, paymentParams.fromWalletableId) && Objects.equals((Object)this.fromWalletableType, (Object)paymentParams.fromWalletableType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.companyId, this.date, this.fromWalletableId, this.fromWalletableType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentParams {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    fromWalletableId: ").append(this.toIndentedString(this.fromWalletableId)).append("\n");
        sb.append("    fromWalletableType: ").append(this.toIndentedString((Object)this.fromWalletableType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FromWalletableTypeEnum {
        BANK_ACCOUNT("bank_account"),
        CREDIT_CARD("credit_card"),
        WALLET("wallet"),
        PRIVATE_ACCOUNT_ITEM("private_account_item");

        private String value;

        private FromWalletableTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FromWalletableTypeEnum fromValue(String value) {
            for (FromWalletableTypeEnum b : FromWalletableTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FromWalletableTypeEnum> {
            public void write(JsonWriter jsonWriter, FromWalletableTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FromWalletableTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FromWalletableTypeEnum.fromValue(value);
            }
        }
    }
}

