/*
 * Decompiled with CFR 0.152.
 */
package jp.co.freee.accounting.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class TransferParams {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Integer amount;
    public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
    @SerializedName(value="company_id")
    private Integer companyId;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private String date;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_FROM_WALLETABLE_ID = "from_walletable_id";
    @SerializedName(value="from_walletable_id")
    private Integer fromWalletableId;
    public static final String SERIALIZED_NAME_FROM_WALLETABLE_TYPE = "from_walletable_type";
    @SerializedName(value="from_walletable_type")
    private FromWalletableTypeEnum fromWalletableType;
    public static final String SERIALIZED_NAME_TO_WALLETABLE_ID = "to_walletable_id";
    @SerializedName(value="to_walletable_id")
    private Integer toWalletableId;
    public static final String SERIALIZED_NAME_TO_WALLETABLE_TYPE = "to_walletable_type";
    @SerializedName(value="to_walletable_type")
    private ToWalletableTypeEnum toWalletableType;

    public TransferParams amount(Integer amount) {
        this.amount = amount;
        return this;
    }

    @ApiModelProperty(example="5000", required=true, value="\u91d1\u984d")
    public Integer getAmount() {
        return this.amount;
    }

    public void setAmount(Integer amount) {
        this.amount = amount;
    }

    public TransferParams companyId(Integer companyId) {
        this.companyId = companyId;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="\u4e8b\u696d\u6240ID")
    public Integer getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(Integer companyId) {
        this.companyId = companyId;
    }

    public TransferParams date(String date) {
        this.date = date;
        return this;
    }

    @ApiModelProperty(example="2018-01-01", required=true, value="\u632f\u66ff\u65e5 (yyyy-mm-dd)")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public TransferParams description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u5099\u8003", value="\u5099\u8003")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public TransferParams fromWalletableId(Integer fromWalletableId) {
        this.fromWalletableId = fromWalletableId;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="\u632f\u66ff\u5143\u53e3\u5ea7ID")
    public Integer getFromWalletableId() {
        return this.fromWalletableId;
    }

    public void setFromWalletableId(Integer fromWalletableId) {
        this.fromWalletableId = fromWalletableId;
    }

    public TransferParams fromWalletableType(FromWalletableTypeEnum fromWalletableType) {
        this.fromWalletableType = fromWalletableType;
        return this;
    }

    @ApiModelProperty(example="credit_card", required=true, value="\u632f\u66ff\u5143\u53e3\u5ea7\u533a\u5206 (\u9280\u884c\u53e3\u5ea7: bank_account, \u30af\u30ec\u30b8\u30c3\u30c8\u30ab\u30fc\u30c9: credit_card, \u73fe\u91d1: wallet)")
    public FromWalletableTypeEnum getFromWalletableType() {
        return this.fromWalletableType;
    }

    public void setFromWalletableType(FromWalletableTypeEnum fromWalletableType) {
        this.fromWalletableType = fromWalletableType;
    }

    public TransferParams toWalletableId(Integer toWalletableId) {
        this.toWalletableId = toWalletableId;
        return this;
    }

    @ApiModelProperty(example="1", required=true, value="\u632f\u66ff\u5148\u53e3\u5ea7ID")
    public Integer getToWalletableId() {
        return this.toWalletableId;
    }

    public void setToWalletableId(Integer toWalletableId) {
        this.toWalletableId = toWalletableId;
    }

    public TransferParams toWalletableType(ToWalletableTypeEnum toWalletableType) {
        this.toWalletableType = toWalletableType;
        return this;
    }

    @ApiModelProperty(example="bank_account", required=true, value="\u632f\u66ff\u5148\u53e3\u5ea7\u533a\u5206 (\u9280\u884c\u53e3\u5ea7: bank_account, \u30af\u30ec\u30b8\u30c3\u30c8\u30ab\u30fc\u30c9: credit_card, \u73fe\u91d1: wallet)")
    public ToWalletableTypeEnum getToWalletableType() {
        return this.toWalletableType;
    }

    public void setToWalletableType(ToWalletableTypeEnum toWalletableType) {
        this.toWalletableType = toWalletableType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransferParams transferParams = (TransferParams)o;
        return Objects.equals(this.amount, transferParams.amount) && Objects.equals(this.companyId, transferParams.companyId) && Objects.equals(this.date, transferParams.date) && Objects.equals(this.description, transferParams.description) && Objects.equals(this.fromWalletableId, transferParams.fromWalletableId) && Objects.equals((Object)this.fromWalletableType, (Object)transferParams.fromWalletableType) && Objects.equals(this.toWalletableId, transferParams.toWalletableId) && Objects.equals((Object)this.toWalletableType, (Object)transferParams.toWalletableType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.companyId, this.date, this.description, this.fromWalletableId, this.fromWalletableType, this.toWalletableId, this.toWalletableType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransferParams {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    fromWalletableId: ").append(this.toIndentedString(this.fromWalletableId)).append("\n");
        sb.append("    fromWalletableType: ").append(this.toIndentedString((Object)this.fromWalletableType)).append("\n");
        sb.append("    toWalletableId: ").append(this.toIndentedString(this.toWalletableId)).append("\n");
        sb.append("    toWalletableType: ").append(this.toIndentedString((Object)this.toWalletableType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ToWalletableTypeEnum {
        BANK_ACCOUNT("bank_account"),
        CREDIT_CARD("credit_card"),
        WALLET("wallet");

        private String value;

        private ToWalletableTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ToWalletableTypeEnum fromValue(String value) {
            for (ToWalletableTypeEnum b : ToWalletableTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ToWalletableTypeEnum> {
            public void write(JsonWriter jsonWriter, ToWalletableTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ToWalletableTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ToWalletableTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum FromWalletableTypeEnum {
        BANK_ACCOUNT("bank_account"),
        CREDIT_CARD("credit_card"),
        WALLET("wallet");

        private String value;

        private FromWalletableTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static FromWalletableTypeEnum fromValue(String value) {
            for (FromWalletableTypeEnum b : FromWalletableTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<FromWalletableTypeEnum> {
            public void write(JsonWriter jsonWriter, FromWalletableTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public FromWalletableTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return FromWalletableTypeEnum.fromValue(value);
            }
        }
    }
}

