/*
 * Decompiled with CFR 0.152.
 */
package jp.co.freee.accounting;

import java.text.DateFormat;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import jp.co.freee.accounting.DefaultHeadersInterceptor;
import jp.co.freee.accounting.GsonCustomConverterFactory;
import jp.co.freee.accounting.JSON;
import jp.co.freee.accounting.auth.ApiKeyAuth;
import jp.co.freee.accounting.auth.HttpBasicAuth;
import jp.co.freee.accounting.auth.HttpBearerAuth;
import jp.co.freee.accounting.auth.OAuth;
import jp.co.freee.accounting.auth.OAuthFlow;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

public class ApiClient {
    private Map<String, Interceptor> apiAuthorizations = new LinkedHashMap<String, Interceptor>();
    private OkHttpClient.Builder okBuilder;
    private Retrofit.Builder adapterBuilder;
    private JSON json;
    private OkHttpClient okHttpClient;

    public ApiClient() {
        this.createDefaultAdapter();
        this.okBuilder = new OkHttpClient.Builder();
        DefaultHeadersInterceptor defaultHeaders = new DefaultHeadersInterceptor();
        this.okBuilder.addInterceptor((Interceptor)defaultHeaders);
    }

    public ApiClient(OkHttpClient client) {
        this.createDefaultAdapter();
        this.okHttpClient = client;
    }

    public ApiClient(String[] authNames) {
        this();
        for (String authName : authNames) {
            if (!"oauth2".equals(authName)) {
                throw new RuntimeException("auth name \"" + authName + "\" not found in available auth names");
            }
            OAuth auth = new OAuth(OAuthFlow.accessCode, "https://accounts.secure.freee.co.jp/public_api/authorize", "https://accounts.secure.freee.co.jp/public_api/token", "read, write");
            this.addAuthorization(authName, auth);
        }
    }

    public ApiClient(String authName) {
        this(new String[]{authName});
    }

    public ApiClient(String authName, String apiKey) {
        this(authName);
        this.setApiKey(apiKey);
    }

    public ApiClient(String authName, String username, String password) {
        this(authName);
        this.setCredentials(username, password);
    }

    public ApiClient(String authName, String clientId, String secret, String username, String password) {
        this(authName);
        this.getTokenEndPoint().setClientId(clientId).setClientSecret(secret).setUsername(username).setPassword(password);
    }

    public void createDefaultAdapter() {
        this.json = new JSON();
        String baseUrl = "https://api.freee.co.jp";
        if (!baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.adapterBuilder = new Retrofit.Builder().baseUrl(baseUrl).addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create()).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonCustomConverterFactory.create(this.json.getGson()));
    }

    public <S> S createService(Class<S> serviceClass) {
        if (this.okHttpClient != null) {
            return (S)this.adapterBuilder.client(this.okHttpClient).build().create(serviceClass);
        }
        return (S)this.adapterBuilder.client(this.okBuilder.build()).build().create(serviceClass);
    }

    public ApiClient setDateFormat(DateFormat dateFormat) {
        this.json.setDateFormat(dateFormat);
        return this;
    }

    public ApiClient setSqlDateFormat(DateFormat dateFormat) {
        this.json.setSqlDateFormat(dateFormat);
        return this;
    }

    public ApiClient setOffsetDateTimeFormat(DateTimeFormatter dateFormat) {
        this.json.setOffsetDateTimeFormat(dateFormat);
        return this;
    }

    public ApiClient setLocalDateFormat(DateTimeFormatter dateFormat) {
        this.json.setLocalDateFormat(dateFormat);
        return this;
    }

    public ApiClient setApiKey(String apiKey) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof ApiKeyAuth)) continue;
            ApiKeyAuth keyAuth = (ApiKeyAuth)apiAuthorization;
            keyAuth.setApiKey(apiKey);
            return this;
        }
        return this;
    }

    public ApiClient setBearerToken(String bearerToken) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof HttpBearerAuth)) continue;
            ((HttpBearerAuth)apiAuthorization).setBearerToken(bearerToken);
            return this;
        }
        return this;
    }

    public ApiClient setCredentials(String username, String password) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (apiAuthorization instanceof HttpBasicAuth) {
                HttpBasicAuth basicAuth = (HttpBasicAuth)apiAuthorization;
                basicAuth.setCredentials(username, password);
                return this;
            }
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.getTokenRequestBuilder().setUsername(username).setPassword(password);
            return this;
        }
        return this;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenEndPoint() {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            return oauth.getTokenRequestBuilder();
        }
        return null;
    }

    public OAuthClientRequest.AuthenticationRequestBuilder getAuthorizationEndPoint() {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            return oauth.getAuthenticationRequestBuilder();
        }
        return null;
    }

    public ApiClient setAccessToken(String accessToken) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.setAccessToken(accessToken);
            return this;
        }
        return this;
    }

    public ApiClient configureAuthorizationFlow(String clientId, String clientSecret, String redirectURI) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.getTokenRequestBuilder().setClientId(clientId).setClientSecret(clientSecret).setRedirectURI(redirectURI);
            oauth.getAuthenticationRequestBuilder().setClientId(clientId).setRedirectURI(redirectURI);
            return this;
        }
        return this;
    }

    public ApiClient registerAccessTokenListener(OAuth.AccessTokenListener accessTokenListener) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            if (!(apiAuthorization instanceof OAuth)) continue;
            OAuth oauth = (OAuth)apiAuthorization;
            oauth.registerAccessTokenListener(accessTokenListener);
            return this;
        }
        return this;
    }

    public ApiClient addAuthorization(String authName, Interceptor authorization) {
        if (this.apiAuthorizations.containsKey(authName)) {
            throw new RuntimeException("auth name \"" + authName + "\" already in api authorizations");
        }
        this.apiAuthorizations.put(authName, authorization);
        if (this.okBuilder == null) {
            throw new RuntimeException("The ApiClient was created with a built OkHttpClient so it's not possible to add an authorization interceptor to it");
        }
        this.okBuilder.addInterceptor(authorization);
        return this;
    }

    public Map<String, Interceptor> getApiAuthorizations() {
        return this.apiAuthorizations;
    }

    public ApiClient setApiAuthorizations(Map<String, Interceptor> apiAuthorizations) {
        this.apiAuthorizations = apiAuthorizations;
        return this;
    }

    public Retrofit.Builder getAdapterBuilder() {
        return this.adapterBuilder;
    }

    public ApiClient setAdapterBuilder(Retrofit.Builder adapterBuilder) {
        this.adapterBuilder = adapterBuilder;
        return this;
    }

    public OkHttpClient.Builder getOkBuilder() {
        return this.okBuilder;
    }

    public void addAuthsToOkBuilder(OkHttpClient.Builder okBuilder) {
        for (Interceptor apiAuthorization : this.apiAuthorizations.values()) {
            okBuilder.addInterceptor(apiAuthorization);
        }
    }

    public void configureFromOkclient(OkHttpClient okClient) {
        this.okBuilder = okClient.newBuilder();
        this.addAuthsToOkBuilder(this.okBuilder);
    }
}

