/*
 * Decompiled with CFR 0.152.
 */
package jp.co.freee.accounting.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.jackson.nullable.JsonNullable;

public class Bank {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Integer id;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_NAME_KANA = "name_kana";
    @SerializedName(value="name_kana")
    private String nameKana;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    private TypeEnum type;

    public Bank id(Integer id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="\u9023\u643a\u30b5\u30fc\u30d3\u30b9ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Bank name(String name) {
        this.name = name;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u30d5\u30ea\u30fc\u9280\u884c", value="\u9023\u643a\u30b5\u30fc\u30d3\u30b9\u540d")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Bank nameKana(String nameKana) {
        this.nameKana = nameKana;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u30d5\u30ea\u30fc\u30ae\u30f3\u30b3\u30a6", value="\u9023\u643a\u30b5\u30fc\u30d3\u30b9\u540d(\u30ab\u30ca)")
    public String getNameKana() {
        return this.nameKana;
    }

    public void setNameKana(String nameKana) {
        this.nameKana = nameKana;
    }

    public Bank type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="bank_account", value="\u9023\u643a\u30b5\u30fc\u30d3\u30b9\u7a2e\u5225: (\u9280\u884c\u53e3\u5ea7: bank_account, \u30af\u30ec\u30b8\u30c3\u30c8\u30ab\u30fc\u30c9: credit_card, \u73fe\u91d1: wallet)")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bank bank = (Bank)o;
        return Objects.equals(this.id, bank.id) && Objects.equals(this.name, bank.name) && Objects.equals(this.nameKana, bank.nameKana) && Objects.equals((Object)this.type, (Object)bank.type);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.name, this.nameKana, this.type});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Bank {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    nameKana: ").append(this.toIndentedString(this.nameKana)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        BANK_ACCOUNT("bank_account"),
        CREDIT_CARD("credit_card"),
        WALLET("wallet");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String value) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

