/*
 * Decompiled with CFR 0.152.
 */
package jp.co.freee.accounting.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public class CompaniesPlanResponse {
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Integer id;
    public static final String SERIALIZED_NAME_ORG_CODE = "org_code";
    @SerializedName(value="org_code")
    private OrgCodeEnum orgCode;
    public static final String SERIALIZED_NAME_PLAN = "plan";
    @SerializedName(value="plan")
    private PlanEnum plan;

    public CompaniesPlanResponse id(Integer id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="\u4e8b\u696d\u6240ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public CompaniesPlanResponse orgCode(OrgCodeEnum orgCode) {
        this.orgCode = orgCode;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="personal", required=true, value="\u4e8b\u696d\u5f62\u614b\uff08\u500b\u4eba\u4e8b\u696d\u4e3b: personal\u3001\u6cd5\u4eba: corporate\uff09")
    public OrgCodeEnum getOrgCode() {
        return this.orgCode;
    }

    public void setOrgCode(OrgCodeEnum orgCode) {
        this.orgCode = orgCode;
    }

    public CompaniesPlanResponse plan(PlanEnum plan) {
        this.plan = plan;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="basic", required=true, value="\u4f1a\u8a08\u30d7\u30e9\u30f3 \u500b\u4eba\u7528(non_charged: \u7121\u6599\u30d7\u30e9\u30f3\u3001starter: \u30b9\u30bf\u30fc\u30bf\u30fc\u3001standard: \u30b9\u30bf\u30f3\u30c0\u30fc\u30c9\u3001premium: \u30d7\u30ec\u30df\u30a2\u30e0) \u6cd5\u4eba\u7528(non_charged: \u7121\u6599\u30d7\u30e9\u30f3\u3001minimum: \u30df\u30cb\u30de\u30e0\u3001basic: \u30d9\u30fc\u30b7\u30c3\u30af\u3001professional: \u30d7\u30ed\u30d5\u30a7\u30c3\u30b7\u30e7\u30ca\u30eb\u3001enterprise: \u30a8\u30f3\u30bf\u30fc\u30d7\u30e9\u30a4\u30ba)")
    public PlanEnum getPlan() {
        return this.plan;
    }

    public void setPlan(PlanEnum plan) {
        this.plan = plan;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompaniesPlanResponse companiesPlanResponse = (CompaniesPlanResponse)o;
        return Objects.equals(this.id, companiesPlanResponse.id) && Objects.equals((Object)this.orgCode, (Object)companiesPlanResponse.orgCode) && Objects.equals((Object)this.plan, (Object)companiesPlanResponse.plan);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.orgCode, this.plan});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CompaniesPlanResponse {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    orgCode: ").append(this.toIndentedString((Object)this.orgCode)).append("\n");
        sb.append("    plan: ").append(this.toIndentedString((Object)this.plan)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PlanEnum {
        NON_CHARGED("non_charged"),
        STARTER("starter"),
        STANDARD("standard"),
        PREMIUM("premium"),
        MINIMUM("minimum"),
        BASIC("basic"),
        PROFESSIONAL("professional"),
        ENTERPRISE("enterprise");

        private String value;

        private PlanEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PlanEnum fromValue(String value) {
            for (PlanEnum b : PlanEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<PlanEnum> {
            public void write(JsonWriter jsonWriter, PlanEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PlanEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PlanEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OrgCodeEnum {
        PERSONAL("personal"),
        CORPORATE("corporate");

        private String value;

        private OrgCodeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OrgCodeEnum fromValue(String value) {
            for (OrgCodeEnum b : OrgCodeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OrgCodeEnum> {
            public void write(JsonWriter jsonWriter, OrgCodeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OrgCodeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OrgCodeEnum.fromValue(value);
            }
        }
    }
}

