/*
 * Decompiled with CFR 0.152.
 */
package jp.co.freee.accounting.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import jp.co.freee.accounting.models.DealReceiptMetadatum;
import jp.co.freee.accounting.models.DealUser;
import org.openapitools.jackson.nullable.JsonNullable;

public class Receipt {
    public static final String SERIALIZED_NAME_CREATED_AT = "created_at";
    @SerializedName(value="created_at")
    private String createdAt;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_DOCUMENT_TYPE = "document_type";
    @SerializedName(value="document_type")
    private DocumentTypeEnum documentType;
    public static final String SERIALIZED_NAME_FILE_SRC = "file_src";
    @SerializedName(value="file_src")
    private String fileSrc;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private Integer id;
    public static final String SERIALIZED_NAME_INVOICE_REGISTRATION_NUMBER = "invoice_registration_number";
    @SerializedName(value="invoice_registration_number")
    private String invoiceRegistrationNumber;
    public static final String SERIALIZED_NAME_ISSUE_DATE = "issue_date";
    @SerializedName(value="issue_date")
    private String issueDate;
    public static final String SERIALIZED_NAME_MIME_TYPE = "mime_type";
    @SerializedName(value="mime_type")
    private String mimeType;
    public static final String SERIALIZED_NAME_ORIGIN = "origin";
    @SerializedName(value="origin")
    private OriginEnum origin;
    public static final String SERIALIZED_NAME_QUALIFIED_INVOICE = "qualified_invoice";
    @SerializedName(value="qualified_invoice")
    private QualifiedInvoiceEnum qualifiedInvoice;
    public static final String SERIALIZED_NAME_RECEIPT_METADATUM = "receipt_metadatum";
    @SerializedName(value="receipt_metadatum")
    private DealReceiptMetadatum receiptMetadatum;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private StatusEnum status;
    public static final String SERIALIZED_NAME_USER = "user";
    @SerializedName(value="user")
    private DealUser user;

    public Receipt createdAt(String createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2019-12-17T18:30:24+09:00", required=true, value="\u4f5c\u6210\u65e5\u6642\uff08ISO8601\u5f62\u5f0f\uff09")
    public String getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(String createdAt) {
        this.createdAt = createdAt;
    }

    public Receipt description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u30bf\u30af\u30b7\u30fc\u5229\u7528", value="\u30e1\u30e2")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Receipt documentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="receipt", value="\u3053\u306e\u9805\u76ee\u306f\u30a4\u30f3\u30dc\u30a4\u30b9\u5236\u5ea6\u3067\u5229\u7528\u3059\u308b\u9805\u76ee\u3067\u3059\u30022023\u5e744\u6708\u9803\u304b\u3089\u5229\u7528\u3067\u304d\u308b\u4e88\u5b9a\u3067\u3059\u3002 \u66f8\u985e\u306e\u7a2e\u985e\uff08receipt: \u9818\u53ce\u66f8\u3001invoice: \u8acb\u6c42\u66f8\u3001other: \u305d\u306e\u4ed6\u3001null: OCR\u89e3\u6790\u7d50\u679c\u304c\u4fdd\u5b58\u3055\u308c\u3066\u3044\u308b\u6642\u7b49\uff09 ")
    public DocumentTypeEnum getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(DocumentTypeEnum documentType) {
        this.documentType = documentType;
    }

    public Receipt fileSrc(String fileSrc) {
        this.fileSrc = fileSrc;
        return this;
    }

    @Deprecated
    @Nonnull
    @ApiModelProperty(example="https://www.freee.co.jp/api/p/receipts/revisions/1234xxxxx/download", required=true, value="\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9URL\uff08freee\u306b\u30ed\u30b0\u30a4\u30f3\u3057\u305f\u72b6\u614b\u3067\u306e\u307f\u95b2\u89a7\u53ef\u80fd\u3067\u3059\u3002\uff09 <br> <br> file_src\u306f\u5ec3\u6b62\u4e88\u5b9a\u306e\u5c5e\u6027\u306b\u306a\u308a\u307e\u3059\u3002<br> file_src\u306b\u66ff\u308f\u308a\u3001\u8a3c\u6191\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9 API\u3092\u3054\u5229\u7528\u304f\u3060\u3055\u3044\u3002<br> \u8a3c\u6191\u30d5\u30a1\u30a4\u30eb\u306e\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9API\u3092\u5229\u7528\u3059\u308b\u3053\u3068\u3067\u3001\u4ee5\u4e0b\u306e\u3088\u3046\u306b\u306a\u308a\u307e\u3059\u3002 <ul>   <li>\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u5229\u7528\u8005\u306ffreee API\u30a2\u30d7\u30ea\u30b1\u30fc\u30b7\u30e7\u30f3\u306b\u30ed\u30b0\u30a4\u30f3\u3057\u3066\u3044\u308c\u3070\u3001\u8a3c\u6191\u30c0\u30a6\u30f3\u30ed\u30fc\u30c9\u6bce\u306bfreee\u306b\u6539\u3081\u3066\u30ed\u30b0\u30a4\u30f3\u3059\u308b\u3053\u3068\u306a\u304f\u30d5\u30a1\u30a4\u30eb\u304c\u53c2\u7167\u3067\u304d\u308b\u3088\u3046\u306b\u306a\u308a\u307e\u3059\u3002</li> </ul>")
    public String getFileSrc() {
        return this.fileSrc;
    }

    public void setFileSrc(String fileSrc) {
        this.fileSrc = fileSrc;
    }

    public Receipt id(Integer id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="\u30d5\u30a1\u30a4\u30eb\u30dc\u30c3\u30af\u30b9\uff08\u8a3c\u6191\u30d5\u30a1\u30a4\u30eb\uff09ID")
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public Receipt invoiceRegistrationNumber(String invoiceRegistrationNumber) {
        this.invoiceRegistrationNumber = invoiceRegistrationNumber;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="T1000000000001", value="\u3053\u306e\u9805\u76ee\u306f\u30a4\u30f3\u30dc\u30a4\u30b9\u5236\u5ea6\u3067\u5229\u7528\u3059\u308b\u9805\u76ee\u3067\u3059\u30022023\u5e744\u6708\u9803\u304b\u3089\u5229\u7528\u3067\u304d\u308b\u4e88\u5b9a\u3067\u3059\u3002 \u30a4\u30f3\u30dc\u30a4\u30b9\u5236\u5ea6\u9069\u683c\u8acb\u6c42\u66f8\u767a\u884c\u4e8b\u696d\u8005\u767b\u9332\u756a\u53f7\uff08null: OCR\u89e3\u6790\u7d50\u679c\u304c\u4fdd\u5b58\u3055\u308c\u3066\u3044\u308b\u6642\u7b49\uff09 - \u5148\u982dT\u6570\u5b5713\u6841\u306e\u56fa\u5b9a14\u6841\u306e\u6587\u5b57\u5217 <a target=\"_blank\" href=\"https://www.invoice-kohyo.nta.go.jp/index.html\">\u56fd\u7a0e\u5e81\u30a4\u30f3\u30dc\u30a4\u30b9\u5236\u5ea6\u9069\u683c\u8acb\u6c42\u66f8\u767a\u884c\u4e8b\u696d\u8005\u516c\u8868\u30b5\u30a4\u30c8</a> ")
    public String getInvoiceRegistrationNumber() {
        return this.invoiceRegistrationNumber;
    }

    public void setInvoiceRegistrationNumber(String invoiceRegistrationNumber) {
        this.invoiceRegistrationNumber = invoiceRegistrationNumber;
    }

    public Receipt issueDate(String issueDate) {
        this.issueDate = issueDate;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="2019-12-17", value="\u767a\u751f\u65e5")
    public String getIssueDate() {
        return this.issueDate;
    }

    public void setIssueDate(String issueDate) {
        this.issueDate = issueDate;
    }

    public Receipt mimeType(String mimeType) {
        this.mimeType = mimeType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="image/png", required=true, value="MIME\u30bf\u30a4\u30d7")
    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public Receipt origin(OriginEnum origin) {
        this.origin = origin;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="public_api", required=true, value="\u30a2\u30c3\u30d7\u30ed\u30fc\u30c9\u5143\u7a2e\u5225")
    public OriginEnum getOrigin() {
        return this.origin;
    }

    public void setOrigin(OriginEnum origin) {
        this.origin = origin;
    }

    public Receipt qualifiedInvoice(QualifiedInvoiceEnum qualifiedInvoice) {
        this.qualifiedInvoice = qualifiedInvoice;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="qualified", value="\u3053\u306e\u9805\u76ee\u306f\u30a4\u30f3\u30dc\u30a4\u30b9\u5236\u5ea6\u3067\u5229\u7528\u3059\u308b\u9805\u76ee\u3067\u3059\u30022023\u5e744\u6708\u9803\u304b\u3089\u5229\u7528\u3067\u304d\u308b\u4e88\u5b9a\u3067\u3059\u3002 \u9069\u683c\u8acb\u6c42\u66f8\u7b49\uff08qualified: \u8a72\u5f53\u3059\u308b\u3001not_qualified: \u8a72\u5f53\u3057\u306a\u3044\u3001unselected: \u672a\u9078\u629e\u3001null: OCR\u89e3\u6790\u7d50\u679c\u304c\u4fdd\u5b58\u3055\u308c\u3066\u3044\u308b\u6642\u7b49\uff09 ")
    public QualifiedInvoiceEnum getQualifiedInvoice() {
        return this.qualifiedInvoice;
    }

    public void setQualifiedInvoice(QualifiedInvoiceEnum qualifiedInvoice) {
        this.qualifiedInvoice = qualifiedInvoice;
    }

    public Receipt receiptMetadatum(DealReceiptMetadatum receiptMetadatum) {
        this.receiptMetadatum = receiptMetadatum;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public DealReceiptMetadatum getReceiptMetadatum() {
        return this.receiptMetadatum;
    }

    public void setReceiptMetadatum(DealReceiptMetadatum receiptMetadatum) {
        this.receiptMetadatum = receiptMetadatum;
    }

    public Receipt status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="confirmed", required=true, value="\u30b9\u30c6\u30fc\u30bf\u30b9(confirmed:\u78ba\u8a8d\u6e08\u307f\u3001deleted:\u524a\u9664\u6e08\u307f\u3001ignored:\u7121\u8996)")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public Receipt user(DealUser user) {
        this.user = user;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public DealUser getUser() {
        return this.user;
    }

    public void setUser(DealUser user) {
        this.user = user;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Receipt receipt = (Receipt)o;
        return Objects.equals(this.createdAt, receipt.createdAt) && Objects.equals(this.description, receipt.description) && Objects.equals((Object)this.documentType, (Object)receipt.documentType) && Objects.equals(this.fileSrc, receipt.fileSrc) && Objects.equals(this.id, receipt.id) && Objects.equals(this.invoiceRegistrationNumber, receipt.invoiceRegistrationNumber) && Objects.equals(this.issueDate, receipt.issueDate) && Objects.equals(this.mimeType, receipt.mimeType) && Objects.equals((Object)this.origin, (Object)receipt.origin) && Objects.equals((Object)this.qualifiedInvoice, (Object)receipt.qualifiedInvoice) && Objects.equals(this.receiptMetadatum, receipt.receiptMetadatum) && Objects.equals((Object)this.status, (Object)receipt.status) && Objects.equals(this.user, receipt.user);
    }

    private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
        return a == b || a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.createdAt, this.description, this.documentType, this.fileSrc, this.id, this.invoiceRegistrationNumber, this.issueDate, this.mimeType, this.origin, this.qualifiedInvoice, this.receiptMetadatum, this.status, this.user});
    }

    private static <T> int hashCodeNullable(JsonNullable<T> a) {
        if (a == null) {
            return 1;
        }
        return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Receipt {\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    documentType: ").append(this.toIndentedString((Object)this.documentType)).append("\n");
        sb.append("    fileSrc: ").append(this.toIndentedString(this.fileSrc)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    invoiceRegistrationNumber: ").append(this.toIndentedString(this.invoiceRegistrationNumber)).append("\n");
        sb.append("    issueDate: ").append(this.toIndentedString(this.issueDate)).append("\n");
        sb.append("    mimeType: ").append(this.toIndentedString(this.mimeType)).append("\n");
        sb.append("    origin: ").append(this.toIndentedString((Object)this.origin)).append("\n");
        sb.append("    qualifiedInvoice: ").append(this.toIndentedString((Object)this.qualifiedInvoice)).append("\n");
        sb.append("    receiptMetadatum: ").append(this.toIndentedString(this.receiptMetadatum)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    user: ").append(this.toIndentedString(this.user)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        CONFIRMED("confirmed"),
        DELETED("deleted"),
        IGNORED("ignored");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum QualifiedInvoiceEnum {
        QUALIFIED("qualified"),
        NOT_QUALIFIED("not_qualified"),
        UNSELECTED("unselected");

        private String value;

        private QualifiedInvoiceEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static QualifiedInvoiceEnum fromValue(String value) {
            for (QualifiedInvoiceEnum b : QualifiedInvoiceEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<QualifiedInvoiceEnum> {
            public void write(JsonWriter jsonWriter, QualifiedInvoiceEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public QualifiedInvoiceEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return QualifiedInvoiceEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OriginEnum {
        UNKNOWN("unknown"),
        WEB("web"),
        MOBILE_CAMERA("mobile_camera"),
        MOBILE_ALBUM("mobile_album"),
        SCANSNAP("scansnap"),
        SCANNABLE("scannable"),
        DROPBOX("dropbox"),
        MAIL("mail"),
        SAFETY_CONTACT_FILE("safety_contact_file"),
        PUBLIC_API("public_api");

        private String value;

        private OriginEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OriginEnum fromValue(String value) {
            for (OriginEnum b : OriginEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<OriginEnum> {
            public void write(JsonWriter jsonWriter, OriginEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public OriginEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OriginEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DocumentTypeEnum {
        RECEIPT("receipt"),
        INVOICE("invoice"),
        OTHER("other");

        private String value;

        private DocumentTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DocumentTypeEnum fromValue(String value) {
            for (DocumentTypeEnum b : DocumentTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DocumentTypeEnum> {
            public void write(JsonWriter jsonWriter, DocumentTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public DocumentTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DocumentTypeEnum.fromValue(value);
            }
        }
    }
}

