/*
 * Decompiled with CFR 0.152.
 */
package jp.co.freee.accounting.models;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class WalletTxnParams {
    public static final String SERIALIZED_NAME_AMOUNT = "amount";
    @SerializedName(value="amount")
    private Long amount;
    public static final String SERIALIZED_NAME_BALANCE = "balance";
    @SerializedName(value="balance")
    private Long balance;
    public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
    @SerializedName(value="company_id")
    private Integer companyId;
    public static final String SERIALIZED_NAME_DATE = "date";
    @SerializedName(value="date")
    private String date;
    public static final String SERIALIZED_NAME_DESCRIPTION = "description";
    @SerializedName(value="description")
    private String description;
    public static final String SERIALIZED_NAME_ENTRY_SIDE = "entry_side";
    @SerializedName(value="entry_side")
    private EntrySideEnum entrySide;
    public static final String SERIALIZED_NAME_WALLETABLE_ID = "walletable_id";
    @SerializedName(value="walletable_id")
    private Integer walletableId;
    public static final String SERIALIZED_NAME_WALLETABLE_TYPE = "walletable_type";
    @SerializedName(value="walletable_type")
    private WalletableTypeEnum walletableType;

    public WalletTxnParams amount(Long amount) {
        this.amount = amount;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="5000", required=true, value="\u53d6\u5f15\u91d1\u984d")
    public Long getAmount() {
        return this.amount;
    }

    public void setAmount(Long amount) {
        this.amount = amount;
    }

    public WalletTxnParams balance(Long balance) {
        this.balance = balance;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="10000", value="\u6b8b\u9ad8 (\u9280\u884c\u53e3\u5ea7\u7b49)")
    public Long getBalance() {
        return this.balance;
    }

    public void setBalance(Long balance) {
        this.balance = balance;
    }

    public WalletTxnParams companyId(Integer companyId) {
        this.companyId = companyId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="\u4e8b\u696d\u6240ID")
    public Integer getCompanyId() {
        return this.companyId;
    }

    public void setCompanyId(Integer companyId) {
        this.companyId = companyId;
    }

    public WalletTxnParams date(String date) {
        this.date = date;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="2019-12-17", required=true, value="\u53d6\u5f15\u65e5 (yyyy-mm-dd)")
    public String getDate() {
        return this.date;
    }

    public void setDate(String date) {
        this.date = date;
    }

    public WalletTxnParams description(String description) {
        this.description = description;
        return this;
    }

    @Nullable
    @ApiModelProperty(example="\u53d6\u5f15\u5185\u5bb9", value="\u53d6\u5f15\u5185\u5bb9")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public WalletTxnParams entrySide(EntrySideEnum entrySide) {
        this.entrySide = entrySide;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="income", required=true, value="\u5165\u91d1\uff0f\u51fa\u91d1 (\u5165\u91d1: income, \u51fa\u91d1: expense)")
    public EntrySideEnum getEntrySide() {
        return this.entrySide;
    }

    public void setEntrySide(EntrySideEnum entrySide) {
        this.entrySide = entrySide;
    }

    public WalletTxnParams walletableId(Integer walletableId) {
        this.walletableId = walletableId;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1", required=true, value="\u53e3\u5ea7ID")
    public Integer getWalletableId() {
        return this.walletableId;
    }

    public void setWalletableId(Integer walletableId) {
        this.walletableId = walletableId;
    }

    public WalletTxnParams walletableType(WalletableTypeEnum walletableType) {
        this.walletableType = walletableType;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="bank_account", required=true, value="\u53e3\u5ea7\u533a\u5206 (\u9280\u884c\u53e3\u5ea7: bank_account, \u30af\u30ec\u30b8\u30c3\u30c8\u30ab\u30fc\u30c9: credit_card, \u73fe\u91d1: wallet)")
    public WalletableTypeEnum getWalletableType() {
        return this.walletableType;
    }

    public void setWalletableType(WalletableTypeEnum walletableType) {
        this.walletableType = walletableType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WalletTxnParams walletTxnParams = (WalletTxnParams)o;
        return Objects.equals(this.amount, walletTxnParams.amount) && Objects.equals(this.balance, walletTxnParams.balance) && Objects.equals(this.companyId, walletTxnParams.companyId) && Objects.equals(this.date, walletTxnParams.date) && Objects.equals(this.description, walletTxnParams.description) && Objects.equals((Object)this.entrySide, (Object)walletTxnParams.entrySide) && Objects.equals(this.walletableId, walletTxnParams.walletableId) && Objects.equals((Object)this.walletableType, (Object)walletTxnParams.walletableType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.amount, this.balance, this.companyId, this.date, this.description, this.entrySide, this.walletableId, this.walletableType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WalletTxnParams {\n");
        sb.append("    amount: ").append(this.toIndentedString(this.amount)).append("\n");
        sb.append("    balance: ").append(this.toIndentedString(this.balance)).append("\n");
        sb.append("    companyId: ").append(this.toIndentedString(this.companyId)).append("\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    entrySide: ").append(this.toIndentedString((Object)this.entrySide)).append("\n");
        sb.append("    walletableId: ").append(this.toIndentedString(this.walletableId)).append("\n");
        sb.append("    walletableType: ").append(this.toIndentedString((Object)this.walletableType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum WalletableTypeEnum {
        BANK_ACCOUNT("bank_account"),
        CREDIT_CARD("credit_card"),
        WALLET("wallet");

        private String value;

        private WalletableTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static WalletableTypeEnum fromValue(String value) {
            for (WalletableTypeEnum b : WalletableTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<WalletableTypeEnum> {
            public void write(JsonWriter jsonWriter, WalletableTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public WalletableTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return WalletableTypeEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EntrySideEnum {
        INCOME("income"),
        EXPENSE("expense");

        private String value;

        private EntrySideEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EntrySideEnum fromValue(String value) {
            for (EntrySideEnum b : EntrySideEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<EntrySideEnum> {
            public void write(JsonWriter jsonWriter, EntrySideEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EntrySideEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EntrySideEnum.fromValue(value);
            }
        }
    }
}

