/*
 * freee API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * WalletableCreateParams
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class WalletableCreateParams {
  public static final String SERIALIZED_NAME_BANK_ID = "bank_id";
  @SerializedName(SERIALIZED_NAME_BANK_ID)
  private Integer bankId;

  public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
  @SerializedName(SERIALIZED_NAME_COMPANY_ID)
  private Integer companyId;

  public static final String SERIALIZED_NAME_IS_ASSET = "is_asset";
  @SerializedName(SERIALIZED_NAME_IS_ASSET)
  private Boolean isAsset;

  public static final String SERIALIZED_NAME_NAME = "name";
  @SerializedName(SERIALIZED_NAME_NAME)
  private String name;

  /**
   * 口座種別（bank_account : 銀行口座, credit_card : クレジットカード, wallet : その他の決済口座）
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    BANK_ACCOUNT("bank_account"),
    
    CREDIT_CARD("credit_card"),
    
    WALLET("wallet");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String value) {
      for (TypeEnum b : TypeEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return TypeEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_TYPE = "type";
  @SerializedName(SERIALIZED_NAME_TYPE)
  private TypeEnum type;

  public WalletableCreateParams() { 
  }

  public WalletableCreateParams bankId(Integer bankId) {
    
    this.bankId = bankId;
    return this;
  }

   /**
   * 連携サービスID（typeにbank_account、credit_cardを指定する場合は必須）
   * minimum: 1
   * maximum: 2147483647
   * @return bankId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "連携サービスID（typeにbank_account、credit_cardを指定する場合は必須）")

  public Integer getBankId() {
    return bankId;
  }


  public void setBankId(Integer bankId) {
    this.bankId = bankId;
  }


  public WalletableCreateParams companyId(Integer companyId) {
    
    this.companyId = companyId;
    return this;
  }

   /**
   * 事業所ID
   * minimum: 1
   * maximum: 2147483647
   * @return companyId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "1", required = true, value = "事業所ID")

  public Integer getCompanyId() {
    return companyId;
  }


  public void setCompanyId(Integer companyId) {
    this.companyId = companyId;
  }


  public WalletableCreateParams isAsset(Boolean isAsset) {
    
    this.isAsset = isAsset;
    return this;
  }

   /**
   * 口座を資産口座とするか負債口座とするか（true: 資産口座 (デフォルト), false: 負債口座）&lt;br&gt; bank_idを指定しない場合にのみ使われます。&lt;br&gt; bank_idを指定する場合には資産口座か負債口座かはbank_idに指定したサービスに応じて決定され、is_assetに指定した値は無視されます。 
   * @return isAsset
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "true", value = "口座を資産口座とするか負債口座とするか（true: 資産口座 (デフォルト), false: 負債口座）<br> bank_idを指定しない場合にのみ使われます。<br> bank_idを指定する場合には資産口座か負債口座かはbank_idに指定したサービスに応じて決定され、is_assetに指定した値は無視されます。 ")

  public Boolean getIsAsset() {
    return isAsset;
  }


  public void setIsAsset(Boolean isAsset) {
    this.isAsset = isAsset;
  }


  public WalletableCreateParams name(String name) {
    
    this.name = name;
    return this;
  }

   /**
   * 口座名 (255文字以内)
   * @return name
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "ＸＸ銀行", required = true, value = "口座名 (255文字以内)")

  public String getName() {
    return name;
  }


  public void setName(String name) {
    this.name = name;
  }


  public WalletableCreateParams type(TypeEnum type) {
    
    this.type = type;
    return this;
  }

   /**
   * 口座種別（bank_account : 銀行口座, credit_card : クレジットカード, wallet : その他の決済口座）
   * @return type
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "bank_account", required = true, value = "口座種別（bank_account : 銀行口座, credit_card : クレジットカード, wallet : その他の決済口座）")

  public TypeEnum getType() {
    return type;
  }


  public void setType(TypeEnum type) {
    this.type = type;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    WalletableCreateParams walletableCreateParams = (WalletableCreateParams) o;
    return Objects.equals(this.bankId, walletableCreateParams.bankId) &&
        Objects.equals(this.companyId, walletableCreateParams.companyId) &&
        Objects.equals(this.isAsset, walletableCreateParams.isAsset) &&
        Objects.equals(this.name, walletableCreateParams.name) &&
        Objects.equals(this.type, walletableCreateParams.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(bankId, companyId, isAsset, name, type);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class WalletableCreateParams {\n");
    sb.append("    bankId: ").append(toIndentedString(bankId)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    isAsset: ").append(toIndentedString(isAsset)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

