/*
 * freee API
 * No description provided (generated by Openapi Generator https://github.com/openapitools/openapi-generator)
 *
 * The version of the OpenAPI document: v1.0
 * 
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package jp.co.freee.accounting.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import jp.co.freee.accounting.models.ApprovalRequestResponseApprovalRequestApprovers;
import org.openapitools.jackson.nullable.JsonNullable;

/**
 * PaymentRequestsIndexResponsePaymentRequests
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen")
public class PaymentRequestsIndexResponsePaymentRequests {
  public static final String SERIALIZED_NAME_APPLICANT_ID = "applicant_id";
  @SerializedName(SERIALIZED_NAME_APPLICANT_ID)
  private Integer applicantId;

  public static final String SERIALIZED_NAME_APPLICATION_DATE = "application_date";
  @SerializedName(SERIALIZED_NAME_APPLICATION_DATE)
  private String applicationDate;

  public static final String SERIALIZED_NAME_APPLICATION_NUMBER = "application_number";
  @SerializedName(SERIALIZED_NAME_APPLICATION_NUMBER)
  private String applicationNumber;

  public static final String SERIALIZED_NAME_APPROVERS = "approvers";
  @SerializedName(SERIALIZED_NAME_APPROVERS)
  private List<ApprovalRequestResponseApprovalRequestApprovers> approvers = new ArrayList<>();

  public static final String SERIALIZED_NAME_COMPANY_ID = "company_id";
  @SerializedName(SERIALIZED_NAME_COMPANY_ID)
  private Integer companyId;

  public static final String SERIALIZED_NAME_CURRENT_ROUND = "current_round";
  @SerializedName(SERIALIZED_NAME_CURRENT_ROUND)
  private Integer currentRound;

  public static final String SERIALIZED_NAME_CURRENT_STEP_ID = "current_step_id";
  @SerializedName(SERIALIZED_NAME_CURRENT_STEP_ID)
  private Integer currentStepId;

  public static final String SERIALIZED_NAME_DEAL_ID = "deal_id";
  @SerializedName(SERIALIZED_NAME_DEAL_ID)
  private Integer dealId;

  /**
   * 取引ステータス (申請ステータス:statusがapprovedで、取引が存在する時のみdeal_statusが表示されます settled:支払済み, unsettled:支払待ち)
   */
  @JsonAdapter(DealStatusEnum.Adapter.class)
  public enum DealStatusEnum {
    SETTLED("settled"),
    
    UNSETTLED("unsettled");

    private String value;

    DealStatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static DealStatusEnum fromValue(String value) {
      for (DealStatusEnum b : DealStatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<DealStatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final DealStatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public DealStatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return DealStatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_DEAL_STATUS = "deal_status";
  @SerializedName(SERIALIZED_NAME_DEAL_STATUS)
  private DealStatusEnum dealStatus;

  public static final String SERIALIZED_NAME_DOCUMENT_CODE = "document_code";
  @SerializedName(SERIALIZED_NAME_DOCUMENT_CODE)
  private String documentCode;

  public static final String SERIALIZED_NAME_ID = "id";
  @SerializedName(SERIALIZED_NAME_ID)
  private Integer id;

  public static final String SERIALIZED_NAME_ISSUE_DATE = "issue_date";
  @SerializedName(SERIALIZED_NAME_ISSUE_DATE)
  private String issueDate;

  public static final String SERIALIZED_NAME_PARTNER_CODE = "partner_code";
  @SerializedName(SERIALIZED_NAME_PARTNER_CODE)
  private String partnerCode;

  public static final String SERIALIZED_NAME_PARTNER_ID = "partner_id";
  @SerializedName(SERIALIZED_NAME_PARTNER_ID)
  private Integer partnerId;

  public static final String SERIALIZED_NAME_PARTNER_NAME = "partner_name";
  @SerializedName(SERIALIZED_NAME_PARTNER_NAME)
  private String partnerName;

  public static final String SERIALIZED_NAME_PAYMENT_DATE = "payment_date";
  @SerializedName(SERIALIZED_NAME_PAYMENT_DATE)
  private String paymentDate;

  /**
   * 支払方法(none: 指定なし, domestic_bank_transfer: 国内振込, abroad_bank_transfer: 国外振込, account_transfer: 口座振替, credit_card: クレジットカード)
   */
  @JsonAdapter(PaymentMethodEnum.Adapter.class)
  public enum PaymentMethodEnum {
    NONE("none"),
    
    DOMESTIC_BANK_TRANSFER("domestic_bank_transfer"),
    
    ABROAD_BANK_TRANSFER("abroad_bank_transfer"),
    
    ACCOUNT_TRANSFER("account_transfer"),
    
    CREDIT_CARD("credit_card");

    private String value;

    PaymentMethodEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static PaymentMethodEnum fromValue(String value) {
      for (PaymentMethodEnum b : PaymentMethodEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<PaymentMethodEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final PaymentMethodEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public PaymentMethodEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return PaymentMethodEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_PAYMENT_METHOD = "payment_method";
  @SerializedName(SERIALIZED_NAME_PAYMENT_METHOD)
  private PaymentMethodEnum paymentMethod;

  /**
   * 申請ステータス(draft:下書き, in_progress:申請中, approved:承認済, rejected:却下, feedback:差戻し)
   */
  @JsonAdapter(StatusEnum.Adapter.class)
  public enum StatusEnum {
    DRAFT("draft"),
    
    IN_PROGRESS("in_progress"),
    
    APPROVED("approved"),
    
    REJECTED("rejected"),
    
    FEEDBACK("feedback");

    private String value;

    StatusEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static StatusEnum fromValue(String value) {
      for (StatusEnum b : StatusEnum.values()) {
        if (b.value.equals(value)) {
          return b;
        }
      }
      throw new IllegalArgumentException("Unexpected value '" + value + "'");
    }

    public static class Adapter extends TypeAdapter<StatusEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final StatusEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public StatusEnum read(final JsonReader jsonReader) throws IOException {
        String value =  jsonReader.nextString();
        return StatusEnum.fromValue(value);
      }
    }
  }

  public static final String SERIALIZED_NAME_STATUS = "status";
  @SerializedName(SERIALIZED_NAME_STATUS)
  private StatusEnum status;

  public static final String SERIALIZED_NAME_TITLE = "title";
  @SerializedName(SERIALIZED_NAME_TITLE)
  private String title;

  public static final String SERIALIZED_NAME_TOTAL_AMOUNT = "total_amount";
  @SerializedName(SERIALIZED_NAME_TOTAL_AMOUNT)
  private Integer totalAmount;

  public PaymentRequestsIndexResponsePaymentRequests() { 
  }

  public PaymentRequestsIndexResponsePaymentRequests applicantId(Integer applicantId) {
    
    this.applicantId = applicantId;
    return this;
  }

   /**
   * 申請者のユーザーID
   * minimum: 1
   * maximum: 2147483647
   * @return applicantId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "1", required = true, value = "申請者のユーザーID")

  public Integer getApplicantId() {
    return applicantId;
  }


  public void setApplicantId(Integer applicantId) {
    this.applicantId = applicantId;
  }


  public PaymentRequestsIndexResponsePaymentRequests applicationDate(String applicationDate) {
    
    this.applicationDate = applicationDate;
    return this;
  }

   /**
   * 申請日 (yyyy-mm-dd)
   * @return applicationDate
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "2019-12-17", required = true, value = "申請日 (yyyy-mm-dd)")

  public String getApplicationDate() {
    return applicationDate;
  }


  public void setApplicationDate(String applicationDate) {
    this.applicationDate = applicationDate;
  }


  public PaymentRequestsIndexResponsePaymentRequests applicationNumber(String applicationNumber) {
    
    this.applicationNumber = applicationNumber;
    return this;
  }

   /**
   * 申請No.
   * @return applicationNumber
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "2", required = true, value = "申請No.")

  public String getApplicationNumber() {
    return applicationNumber;
  }


  public void setApplicationNumber(String applicationNumber) {
    this.applicationNumber = applicationNumber;
  }


  public PaymentRequestsIndexResponsePaymentRequests approvers(List<ApprovalRequestResponseApprovalRequestApprovers> approvers) {
    
    this.approvers = approvers;
    return this;
  }

  public PaymentRequestsIndexResponsePaymentRequests addApproversItem(ApprovalRequestResponseApprovalRequestApprovers approversItem) {
    this.approvers.add(approversItem);
    return this;
  }

   /**
   * 承認者（配列）   承認ステップのresource_typeがunspecified (指定なし)の場合はapproversはレスポンスに含まれません。   しかし、resource_typeがunspecifiedの承認ステップにおいて誰かが承認・却下・差し戻しのいずれかのアクションを取った後は、   approversはレスポンスに含まれるようになります。   その場合approversにはアクションを行ったステップのIDとアクションを行ったユーザーのIDが含まれます。
   * @return approvers
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(required = true, value = "承認者（配列）   承認ステップのresource_typeがunspecified (指定なし)の場合はapproversはレスポンスに含まれません。   しかし、resource_typeがunspecifiedの承認ステップにおいて誰かが承認・却下・差し戻しのいずれかのアクションを取った後は、   approversはレスポンスに含まれるようになります。   その場合approversにはアクションを行ったステップのIDとアクションを行ったユーザーのIDが含まれます。")

  public List<ApprovalRequestResponseApprovalRequestApprovers> getApprovers() {
    return approvers;
  }


  public void setApprovers(List<ApprovalRequestResponseApprovalRequestApprovers> approvers) {
    this.approvers = approvers;
  }


  public PaymentRequestsIndexResponsePaymentRequests companyId(Integer companyId) {
    
    this.companyId = companyId;
    return this;
  }

   /**
   * 事業所ID
   * minimum: 1
   * maximum: 2147483647
   * @return companyId
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "1", required = true, value = "事業所ID")

  public Integer getCompanyId() {
    return companyId;
  }


  public void setCompanyId(Integer companyId) {
    this.companyId = companyId;
  }


  public PaymentRequestsIndexResponsePaymentRequests currentRound(Integer currentRound) {
    
    this.currentRound = currentRound;
    return this;
  }

   /**
   * 現在のround。差し戻し等により申請がstepの最初からやり直しになるとroundの値が増えます。
   * minimum: 0
   * maximum: 2147483647
   * @return currentRound
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "1", required = true, value = "現在のround。差し戻し等により申請がstepの最初からやり直しになるとroundの値が増えます。")

  public Integer getCurrentRound() {
    return currentRound;
  }


  public void setCurrentRound(Integer currentRound) {
    this.currentRound = currentRound;
  }


  public PaymentRequestsIndexResponsePaymentRequests currentStepId(Integer currentStepId) {
    
    this.currentStepId = currentStepId;
    return this;
  }

   /**
   * 現在承認ステップID
   * minimum: 1
   * maximum: 2147483647
   * @return currentStepId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", required = true, value = "現在承認ステップID")

  public Integer getCurrentStepId() {
    return currentStepId;
  }


  public void setCurrentStepId(Integer currentStepId) {
    this.currentStepId = currentStepId;
  }


  public PaymentRequestsIndexResponsePaymentRequests dealId(Integer dealId) {
    
    this.dealId = dealId;
    return this;
  }

   /**
   * 取引ID (申請ステータス:statusがapprovedで、取引が存在する時のみdeal_idが表示されます)
   * minimum: 1
   * maximum: 2147483647
   * @return dealId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "1", value = "取引ID (申請ステータス:statusがapprovedで、取引が存在する時のみdeal_idが表示されます)")

  public Integer getDealId() {
    return dealId;
  }


  public void setDealId(Integer dealId) {
    this.dealId = dealId;
  }


  public PaymentRequestsIndexResponsePaymentRequests dealStatus(DealStatusEnum dealStatus) {
    
    this.dealStatus = dealStatus;
    return this;
  }

   /**
   * 取引ステータス (申請ステータス:statusがapprovedで、取引が存在する時のみdeal_statusが表示されます settled:支払済み, unsettled:支払待ち)
   * @return dealStatus
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "settled", value = "取引ステータス (申請ステータス:statusがapprovedで、取引が存在する時のみdeal_statusが表示されます settled:支払済み, unsettled:支払待ち)")

  public DealStatusEnum getDealStatus() {
    return dealStatus;
  }


  public void setDealStatus(DealStatusEnum dealStatus) {
    this.dealStatus = dealStatus;
  }


  public PaymentRequestsIndexResponsePaymentRequests documentCode(String documentCode) {
    
    this.documentCode = documentCode;
    return this;
  }

   /**
   * 請求書番号
   * @return documentCode
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "2", required = true, value = "請求書番号")

  public String getDocumentCode() {
    return documentCode;
  }


  public void setDocumentCode(String documentCode) {
    this.documentCode = documentCode;
  }


  public PaymentRequestsIndexResponsePaymentRequests id(Integer id) {
    
    this.id = id;
    return this;
  }

   /**
   * 支払依頼ID
   * minimum: 1
   * maximum: 2147483647
   * @return id
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "1", required = true, value = "支払依頼ID")

  public Integer getId() {
    return id;
  }


  public void setId(Integer id) {
    this.id = id;
  }


  public PaymentRequestsIndexResponsePaymentRequests issueDate(String issueDate) {
    
    this.issueDate = issueDate;
    return this;
  }

   /**
   * 発生日 (yyyy-mm-dd)
   * @return issueDate
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "2019-12-17", required = true, value = "発生日 (yyyy-mm-dd)")

  public String getIssueDate() {
    return issueDate;
  }


  public void setIssueDate(String issueDate) {
    this.issueDate = issueDate;
  }


  public PaymentRequestsIndexResponsePaymentRequests partnerCode(String partnerCode) {
    
    this.partnerCode = partnerCode;
    return this;
  }

   /**
   * 取引先コード
   * @return partnerCode
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "code001", required = true, value = "取引先コード")

  public String getPartnerCode() {
    return partnerCode;
  }


  public void setPartnerCode(String partnerCode) {
    this.partnerCode = partnerCode;
  }


  public PaymentRequestsIndexResponsePaymentRequests partnerId(Integer partnerId) {
    
    this.partnerId = partnerId;
    return this;
  }

   /**
   * 取引先ID
   * minimum: 1
   * maximum: 2147483647
   * @return partnerId
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "201", required = true, value = "取引先ID")

  public Integer getPartnerId() {
    return partnerId;
  }


  public void setPartnerId(Integer partnerId) {
    this.partnerId = partnerId;
  }


  public PaymentRequestsIndexResponsePaymentRequests partnerName(String partnerName) {
    
    this.partnerName = partnerName;
    return this;
  }

   /**
   * 取引先名
   * @return partnerName
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "freee", required = true, value = "取引先名")

  public String getPartnerName() {
    return partnerName;
  }


  public void setPartnerName(String partnerName) {
    this.partnerName = partnerName;
  }


  public PaymentRequestsIndexResponsePaymentRequests paymentDate(String paymentDate) {
    
    this.paymentDate = paymentDate;
    return this;
  }

   /**
   * 支払期限 (yyyy-mm-dd)
   * @return paymentDate
  **/
  @javax.annotation.Nullable
  @ApiModelProperty(example = "2019-12-17", required = true, value = "支払期限 (yyyy-mm-dd)")

  public String getPaymentDate() {
    return paymentDate;
  }


  public void setPaymentDate(String paymentDate) {
    this.paymentDate = paymentDate;
  }


  public PaymentRequestsIndexResponsePaymentRequests paymentMethod(PaymentMethodEnum paymentMethod) {
    
    this.paymentMethod = paymentMethod;
    return this;
  }

   /**
   * 支払方法(none: 指定なし, domestic_bank_transfer: 国内振込, abroad_bank_transfer: 国外振込, account_transfer: 口座振替, credit_card: クレジットカード)
   * @return paymentMethod
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "none", required = true, value = "支払方法(none: 指定なし, domestic_bank_transfer: 国内振込, abroad_bank_transfer: 国外振込, account_transfer: 口座振替, credit_card: クレジットカード)")

  public PaymentMethodEnum getPaymentMethod() {
    return paymentMethod;
  }


  public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
    this.paymentMethod = paymentMethod;
  }


  public PaymentRequestsIndexResponsePaymentRequests status(StatusEnum status) {
    
    this.status = status;
    return this;
  }

   /**
   * 申請ステータス(draft:下書き, in_progress:申請中, approved:承認済, rejected:却下, feedback:差戻し)
   * @return status
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "draft", required = true, value = "申請ステータス(draft:下書き, in_progress:申請中, approved:承認済, rejected:却下, feedback:差戻し)")

  public StatusEnum getStatus() {
    return status;
  }


  public void setStatus(StatusEnum status) {
    this.status = status;
  }


  public PaymentRequestsIndexResponsePaymentRequests title(String title) {
    
    this.title = title;
    return this;
  }

   /**
   * 申請タイトル
   * @return title
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "仕入代金支払い", required = true, value = "申請タイトル")

  public String getTitle() {
    return title;
  }


  public void setTitle(String title) {
    this.title = title;
  }


  public PaymentRequestsIndexResponsePaymentRequests totalAmount(Integer totalAmount) {
    
    this.totalAmount = totalAmount;
    return this;
  }

   /**
   * 合計金額
   * @return totalAmount
  **/
  @javax.annotation.Nonnull
  @ApiModelProperty(example = "30000", required = true, value = "合計金額")

  public Integer getTotalAmount() {
    return totalAmount;
  }


  public void setTotalAmount(Integer totalAmount) {
    this.totalAmount = totalAmount;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    PaymentRequestsIndexResponsePaymentRequests paymentRequestsIndexResponsePaymentRequests = (PaymentRequestsIndexResponsePaymentRequests) o;
    return Objects.equals(this.applicantId, paymentRequestsIndexResponsePaymentRequests.applicantId) &&
        Objects.equals(this.applicationDate, paymentRequestsIndexResponsePaymentRequests.applicationDate) &&
        Objects.equals(this.applicationNumber, paymentRequestsIndexResponsePaymentRequests.applicationNumber) &&
        Objects.equals(this.approvers, paymentRequestsIndexResponsePaymentRequests.approvers) &&
        Objects.equals(this.companyId, paymentRequestsIndexResponsePaymentRequests.companyId) &&
        Objects.equals(this.currentRound, paymentRequestsIndexResponsePaymentRequests.currentRound) &&
        Objects.equals(this.currentStepId, paymentRequestsIndexResponsePaymentRequests.currentStepId) &&
        Objects.equals(this.dealId, paymentRequestsIndexResponsePaymentRequests.dealId) &&
        Objects.equals(this.dealStatus, paymentRequestsIndexResponsePaymentRequests.dealStatus) &&
        Objects.equals(this.documentCode, paymentRequestsIndexResponsePaymentRequests.documentCode) &&
        Objects.equals(this.id, paymentRequestsIndexResponsePaymentRequests.id) &&
        Objects.equals(this.issueDate, paymentRequestsIndexResponsePaymentRequests.issueDate) &&
        Objects.equals(this.partnerCode, paymentRequestsIndexResponsePaymentRequests.partnerCode) &&
        Objects.equals(this.partnerId, paymentRequestsIndexResponsePaymentRequests.partnerId) &&
        Objects.equals(this.partnerName, paymentRequestsIndexResponsePaymentRequests.partnerName) &&
        Objects.equals(this.paymentDate, paymentRequestsIndexResponsePaymentRequests.paymentDate) &&
        Objects.equals(this.paymentMethod, paymentRequestsIndexResponsePaymentRequests.paymentMethod) &&
        Objects.equals(this.status, paymentRequestsIndexResponsePaymentRequests.status) &&
        Objects.equals(this.title, paymentRequestsIndexResponsePaymentRequests.title) &&
        Objects.equals(this.totalAmount, paymentRequestsIndexResponsePaymentRequests.totalAmount);
  }

  private static <T> boolean equalsNullable(JsonNullable<T> a, JsonNullable<T> b) {
    return a == b || (a != null && b != null && a.isPresent() && b.isPresent() && Objects.deepEquals(a.get(), b.get()));
  }

  @Override
  public int hashCode() {
    return Objects.hash(applicantId, applicationDate, applicationNumber, approvers, companyId, currentRound, currentStepId, dealId, dealStatus, documentCode, id, issueDate, partnerCode, partnerId, partnerName, paymentDate, paymentMethod, status, title, totalAmount);
  }

  private static <T> int hashCodeNullable(JsonNullable<T> a) {
    if (a == null) {
      return 1;
    }
    return a.isPresent() ? Arrays.deepHashCode(new Object[]{a.get()}) : 31;
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class PaymentRequestsIndexResponsePaymentRequests {\n");
    sb.append("    applicantId: ").append(toIndentedString(applicantId)).append("\n");
    sb.append("    applicationDate: ").append(toIndentedString(applicationDate)).append("\n");
    sb.append("    applicationNumber: ").append(toIndentedString(applicationNumber)).append("\n");
    sb.append("    approvers: ").append(toIndentedString(approvers)).append("\n");
    sb.append("    companyId: ").append(toIndentedString(companyId)).append("\n");
    sb.append("    currentRound: ").append(toIndentedString(currentRound)).append("\n");
    sb.append("    currentStepId: ").append(toIndentedString(currentStepId)).append("\n");
    sb.append("    dealId: ").append(toIndentedString(dealId)).append("\n");
    sb.append("    dealStatus: ").append(toIndentedString(dealStatus)).append("\n");
    sb.append("    documentCode: ").append(toIndentedString(documentCode)).append("\n");
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    issueDate: ").append(toIndentedString(issueDate)).append("\n");
    sb.append("    partnerCode: ").append(toIndentedString(partnerCode)).append("\n");
    sb.append("    partnerId: ").append(toIndentedString(partnerId)).append("\n");
    sb.append("    partnerName: ").append(toIndentedString(partnerName)).append("\n");
    sb.append("    paymentDate: ").append(toIndentedString(paymentDate)).append("\n");
    sb.append("    paymentMethod: ").append(toIndentedString(paymentMethod)).append("\n");
    sb.append("    status: ").append(toIndentedString(status)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    totalAmount: ").append(toIndentedString(totalAmount)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

