/*
 * Decompiled with CFR 0.152.
 */
package com.eligor;

import android.os.Bundle;
import android.util.Log;
import com.eligor.IPeriodicSyncManager;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class Eligor {
    public static final String TAG = Eligor.class.getSimpleName();
    private static volatile Eligor sInstance;
    private final int mDefaultPeriod;
    private final Map<String, IPeriodicSyncManager> mSyncManagers;

    Eligor(int defaultPeriod) {
        this.mDefaultPeriod = defaultPeriod;
        this.mSyncManagers = new HashMap<String, IPeriodicSyncManager>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initialize(int defaultPeriod) {
        if (sInstance != null) {
            Log.i((String)TAG, (String)(TAG + " is already initialized."));
            return;
        }
        Class<Eligor> clazz = Eligor.class;
        synchronized (Eligor.class) {
            if (sInstance == null) {
                sInstance = new Eligor(defaultPeriod);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static synchronized Eligor getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException(TAG + " is not initialized yet. Call initialize() first.");
        }
        return sInstance;
    }

    public static synchronized void destroy() {
        sInstance = null;
    }

    public void registerPeriodicSyncManager(IPeriodicSyncManager manager) {
        this.mSyncManagers.put(manager.getAuthority(), manager);
    }

    @Nullable
    public IPeriodicSyncManager getPeriodicSyncManager(String authority) {
        return this.mSyncManagers.get(authority);
    }

    public void unregisterPeriodicSyncManager(String authority) {
        this.mSyncManagers.remove(authority);
    }

    public void applySyncPeriod() {
        this.applySyncPeriod(this.mDefaultPeriod);
    }

    public void applySyncPeriod(Bundle args) {
        this.applySyncPeriod(this.mDefaultPeriod, args);
    }

    public void applySyncPeriod(int period) {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            manager.applySyncPeriod(period);
        }
    }

    public void applySyncPeriod(int period, Bundle args) {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            manager.applySyncPeriod(period, args);
        }
    }

    public void applySyncPeriod(String authority) {
        this.applySyncPeriod(authority, this.mDefaultPeriod);
    }

    public void applySyncPeriod(String authority, int period) {
        IPeriodicSyncManager manager = this.getPeriodicSyncManager(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return;
        }
        manager.applySyncPeriod(period);
    }

    public void applySyncPeriod(String authority, Bundle args) {
        this.applySyncPeriod(authority, this.mDefaultPeriod, args);
    }

    public void applySyncPeriod(String authority, int period, Bundle args) {
        IPeriodicSyncManager manager = this.getPeriodicSyncManager(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return;
        }
        manager.applySyncPeriod(period, args);
    }

    public void requestSync() {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            manager.requestSync();
        }
    }

    public void requestSync(Bundle args) {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            manager.requestSync(args);
        }
    }

    public void requestSync(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return;
        }
        manager.requestSync();
    }

    public void requestSync(String authority, Bundle args) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return;
        }
        manager.requestSync(args);
    }

    public void cancelSync() {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            manager.cancelSync();
        }
    }

    public void cancelSync(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return;
        }
        manager.cancelSync();
    }

    public void enableSync() {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            manager.enableSync();
        }
    }

    public void enableSync(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return;
        }
        manager.enableSync();
    }

    public void disableSync() {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            manager.disableSync();
        }
    }

    public void disableSync(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return;
        }
        manager.disableSync();
    }

    public void setSyncable() {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            manager.setSyncable();
        }
    }

    public void setSyncable(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return;
        }
        manager.setSyncable();
    }

    public void setNotSyncable() {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            manager.setNotSyncable();
        }
    }

    public void setNotSyncable(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return;
        }
        manager.setNotSyncable();
    }

    public boolean isSyncEnabled() {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            if (manager.isSyncEnabled()) continue;
            return false;
        }
        return true;
    }

    public boolean isSyncEnabled(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return false;
        }
        return manager.isSyncEnabled();
    }

    public boolean isSyncActive() {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            if (manager.isSyncActive()) continue;
            return false;
        }
        return true;
    }

    public boolean isSyncActive(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return false;
        }
        return manager.isSyncActive();
    }

    public boolean isSyncPending() {
        for (IPeriodicSyncManager manager : this.mSyncManagers.values()) {
            if (manager.isSyncPending()) continue;
            return false;
        }
        return true;
    }

    public boolean isSyncPending(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return false;
        }
        return manager.isSyncPending();
    }

    public boolean isSyncable(String authority) {
        IPeriodicSyncManager manager = this.mSyncManagers.get(authority);
        if (manager == null) {
            Log.i((String)TAG, (String)"unknown authority for the request. ensure to call registerPeriodicSyncManager(IPeriodicSyncManager) first.");
            return false;
        }
        return manager.isSyncable();
    }
}

