/*
 * Decompiled with CFR 0.152.
 */
package com.eligor;

import android.accounts.Account;
import android.annotation.SuppressLint;
import android.content.ContentResolver;
import android.content.Context;
import android.content.SharedPreferences;
import android.os.Build;
import android.os.Bundle;
import com.eligor.AbstractPeriodicSyncManager;
import javax.annotation.Nonnull;

public class PreferencedPeriodicSyncManager
extends AbstractPeriodicSyncManager {
    private static final String KEY_PERIOD = "period";
    private static final String KEY_ENABLED = "enabled";
    private final boolean mDefaultEnabled;
    private SharedPreferences mPreferences;

    public PreferencedPeriodicSyncManager(Context context, @Nonnull Account account, @Nonnull String authority, boolean defaultEnabled) {
        super(account, authority);
        this.mPreferences = context.getSharedPreferences(authority, 0);
        this.mDefaultEnabled = defaultEnabled;
    }

    @Override
    public void applySyncPeriod(int period) {
        boolean enabled = this.mPreferences.getBoolean(KEY_ENABLED, this.mDefaultEnabled);
        if (enabled) {
            this.applyEdit(this.mPreferences.edit().putInt(KEY_PERIOD, period));
            ContentResolver.addPeriodicSync((Account)this.getAccount(), (String)this.getAuthority(), (Bundle)new Bundle(), (long)period);
        }
    }

    @Override
    public void applySyncPeriod(int period, Bundle args) {
        boolean enabled = this.mPreferences.getBoolean(KEY_ENABLED, this.mDefaultEnabled);
        if (enabled) {
            this.applyEdit(this.mPreferences.edit().putInt(KEY_PERIOD, period));
            ContentResolver.addPeriodicSync((Account)this.getAccount(), (String)this.getAuthority(), (Bundle)args, (long)period);
        }
    }

    @Override
    public void requestSync() {
        ContentResolver.requestSync((Account)this.getAccount(), (String)this.getAuthority(), (Bundle)new Bundle());
    }

    @Override
    public void requestSync(Bundle args) {
        ContentResolver.requestSync((Account)this.getAccount(), (String)this.getAuthority(), (Bundle)args);
    }

    @Override
    public void cancelSync() {
        ContentResolver.cancelSync((Account)this.getAccount(), (String)this.getAuthority());
    }

    @Override
    public void enableSync() {
        this.applyEdit(this.mPreferences.edit().putBoolean(KEY_ENABLED, true));
        ContentResolver.setSyncAutomatically((Account)this.getAccount(), (String)this.getAuthority(), (boolean)true);
    }

    @Override
    public void disableSync() {
        this.applyEdit(this.mPreferences.edit().putBoolean(KEY_ENABLED, false));
        ContentResolver.setSyncAutomatically((Account)this.getAccount(), (String)this.getAuthority(), (boolean)false);
    }

    @Override
    public void setSyncable() {
        ContentResolver.setIsSyncable((Account)this.getAccount(), (String)this.getAuthority(), (int)1);
    }

    @Override
    public void setNotSyncable() {
        ContentResolver.setIsSyncable((Account)this.getAccount(), (String)this.getAuthority(), (int)0);
    }

    @Override
    public boolean isSyncEnabled() {
        return ContentResolver.getSyncAutomatically((Account)this.getAccount(), (String)this.getAuthority());
    }

    @Override
    public boolean isSyncActive() {
        return ContentResolver.isSyncActive((Account)this.getAccount(), (String)this.getAuthority());
    }

    @Override
    public boolean isSyncPending() {
        return ContentResolver.isSyncPending((Account)this.getAccount(), (String)this.getAuthority());
    }

    @Override
    public boolean isSyncable() {
        int flag = ContentResolver.getIsSyncable((Account)this.getAccount(), (String)this.getAuthority());
        return flag > 0;
    }

    @SuppressLint(value={"NewApi"})
    private void applyEdit(SharedPreferences.Editor editor) {
        if (Build.VERSION.SDK_INT < 9) {
            editor.commit();
        } else {
            editor.apply();
        }
    }
}

