/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kz.greetgo.class_scanner.ClassScannerDef;
import kz.greetgo.depinject.core.Bean;
import kz.greetgo.depinject.core.BeanConfig;
import kz.greetgo.depinject.core.BeanContainer;
import kz.greetgo.depinject.core.BeanFactory;
import kz.greetgo.depinject.core.BeanScanner;
import kz.greetgo.depinject.core.FactoredBy;
import kz.greetgo.depinject.core.Include;
import kz.greetgo.depinject.core.ScanPackage;
import kz.greetgo.depinject.gen.BeanCreation;
import kz.greetgo.depinject.gen.BeanCreationWithFactoryMethod;
import kz.greetgo.depinject.gen.BeanReference;
import kz.greetgo.depinject.gen.Context;
import kz.greetgo.depinject.gen.Utils;
import kz.greetgo.depinject.gen.errors.FactoryMethodCannotContainAnyArguments;
import kz.greetgo.depinject.gen.errors.NoBeanContainer;
import kz.greetgo.depinject.gen.errors.NoInclude;

public class BeanCreationCollector {
    private final Context context;
    private final Class<?> beanContainerInterface;
    public final List<BeanCreation> beanCreationList = new ArrayList<BeanCreation>();
    private final LinkedList<BeanReference> factoryClassStack = new LinkedList();

    public BeanCreationCollector(Context context, Class<?> beanContainerInterface) {
        this.context = context;
        this.beanContainerInterface = beanContainerInterface;
    }

    public List<BeanCreation> collect() {
        if (!BeanContainer.class.isAssignableFrom(this.beanContainerInterface)) {
            throw new NoBeanContainer(this.beanContainerInterface);
        }
        this.context.configTree.ROOT(this.beanContainerInterface.getName());
        List<Include> includes = Utils.getAllAnnotations(this.beanContainerInterface, Include.class);
        if (includes.isEmpty()) {
            throw new NoInclude(this.beanContainerInterface);
        }
        includes.forEach(this::collectFromInclude);
        return this.beanCreationList;
    }

    private void collectFromInclude(Include include) {
        for (Class beanConfig : include.value()) {
            this.context.configTree.includes(beanConfig.getName());
            this.collectFromBeanConfig(beanConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectFromBeanConfig(Class<?> beanConfig) {
        try {
            ScanPackage scanPackage;
            boolean addToFactoryClassStack;
            ++this.context.configTree.tab;
            BeanConfig beanConfigAnn = beanConfig.getAnnotation(BeanConfig.class);
            if (beanConfigAnn == null) {
                throw this.context.newNoBeanConfig(beanConfig);
            }
            Class defaultFactoryClass = beanConfigAnn.defaultFactoryClass();
            boolean bl = addToFactoryClassStack = BeanFactory.class != defaultFactoryClass;
            if (addToFactoryClassStack) {
                this.factoryClassStack.add(this.context.newBeanReference(defaultFactoryClass, "default bean factory of " + Utils.asStr(beanConfig)));
            }
            Utils.getAllAnnotations(beanConfig, Include.class).forEach(this::collectFromInclude);
            BeanScanner beanScanner = beanConfig.getAnnotation(BeanScanner.class);
            if (beanScanner != null) {
                this.collectFromPackage(beanConfig.getPackage().getName());
            }
            if ((scanPackage = beanConfig.getAnnotation(ScanPackage.class)) != null) {
                for (String subPackageName : scanPackage.value()) {
                    String packageName = BeanCreationCollector.calcFullName(beanConfig.getPackage().getName(), subPackageName);
                    this.context.configTree.scannerPackage(packageName);
                    ++this.context.configTree.tab;
                    this.collectFromPackage(packageName);
                    --this.context.configTree.tab;
                }
            }
            if (addToFactoryClassStack) {
                this.factoryClassStack.removeLast();
            }
        }
        finally {
            --this.context.configTree.tab;
        }
    }

    static String calcFullName(String current, String relative) {
        int count;
        if (relative.startsWith(".")) {
            return current + relative;
        }
        if (!relative.startsWith("^")) {
            return relative;
        }
        ArrayList currentList = new ArrayList();
        Collections.addAll(currentList, current.split("\\."));
        for (count = 0; count < relative.length() && relative.charAt(count) == '^'; ++count) {
            if (currentList.size() <= 0) continue;
            currentList.remove(currentList.size() - 1);
        }
        while (count < relative.length() && relative.charAt(count) == '.') {
            ++count;
        }
        Collections.addAll(currentList, relative.substring(count).split("\\."));
        return currentList.stream().collect(Collectors.joining("."));
    }

    private void collectFromPackage(String packageName) {
        new ClassScannerDef().scanPackage(packageName).forEach(someClass -> {
            Bean bean = someClass.getAnnotation(Bean.class);
            if (bean != null) {
                this.addClassAsBeanAndViewItForAnotherBeans((Class<?>)someClass, bean.singleton());
            }
        });
    }

    private void addClassAsBeanAndViewItForAnotherBeans(Class<?> parentBeanClass, boolean singleton) {
        BeanCreation parentBeanCreation;
        if (Utils.isRealClass(parentBeanClass)) {
            parentBeanCreation = this.context.newBeanCreationWithDefaultConstructor(parentBeanClass, singleton);
            this.beanCreationList.add(parentBeanCreation);
        } else {
            parentBeanCreation = this.context.newBeanCreationWithBeanFactory(parentBeanClass, singleton, this.extractBeanFactoryReference(parentBeanClass));
            this.beanCreationList.add(parentBeanCreation);
        }
        this.context.configTree.bean("" + parentBeanCreation);
        ++this.context.configTree.tab;
        for (Method method : parentBeanClass.getMethods()) {
            Bean bean = Utils.getAnnotation(method, Bean.class);
            if (bean == null) continue;
            if (method.getParameterTypes().length > 0) {
                throw new FactoryMethodCannotContainAnyArguments(method);
            }
            BeanCreationWithFactoryMethod subBean = this.context.newBeanCreationWithFactoryMethod(method.getReturnType(), bean.singleton(), parentBeanCreation, method);
            this.context.configTree.bean("" + subBean);
            this.beanCreationList.add(subBean);
        }
        --this.context.configTree.tab;
    }

    private BeanReference extractBeanFactoryReference(Class<?> beanClass) {
        List<FactoredBy> factoredByList = Utils.getAllAnnotations(beanClass, FactoredBy.class);
        if (factoredByList.size() > 0) {
            return this.context.newBeanReference(factoredByList.get(0).value(), FactoredBy.class.getSimpleName() + " in (or in any parents of) " + Utils.asStr(beanClass));
        }
        if (this.factoryClassStack.size() == 0) {
            throw this.context.newNoDefaultBeanFactory(beanClass);
        }
        return this.factoryClassStack.getLast();
    }
}

