/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.List;
import kz.greetgo.depinject.core.BeanGetter;
import kz.greetgo.depinject.core.LetBeNonePublic;
import kz.greetgo.depinject.gen.BeanCreation;
import kz.greetgo.depinject.gen.BeanReference;
import kz.greetgo.depinject.gen.Context;
import kz.greetgo.depinject.gen.Outer;
import kz.greetgo.depinject.gen.Utils;
import kz.greetgo.depinject.gen.errors.BeanGetterIsNotPublic;

public class BeanCreationWithDefaultConstructor
extends BeanCreation {
    public BeanCreationWithDefaultConstructor(Context context, Class<?> beanClass, boolean singleton) {
        super(context, beanClass, singleton);
    }

    @Override
    public List<BeanReference> getAdditionalBeanReferences() {
        return Collections.emptyList();
    }

    public String toString() {
        return (this.use ? (char)'{' : '(') + Utils.asStr(this.beanClass) + (this.singleton ? ":SINGLE" : "MULT") + " created by def constructor" + this.preparationInfo() + (this.use ? (char)'}' : ')');
    }

    @Override
    protected void markToUseAdditions() {
    }

    @Override
    protected void writeCreateBean(int tab, Outer out, String variableName) {
        out.tab(tab).stn(Utils.codeName(this.beanClass) + ' ' + variableName + " = new " + Utils.codeName(this.beanClass) + "();");
    }

    @Override
    public void checkBeanGetterNotPublic() {
        BeanCreationWithDefaultConstructor.checkBeanGetterNotPublicFor(this.beanClass, null);
        Class me = this.beanClass;
        Class parent;
        while (!Object.class.equals(parent = me.getSuperclass())) {
            BeanCreationWithDefaultConstructor.checkBeanGetterNotPublicFor(parent, this.beanClass);
            me = parent;
        }
        return;
    }

    private static void checkBeanGetterNotPublicFor(Class<?> aClass, Class<?> beanClass) {
        if (aClass.getAnnotation(LetBeNonePublic.class) != null) {
            return;
        }
        for (Field field : aClass.getDeclaredFields()) {
            if (Modifier.isPublic(field.getModifiers()) || !BeanGetter.class.equals(field.getType()) || field.getAnnotation(LetBeNonePublic.class) != null) continue;
            throw new BeanGetterIsNotPublic(aClass, field, beanClass);
        }
    }
}

