/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.util.Objects;

public class DepinjectVersion
implements Comparable<DepinjectVersion> {
    public final int version1;
    public final int version2;
    public final int version3;

    private DepinjectVersion(int version1, int version2, int version3) {
        this.version1 = version1;
        this.version2 = version2;
        this.version3 = version3;
    }

    public static DepinjectVersion parse(String version) {
        String[] split = version.split("\\.");
        return new DepinjectVersion(Integer.parseInt(split[0]), Integer.parseInt(split[1]), Integer.parseInt(split[2]));
    }

    public String toString() {
        return "DepinjectVersion{version1=" + this.version1 + ", version2=" + this.version2 + ", version3=" + this.version3 + '}';
    }

    @Override
    public int compareTo(DepinjectVersion o) {
        int cmp = this.version1 - o.version1;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.version2 - o.version2;
        if (cmp != 0) {
            return cmp;
        }
        return this.version3 - o.version3;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DepinjectVersion that = (DepinjectVersion)o;
        return this.compareTo(that) == 0;
    }

    public int hashCode() {
        return Objects.hash(this.version1, this.version2, this.version3);
    }
}

