/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class Utils {
    public static <T extends Annotation> T getAnnotation(Method method, Class<T> annotation) {
        T ann;
        while ((ann = method.getAnnotation(annotation)) == null) {
            Class<?> aClass = method.getDeclaringClass();
            if (aClass == Object.class) {
                return null;
            }
            Class<?> superclass = aClass.getSuperclass();
            if (superclass == null) {
                return null;
            }
            try {
                method = superclass.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException e) {
                return null;
            }
        }
        return ann;
    }

    public static <T extends Annotation> T getAnnotation(Class<?> source, Class<T> annotation) {
        return Utils.getAnnotationInner(source, annotation, new HashSet());
    }

    private static <T extends Annotation> T getAnnotationInner(Class<?> source, Class<T> annotation, Set<Class<?>> cache) {
        if (source == null) {
            return null;
        }
        T ann = source.getAnnotation(annotation);
        if (ann != null) {
            return ann;
        }
        if (cache.contains(source)) {
            return null;
        }
        cache.add(source);
        for (Class<?> aClass : source.getInterfaces()) {
            T ann2 = Utils.getAnnotationInner(aClass, annotation, cache);
            if (ann2 == null) continue;
            return ann2;
        }
        return Utils.getAnnotationInner(source.getSuperclass(), annotation, cache);
    }

    public static <T extends Annotation> List<T> getAllAnnotations(Class<?> source, Class<T> annotation) {
        ArrayList ret = new ArrayList();
        Utils.putAllAnnotations(source, annotation, ret, new HashSet());
        return ret;
    }

    private static <T extends Annotation> void putAllAnnotations(Class<?> source, Class<T> annotation, List<T> accumulator, Set<Class<?>> cache) {
        if (source == null) {
            return;
        }
        T ann = source.getAnnotation(annotation);
        if (ann != null) {
            accumulator.add(ann);
        }
        if (cache.contains(source)) {
            return;
        }
        cache.add(source);
        for (Class<?> aClass : source.getInterfaces()) {
            Utils.putAllAnnotations(aClass, annotation, accumulator, cache);
        }
        Utils.putAllAnnotations(source.getSuperclass(), annotation, accumulator, cache);
    }

    public static boolean isRealClass(Class<?> aClass) {
        boolean isInterface = aClass.isInterface();
        boolean isAbstract = Modifier.isAbstract(aClass.getModifiers());
        return !isInterface && !isAbstract;
    }

    public static String asStr(Class<?> aClass) {
        boolean isInterface = aClass.isInterface();
        if (isInterface) {
            return "iface " + aClass.getSimpleName();
        }
        boolean isAbstract = Modifier.isAbstract(aClass.getModifiers());
        if (isAbstract) {
            return "abstract " + aClass.getSimpleName();
        }
        return aClass.getSimpleName();
    }

    public static Class<?> extractRawClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return Utils.extractRawClass(((ParameterizedType)type).getRawType());
        }
        throw new IllegalArgumentException("Left type " + type);
    }

    public static String codeName(Class<?> aClass) {
        return aClass.getName().replaceAll("\\$", ".");
    }

    public static String streamToStr(InputStream inputStream) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        Utils.copyStreams(inputStream, bOut, 512);
        try {
            return bOut.toString("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void copyStreams(InputStream inputStream, OutputStream outputStream) {
        Utils.copyStreams(inputStream, outputStream, 4096);
    }

    public static void copyStreams(InputStream inputStream, OutputStream outputStream, int bufferSize) {
        byte[] buffer = new byte[bufferSize];
        try {
            try {
                while (true) {
                    int readCount;
                    if ((readCount = inputStream.read(buffer)) < 0) {
                        return;
                    }
                    outputStream.write(buffer, 0, readCount);
                }
            }
            finally {
                inputStream.close();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

