/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.util.ArrayList;
import java.util.List;

public class BeanConfigTree {
    public final List<TreeElement> tree = new ArrayList<TreeElement>();
    public int tab = 0;

    private void message(TreeElementType type, String message) {
        this.tree.add(new TreeElement(this.tab, type, message));
    }

    public void ROOT(String message) {
        this.message(TreeElementType.ROOT, message);
    }

    public void includes(String message) {
        this.message(TreeElementType.Include, message);
    }

    public void scannerPackage(String message) {
        this.message(TreeElementType.ScanPackage, message);
    }

    public void bean(String message) {
        this.message(TreeElementType.Bean, message);
    }

    public String asStr(boolean showBeans, boolean showTitle) {
        StringBuilder sb = new StringBuilder();
        if (showTitle) {
            sb.append("\nBean Config Tree (without unusable branches):");
        }
        this.tree.stream().filter(a -> showBeans || a.type != TreeElementType.Bean).forEachOrdered(s -> sb.append('\n').append(s));
        return sb.toString();
    }

    public static class TreeElement {
        final int tab;
        final TreeElementType type;
        final String message;

        public TreeElement(int tab, TreeElementType type, String message) {
            this.tab = tab;
            this.type = type;
            this.message = message;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            int c = this.tab + 2;
            for (int i = 0; i < c; ++i) {
                sb.append('\t');
            }
            sb.append((Object)this.type).append(' ').append(this.message);
            return sb.toString();
        }
    }

    public static enum TreeElementType {
        ROOT,
        Include,
        ScanPackage,
        Bean;


        public String toString() {
            if (this == Bean) {
                return "+ " + super.toString();
            }
            return super.toString();
        }
    }
}

