/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kz.greetgo.depinject.core.BeanPreparation;
import kz.greetgo.depinject.gen.BeanContainerMethod;
import kz.greetgo.depinject.gen.BeanCreation;
import kz.greetgo.depinject.gen.BeanCreationCollector;
import kz.greetgo.depinject.gen.BeanReference;
import kz.greetgo.depinject.gen.Context;
import kz.greetgo.depinject.gen.GetterCreation;
import kz.greetgo.depinject.gen.Outer;
import kz.greetgo.depinject.gen.errors.NoMethodsInBeanContainer;

public class BeanContainerManager {
    private final Context context;
    private final Class<?> beanContainerInterface;
    BeanCreationCollector collector;
    List<BeanContainerMethod> beanContainerMethodList;
    List<BeanCreation> beanCreationList;
    List<BeanReference> allBeanReferences;
    List<BeanCreation> preparations;
    List<BeanCreation> replacers;
    List<BeanCreation> usingBeanCreationList;
    List<BeanReference> usingBeanReferences;
    List<GetterCreation> writingGetterCreations;
    List<BeanReference> writingBeanReferences;

    BeanContainerManager(Context context, Class<?> beanContainerInterface) {
        this.context = context;
        this.beanContainerInterface = beanContainerInterface;
    }

    void prepareToWrite() {
        this.beanContainerMethodList = this.context.extractBeanContainerMethodList(this.beanContainerInterface);
        this.collector = this.context.newBeanCreationCollector(this.beanContainerInterface);
        this.collector.collect();
        this.beanCreationList = ((Stream)this.collector.beanCreationList.stream().unordered()).distinct().collect(Collectors.toList());
        this.beanCreationList.sort(Comparator.comparing(o -> o.beanClass.getName()));
        this.beanCreationList.forEach(BeanCreation::fillBeanGetterDotList);
        this.allBeanReferences = new ArrayList<BeanReference>();
        this.beanContainerMethodList.forEach(x -> this.allBeanReferences.add(x.beanReference));
        this.beanCreationList.forEach(a -> a.beanGetterDotList.forEach(b -> this.allBeanReferences.add(b.beanReference)));
        this.beanCreationList.stream().flatMap(a -> a.getAdditionalBeanReferences().stream()).forEachOrdered(a -> this.allBeanReferences.add((BeanReference)a));
        this.allBeanReferences.forEach(a -> a.fillTargetCreationsFrom(this.beanCreationList));
        this.preparations = this.beanCreationList.stream().filter(bc -> BeanPreparation.class.isAssignableFrom(bc.beanClass)).peek(BeanCreation::calculatePreparingClass).collect(Collectors.toList());
        this.preparations.forEach(p -> p.calculatesBeanPreparationPriority(this.preparations));
        this.preparations.sort(Comparator.comparing(BeanCreation::beanPreparationPriority));
        this.allBeanReferences.forEach(r -> r.usePreparations(this.preparations));
        this.replacers = this.beanCreationList.stream().peek(BeanCreation::calculateReplaceChecker).filter(BeanCreation::hasReplaceChecker).peek(BeanCreation::calculateReplacerPriority).sorted(Comparator.comparing(BeanCreation::replacerPriority)).collect(Collectors.toList());
        this.allBeanReferences.forEach(r -> r.useReplacers(this.replacers));
        this.beanContainerMethodList.forEach(BeanContainerMethod::markToUse);
        this.usingBeanCreationList = this.beanCreationList.stream().filter(a -> a.use).collect(Collectors.toList());
        this.usingBeanReferences = this.allBeanReferences.stream().filter(a -> a.use).collect(Collectors.toList());
        this.usingBeanReferences.forEach(BeanReference::checkConnectivity);
        HashMap getterCreationMap = new HashMap();
        this.usingBeanReferences.stream().flatMap(a -> a.getterCreations.stream()).filter(GetterCreation::needGetter).forEachOrdered(a -> getterCreationMap.computeIfAbsent(a, k -> new ArrayList()).add(a));
        this.writingGetterCreations = new ArrayList<GetterCreation>();
        this.writingGetterCreations.addAll(getterCreationMap.keySet());
        this.writingGetterCreations.sort(Comparator.comparing(o -> o.beanCreation.beanClass.getName()));
        HashMap beanReferenceMap = new HashMap();
        this.usingBeanReferences.stream().filter(BeanReference::needGetter).forEachOrdered(br -> beanReferenceMap.computeIfAbsent(br, k -> new ArrayList()).add(br));
        this.writingBeanReferences = new ArrayList(beanReferenceMap.keySet());
        this.writingBeanReferences.sort(Comparator.comparing(BeanReference::compareStr));
        int[] varIndex = new int[]{1};
        this.usingBeanCreationList.forEach(bc -> {
            int n = varIndex[0];
            varIndex[0] = n + 1;
            bc.varIndex = n;
        });
        this.writingBeanReferences.forEach(br -> {
            int n = varIndex[0];
            varIndex[0] = n + 1;
            br.varIndex = n;
            ((List)beanReferenceMap.get(br)).forEach(br2 -> {
                br2.varIndex = br.varIndex;
            });
        });
        this.writingGetterCreations.forEach(gc -> {
            int n = varIndex[0];
            varIndex[0] = n + 1;
            gc.varIndex = n;
            ((List)getterCreationMap.get(gc)).forEach(gc2 -> {
                gc2.varIndex = gc.varIndex;
            });
        });
        this.usingBeanCreationList.forEach(BeanCreation::checkBeanGetterNotPublic);
    }

    void writeBeanContainerMethods(int tab, Outer out) {
        if (this.beanContainerMethodList.isEmpty()) {
            throw new NoMethodsInBeanContainer(this.beanContainerInterface);
        }
        this.beanContainerMethodList.forEach(bcm -> bcm.writeBeanContainerMethod(tab, out));
    }

    void writeBeanCreations(int tab, Outer out) {
        this.usingBeanCreationList.forEach(a -> a.writeGetter(tab, out));
    }

    void writeBeanContainerImpl0(Outer outer, String packageName, String classSimpleName) {
        if (packageName != null) {
            outer.stn("package " + packageName + ";");
        }
        outer.stn("public final class " + classSimpleName + " implements " + this.beanContainerInterface.getName().replaceAll("\\$", ".") + '{');
        outer.nl().tab(1).stn("private final java.lang.Object forSynchronizedBlocks = new java.lang.Object();");
        outer.nl();
        outer.tab(1).stn("//");
        outer.tab(1).stn("// Bean container methods");
        outer.tab(1).stn("//");
        this.writeBeanContainerMethods(1, outer);
        outer.nl();
        outer.tab(1).stn("//");
        outer.tab(1).stn("// Bean creations");
        outer.tab(1).stn("//");
        this.writeBeanCreations(1, outer);
        outer.nl();
        outer.tab(1).stn("//");
        outer.tab(1).stn("// Bean references");
        outer.tab(1).stn("//");
        this.writeBeanReferences(1, outer);
        outer.tab(1).nl();
        outer.tab(1).stn("//");
        outer.tab(1).stn("// Getter creations");
        outer.tab(1).stn("//");
        this.writeGetterCreations(1, outer);
        outer.stn("}");
    }

    private void writeBeanReferences(int tab, Outer outer) {
        this.writingBeanReferences.forEach(a -> a.writeGetter(tab, outer));
    }

    private void writeGetterCreations(int tab, Outer outer) {
        this.writingGetterCreations.forEach(gc -> gc.writeGetter(tab, outer));
    }

    public void writeBeanContainerImpl(Outer outer, String packageName, String classSimpleName) {
        this.prepareToWrite();
        this.writeBeanContainerImpl0(outer, packageName, classSimpleName);
    }
}

