/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import kz.greetgo.depinject.core.BeanGetter;
import kz.greetgo.depinject.core.BeanPreparation;
import kz.greetgo.depinject.core.BeanPreparationPriority;
import kz.greetgo.depinject.core.HasAfterInject;
import kz.greetgo.depinject.core.replace.BeanReplacer;
import kz.greetgo.depinject.core.replace.ReplacePriority;
import kz.greetgo.depinject.gen.BeanGetterDot;
import kz.greetgo.depinject.gen.BeanReference;
import kz.greetgo.depinject.gen.Context;
import kz.greetgo.depinject.gen.Outer;
import kz.greetgo.depinject.gen.ReplaceChecker;
import kz.greetgo.depinject.gen.ReplaceCheckerExtractor;
import kz.greetgo.depinject.gen.Utils;
import kz.greetgo.depinject.gen.errors.LeftException;

public abstract class BeanCreation {
    public final Class<?> beanClass;
    public final boolean singleton;
    public int varIndex;
    protected final Context context;
    public final List<BeanGetterDot> beanGetterDotList = new ArrayList<BeanGetterDot>();
    public boolean use = false;
    private final BeanPreparationPriorityDot beanPreparationPriority = new BeanPreparationPriorityDot();
    public Class<?> preparingClass = null;
    public ReplaceChecker replaceChecker = null;
    private final ReplacerPriorityDot replacerPriority = new ReplacerPriorityDot();

    public BeanCreation(Context context, Class<?> beanClass, boolean singleton) {
        this.context = context;
        if (beanClass == null) {
            throw new NullPointerException("beanClass == null");
        }
        this.beanClass = beanClass;
        this.singleton = singleton;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanCreation that = (BeanCreation)o;
        return this.beanClass.equals(that.beanClass);
    }

    public int hashCode() {
        return this.beanClass.hashCode();
    }

    public void checkBeanGetterNotPublic() {
    }

    public String getterVarName() {
        if (this.varIndex <= 0) {
            throw new LeftException("Left varIndex value = " + this.varIndex);
        }
        return "getter_native_" + this.beanClass.getSimpleName() + '_' + this.varIndex;
    }

    private String gettingMethodName() {
        if (this.varIndex <= 0) {
            throw new LeftException("Left varIndex value = " + this.varIndex);
        }
        return "get_native_" + this.beanClass.getSimpleName() + '_' + this.varIndex;
    }

    public String cachedValueVarName() {
        if (this.varIndex <= 0) {
            throw new LeftException("Left varIndex value = " + this.varIndex);
        }
        return "cachedValue_native_" + this.beanClass.getSimpleName() + '_' + this.varIndex;
    }

    public abstract List<BeanReference> getAdditionalBeanReferences();

    public void fillBeanGetterDotList() {
        this.context.fillBeanGetterDotListInner(this.beanGetterDotList, this.beanClass);
    }

    public void markToUse() {
        if (this.use) {
            return;
        }
        this.use = true;
        this.beanGetterDotList.forEach(a -> a.beanReference.markToUse());
        this.markToUseAdditions();
    }

    protected abstract void markToUseAdditions();

    public void writeGetter(int tab, Outer out) {
        out.nl();
        int tab1 = tab + 1;
        int tab2 = tab + 2;
        int tab3 = tab + 3;
        if (this.singleton) {
            out.tab(tab).stn("private final " + Utils.codeName(AtomicReference.class) + "<" + Utils.codeName(this.beanClass) + "> " + this.cachedValueVarName() + " = new " + Utils.codeName(AtomicReference.class) + "<>(null);");
        }
        out.tab(tab).stn("private final " + Utils.codeName(BeanGetter.class) + "<" + Utils.codeName(this.beanClass) + "> " + this.getterVarName() + " = this::" + this.gettingMethodName() + ";");
        out.tab(tab).stn("private " + Utils.codeName(this.beanClass) + " " + this.gettingMethodName() + " () {");
        if (this.singleton) {
            out.tab(tab1).stn("{");
            out.tab(tab2).stn(Utils.codeName(this.beanClass) + " x = " + this.cachedValueVarName() + ".get();");
            out.tab(tab2).stn("if (x != null) return x;");
            out.tab(tab1).stn("}");
            out.tab(tab1).stn("synchronized (forSynchronizedBlocks) {");
            out.tab(tab2).stn("{");
            out.tab(tab3).stn(Utils.codeName(this.beanClass) + " x = " + this.cachedValueVarName() + ".get();");
            out.tab(tab3).stn("if (x != null) return x;");
            out.tab(tab2).stn("}");
            out.tab(tab2).stn("try {");
            this.writeCreateBean(tab + 3, out, "localValue");
            this.writeBeanGettersAndInit(tab + 3, out, "localValue");
            out.tab(tab3).stn(this.cachedValueVarName() + ".set(localValue);");
            out.tab(tab3).stn("return localValue;");
            out.tab(tab2).stn("} catch (java.lang.Exception e) {");
            out.tab(tab3).stn("if (e instanceof java.lang.RuntimeException) throw (java.lang.RuntimeException) e;");
            out.tab(tab3).stn("throw new java.lang.RuntimeException(e);");
            out.tab(tab2).stn("}");
            out.tab(tab1).stn("}");
        } else {
            out.tab(tab1).stn("try {");
            this.writeCreateBean(tab2, out, "localValue");
            this.writeBeanGettersAndInit(tab2, out, "localValue");
            out.tab(tab2).stn("return localValue;");
            out.tab(tab1).stn("} catch (java.lang.Exception e) {");
            out.tab(tab2).stn("if (e instanceof java.lang.RuntimeException) throw (java.lang.RuntimeException) e;");
            out.tab(tab2).stn("throw new java.lang.RuntimeException(e);");
            out.tab(tab1).stn("}");
        }
        out.tab(tab).stn("}");
    }

    public void writeBeanGettersAndInit(int tab, Outer out, String variableName) {
        this.beanGetterDotList.forEach(bg -> bg.writeAssignment(tab, out, variableName));
        if (HasAfterInject.class.isAssignableFrom(this.beanClass)) {
            out.tab(tab).stn(variableName + ".afterInject();");
        }
    }

    protected abstract void writeCreateBean(int var1, Outer var2, String var3);

    public void calculatesBeanPreparationPriority(List<BeanCreation> preparations) {
        BeanPreparationPriority annotation = Utils.getAnnotation(this.beanClass, BeanPreparationPriority.class);
        if (annotation != null) {
            this.beanPreparationPriority.fromAnnotation = annotation.value();
        }
        preparations.stream().filter(bc -> bc.preparingClass != null).forEach(that -> {
            if (that.preparingClass.isAssignableFrom(this.preparingClass)) {
                ++that.beanPreparationPriority.parenting;
            }
        });
    }

    public BeanPreparationPriorityDot beanPreparationPriority() {
        return this.beanPreparationPriority;
    }

    public void calculatePreparingClass() {
        this.preparingClass = BeanCreation.getPreparingClass(this.beanClass, new HashSet());
    }

    static Class<?> getPreparingClass(Type type, Set<Class<?>> cacheSet) {
        if (type == null) {
            return null;
        }
        if (type instanceof ParameterizedType) {
            Class rawClass;
            ParameterizedType parameterizedType = (ParameterizedType)((Object)type);
            Type rawType = parameterizedType.getRawType();
            if (rawType instanceof Class && BeanPreparation.class == (rawClass = (Class)rawType)) {
                Type typeArg0 = parameterizedType.getActualTypeArguments()[0];
                return Utils.extractRawClass(typeArg0);
            }
            type = Utils.extractRawClass(rawType);
        }
        if (type instanceof Class) {
            Class aClass = type;
            if (cacheSet.contains(aClass)) {
                return null;
            }
            cacheSet.add(aClass);
            for (Type interfaceType : aClass.getGenericInterfaces()) {
                Class<?> ret = BeanCreation.getPreparingClass(interfaceType, cacheSet);
                if (ret == null) continue;
                return ret;
            }
            return BeanCreation.getPreparingClass(aClass.getSuperclass(), cacheSet);
        }
        throw new IllegalArgumentException("Unknown type: " + type);
    }

    protected String preparationInfo() {
        if (this.preparingClass == null) {
            return "";
        }
        return ", preparation for " + Utils.asStr(this.preparingClass) + ' ' + this.beanPreparationPriority.toString();
    }

    public boolean hasReplaceChecker() {
        return this.replaceChecker != null;
    }

    public void calculateReplaceChecker() {
        this.replaceChecker = null;
        if (!BeanReplacer.class.isAssignableFrom(this.beanClass)) {
            return;
        }
        this.replaceChecker = ReplaceCheckerExtractor.fromBeanClass(this.beanClass);
    }

    public ReplacerPriorityDot replacerPriority() {
        return this.replacerPriority;
    }

    public void calculateReplacerPriority() {
        this.replacerPriority.className = this.beanClass.getName();
        ReplacePriority replacePriority = Utils.getAnnotation(this.beanClass, ReplacePriority.class);
        if (replacePriority != null) {
            this.replacerPriority.priority = replacePriority.value();
        }
    }

    public static class ReplacerPriorityDot
    implements Comparable<ReplacerPriorityDot> {
        private String className;
        private double priority = 0.0;

        @Override
        public int compareTo(ReplacerPriorityDot o) {
            int cmp = Double.compare(this.priority, o.priority);
            if (cmp != 0) {
                return cmp;
            }
            return this.className.compareTo(o.className);
        }
    }

    public static class BeanPreparationPriorityDot
    implements Comparable<BeanPreparationPriorityDot> {
        int parenting = 0;
        double fromAnnotation = 0.0;

        @Override
        public int compareTo(BeanPreparationPriorityDot o) {
            int cmp = Integer.compare(this.parenting, o.parenting);
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(this.fromAnnotation, o.fromAnnotation);
        }

        public String toString() {
            return "(" + this.parenting + ", " + this.fromAnnotation + ')';
        }
    }
}

