/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import kz.greetgo.depinject.core.BeanGetter;
import kz.greetgo.depinject.gen.BeanCreation;
import kz.greetgo.depinject.gen.Context;
import kz.greetgo.depinject.gen.GetterCreation;
import kz.greetgo.depinject.gen.Outer;
import kz.greetgo.depinject.gen.Utils;
import kz.greetgo.depinject.gen.errors.IllegalBeanGetterArgumentType;
import kz.greetgo.depinject.gen.errors.LeftException;

public class BeanReference {
    public final String place;
    private final Context context;
    public final Class<?> sourceClass;
    public final boolean isList;
    public final List<GetterCreation> getterCreations = new ArrayList<GetterCreation>();
    private String compareStr = null;
    private boolean wasFillTargetCreations = false;
    public boolean use = false;
    private boolean wasUsePreparations = false;
    private boolean wasUseReplacers = false;
    public int varIndex = 0;

    public BeanReference(Context context, Type target, String place) {
        if (place == null) {
            throw new NullPointerException("place == null");
        }
        this.context = context;
        this.place = place;
        if (target instanceof Class) {
            this.sourceClass = (Class)target;
            this.isList = false;
            return;
        }
        if (target instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)target;
            if (parameterizedType.getRawType() == List.class) {
                Type listArg = parameterizedType.getActualTypeArguments()[0];
                if (listArg instanceof Class) {
                    this.sourceClass = (Class)listArg;
                    this.isList = true;
                    return;
                }
                throw new IllegalBeanGetterArgumentType("Cannot extract bean class from List: " + parameterizedType.toString() + "; " + place);
            }
            throw new IllegalBeanGetterArgumentType("Cannot extract bean class from parameterized type: " + parameterizedType.toString() + "; " + place);
        }
        throw new IllegalBeanGetterArgumentType("Cannot extract bean class from type: " + target.toString() + "; " + place);
    }

    public String targetClassCode() {
        return this.isList ? Utils.codeName(List.class) + '<' + Utils.codeName(this.sourceClass) + '>' : Utils.codeName(this.sourceClass);
    }

    public String compareStr() {
        if (this.compareStr == null) {
            this.compareStr = (this.isList ? "A_" : "B_") + this.sourceClass.getName();
        }
        return this.compareStr;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BeanReference that = (BeanReference)o;
        if (this.isList != that.isList) {
            return false;
        }
        return this.getterCreations.equals(that.getterCreations);
    }

    public int hashCode() {
        int result = this.isList ? 1 : 0;
        result = 31 * result + this.getterCreations.hashCode();
        return result;
    }

    public void fillTargetCreationsFrom(List<BeanCreation> candidates) {
        if (this.wasFillTargetCreations) {
            return;
        }
        this.wasFillTargetCreations = true;
        for (BeanCreation candidate : candidates) {
            if (!this.sourceClass.isAssignableFrom(candidate.beanClass)) continue;
            this.getterCreations.add(new GetterCreation(this.sourceClass, candidate));
        }
        this.getterCreations.sort(Comparator.comparing(o -> o.beanCreation.beanClass.getName()));
    }

    public void markToUse() {
        if (this.use) {
            return;
        }
        this.use = true;
        this.getterCreations.forEach(GetterCreation::markToUse);
    }

    public String firstBeanToString() {
        if (this.getterCreations.size() == 0) {
            return "NO_BEAN";
        }
        return this.getterCreations.get(0).toString();
    }

    public String toString() {
        return (this.isList ? "[" : "") + Utils.asStr(this.sourceClass) + (this.isList ? "]" : "") + " -> " + this.getterCreations.size() + '[' + this.getterCreations.stream().map(GetterCreation::toString).collect(Collectors.joining(", ")) + ']';
    }

    public void checkConnectivity() {
        if (this.isList) {
            return;
        }
        if (this.getterCreations.size() == 0) {
            throw this.context.newNoCandidates(this);
        }
        if (this.getterCreations.size() > 1) {
            throw this.context.newManyCandidates(this);
        }
    }

    public String toFullString() {
        return this.toString() + this.preparationsStr();
    }

    private String preparationsStr() {
        StringBuilder sb = new StringBuilder();
        for (GetterCreation getterCreation : this.getterCreations) {
            sb.append(getterCreation.preparationStr());
        }
        return sb.toString();
    }

    public void usePreparations(List<BeanCreation> allPreparations) {
        if (this.wasUsePreparations) {
            return;
        }
        this.wasUsePreparations = true;
        this.getterCreations.forEach(tc -> tc.usePreparations(allPreparations));
    }

    public void useReplacers(List<BeanCreation> allReplacers) {
        if (this.wasUseReplacers) {
            return;
        }
        this.wasUseReplacers = true;
        this.getterCreations.forEach(tc -> tc.useReplacers(allReplacers));
    }

    public boolean needGetter() {
        return this.isList;
    }

    public String getterVarName() {
        return this.needGetter() ? "getter_ref_" + (this.isList ? "list_" : "") + this.sourceClass.getSimpleName() + '_' + this.varIndex() : this.getterCreations.get(0).getterVarName();
    }

    private String gettingMethodName() {
        if (!this.needGetter()) {
            throw new LeftException("jhb4jhb5hjb6jn7");
        }
        return "get_ref_" + (this.isList ? "list_" : "") + this.sourceClass.getSimpleName() + '_' + this.varIndex();
    }

    private int varIndex() {
        if (this.varIndex <= 0) {
            throw new RuntimeException("Left var index = " + this.varIndex);
        }
        return this.varIndex;
    }

    public void writeGetter(int tab, Outer outer) {
        if (!this.needGetter()) {
            return;
        }
        outer.nl();
        if (this.isList) {
            this.writeGetterAsList(tab, outer);
        } else {
            this.writeGetterMono(tab, outer);
        }
    }

    private void writeGetterMono(int tab, Outer outer) {
        throw new UnsupportedOperationException();
    }

    private void writeGetterAsList(int tab, Outer outer) {
        outer.tab(tab).stn("private final " + Utils.codeName(BeanGetter.class) + "<" + Utils.codeName(List.class) + "<" + Utils.codeName(this.sourceClass) + ">> " + this.getterVarName() + " = this::" + this.gettingMethodName() + ";");
        outer.tab(tab).stn("private " + Utils.codeName(List.class) + "<" + Utils.codeName(this.sourceClass) + "> " + this.gettingMethodName() + "() {");
        int tab1 = tab + 1;
        outer.tab(tab1).stn(Utils.codeName(List.class) + "<" + Utils.codeName(this.sourceClass) + "> list = new " + Utils.codeName(ArrayList.class) + "<>();");
        for (GetterCreation gc : this.getterCreations) {
            gc.getterVarName();
            outer.tab(tab1).stn("list.add(" + gc.getterVarName() + ".get());");
        }
        outer.tab(tab1).stn("return list;");
        outer.tab(tab).stn("}");
    }
}

