/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kz.greetgo.depinject.gen.DepinjectUtil;

public class DepinjectGenerate {
    public static final String RESET = "\u001b[0m";
    public static final String BLACK_BOLD = "\u001b[1;30m";

    public static void main(String[] args) {
        System.exit(new DepinjectGenerate().exec(args));
    }

    private int exec(String[] args) {
        if (args.length == 0) {
            this.help();
            return 1;
        }
        if ("impl".equals(args[0])) {
            this.impl(args, 1);
            return 0;
        }
        System.err.println("ERROR: Unknown command: " + args[0]);
        this.help();
        return 1;
    }

    private void help() {
        System.err.println("    ");
        System.err.println("Using: java ... " + this.getClass().getName() + " impl -p <package_name1>[:<package_name2>[:...]] -s <out src dir> [-c]");
        System.err.println("    ");
        System.err.println("      Scan <package_name1>, <package_name2>, ... for interfaces extends BeanContainer and generate its implementation.");
        System.err.println("    Place generated implementations into <err src dir>. Package of implementation is same");
        System.err.println("    as implementing interface.");
        System.err.println("    ");
        System.err.println("    \u001b[1;30m-c\u001b[0m if specified this flag, then generated source would be compiled in <out src dir>");
    }

    private void impl(String[] args, int startFrom) {
        Arguments arguments = new Arguments();
        arguments.parse(args, startFrom);
        if (arguments.compile) {
            arguments.packageNameList.forEach(pn -> DepinjectUtil.implementBeanContainers(pn, arguments.outSrcDir));
            return;
        }
        arguments.packageNameList.forEach(pn -> DepinjectUtil.generateBeanContainersSources(pn, arguments.outSrcDir));
    }

    private static class Arguments {
        List<String> packageNameList = new ArrayList<String>();
        String outSrcDir;
        boolean compile;

        private Arguments() {
        }

        void parse(String[] args, int startFrom) {
            int i = startFrom;
            while (i < args.length) {
                String x = args[i];
                if ("-c".equals(x)) {
                    this.compile = true;
                    ++i;
                    continue;
                }
                if ("-p".equals(x)) {
                    if (args.length == i + 1) {
                        throw new RuntimeException("Please specify argument for parameter -p");
                    }
                    this.packageNameList = Arrays.stream(args[i + 1].split(":")).collect(Collectors.toList());
                    i += 2;
                    continue;
                }
                if ("-s".equals(x)) {
                    if (args.length == i + 1) {
                        throw new RuntimeException("Please specify argument for parameter -s");
                    }
                    this.outSrcDir = args[i + 1];
                    i += 2;
                    continue;
                }
                throw new RuntimeException("Unknown option " + x);
            }
            if (this.packageNameList == null || this.packageNameList.isEmpty()) {
                throw new RuntimeException("Please specify parameter -p");
            }
            if (this.outSrcDir == null) {
                throw new RuntimeException("Please specify parameter -s");
            }
        }

        public String toString() {
            return "Parameters{packageNameList='" + String.join((CharSequence)":", this.packageNameList) + '\'' + ", outSrcDir='" + this.outSrcDir + '\'' + ", compile=" + this.compile + '}';
        }
    }
}

