/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kz.greetgo.depinject.core.Bean;
import kz.greetgo.depinject.core.BeanGetter;
import kz.greetgo.depinject.core.SkipInject;
import kz.greetgo.depinject.gen.BeanCreation;
import kz.greetgo.depinject.gen.BeanReference;
import kz.greetgo.depinject.gen.ConstructorArg;
import kz.greetgo.depinject.gen.Context;
import kz.greetgo.depinject.gen.Outer;
import kz.greetgo.depinject.gen.Utils;
import kz.greetgo.depinject.gen.errors.NonPublicBeanWithoutConstructor;

public class BeanCreationWithConstructor
extends BeanCreation {
    final List<ConstructorArg> argList;

    public BeanCreationWithConstructor(Context context, Class<?> beanClass, Bean bean, List<ConstructorArg> argList) {
        super(context, beanClass, bean);
        Objects.requireNonNull(argList, "argList == null");
        this.argList = argList;
    }

    @Override
    public List<BeanReference> getAdditionalBeanReferences() {
        return this.argList.stream().map(ConstructorArg::beanReference).collect(Collectors.toList());
    }

    public String toString() {
        return (this.use ? (char)'{' : '(') + Utils.asStr(this.beanClass) + (this.bean.singleton() ? ":SINGLE" : "MANY") + " created by constructor(" + this.argList.stream().map(ConstructorArg::displayStr).collect(Collectors.joining(", ")) + ")" + this.preparationInfo() + (this.use ? (char)'}' : ')');
    }

    @Override
    protected void markToUseAdditions() {
        this.argList.forEach(ConstructorArg::markToUse);
    }

    @Override
    protected void writeCreateBean(int tab, Outer out, String variableName) {
        out.tab(tab).stn(Utils.codeName(this.beanClass) + ' ' + variableName + " = new " + Utils.codeName(this.beanClass) + "(" + this.argList.stream().map(ConstructorArg::referenceExpression).collect(Collectors.joining(", ")) + ");");
    }

    @Override
    public void checkBeanGetterNotPublic() {
        this.checkBeanGetterNotPublicFor(this.beanClass, null);
        Class me = this.beanClass;
        Class parent;
        while (!Object.class.equals(parent = me.getSuperclass())) {
            this.checkBeanGetterNotPublicFor(parent, this.beanClass);
            me = parent;
        }
        return;
    }

    private void checkBeanGetterNotPublicFor(Class<?> aClass, Class<?> beanClass) {
        if (aClass.getAnnotation(SkipInject.class) != null) {
            return;
        }
        Set argTypes = this.argList.stream().map(a -> a.argType.toString()).collect(Collectors.toSet());
        for (Field field : aClass.getDeclaredFields()) {
            if (Modifier.isPublic(field.getModifiers()) || !BeanGetter.class.equals(field.getType()) || field.getAnnotation(SkipInject.class) != null || argTypes.contains(field.getGenericType().toString())) continue;
            throw new NonPublicBeanWithoutConstructor(aClass, field, beanClass);
        }
    }
}

