/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import kz.greetgo.class_scanner.ClassScannerDef;
import kz.greetgo.depinject.core.BeanContainer;
import kz.greetgo.depinject.core.Include;
import kz.greetgo.depinject.gen.BeanContainerGenerator;
import kz.greetgo.depinject.gen.DepinjectVersion;
import kz.greetgo.depinject.gen.Utils;
import kz.greetgo.java_compiler.JavaCompiler;
import kz.greetgo.java_compiler.JavaCompilerFactory;
import kz.greetgo.util.ServerUtil;

public class DepinjectUtil {
    public static Class<?> typeToClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return (Class)pt.getRawType();
        }
        return null;
    }

    public static String toCode(Type type) {
        return DepinjectUtil.toCode0(type).replaceAll("\\$", ".");
    }

    private static String toCode0(Type type) {
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type.toString();
    }

    public static String spaces(int spaces) {
        char[] s = new char[spaces];
        int n = s.length;
        for (int i = 0; i < n; ++i) {
            s[i] = 32;
        }
        return new String(s);
    }

    public static List<File> generateBeanContainersSources(String packageName, String srcDir) {
        ArrayList<File> filesToCompile = new ArrayList<File>();
        ClassScannerDef classScanner = new ClassScannerDef();
        for (Class aClass : classScanner.scanPackage(packageName)) {
            if (!BeanContainer.class.isAssignableFrom(aClass) || aClass.getAnnotation(Include.class) == null) continue;
            BeanContainerGenerator bcg = new BeanContainerGenerator();
            bcg.beanContainerInterface = aClass;
            bcg.implClassName = aClass.getSimpleName() + "AutomaticallyGeneratedImplementation";
            bcg.packageName = aClass.getPackage().getName();
            filesToCompile.add(bcg.writeToSourceDir(srcDir));
        }
        return filesToCompile;
    }

    public static void implementBeanContainers(String packageName, String srcDir) {
        List<File> filesToCompile = DepinjectUtil.generateBeanContainersSources(packageName, srcDir);
        JavaCompiler compiler = JavaCompilerFactory.createDefault();
        for (File file : filesToCompile) {
            compiler.compile(file);
        }
    }

    public static void implementAndUseBeanContainers(String packageName, String srcDir) throws Exception {
        DepinjectUtil.implementBeanContainers(packageName, srcDir);
        ServerUtil.addToClasspath((String)srcDir);
    }

    public static DepinjectVersion version() {
        String version = Utils.streamToStr(DepinjectUtil.class.getResourceAsStream("/depinject_version.txt")).trim();
        return DepinjectVersion.parse(version);
    }
}

