/*
 * Decompiled with CFR 0.152.
 */
package kz.greetgo.depinject.gen;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import kz.greetgo.class_scanner.ClassScannerDef;
import kz.greetgo.depinject.core.Bean;
import kz.greetgo.depinject.core.BeanConfig;
import kz.greetgo.depinject.core.BeanContainer;
import kz.greetgo.depinject.core.BeanFactory;
import kz.greetgo.depinject.core.BeanScanner;
import kz.greetgo.depinject.core.FactoredBy;
import kz.greetgo.depinject.core.Include;
import kz.greetgo.depinject.core.ScanPackage;
import kz.greetgo.depinject.gen.BeanCreation;
import kz.greetgo.depinject.gen.BeanCreationWithFactoryMethod;
import kz.greetgo.depinject.gen.BeanReference;
import kz.greetgo.depinject.gen.BeanReferencePlace;
import kz.greetgo.depinject.gen.Context;
import kz.greetgo.depinject.gen.Utils;
import kz.greetgo.depinject.gen.errors.FactoryMethodCannotContainAnyArguments;
import kz.greetgo.depinject.gen.errors.NoBeanContainer;
import kz.greetgo.depinject.gen.errors.NoInclude;

public class BeanCreationCollector {
    private final Context context;
    private final Class<?> beanContainerInterface;
    public final List<BeanCreation> beanCreationList = new ArrayList<BeanCreation>();
    private final LinkedList<BeanReference> factoryClassStack = new LinkedList();

    public BeanCreationCollector(Context context, Class<?> beanContainerInterface) {
        this.context = context;
        this.beanContainerInterface = beanContainerInterface;
    }

    public List<BeanCreation> collect() {
        if (!BeanContainer.class.isAssignableFrom(this.beanContainerInterface)) {
            throw new NoBeanContainer(this.beanContainerInterface);
        }
        this.context.configTree.root(this.beanContainerInterface.getName());
        List<Include> includes = Utils.getAllAnnotations(this.beanContainerInterface, Include.class);
        if (includes.isEmpty()) {
            throw new NoInclude(this.beanContainerInterface);
        }
        includes.forEach(this::collectFromInclude);
        return this.beanCreationList;
    }

    private void collectFromInclude(Include include) {
        for (Class beanConfig : include.value()) {
            this.context.configTree.includes(beanConfig.getName());
            this.collectFromBeanConfig(beanConfig);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void collectFromBeanConfig(Class<?> beanConfig) {
        try {
            ScanPackage scanPackage;
            boolean addToFactoryClassStack;
            ++this.context.configTree.tab;
            BeanConfig beanConfigAnn = beanConfig.getAnnotation(BeanConfig.class);
            if (beanConfigAnn == null) {
                throw this.context.newNoBeanConfig(beanConfig);
            }
            Class factoryClass = beanConfigAnn.factory();
            boolean bl = addToFactoryClassStack = BeanFactory.class != factoryClass;
            if (addToFactoryClassStack) {
                BeanReference.Place place = BeanReferencePlace.placeInBeanFactory(beanConfig, beanConfigAnn);
                this.factoryClassStack.add(this.context.newBeanReference(factoryClass, place));
            }
            Utils.getAllAnnotations(beanConfig, Include.class).forEach(this::collectFromInclude);
            BeanScanner beanScanner = beanConfig.getAnnotation(BeanScanner.class);
            if (beanScanner != null) {
                this.collectFromPackage(beanConfig.getPackage().getName());
            }
            if ((scanPackage = beanConfig.getAnnotation(ScanPackage.class)) != null) {
                for (String subPackageName : scanPackage.value()) {
                    String packageName = BeanCreationCollector.calcFullName(beanConfig.getPackage().getName(), subPackageName);
                    this.context.configTree.scannerPackage(packageName);
                    ++this.context.configTree.tab;
                    this.collectFromPackage(packageName);
                    --this.context.configTree.tab;
                }
            }
            if (addToFactoryClassStack) {
                this.factoryClassStack.removeLast();
            }
        }
        finally {
            --this.context.configTree.tab;
        }
    }

    static String calcFullName(String current, String relative) {
        int count;
        if (relative.startsWith(".")) {
            return current + relative;
        }
        if (!relative.startsWith("^")) {
            return relative;
        }
        ArrayList currentList = new ArrayList();
        Collections.addAll(currentList, current.split("\\."));
        for (count = 0; count < relative.length() && relative.charAt(count) == '^'; ++count) {
            if (currentList.size() <= 0) continue;
            currentList.remove(currentList.size() - 1);
        }
        while (count < relative.length() && relative.charAt(count) == '.') {
            ++count;
        }
        Collections.addAll(currentList, relative.substring(count).split("\\."));
        return String.join((CharSequence)".", currentList);
    }

    private void collectFromPackage(String packageName) {
        new ClassScannerDef().scanPackage(packageName).forEach(someClass -> {
            Bean bean = someClass.getAnnotation(Bean.class);
            if (bean != null) {
                this.addClassAsBeanAndViewItForAnotherBeans((Class<?>)someClass, bean);
            }
        });
    }

    private void addClassAsBeanAndViewItForAnotherBeans(Class<?> beanClass, Bean bean) {
        BeanCreation beanCreation;
        if (Utils.isRealClass(beanClass)) {
            beanCreation = this.context.newBeanCreationWithConstructor(beanClass, bean);
            this.beanCreationList.add(beanCreation);
        } else {
            beanCreation = this.context.newBeanCreationWithBeanFactory(beanClass, bean, this.extractBeanFactoryReference(beanClass));
            this.beanCreationList.add(beanCreation);
        }
        this.context.configTree.bean("" + beanCreation);
        ++this.context.configTree.tab;
        for (Method method : beanClass.getMethods()) {
            Bean methodBean = Utils.getAnnotation(method, Bean.class);
            if (methodBean == null) continue;
            if (method.getParameterTypes().length > 0) {
                throw new FactoryMethodCannotContainAnyArguments(method);
            }
            BeanCreationWithFactoryMethod subBean = this.context.newBeanCreationWithFactoryMethod(method.getReturnType(), methodBean, beanCreation, method);
            this.context.configTree.bean("" + subBean);
            this.beanCreationList.add(subBean);
        }
        --this.context.configTree.tab;
    }

    private BeanReference extractBeanFactoryReference(Class<?> beanClass) {
        List<FactoredBy> factoredByList = Utils.getAllAnnotations(beanClass, FactoredBy.class);
        if (factoredByList.size() > 0) {
            FactoredBy factoredBy = factoredByList.get(0);
            BeanReference.Place place = BeanReferencePlace.placeInAnnotationFactoredBy(beanClass, factoredBy);
            return this.context.newBeanReference(factoredBy.value(), place);
        }
        if (this.factoryClassStack.size() == 0) {
            throw this.context.newNoDefaultBeanFactory(beanClass);
        }
        return this.factoryClassStack.getLast();
    }
}

